DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -1.34963085984344E-11   0.00000000000000E+00   1.31938183510132E-10   1.64404522304562E-22
      1.33643758479056E-08   1.34963140314159E-08  -7.90356667088165E-19  -2.50371042858463E-01  -2.50371042857039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42386139855523E-09   0.00000000000000E+00  -1.42386139855523E-09
      3.70001668496812E-18  -2.50371042858463E-01  -2.46567585215325E-01   0.00000000000000E+00  -4.28244497408505E-12
     -9.83447782343779E-23  -1.20681701878848E-08  -1.20724526328589E-08  -2.90966001787995E-18
      1.17500000000000E-12
      0.00000000000000E+00  -1.34927266536833E-11   0.00000000000000E+00   8.88167128140601E-12   1.65515304674180E-22
      1.34838990896254E-08   1.34927807609070E-08  -7.89530143318334E-19  -2.50727023102219E-01  -2.50727023100879E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33966529009952E-09   0.00000000000000E+00  -1.33966529009952E-09
      3.69911241089730E-18  -2.50727023102218E-01  -2.46898160230399E-01   0.00000000000000E+00  -5.90624900078289E-12
     -9.83509867145652E-23  -1.21472092218094E-08  -1.21531154708103E-08  -2.90958226757896E-18
      2.08625000000000E-12
      0.00000000000000E+00  -1.34885936405090E-11   0.00000000000000E+00   2.89542680029886E-13   1.67333218667985E-22
      1.34883042186268E-08   1.34885937613070E-08  -7.88547512361127E-19  -2.51140737930657E-01  -2.51140737929448E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20884850237588E-09   0.00000000000000E+00  -1.20884850237588E-09
      3.69801084769951E-18  -2.51140737930656E-01  -2.47271964092225E-01   0.00000000000000E+00  -6.68041321705813E-12
     -9.83571885620093E-23  -1.22730648457139E-08  -1.22797452589311E-08  -2.90946333533838E-18
      2.24002343750000E-12
      0.00000000000000E+00  -1.34879507273485E-11   0.00000000000000E+00  -6.06630531953825E-14   1.70349933867749E-22
      1.34879716867892E-08   1.34879110237362E-08  -7.88385412305810E-19  -2.51208897626914E-01  -2.51208897625728E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18639459359763E-09   0.00000000000000E+00  -1.18639459359763E-09
      3.69782841172462E-18  -2.51208897626913E-01  -2.47333264338896E-01   0.00000000000000E+00  -6.78363041643807E-12
     -1.00997914656981E-22  -1.22947327997100E-08  -1.23015164301266E-08  -2.90944299941881E-18
      2.34382050781250E-12
      0.00000000000000E+00  -1.34874915036625E-11   0.00000000000000E+00  -1.35309089588298E-13   1.69645780341682E-22
      1.34875934050413E-08   1.34874580959519E-08  -7.88277660858141E-19  -2.51254190404009E-01  -2.51254190402837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17110270113674E-09   0.00000000000000E+00  -1.17110270113674E-09
      3.69770685469521E-18  -2.51254190404008E-01  -2.47373882048185E-01   0.00000000000000E+00  -6.83801239638149E-12
     -9.95138095597657E-23  -1.23095173824254E-08  -1.23163553948219E-08  -2.90942919383707E-18
      2.48394655273438E-12
      0.00000000000000E+00  -1.34868485905021E-11   0.00000000000000E+00  -1.59238890227880E-13   1.68945217442533E-22
      1.34870184417741E-08   1.34868592028841E-08  -7.88135167692091E-19  -2.51314079711672E-01  -2.51314079710521E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15030364376640E-09   0.00000000000000E+00  -1.15030364376640E-09
      3.69754566719515E-18  -2.51314079711671E-01  -2.47427407227714E-01   0.00000000000000E+00  -6.88278514550921E-12
     -9.87371029357118E-23  -1.23296727739803E-08  -1.23365555591259E-08  -2.90941049950306E-18
      2.67311671337891E-12
      0.00000000000000E+00  -1.34860219878672E-11   0.00000000000000E+00  -1.62344961061739E-13   1.68847347929712E-22
      1.34862352680854E-08   1.34860729231245E-08  -7.87948069701082E-19  -2.51392713007248E-01  -2.51392713006126E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12214698947674E-09   0.00000000000000E+00  -1.12214698947674E-09
      3.69733339046888E-18  -2.51392713007247E-01  -2.47497417427965E-01   0.00000000000000E+00  -6.89484550603301E-12
     -9.85268090720650E-23  -1.23570310881474E-08  -1.23639259336535E-08  -2.90938532076780E-18
      2.92849643024902E-12
      0.00000000000000E+00  -1.34850116957579E-11   0.00000000000000E+00  -1.57962482136781E-13   1.69311931656342E-22
      1.34852084109107E-08   1.34850504484288E-08  -7.87704747234825E-19  -2.51494971481779E-01  -2.51494971480694E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08438999352864E-09   0.00000000000000E+00  -1.08438999352864E-09
      3.69705645925936E-18  -2.51494971481778E-01  -2.47588102642136E-01   0.00000000000000E+00  -6.84274113082110E-12
     -9.83202772798731E-23  -1.23938177137668E-08  -1.24006604548978E-08  -2.90935171202453E-18
      3.27325904802368E-12
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00  -1.50204802084618E-13   1.70197178772527E-22
      1.34838882139815E-08   1.34837380091796E-08  -7.87392345403323E-19  -2.51626248116220E-01  -2.51626248115185E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452921939179E-09   0.00000000000000E+00  -1.03452921939179E-09
      3.69669979225752E-18  -2.51626248116219E-01  -2.47704084135614E-01   0.00000000000000E+00  -6.68932715380409E-12
     -9.82601756986231E-23  -1.24425194626312E-08  -1.24492087897851E-08  -2.90930744685419E-18
      3.73868858201947E-12
      0.00000000000000E+00  -1.34820726641673E-11   0.00000000000000E+00  -1.39507826737740E-13   1.71410284105382E-22
      1.34822220117398E-08   1.34820825039132E-08  -7.86998084914797E-19  -2.51791892979962E-01  -2.51791892978992E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70090135477892E-10   0.00000000000000E+00  -9.70090135477892E-10
      3.69624828365783E-18  -2.51791892979962E-01  -2.47849949232124E-01   0.00000000000000E+00  -6.40206250471425E-12
     -9.82498320009575E-23  -1.25055903059304E-08  -1.25119923684352E-08  -2.90925019874303E-18
      4.36701845291379E-12
      0.00000000000000E+00  -1.34800520799487E-11   0.00000000000000E+00  -1.28633744902668E-13   1.72815323130403E-22
      1.34801672377368E-08   1.34800386039921E-08  -7.86511767429377E-19  -2.51996156322879E-01  -2.51996156321990E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.89102657091574E-10   0.00000000000000E+00  -8.89102657091574E-10
      3.69568963390009E-18  -2.51996156322878E-01  -2.48029340899474E-01   0.00000000000000E+00  -5.95824355289652E-12
     -9.80235623298445E-23  -1.25849777033460E-08  -1.25909359468989E-08  -2.90917786647071E-18
      4.79114111576745E-12
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00  -1.18154276679157E-13   1.49842949265408E-22
      1.34788627279233E-08   1.34787445736468E-08  -7.86203247203436E-19  -2.52125706457580E-01  -2.52125706456743E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37237074291795E-10   0.00000000000000E+00  -8.37237074291795E-10
      3.69533454268270E-18  -2.52125706583945E-01  -2.48142959440376E-01   0.00000000000000E+00  -5.65595124264799E-12
     -9.78713887219837E-23  -1.26358515481124E-08  -1.26415074993552E-08  -2.90913129547926E-18
      4.93428251448056E-12
      0.00000000000000E+00  -1.34783070299418E-11   0.00000000000000E+00  -1.18566306929611E-13   1.65180657651602E-22
      1.34784320798618E-08   1.34783135135550E-08  -7.86101328282438E-19  -2.52168497602867E-01  -2.52168497602047E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20052273666476E-10   0.00000000000000E+00  -8.20052273666476E-10
      3.69521715925323E-18  -2.52168497865794E-01  -2.48180471472437E-01   0.00000000000000E+00  -5.54990397399085E-12
     -1.00283789167749E-22  -1.26527113359035E-08  -1.26582612398776E-08  -2.90911583097079E-18
      5.12752340274326E-12
      0.00000000000000E+00  -1.34777559615185E-11   0.00000000000000E+00  -1.15661863470125E-13   1.56660054844244E-22
      1.34778665839546E-08   1.34777509220913E-08  -7.85967646265161E-19  -2.52224618254929E-01  -2.52224618254132E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97431102373563E-10   0.00000000000000E+00  -7.97431102373563E-10
      3.69506306295867E-18  -2.52224618647510E-01  -2.48229642584208E-01   0.00000000000000E+00  -5.41130252459341E-12
     -9.82933384982946E-23  -1.26749085171888E-08  -1.26803198197135E-08  -2.90909541669351E-18
      5.38839860189791E-12
      0.00000000000000E+00  -1.34770212036209E-11   0.00000000000000E+00  -1.10553959414590E-13   1.69067300956196E-22
      1.34771341498755E-08   1.34770235959162E-08  -7.85794035386139E-19  -2.52297492116003E-01  -2.52297492115235E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67938559799581E-10   0.00000000000000E+00  -7.67938559799581E-10
      3.69486272683395E-18  -2.52297492545294E-01  -2.48293454087229E-01   0.00000000000000E+00  -5.22727842512548E-12
     -9.81954655148385E-23  -1.27038577577002E-08  -1.27090850361254E-08  -2.90906869144781E-18
      5.74058012075668E-12
      0.00000000000000E+00  -1.34761027562488E-11   0.00000000000000E+00  -1.04780994766320E-13   1.67179714692725E-22
      1.34761955881893E-08   1.34760908071947E-08  -7.85571546567190E-19  -2.52390867328759E-01  -2.52390867328029E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29980579151523E-10   0.00000000000000E+00  -7.29980579151523E-10
      3.69460564116485E-18  -2.52390867766853E-01  -2.48375164538078E-01   0.00000000000000E+00  -4.98456673098093E-12
     -9.80345281419413E-23  -1.27411256613134E-08  -1.27461102280445E-08  -2.90903409459766E-18
      6.21602517121602E-12
      0.00000000000000E+00  -1.34749087746651E-11   0.00000000000000E+00  -9.72508427929573E-14   1.72822259876932E-22
      1.34750136594002E-08   1.34749164085576E-08  -7.85291428288052E-19  -2.52508403060243E-01  -2.52508403059561E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81976895242707E-10   0.00000000000000E+00  -6.81976895242707E-10
      3.69428139862548E-18  -2.52508403503518E-01  -2.48477946820055E-01   0.00000000000000E+00  -4.67147087812093E-12
     -9.55884190127745E-23  -1.27882680424349E-08  -1.27929395133131E-08  -2.90898997033742E-18
      6.85787598933613E-12
      0.00000000000000E+00  -1.34734392588698E-11   0.00000000000000E+00  -8.92488016105291E-14   1.64571844431215E-22
      1.34735602029055E-08   1.34734709541041E-08  -7.84946953852209E-19  -2.52652900516761E-01  -2.52652900516139E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22673559068139E-10   0.00000000000000E+00  -6.22673559068139E-10
      3.69388173509217E-18  -2.52652900960421E-01  -2.48604215871386E-01   0.00000000000000E+00  -4.27662615408737E-12
     -9.20031353152586E-23  -1.28465207688809E-08  -1.28507973950351E-08  -2.90893478123995E-18
      7.29112529156720E-12
      0.00000000000000E+00  -1.34725208114977E-11   0.00000000000000E+00  -8.22267675369573E-14   1.59603243361017E-22
      1.34726399047240E-08   1.34725576779566E-08  -7.84728864437243E-19  -2.52744360988434E-01  -2.52744360987848E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85018736854978E-10   0.00000000000000E+00  -5.85018736854978E-10
      3.69362827613263E-18  -2.52744361468369E-01  -2.48684101395761E-01   0.00000000000000E+00  -4.02600302995402E-12
     -9.45537432928657E-23  -1.28835129380746E-08  -1.28875389411046E-08  -2.90889941169539E-18
      7.36423611131870E-12
      0.00000000000000E+00  -1.34724289667605E-11   0.00000000000000E+00  -8.29042514282010E-14   1.64913770792881E-22
      1.34724863383592E-08   1.34724034341080E-08  -7.84692469067797E-19  -2.52759623140849E-01  -2.52759623140270E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78731376228809E-10   0.00000000000000E+00  -5.78731376228809E-10
      3.69358596460730E-18  -2.52759623632125E-01  -2.48697430807589E-01   0.00000000000000E+00  -3.98231314922142E-12
     -9.54909905061751E-23  -1.28896897447128E-08  -1.28936720578621E-08  -2.90889349553950E-18
      7.46293571798321E-12
      0.00000000000000E+00  -1.34722452772861E-11   0.00000000000000E+00  -8.16579175844012E-14   1.70778547632881E-22
      1.34722821497621E-08   1.34722004918447E-08  -7.84644066131198E-19  -2.52779919259851E-01  -2.52779919259280E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70363914490316E-10   0.00000000000000E+00  -5.70363914490316E-10
      3.69352966991328E-18  -2.52779919760423E-01  -2.48715154695650E-01   0.00000000000000E+00  -3.92621897845864E-12
     -9.63801490595873E-23  -1.28979103583935E-08  -1.29018365773721E-08  -2.90888560378209E-18
      7.59618018698031E-12
      0.00000000000000E+00  -1.34719697430744E-11   0.00000000000000E+00  -8.01106833638255E-14   1.71403153222872E-22
      1.34720121013820E-08   1.34719319906988E-08  -7.84580027657467E-19  -2.52806769783942E-01  -2.52806769783383E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59283466653202E-10   0.00000000000000E+00  -5.59283466653202E-10
      3.69345514848475E-18  -2.52806770285474E-01  -2.48738598870933E-01   0.00000000000000E+00  -3.85172724705959E-12
     -9.68823147244530E-23  -1.29087967967973E-08  -1.29126485240445E-08  -2.90887512082728E-18
      7.77606022012639E-12
      0.00000000000000E+00  -1.34716023641256E-11   0.00000000000000E+00  -7.78648561628642E-14   1.75508089847153E-22
      1.34716572781523E-08   1.34715794132963E-08  -7.84495892078733E-19  -2.52842043915435E-01  -2.52842043914891E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44708442201168E-10   0.00000000000000E+00  -5.44708442201168E-10
      3.69335716631211E-18  -2.52842044418267E-01  -2.48769392245440E-01   0.00000000000000E+00  -3.75378126113272E-12
     -9.76913835650886E-23  -1.29231171898272E-08  -1.29268709710884E-08  -2.90886127423338E-18
      8.01889826487360E-12
      0.00000000000000E+00  -1.34711431404396E-11   0.00000000000000E+00  -7.50614644496260E-14   1.79530054642082E-22
      1.34711954609601E-08   1.34711203994958E-08  -7.84386381662901E-19  -2.52887951761615E-01  -2.52887951761089E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25710032311334E-10   0.00000000000000E+00  -5.25710032311334E-10
      3.69322950391576E-18  -2.52887952266514E-01  -2.48809459244955E-01   0.00000000000000E+00  -3.62548938143071E-12
     -9.81107337302607E-23  -1.29417848777955E-08  -1.29454103671771E-08  -2.90884312225286E-18
      8.34672962528234E-12
      0.00000000000000E+00  -1.34705002272791E-11   0.00000000000000E+00  -7.14136994301969E-14   1.83456054122560E-22
      1.34706018922674E-08   1.34705304785682E-08  -7.84245615414371E-19  -2.52946954221274E-01  -2.52946954220773E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01247399222843E-10   0.00000000000000E+00  -5.01247399222843E-10
      3.69306517929897E-18  -2.52946954726796E-01  -2.48860940603529E-01   0.00000000000000E+00  -3.45941922839374E-12
     -9.83541070828105E-23  -1.29658236601229E-08  -1.29692830793514E-08  -2.90881956388460E-18
      8.78930196183413E-12
      0.00000000000000E+00  -1.34698573141187E-11   0.00000000000000E+00  -6.66930186722976E-14   1.86890023758798E-22
      1.34698516284555E-08   1.34697849354370E-08  -7.84067663397995E-19  -2.53021529446728E-01  -2.53021529446258E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70262984906056E-10   0.00000000000000E+00  -4.70262984906056E-10
      3.69285705391095E-18  -2.53021529951807E-01  -2.48925989100236E-01   0.00000000000000E+00  -3.24782749067421E-12
     -9.81405999900836E-23  -1.29962741230409E-08  -1.29995219505317E-08  -2.90878939051295E-18
      9.38677461617904E-12
      0.00000000000000E+00  -1.34688470220094E-11   0.00000000000000E+00  -6.05715334661373E-14   1.88761274196541E-22
      1.34689240997291E-08   1.34688635281958E-08  -7.83847620291774E-19  -2.53113721414230E-01  -2.53113721413798E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31869672757379E-10   0.00000000000000E+00  -4.31869672757379E-10
      3.69259902359124E-18  -2.53113721918672E-01  -2.49006375665317E-01   0.00000000000000E+00  -2.98421647172085E-12
     -1.07873007289320E-22  -1.30340096389674E-08  -1.30369938554393E-08  -2.90875140329946E-18
      1.01933626995447E-11
      0.00000000000000E+00  -1.34677448851629E-11   0.00000000000000E+00  -5.45048256210754E-14   1.88588545292986E-22
      1.34678104450267E-08   1.34677559402013E-08  -7.83583341002138E-19  -2.53224410994417E-01  -2.53224410994031E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85657221821879E-10   0.00000000000000E+00  -3.85657221821879E-10
      3.69228795707185E-18  -2.53224411498280E-01  -2.49102854696410E-01   0.00000000000000E+00  -2.66364765422897E-12
     -7.36245928380906E-23  -1.30794350707237E-08  -1.30820987183780E-08  -2.90870461606971E-18
      1.07378096558165E-11
      0.00000000000000E+00  -1.34671019720024E-11   0.00000000000000E+00  -1.78839851004617E-13   1.87034945729819E-22
      1.34671055617130E-08   1.34669267218622E-08  -7.83418740689073E-19  -2.53293333940299E-01  -2.53293333939942E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.56828241072204E-10   0.00000000000000E+00  -3.56828241072204E-10
      3.69209368302209E-18  -2.53293330964076E-01  -2.49162912621612E-01   0.00000000000000E+00  -2.33540690217613E-12
     -6.11803822577496E-23  -1.31077630738885E-08  -1.31100984807907E-08  -2.90867494233301E-18
      1.09215605035582E-11
      0.00000000000000E+00  -1.34668264377908E-11   0.00000000000000E+00  -6.00955757017427E-14   1.82097639414335E-22
      1.34668634696590E-08   1.34668033740835E-08  -7.83364717505794E-19  -2.53315949993303E-01  -2.53315949992956E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47365444770921E-10   0.00000000000000E+00  -3.47365444770921E-10
      3.69202985432713E-18  -2.53315950218639E-01  -2.49182627366025E-01   0.00000000000000E+00  -2.38699395149954E-12
     -8.99467408786690E-23  -1.31170509353678E-08  -1.31194379293193E-08  -2.90866513682134E-18
      1.11696241480096E-11
      0.00000000000000E+00  -1.34665509035792E-11   0.00000000000000E+00  -4.71324898499618E-14   1.74508841572665E-22
      1.34665679398170E-08   1.34665208073273E-08  -7.83294478618568E-19  -2.53345354215001E-01  -2.53345354214666E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35053100882905E-10   0.00000000000000E+00  -3.35053100882905E-10
      3.69194673983384E-18  -2.53345357372791E-01  -2.49208246795196E-01   0.00000000000000E+00  -2.31259028229473E-12
     -5.97349562956447E-23  -1.31291551161603E-08  -1.31314677064426E-08  -2.90865226121528E-18
      1.15045100680189E-11
      0.00000000000000E+00  -1.34661835246304E-11   0.00000000000000E+00  -3.69661692483471E-14   1.72724011963097E-22
      1.34661934346952E-08   1.34661564685262E-08  -7.83204305188275E-19  -2.53383098490743E-01  -2.53383098490424E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19230197207418E-10   0.00000000000000E+00  -3.19230197207418E-10
      3.69183983413556E-18  -2.53383102190127E-01  -2.49241123626120E-01   0.00000000000000E+00  -2.21035506573756E-12
     -9.13301874165004E-23  -1.31447159162448E-08  -1.31469262713107E-08  -2.90863552894728E-18
      1.19566060600314E-11
      0.00000000000000E+00  -1.34656324562071E-11   0.00000000000000E+00  -4.08283670937776E-14   1.76185690250340E-22
      1.34657235877927E-08   1.34656827594257E-08  -7.83090506810095E-19  -2.53430723491579E-01  -2.53430723491280E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99247158601682E-10   0.00000000000000E+00  -2.99247158601682E-10
      3.69170454569453E-18  -2.53430728313995E-01  -2.49282601105477E-01   0.00000000000000E+00  -2.06352157736975E-12
     -9.87151006194143E-23  -1.31643720792470E-08  -1.31664356008245E-08  -2.90861403888444E-18
      1.25669356492484E-11
      0.00000000000000E+00  -1.34651732325211E-11   0.00000000000000E+00  -3.75069771408810E-14   1.81336740952043E-22
      1.34651389621280E-08   1.34651014551510E-08  -7.82950086665254E-19  -2.53489474188918E-01  -2.53489474188644E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74571445923799E-10   0.00000000000000E+00  -2.74571445923799E-10
      3.69153696661673E-18  -2.53489479760256E-01  -2.49333761653400E-01   0.00000000000000E+00  -1.89013817624609E-12
     -9.81019583427620E-23  -1.31886398710538E-08  -1.31905300092301E-08  -2.90858687995148E-18
      1.33908805946913E-11
      0.00000000000000E+00  -1.34644384746234E-11   0.00000000000000E+00  -3.29767221831128E-14   2.27864152518368E-22
      1.34644344190130E-08   1.34644014422911E-08  -7.82781873048007E-19  -2.53559828358277E-01  -2.53559828358032E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44999906984638E-10   0.00000000000000E+00  -2.44999906984638E-10
      3.69133510018174E-18  -2.53559834156589E-01  -2.49395020220349E-01   0.00000000000000E+00  -1.68201434987583E-12
     -9.77380408446478E-23  -1.32177195209563E-08  -1.32194015353062E-08  -2.90855322713373E-18
      1.45032062710393E-11
      0.00000000000000E+00  -1.34636118719886E-11   0.00000000000000E+00  -2.89339887587503E-14   2.11721375447286E-22
      1.34636201589139E-08   1.34635912249254E-08  -7.82587983497960E-19  -2.53640881627562E-01  -2.53640881627351E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10922490562519E-10   0.00000000000000E+00  -2.10922490562519E-10
      3.69110048567977E-18  -2.53640887341183E-01  -2.49465592297981E-01   0.00000000000000E+00  -1.43999126659208E-12
     -9.80909229584100E-23  -1.32512287430949E-08  -1.32526687343616E-08  -2.90851250218180E-18
      1.60048459341090E-11
      0.00000000000000E+00  -1.34626934246165E-11   0.00000000000000E+00  -2.16399314332612E-14   2.06035050550218E-22
      1.34627310719708E-08   1.34627094320395E-08  -7.82375281897767E-19  -2.53729738231615E-01  -2.53729738231442E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73593513914158E-10   0.00000000000000E+00  -1.73593513914158E-10
      3.69083981077402E-18  -2.53729750326278E-01  -2.49542973123700E-01   0.00000000000000E+00  -1.17678316922768E-12
     -9.83493093703096E-23  -1.32879391349563E-08  -1.32891159181256E-08  -2.90846452887625E-18
      1.62582476272520E-11
      0.00000000000000E+00  -1.34626015798793E-11   0.00000000000000E+00  -2.33007597957919E-14   2.05902295722197E-22
      1.34625831715591E-08   1.34625598707995E-08  -7.82340735247301E-19  -2.53744167460500E-01  -2.53744167460332E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67533049004456E-10   0.00000000000000E+00  -1.67533049004456E-10
      3.69079735761575E-18  -2.53744178440325E-01  -2.49555538411832E-01   0.00000000000000E+00  -1.13098579765457E-12
     -9.86054526645808E-23  -1.32938958360029E-08  -1.32950268218007E-08  -2.90845662236844E-18
      1.66003399129950E-11
      0.00000000000000E+00  -1.34623260456676E-11   0.00000000000000E+00  -2.19304187469976E-14   2.05323312717463E-22
      1.34623949108303E-08   1.34623729804118E-08  -7.82296424906422E-19  -2.53762671192156E-01  -2.53762671191996E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59762183175715E-10   0.00000000000000E+00  -1.59762183175715E-10
      3.69074270420533E-18  -2.53762681322052E-01  -2.49571651958584E-01   0.00000000000000E+00  -1.07606396203840E-12
     -9.91352936995656E-23  -1.33015347332722E-08  -1.33026107972343E-08  -2.90844627929890E-18
      1.70621644987482E-11
      0.00000000000000E+00  -1.34621423561932E-11   0.00000000000000E+00  -2.02532744944036E-14   2.04777670780153E-22
      1.34621596152221E-08   1.34621393619478E-08  -7.82240561556305E-19  -2.53785993593658E-01  -2.53785993593508E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49971349664967E-10   0.00000000000000E+00  -1.49971349664967E-10
      3.69067344374889E-18  -2.53786003190464E-01  -2.49591962824062E-01   0.00000000000000E+00  -1.00676567096632E-12
     -9.88739677832018E-23  -1.33111612466096E-08  -1.33121680122807E-08  -2.90843288219259E-18
      1.76856276895149E-11
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00  -1.83687266670284E-14   2.05056945003220E-22
      1.34618706497470E-08   1.34618522810205E-08  -7.82171714464390E-19  -2.53814726563708E-01  -2.53814726563570E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37920996482562E-10   0.00000000000000E+00  -1.37920996482562E-10
      3.69058745508435E-18  -2.53814735813504E-01  -2.49616989434608E-01   0.00000000000000E+00  -9.20993135289134E-13
     -3.85770546515008E-22  -1.33230102914004E-08  -1.33239312845360E-08  -2.90841574061996E-18
      1.85273029970500E-11
      0.00000000000000E+00  -1.34614994430328E-11   0.00000000000000E+00  -1.63514448135492E-14   2.10055458137614E-22
      1.34615252408386E-08   1.34615088893940E-08  -7.82089348791138E-19  -2.53849084492433E-01  -2.53849084492309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23539593906723E-10   0.00000000000000E+00  -1.23539593906723E-10
      3.69048347485866E-18  -2.53849093446334E-01  -2.49646924354791E-01   0.00000000000000E+00  -8.18074956973110E-13
     -5.21871802461534E-23  -1.33371512205317E-08  -1.33379692954887E-08  -2.90839412606752E-18
      1.96635646622224E-11
      0.00000000000000E+00  -1.34611320640840E-11   0.00000000000000E+00  -1.39642482211813E-14   2.13154394000224E-22
      1.34611277842864E-08   1.34611138200384E-08  -7.81994520389699E-19  -2.53888613275786E-01  -2.53888613275679E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07051398868474E-10   0.00000000000000E+00  -1.07051398868474E-10
      3.69036183645792E-18  -2.53888621887580E-01  -2.49681382641944E-01   0.00000000000000E+00  -6.99873786146522E-13
     -9.04283715365316E-23  -1.33533625473837E-08  -1.33540624211699E-08  -2.90836731606822E-18
      2.04305412862137E-11
      0.00000000000000E+00  -1.34608565298723E-11   0.00000000000000E+00  -1.25219898185767E-14   2.13040103731488E-22
      1.34608875145322E-08   1.34608749925426E-08  -7.81937168486319E-19  -2.53912507178924E-01  -2.53912507178827E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71134299712846E-11   0.00000000000000E+00  -9.71134299712846E-11
      3.69028735272726E-18  -2.53912515562175E-01  -2.49702220594130E-01   0.00000000000000E+00  -6.28575992363703E-13
     -9.78108111445692E-23  -1.33631329865773E-08  -1.33637615625698E-08  -2.90835018424094E-18
      2.14659597286021E-11
      0.00000000000000E+00  -1.34605809956607E-11   0.00000000000000E+00  -1.06353492229334E-14   2.10868398037921E-22
      1.34606070806311E-08   1.34605964452821E-08  -7.81870179358519E-19  -2.53940395075332E-01  -2.53940395075246E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55684684555360E-11   0.00000000000000E+00  -8.55684684555360E-11
      3.69019875355693E-18  -2.53940403142240E-01  -2.49726558747723E-01   0.00000000000000E+00  -5.45840373963720E-13
     -9.90625372277157E-23  -1.33744821364523E-08  -1.33750279768264E-08  -2.90832857419841E-18
      2.28637746258263E-11
      0.00000000000000E+00  -1.34603054614491E-11   0.00000000000000E+00  -8.52013979541542E-15   2.07850358354988E-22
      1.34602941277679E-08   1.34602856076283E-08  -7.81795338904223E-19  -2.53971517513165E-01  -2.53971517513092E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27838810969122E-11   0.00000000000000E+00  -7.27838810969122E-11
      3.69009701516365E-18  -2.53971525139868E-01  -2.49753750962723E-01   0.00000000000000E+00  -4.54115256540306E-13
     -1.02144434038356E-22  -1.33870476112748E-08  -1.33875017265315E-08  -2.90830167625943E-18
      2.47508247370791E-11
      0.00000000000000E+00  -1.34599380825003E-11   0.00000000000000E+00  -6.12954006749245E-15   1.97540915059395E-22
      1.34599638481650E-08   1.34599577186252E-08  -7.81716223827426E-19  -2.54004364654209E-01  -2.54004364654149E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94669895149314E-11   0.00000000000000E+00  -5.94669895149314E-11
      3.68998479797448E-18  -2.54004371681607E-01  -2.49782505454328E-01   0.00000000000000E+00  -3.58650866114986E-13
     -9.63503461365100E-23  -1.34001320782440E-08  -1.34004907291102E-08  -2.90826857414705E-18
      2.72983423872703E-11
      0.00000000000000E+00  -1.34595707035514E-11   0.00000000000000E+00  -3.62549972859077E-15   6.07846610177156E-23
      1.34596378373380E-08   1.34596342118383E-08  -7.81637942079895E-19  -2.54036787681606E-01  -2.54036787681559E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66230877368713E-11   0.00000000000000E+00  -4.66230877368713E-11
      3.68986602483556E-18  -2.54036793937734E-01  -2.49810983354440E-01   0.00000000000000E+00  -2.66715876270876E-13
     -7.67904915860811E-23  -1.34127444082258E-08  -1.34130111241021E-08  -2.90822808275566E-18
      3.07374912150284E-11
      0.00000000000000E+00  -1.34592951693398E-11   0.00000000000000E+00  -3.44954856241108E-15   6.37530048157706E-23
      1.34593393183704E-08   1.34593358688219E-08  -7.81566011773030E-19  -2.54066473115343E-01  -2.54066473115307E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53563558929433E-11   0.00000000000000E+00  -3.53563558929433E-11
      3.68974442906564E-18  -2.54066478494329E-01  -2.49837211856587E-01   0.00000000000000E+00  -1.84070166407312E-13
     -1.18147757321996E-23  -1.34237954427626E-08  -1.34239795129290E-08  -2.90817841729261E-18
      3.30589166737651E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.82166350699510E-15   1.62318590907598E-22
      1.34591850735226E-08   1.34591822518593E-08  -7.81528729670559E-19  -2.54081813227093E-01  -2.54081813227063E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97776931625824E-11   0.00000000000000E+00  -2.97776931625824E-11
      3.68967530237063E-18  -2.54081818102225E-01  -2.49850842245514E-01   0.00000000000000E+00  -1.43716537380039E-13
     -9.20123980710655E-23  -1.34292608421592E-08  -1.34294045586966E-08  -2.90814657270007E-18
      3.38423977660888E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00   9.13273553286071E-15   1.84254874448692E-22
      1.34591383977765E-08   1.34591475305122E-08  -7.81517289808024E-19  -2.54086514262039E-01  -2.54086514262011E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81004640457275E-11   0.00000000000000E+00  -2.81004640457275E-11
      3.68965328618836E-18  -2.54086518713717E-01  -2.49855029065819E-01   0.00000000000000E+00  -1.43351224856027E-13
     -9.58733331396994E-23  -1.34309037152428E-08  -1.34310470664678E-08  -2.90813599638034E-18
      3.49000972407257E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.22972807471238E-15   1.95644090008192E-22
      1.34590821381105E-08   1.34590799083826E-08  -7.81503634603371E-19  -2.54092116823895E-01  -2.54092116823869E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61570456994661E-11   0.00000000000000E+00  -2.61570456994661E-11
      3.68962561989487E-18  -2.54092121014365E-01  -2.49860036735935E-01   0.00000000000000E+00  -1.17715583122534E-13
     -9.70260559905628E-23  -1.34328051470982E-08  -1.34329228626814E-08  -2.90812198529150E-18
      3.63279915314855E-11
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00  -1.93938307738225E-15   2.00426606066330E-22
      1.34590165465877E-08   1.34590146072048E-08  -7.81487861515904E-19  -2.54098573813049E-01  -2.54098573813025E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40108678224032E-11   0.00000000000000E+00  -2.40108678224032E-11
      3.68959133491378E-18  -2.54098577870179E-01  -2.49865838013939E-01   0.00000000000000E+00  -1.02293364606192E-13
     -6.88584439370731E-25  -1.34349014460179E-08  -1.34350037393825E-08  -2.90810347339788E-18
      3.82556488240113E-11
      0.00000000000000E+00  -1.34589277903910E-11   0.00000000000000E+00  -1.58871381553796E-15   1.97281506954566E-22
      1.34589442247972E-08   1.34589426360836E-08  -7.81470297958997E-19  -2.54105743816642E-01  -2.54105743816621E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17808444276322E-11   0.00000000000000E+00  -2.17808444276322E-11
      3.68954934891019E-18  -2.54105747745772E-01  -2.49872327999805E-01   0.00000000000000E+00  -8.63325085641182E-14
     -1.35089599986347E-22  -1.34370754591481E-08  -1.34371617916568E-08  -2.90807905095119E-18
      4.08579861689211E-11
      0.00000000000000E+00  -1.34588359456538E-11   0.00000000000000E+00  -1.26074911843901E-15   1.95657867101280E-22
      1.34588668431352E-08   1.34588655823863E-08  -7.81451428865549E-19  -2.54113422498422E-01  -2.54113422498402E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96321614836948E-11   0.00000000000000E+00  -1.96321614836948E-11
      3.68949825940320E-18  -2.54113426433137E-01  -2.49879354027522E-01   0.00000000000000E+00  -7.10139178934386E-14
      3.15626705205213E-22  -1.34391624069854E-08  -1.34392334209030E-08  -2.90804683053765E-18
      4.43711415845494E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -1.03353475864159E-15   1.48137763495667E-22
      1.34587859878432E-08   1.34587849543086E-08  -7.81431683856614E-19  -2.54121436559932E-01  -2.54121436559914E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77416450923257E-11   0.00000000000000E+00  -1.77416450923257E-11
      3.68943593024666E-18  -2.54121440889688E-01  -2.49886798268864E-01   0.00000000000000E+00  -5.75902743089375E-14
      1.75185596709352E-23  -1.34409857189419E-08  -1.34410433092162E-08  -2.90800424639005E-18
      4.55568315373239E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.60461634745882E-16   1.88421261472201E-22
      1.34587609663590E-08   1.34587600058975E-08  -7.81425572161132E-19  -2.54123915279843E-01  -2.54123915279826E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72005200140555E-11   0.00000000000000E+00  -1.72005200140555E-11
      3.68941553576290E-18  -2.54123919788156E-01  -2.49889114545907E-01   0.00000000000000E+00  -5.37730916620192E-14
     -5.71099443206767E-23  -1.34415057127905E-08  -1.34415594858822E-08  -2.90798996360177E-18
      4.57569167168546E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.58039150435085E-16   1.92647997211172E-22
      1.34587568103115E-08   1.34587558522725E-08  -7.81424556075457E-19  -2.54124327321459E-01  -2.54124327321442E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71118826977229E-11   0.00000000000000E+00  -1.71118826977229E-11
      3.68941211192877E-18  -2.54124331861960E-01  -2.49889499999846E-01   0.00000000000000E+00  -5.31384807230385E-14
     -7.62895962424558E-23  -1.34415908310862E-08  -1.34416439695670E-08  -2.90798755585332E-18
      4.60270317092211E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.31574268270851E-16   1.95943185141579E-22
      1.34587513051118E-08   1.34587503735377E-08  -7.81423211062277E-19  -2.54124872664924E-01  -2.54124872664907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69968956083312E-11   0.00000000000000E+00  -1.69968956083312E-11
      3.68940752081245E-18  -2.54124877249852E-01  -2.49890010890854E-01   0.00000000000000E+00  -5.23404200873542E-14
     -9.09015043637454E-23  -1.34417011375103E-08  -1.34417534779305E-08  -2.90798430975017E-18
      4.63916869489158E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.11196514677997E-16   1.99055852109318E-22
      1.34587440594359E-08   1.34587431482396E-08  -7.81421441403922E-19  -2.54125590059371E-01  -2.54125590059354E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68497223863384E-11   0.00000000000000E+00  -1.68497223863384E-11
      3.68940137647289E-18  -2.54125594708475E-01  -2.49890684259238E-01   0.00000000000000E+00  -5.13067248041752E-14
     -9.62675835012253E-23  -1.34418421191331E-08  -1.34418934258580E-08  -2.90797993506897E-18
      4.68839715225036E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.85290504726848E-16   2.01891454181868E-22
      1.34587345965529E-08   1.34587337112626E-08  -7.81419130548706E-19  -2.54126526688648E-01  -2.54126526688632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66646690831235E-11   0.00000000000000E+00  -1.66646690831235E-11
      3.68939317271338E-18  -2.54126531432740E-01  -2.49891565656068E-01   0.00000000000000E+00  -5.00102547743602E-14
     -9.89084756363051E-23  -1.34420190319246E-08  -1.34420690421794E-08  -2.90797404216467E-18
      4.75485556968472E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.53411688249053E-16   2.03172929336549E-22
      1.34587223500097E-08   1.34587214965983E-08  -7.81416140349603E-19  -2.54127738530063E-01  -2.54127738530047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64373308596766E-11   0.00000000000000E+00  -1.64373308596766E-11
      3.68938224872342E-18  -2.54127743417301E-01  -2.49892709866635E-01   0.00000000000000E+00  -4.84231369044426E-14
     -9.79843762163099E-23  -1.34422357426022E-08  -1.34422841657392E-08  -2.90796610837382E-18
      4.84457443322111E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.15598156742735E-16   2.02464057462589E-22
      1.34587066615977E-08   1.34587058459998E-08  -7.81412311420487E-19  -2.54129290368230E-01  -2.54129290368214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61663198557626E-11   0.00000000000000E+00  -1.61663198557626E-11
      3.68936774448497E-18  -2.54129295475502E-01  -2.49894181474499E-01   0.00000000000000E+00  -4.65406947497722E-14
     -8.77651721286951E-23  -1.34424929854481E-08  -1.34425395261429E-08  -2.90795543306448E-18
      4.96569489899523E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.72526453108554E-16   1.98930725600573E-22
      1.34586867767068E-08   1.34586860041805E-08  -7.81407463120342E-19  -2.54131256211891E-01  -2.54131256211876E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58553833850425E-11   0.00000000000000E+00  -1.58553833850425E-11
      3.68934854037076E-18  -2.54131261664843E-01  -2.49896055955824E-01   0.00000000000000E+00  -4.43974795523029E-14
     -1.41154620515017E-22  -1.34427862233160E-08  -1.34428306207957E-08  -2.90794107725042E-18
      5.12920752779030E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.26249909904219E-16   1.96227913379079E-22
      1.34586618153520E-08   1.34586610891023E-08  -7.81401388954915E-19  -2.54133722099332E-01  -2.54133722099317E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55152176843037E-11   0.00000000000000E+00  -1.55152176843037E-11
      3.68932317103047E-18  -2.54133728107154E-01  -2.49898423080219E-01   0.00000000000000E+00  -4.20805040917259E-14
     -9.52194798522800E-23  -1.34431037909144E-08  -1.34431458714186E-08  -2.90792178207555E-18
      5.18439304000863E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -3.25764281832952E-14   1.97281966053463E-22
      1.34586591815930E-08   1.34586266051650E-08  -7.81399389108440E-19  -2.54134535283359E-01  -2.54134535283344E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54134127792491E-11   0.00000000000000E+00  -1.54134127792491E-11
      3.68931466505967E-18  -2.54134539567479E-01  -2.49899203141377E-01   0.00000000000000E+00  -9.02240662858053E-15
     -9.48556080799838E-23  -1.34432041699772E-08  -1.34432131923839E-08  -2.90791527595124E-18
      5.19370559519547E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.18269580315784E-16   1.98630008187212E-22
      1.34586581581715E-08   1.34586576399021E-08  -7.81399050954768E-19  -2.54134672309657E-01  -2.54134672309641E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53995941926427E-11   0.00000000000000E+00  -1.53995941926427E-11
      3.68931323096397E-18  -2.54134676300790E-01  -2.49899335934778E-01   0.00000000000000E+00  -3.99210220066709E-14
     -9.67450839435055E-23  -1.34432181246713E-08  -1.34432580456934E-08  -2.90791418000920E-18
      5.20627754469771E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -9.49501647436411E-16   1.97284135702280E-22
      1.34586556786381E-08   1.34586547291366E-08  -7.81398598082785E-19  -2.54134856135238E-01  -2.54134856135223E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53772935198716E-11   0.00000000000000E+00  -1.53772935198716E-11
      3.68931129773839E-18  -2.54134860042254E-01  -2.49899513567373E-01   0.00000000000000E+00  -4.01619374950143E-14
     -9.76654204642625E-23  -1.34432372736904E-08  -1.34432774356280E-08  -2.90791269965561E-18
      5.22324967652574E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.18384342983509E-15   1.96884607722860E-22
      1.34586515295872E-08   1.34586503457440E-08  -7.81397992251784E-19  -2.54135102190528E-01  -2.54135102190513E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53441977778351E-11   0.00000000000000E+00  -1.53441977778351E-11
      3.68930869350091E-18  -2.54135106225815E-01  -2.49899750704958E-01   0.00000000000000E+00  -4.07809335386919E-14
     -9.92337324970034E-23  -1.34432653670302E-08  -1.34433061479639E-08  -2.90791070124913E-18
      5.24616205449357E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.09378009686935E-15   1.96804223439795E-22
      1.34586463548908E-08   1.34586452611109E-08  -7.81397183095175E-19  -2.54135430956407E-01  -2.54135430956391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53002632639539E-11   0.00000000000000E+00  -1.53002632639539E-11
      3.68930518784677E-18  -2.54135435243296E-01  -2.49900067482869E-01   0.00000000000000E+00  -4.08831174133505E-14
     -9.70622655720309E-23  -1.34433041147319E-08  -1.34433449978494E-08  -2.90790800475159E-18
      5.27709376475014E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -8.76812829228565E-16   1.96709815822795E-22
      1.34586407405825E-08   1.34586398637699E-08  -7.81396104918729E-19  -2.54135869252017E-01  -2.54135869252002E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52451521937810E-11   0.00000000000000E+00  -1.52451521937810E-11
      3.68930047226046E-18  -2.54135873816739E-01  -2.49900490394342E-01   0.00000000000000E+00  -4.05006682946483E-14
     -9.87963144557989E-23  -1.34433542109137E-08  -1.34433947115821E-08  -2.90790436734173E-18
      5.31885157359651E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.25984000961392E-16   1.96411707121049E-22
      1.34586344541710E-08   1.34586337281872E-08  -7.81394673033584E-19  -2.54136451701737E-01  -2.54136451701722E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51768903447395E-11   0.00000000000000E+00  -1.51768903447395E-11
      3.68929413472360E-18  -2.54136456528431E-01  -2.49901053533676E-01   0.00000000000000E+00  -3.99237616866482E-14
     -9.60620545494489E-23  -1.34434169140796E-08  -1.34434568378414E-08  -2.90789946169002E-18
      5.37522461553911E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.67648647407990E-16   1.95816394637489E-22
      1.34586266608228E-08   1.34586259931743E-08  -7.81392779542599E-19  -2.54137222540530E-01  -2.54137222540515E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50925814148045E-11   0.00000000000000E+00  -1.50925814148045E-11
      3.68928562657635E-18  -2.54137227631673E-01  -2.49901800512993E-01   0.00000000000000E+00  -3.92829069772288E-14
     -9.12448646020006E-23  -1.34434941288528E-08  -1.34435334117599E-08  -2.90789284703375E-18
      5.45132822216163E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.50316240324993E-16   1.94916695196674E-22
      1.34586164509606E-08   1.34586158006445E-08  -7.81390288357598E-19  -2.54138237868876E-01  -2.54138237868861E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49898301022598E-11   0.00000000000000E+00  -1.49898301022598E-11
      3.68927421877502E-18  -2.54138243280050E-01  -2.49902787001644E-01   0.00000000000000E+00  -3.85743848959071E-14
     -9.05296981519774E-23  -1.34435873961570E-08  -1.34436259705419E-08  -2.90788393041742E-18
      5.55406809110202E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.38184597451378E-16   1.93772042115469E-22
      1.34586029887387E-08   1.34586023505543E-08  -7.81387028974699E-19  -2.54139568591018E-01  -2.54139568591003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48678085601470E-11   0.00000000000000E+00  -1.48678085601470E-11
      3.68925894360799E-18  -2.54139574448590E-01  -2.49904083965990E-01   0.00000000000000E+00  -3.77735478677078E-14
     -9.04210398110836E-23  -1.34436967684448E-08  -1.34437345419928E-08  -2.90787191463329E-18
      5.69276691417155E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.22262517661910E-16   1.92481483452542E-22
      1.34585853627010E-08   1.34585847404387E-08  -7.81382787831126E-19  -2.54141304688399E-01  -2.54141304688385E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47279247753949E-11   0.00000000000000E+00  -1.47279247753949E-11
      3.68923851614966E-18  -2.54141311212019E-01  -2.49905782208794E-01   0.00000000000000E+00  -3.68827287682836E-14
     -9.04251714509076E-23  -1.34438199329349E-08  -1.34438568156637E-08  -2.90785572831854E-18
      5.88001032531541E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.03583045385036E-16   1.91162555741019E-22
      1.34585624134612E-08   1.34585618098784E-08  -7.81377294903613E-19  -2.54143562108844E-01  -2.54143562108829E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45741074382024E-11   0.00000000000000E+00  -1.45741074382024E-11
      3.68921122709375E-18  -2.54143569655844E-01  -2.49907999419053E-01   0.00000000000000E+00  -3.59352107171405E-14
     -9.02112553000861E-23  -1.34439517672295E-08  -1.34439877024403E-08  -2.90783393219014E-18
      6.13278893035963E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.84229725947288E-16   1.89938403528980E-22
      1.34585325927991E-08   1.34585320085695E-08  -7.81370202361922E-19  -2.54146494101970E-01  -2.54146494101956E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44122672507328E-11   0.00000000000000E+00  -1.44122672507328E-11
      3.68917479596564E-18  -2.54146503245520E-01  -2.49910891413037E-01   0.00000000000000E+00  -3.49862718831106E-14
     -9.03950816689342E-23  -1.34440847550468E-08  -1.34441197413187E-08  -2.90780459360372E-18
      6.47404004716933E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.65756715515752E-16   1.88913589179909E-22
      1.34584937960520E-08   1.34584932302955E-08  -7.81361053248963E-19  -2.54150308684042E-01  -2.54150308684028E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42484312398012E-11   0.00000000000000E+00  -1.42484312398012E-11
      3.68912617303490E-18  -2.54150320334876E-01  -2.49914669107237E-01   0.00000000000000E+00  -3.40972155414651E-14
     -9.03965326193857E-23  -1.34442107018402E-08  -1.34442447990558E-08  -2.90776511978594E-18
      6.93472905486242E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.49095948159490E-16   1.88146139849207E-22
      1.34584431378450E-08   1.34584425887492E-08  -7.81349243147701E-19  -2.54155292386141E-01  -2.54155292386127E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40857064560448E-11   0.00000000000000E+00  -1.40857064560448E-11
      3.68906128173361E-18  -2.54155307961185E-01  -2.49919621427506E-01   0.00000000000000E+00  -3.33132382807183E-14
     -9.03932132192566E-23  -1.34443235690545E-08  -1.34443568822929E-08  -2.90771203858591E-18
      7.55665921524809E-11
      0.00000000000000E+00  -1.34583767219677E-11   0.00000000000000E+00  -5.34376389606043E-16   1.87629320566081E-22
      1.34583766970573E-08   1.34583761626811E-08  -7.81333986092080E-19  -2.54161837835310E-01  -2.54161837835296E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39213432726960E-11   0.00000000000000E+00  -1.39213432726960E-11
      3.68897470070106E-18  -2.54161859449296E-01  -2.49926142068297E-01   0.00000000000000E+00  -3.26429411293242E-14
     -9.03938994142376E-23  -1.34444221764674E-08  -1.34444548194087E-08  -2.90764071460898E-18
      8.39626493176874E-11
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00  -5.20703544381416E-16   1.87300104475570E-22
      1.34582893034924E-08   1.34582887827890E-08  -7.81314302614316E-19  -2.54170471183269E-01  -2.54170471183256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37457545352136E-11   0.00000000000000E+00  -1.37457545352136E-11
      3.68885929056020E-18  -2.54170501715210E-01  -2.49934756554399E-01   0.00000000000000E+00  -3.20518975168932E-14
     -9.03948653050057E-23  -1.34445109763561E-08  -1.34445430282537E-08  -2.90754498794589E-18
      9.52973264907162E-11
      0.00000000000000E+00  -1.34581930324933E-11   0.00000000000000E+00  -5.05848258804646E-16   1.87071858725342E-22
      1.34581745741077E-08   1.34581740682596E-08  -7.81289046516405E-19  -2.54181877444057E-01  -2.54181877444044E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35444494167102E-11   0.00000000000000E+00  -1.35444494167102E-11
      3.68870576859858E-18  -2.54181919603665E-01  -2.49946147176285E-01   0.00000000000000E+00  -3.14751996824176E-14
     -9.03961354636580E-23  -1.34445981436432E-08  -1.34446296188429E-08  -2.90741672208218E-18
      1.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00  -4.85104528359836E-16   1.86867853870947E-22
      1.34580259232968E-08   1.34580254381925E-08  -7.81256977100974E-19  -2.54196927089931E-01  -2.54196927089918E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33020645700347E-11   0.00000000000000E+00  -1.33020645700347E-11
      3.68850222287827E-18  -2.54196976638074E-01  -2.49961174691406E-01   0.00000000000000E+00  -3.08373054512552E-14
     -9.03978215326587E-23  -1.34446925363170E-08  -1.34447233736225E-08  -2.90724524577730E-18
      1.30599140674305E-10
      0.00000000000000E+00  -1.34578256535445E-11   0.00000000000000E+00  -4.52847686499759E-16   1.86642552250200E-22
      1.34578447693920E-08   1.34578443165445E-08  -7.81218063908465E-19  -2.54216095064996E-01  -2.54216095064983E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30148874656627E-11   0.00000000000000E+00  -1.30148874656627E-11
      3.68824192512896E-18  -2.54216114668392E-01  -2.49980279331897E-01   0.00000000000000E+00  -3.00862334730048E-14
     -9.03999850245091E-23  -1.34447993428452E-08  -1.34448294290788E-08  -2.90702386122049E-18
      1.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00  -4.19102234818511E-16   1.86429632565979E-22
      1.34576761781067E-08   1.34576757590046E-08  -7.81181829173181E-19  -2.54234809142503E-01  -2.54234809142490E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27492174547230E-11   0.00000000000000E+00  -1.27492174547230E-11
      3.68798694077986E-18  -2.54234739748435E-01  -2.49998873840082E-01   0.00000000000000E+00  -2.93850509455960E-14
     -9.04021106662970E-23  -1.34448971564989E-08  -1.34449265415499E-08  -2.90680511160668E-18
      1.70599140674305E-10
      0.00000000000000E+00  -1.34575501193329E-11   0.00000000000000E+00  -4.07021774423602E-16   1.86222700283935E-22
      1.34575114844726E-08   1.34575110774510E-08  -7.81148046599429E-19  -2.54253084782530E-01  -2.54253084782518E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24965459603464E-11   0.00000000000000E+00  -1.24965459603464E-11
      3.68773700986066E-18  -2.54252882468943E-01  -2.50016988862300E-01   0.00000000000000E+00  -2.87514582080152E-14
     -9.04042024420592E-23  -1.34449857800323E-08  -1.34450145314906E-08  -2.90658896326123E-18
      1.90599140674305E-10
      0.00000000000000E+00  -1.34573664298584E-11   0.00000000000000E+00  -4.42234522390437E-16   1.86019992241001E-22
      1.34573316756496E-08   1.34573312334153E-08  -7.81116589388179E-19  -2.54270901069462E-01  -2.54270901069450E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22455991800415E-11   0.00000000000000E+00  -1.22455991800415E-11
      3.68749209787706E-18  -2.54270601844850E-01  -2.50034685859794E-01   0.00000000000000E+00  -2.82485893067903E-14
     -9.04062695028346E-23  -1.34450573856458E-08  -1.34450856342352E-08  -2.90637550848887E-18
      2.10599140674305E-10
      0.00000000000000E+00  -1.34570908956468E-11   0.00000000000000E+00  -5.50060351810735E-16   1.85820668435232E-22
      1.34571131943650E-08   1.34571126443049E-08  -7.81087400868600E-19  -2.54288212266298E-01  -2.54288212266286E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19864312755149E-11   0.00000000000000E+00  -1.19864312755149E-11
      3.68725236925155E-18  -2.54287999181723E-01  -2.50052070430102E-01   0.00000000000000E+00  -2.79338914187125E-14
     -9.04083276230675E-23  -1.34450982791378E-08  -1.34451262130293E-08  -2.90616496838295E-18
      2.30599140674305E-10
      0.00000000000000E+00  -1.34568153614352E-11   0.00000000000000E+00  -6.56160904111144E-16   1.85624258814307E-22
      1.34568461063534E-08   1.34568454501927E-08  -7.81060391918312E-19  -2.54304993310541E-01  -2.54304993310529E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17203189591347E-11   0.00000000000000E+00  -1.17203189591347E-11
      3.68701796287236E-18  -2.54305199223978E-01  -2.50069270839239E-01   0.00000000000000E+00  -2.78537023537992E-14
     -9.04103905335083E-23  -1.34450972775311E-08  -1.34451251312336E-08  -2.90595757095405E-18
      2.50599140674305E-10
      0.00000000000000E+00  -1.34565398272236E-11   0.00000000000000E+00  -7.09679433371002E-16   1.85430908186271E-22
      1.34565619261034E-08   1.34565612164242E-08  -7.81035265456910E-19  -2.54321319619642E-01  -2.54321319619630E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14715357542624E-11   0.00000000000000E+00  -1.14715357542624E-11
      3.68678853215728E-18  -2.54322278611470E-01  -2.50086361413649E-01   0.00000000000000E+00  -2.77978444107119E-14
     -9.04124619577062E-23  -1.34450618828254E-08  -1.34450896806699E-08  -2.90575326670037E-18
      2.70599140674305E-10
      0.00000000000000E+00  -1.34563561377492E-11   0.00000000000000E+00  -5.05868798732408E-16   1.85241716460470E-22
      1.34563549174766E-08   1.34563544116080E-08  -7.81011349543054E-19  -2.54337444523348E-01  -2.54337444523337E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12909817531153E-11   0.00000000000000E+00  -1.12909817531153E-11
      3.68656271252221E-18  -2.54339147933847E-01  -2.50103239032218E-01   0.00000000000000E+00  -2.74365756481721E-14
     -9.04145085133571E-23  -1.34450359932791E-08  -1.34450634298549E-08  -2.90555136297916E-18
      2.90599140674305E-10
      0.00000000000000E+00  -1.34563561377492E-11   0.00000000000000E+00   2.33577293273623E-17   1.85058641441126E-22
      1.34563663073038E-08   1.34563663306617E-08  -7.80987620466622E-19  -2.54353791497863E-01  -2.54353791497852E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12371419921976E-11   0.00000000000000E+00  -1.12371419921976E-11
      3.68633796968237E-18  -2.54355449329063E-01  -2.50119519727949E-01   0.00000000000000E+00  -2.62219562154716E-14
     -9.04164607242931E-23  -1.34451029667132E-08  -1.34451291886695E-08  -2.90535034921575E-18
      3.10599140674305E-10
      0.00000000000000E+00  -1.34567235166980E-11   0.00000000000000E+00   8.44334777595318E-16   1.84883416715112E-22
      1.34566992985667E-08   1.34567001429017E-08  -7.80963137759815E-19  -2.54370758237253E-01  -2.54370758237242E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13244671986459E-11   0.00000000000000E+00  -1.13244671986459E-11
      3.68611148033840E-18  -2.54370596093324E-01  -2.50134588864260E-01   0.00000000000000E+00  -2.39492909186946E-14
     -9.04182245825880E-23  -1.34453517264121E-08  -1.34453756757031E-08  -2.90514834257858E-18
      3.30599140674305E-10
      0.00000000000000E+00  -1.34572745851212E-11   0.00000000000000E+00   1.46430296100237E-15   1.84715311265221E-22
      1.34572624633441E-08   1.34572639276473E-08  -7.80937977163908E-19  -2.54388289869743E-01  -2.54388289869732E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14500033035065E-11   0.00000000000000E+00  -1.14500033035065E-11
      3.68588248027233E-18  -2.54384099149547E-01  -2.50147953883393E-01   0.00000000000000E+00  -2.11562743086757E-14
     -9.04197595358006E-23  -1.34457927680693E-08  -1.34458139243437E-08  -2.90494450310842E-18
      3.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00   8.75381994926755E-16   1.84548534455236E-22
      1.34576099164133E-08   1.34576107917955E-08  -7.80914345657663E-19  -2.54405361100733E-01  -2.54405361100722E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13457264740275E-11   0.00000000000000E+00  -1.13457264740275E-11
      3.68565556574285E-18  -2.54396217200504E-01  -2.50159929799706E-01   0.00000000000000E+00  -1.95611183444152E-14
     -9.04211856143714E-23  -1.34462455042031E-08  -1.34462650653215E-08  -2.90474122008519E-18
      3.70599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -1.60338744044119E-15   1.84371481863698E-22
      1.34569395187661E-08   1.34569379153788E-08  -7.80896959174356E-19  -2.54419785501013E-01  -2.54419785501002E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06395371752209E-11   0.00000000000000E+00  -1.06395371752209E-11
      3.68544277499934E-18  -2.54408681857121E-01  -2.50172383987996E-01   0.00000000000000E+00  -2.23098239877646E-14
     -9.04228662740413E-23  -1.34462760683795E-08  -1.34462983782035E-08  -2.90454581582499E-18
      3.90599140674305E-10
      0.00000000000000E+00  -1.34545192430050E-11   0.00000000000000E+00  -5.81142389724009E-15   1.84171038814715E-22
      1.34544575249904E-08   1.34544517135667E-08  -7.80891332029782E-19  -2.54428974454335E-01  -2.54428974454326E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.10364851160971E-12   0.00000000000000E+00  -9.10364851160971E-12
      3.68526070202911E-18  -2.54424842954428E-01  -2.50188844587567E-01   0.00000000000000E+00  -3.19527889491306E-14
     -9.04253623771585E-23  -1.34453161122660E-08  -1.34453480650550E-08  -2.90436936999933E-18
      4.10599140674305E-10
      0.00000000000000E+00  -1.34502025403563E-11   0.00000000000000E+00  -7.78675530840924E-15   1.83944054443714E-22
      1.34502114392177E-08   1.34502036524626E-08  -7.80899009135278E-19  -2.54432105935885E-01  -2.54432105935878E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07868296879941E-12   0.00000000000000E+00  -7.07868296879941E-12
      3.68511912836974E-18  -2.54448328958695E-01  -2.50213031762375E-01   0.00000000000000E+00  -4.90706914178817E-14
     -9.04290998568172E-23  -1.34430758988023E-08  -1.34431249694938E-08  -2.90422011923446E-18
      4.30599140674305E-10
      0.00000000000000E+00  -1.34460695271819E-11   0.00000000000000E+00  -9.94931638002681E-15   1.83713477423770E-22
      1.34461400819774E-08   1.34461301326612E-08  -7.80910704023626E-19  -2.54433289612985E-01  -2.54433289612979E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86277140623131E-12   0.00000000000000E+00  -5.86277140623131E-12
      3.68500187294161E-18  -2.54479658709028E-01  -2.50245261033855E-01   0.00000000000000E+00  -5.79543984926949E-14
     -9.04337439836143E-23  -1.34402094068564E-08  -1.34402673612550E-08  -2.90409116891798E-18
      4.50599140674305E-10
      0.00000000000000E+00  -1.34465287508680E-11   0.00000000000000E+00   9.84394789299078E-16   1.78685621538816E-22
      1.34465339609832E-08   1.34465349453782E-08  -7.80901645105707E-19  -2.54443782929025E-01  -2.54443782929018E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.61856797268549E-12   0.00000000000000E+00  -7.61856797268549E-12
      3.68484950158216E-18  -2.54511673609016E-01  -2.50277701579064E-01   0.00000000000000E+00  -4.96977178527434E-14
     -9.11290803810862E-23  -1.34388666796877E-08  -1.34389163774056E-08  -2.90394785647645E-18
      4.70599140674305E-10
      0.00000000000000E+00  -1.34567235166980E-11   0.00000000000000E+00   2.55812452928619E-14   1.77551148507409E-22
      1.34566701401168E-08   1.34566957213623E-08  -7.80836968971758E-19  -2.54479660260451E-01  -2.54479660260437E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42608492099239E-11   0.00000000000000E+00  -1.42608492099239E-11
      3.68456428459796E-18  -2.54526912217870E-01  -2.50291831874368E-01   0.00000000000000E+00  -4.95278631807277E-15
     -9.10685825696057E-23  -1.34424299193659E-08  -1.34424348721524E-08  -2.90372731562620E-18
      4.90599140674305E-10
      0.00000000000000E+00  -1.34786744088906E-11   0.00000000000000E+00   5.90745368693022E-14   1.78879172903682E-22
      1.34786390038808E-08   1.34786980784179E-08  -7.80694582447980E-19  -2.54551465158722E-01  -2.54551465158697E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.51524368967417E-11   0.00000000000000E+00  -2.51524368967417E-11
      3.68406123586003E-18  -2.54502221226945E-01  -2.50263641733670E-01   0.00000000000000E+00   7.50044568795945E-14
     -9.11508485817604E-23  -1.34536206459779E-08  -1.34535456415211E-08  -2.90336665341204E-18
      5.00599140674305E-10
      0.00000000000000E+00  -1.34921755852601E-11   0.00000000000000E+00  -5.80172371892901E-14   1.82797442707871E-22
      1.34921013238019E-08   1.34920433065649E-08  -7.80602489908573E-19  -2.54597026352840E-01  -2.54597026352809E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.12766857215692E-11   0.00000000000000E+00  -3.12766857215692E-11
      3.68374846900281E-18  -2.54477611789683E-01  -2.50236716301328E-01   0.00000000000000E+00   2.55563175762058E-13
     -9.95978697574027E-23  -1.34610221840187E-08  -1.34607666208430E-08  -2.90314597909423E-18
      5.03974140674305E-10
      0.00000000000000E+00  -1.34975025800181E-11   0.00000000000000E+00   7.79287146446522E-14   1.82453710605750E-22
      1.34974175687725E-08   1.34974954974873E-08  -7.80569508505282E-19  -2.54613357856830E-01  -2.54613357856796E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.34827529466042E-11   0.00000000000000E+00  -3.34827529466042E-11
      3.68363546471161E-18  -2.54467432650439E-01  -2.50225553958401E-01   0.00000000000000E+00   1.44198039928201E-13
     -9.98011758581593E-23  -1.34641569425810E-08  -1.34640127445411E-08  -2.90306595620633E-18
      5.08530390674305E-10
      0.00000000000000E+00  -1.35047583142575E-11   0.00000000000000E+00   7.95047596920789E-14   1.84651109127716E-22
      1.35047197562802E-08   1.35047992610400E-08  -7.80520648055506E-19  -2.54637397764644E-01  -2.54637397764607E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64613361505255E-11   0.00000000000000E+00  -3.64613361505255E-11
      3.68346933774878E-18  -2.54450523037833E-01  -2.50207281736485E-01   0.00000000000000E+00   1.73070039996979E-13
     -9.69611392717336E-23  -1.34685109949291E-08  -1.34683379248892E-08  -2.90294868969327E-18
      5.14681328174305E-10
      0.00000000000000E+00  -1.35153204590364E-11   0.00000000000000E+00   8.49466034495296E-14   1.84769067487226E-22
      1.35152420574183E-08   1.35153270040219E-08  -7.80447874188987E-19  -2.54673075341466E-01  -2.54673075341425E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04187004839272E-11   0.00000000000000E+00  -4.04187004839272E-11
      3.68322072484827E-18  -2.54421411292693E-01  -2.50176099977576E-01   0.00000000000000E+00   2.08976103170349E-13
     -1.65454419679349E-22  -1.34751172796410E-08  -1.34749083035380E-08  -2.90277285065928E-18
      5.22985093799305E-10
      0.00000000000000E+00  -1.35299237722524E-11   0.00000000000000E+00   8.72020290606016E-14   3.89374346686721E-22
      1.35298172160642E-08   1.35299044180936E-08  -7.80341669082999E-19  -2.54725161509778E-01  -2.54725161509733E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.49604020233287E-11   0.00000000000000E+00  -4.49604020233287E-11
      3.68284738420746E-18  -2.54369882151469E-01  -2.50121409015501E-01   0.00000000000000E+00   2.54730502674301E-13
     -3.68854839864419E-22  -1.34851987465726E-08  -1.34849440160703E-08  -2.90250571512446E-18
      5.34195177393055E-10
      0.00000000000000E+00  -1.35459047565265E-11   0.00000000000000E+00   7.08894974556761E-14   2.87307251858511E-22
      1.35458146610522E-08   1.35458855505499E-08  -7.80206276651522E-19  -2.54792517302861E-01  -2.54792517302814E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70068435669752E-11   0.00000000000000E+00  -4.70068435669752E-11
      3.68232043356160E-18  -2.54280242476464E-01  -2.50027379035314E-01   0.00000000000000E+00   2.94619195109003E-13
      3.17499687471397E-22  -1.34991733261784E-08  -1.34988787069830E-08  -2.90211415691008E-18
      5.49328790244618E-10
      0.00000000000000E+00  -1.35422309670382E-11   0.00000000000000E+00  -1.15861429234519E-14   2.14240675342412E-22
      1.35422104178144E-08   1.35421988316717E-08  -7.80143780396821E-19  -2.54829933682101E-01  -2.54829933682068E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.29915711814112E-11   0.00000000000000E+00  -3.29915711814112E-11
      3.68182115189597E-18  -2.54153237417139E-01  -2.49897119688862E-01   0.00000000000000E+00   2.38010825689613E-13
     -8.77902928537546E-23  -1.35094452713158E-08  -1.35092072604901E-08  -2.90167737149916E-18
      5.69328790244618E-10
      0.00000000000000E+00  -1.34402833087378E-11   0.00000000000000E+00  -2.19855504901577E-13   1.87869852617751E-22
      1.34405470700923E-08   1.34403272145875E-08  -7.80618410512151E-19  -2.54625691650285E-01  -2.54625691650319E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42341292794102E-11   0.00000000000000E+00   3.42341292794102E-11
      3.68250583448156E-18  -2.54149050439028E-01  -2.49903857692893E-01   0.00000000000000E+00  -2.37458167045170E-13
     -4.70017609965892E-23  -1.34743238857000E-08  -1.34745613438670E-08  -2.90188742396941E-18
      5.79328790244618E-10
      0.00000000000000E+00  -1.33586333373604E-11   0.00000000000000E+00  -4.07142325670075E-13   1.84129677194363E-22
      1.33590486848309E-08   1.33586415425054E-08  -7.81042183089057E-19  -2.54438217578714E-01  -2.54438217578796E-01
      0.00000000000000E+00   0.00000000000000E+00   8.18966573921490E-11   0.00000000000000E+00   8.18966573921490E-11
      3.68332480105548E-18  -2.54215994699647E-01  -2.49981509784877E-01   0.00000000000000E+00  -5.36730101020954E-13
     -1.00087501090292E-22  -1.34400014697964E-08  -1.34405381998976E-08  -2.90228261796643E-18
      5.92828790244618E-10
      0.00000000000000E+00  -1.31843120261405E-11   0.00000000000000E+00  -6.21166286380428E-13   1.79285080814703E-22
      1.31849519267390E-08   1.31843307604528E-08  -7.82041052619979E-19  -2.53988140791430E-01  -2.53988140791600E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69917794893982E-10   0.00000000000000E+00   1.69917794893982E-10
      3.68561869128655E-18  -2.54516052765543E-01  -2.50308760326156E-01   0.00000000000000E+00  -1.22750667561799E-12
     -6.00516899099210E-23  -1.33530210486711E-08  -1.33542485553468E-08  -2.90357763866657E-18
      6.11053790244618E-10
      0.00000000000000E+00  -1.28847144933695E-11   0.00000000000000E+00  -7.77298585670413E-13   1.74675609639468E-22
      1.28855352652351E-08   1.28847579666496E-08  -7.83997270055811E-19  -2.53093039161309E-01  -2.53093039161595E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85679634831268E-10   0.00000000000000E+00   2.85679634831268E-10
      3.69082520263135E-18  -2.55441674413463E-01  -2.51292298889780E-01   0.00000000000000E+00  -2.28125588604833E-12
     -9.88025135051998E-23  -1.31681563455947E-08  -1.31704376014809E-08  -2.90682793257554E-18
      6.31053790244618E-10
      0.00000000000000E+00  -1.27170978479658E-11   0.00000000000000E+00  -3.78138813857262E-13   1.71066517708093E-22
      1.27175819263719E-08   1.27172037875582E-08  -7.85579228034403E-19  -2.52350827569489E-01  -2.52350827569761E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71417091899462E-10   0.00000000000000E+00   2.71417091899462E-10
      3.69625354446934E-18  -2.56859052568705E-01  -2.52766961579659E-01   0.00000000000000E+00  -2.58275484366099E-12
     -9.91097231964933E-23  -1.29860381246139E-08  -1.29886208794576E-08  -2.91067431643494E-18
      6.51053790244618E-10
      0.00000000000000E+00  -1.30858544678540E-11   0.00000000000000E+00   1.79457098392125E-12   1.74437616627548E-22
      1.30849517864045E-08   1.30867463573886E-08  -7.84199556275844E-19  -2.52948023594680E-01  -2.52948023594631E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.91664728215080E-11   0.00000000000000E+00  -4.91664728215080E-11
      3.69527021501291E-18  -2.57772474325275E-01  -2.53665228308833E-01   0.00000000000000E+00  -1.48856990543909E-12
     -9.89573596681802E-23  -1.30360913146616E-08  -1.30375798845671E-08  -2.91107065873707E-18
      6.71053790244618E-10
      0.00000000000000E+00  -1.43034401490142E-11   0.00000000000000E+00   3.01204006215649E-12   1.90201360363248E-22
      1.43004252439551E-08   1.43034372840174E-08  -7.77625852900667E-19  -2.55925483358038E-01  -2.55925483357310E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27319390842406E-10   0.00000000000000E+00  -7.27319390842406E-10
      3.68072382719606E-18  -2.56597941290154E-01  -2.52320750384714E-01   0.00000000000000E+00   4.31938241595195E-12
     -9.85532528986681E-23  -1.35804372755909E-08  -1.35761178931751E-08  -2.90309797429539E-18
      6.91053790244618E-10
      0.00000000000000E+00  -1.62519262488719E-11   0.00000000000000E+00   4.82610719537239E-12   2.18815083483761E-22
      1.62471182997022E-08   1.62519444068978E-08  -7.66269625090463E-19  -2.61136707894646E-01  -2.61136707893107E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53897555443321E-09   0.00000000000000E+00  -1.53897555443321E-09
      3.64994431610740E-18  -2.51643314063327E-01  -2.47007951652638E-01   0.00000000000000E+00   1.07051594103046E-11
     -9.73936059353471E-23  -1.47236740118747E-08  -1.47129688524645E-08  -2.88367469101693E-18
      7.11053790244618E-10
      0.00000000000000E+00  -1.79345218345137E-11   0.00000000000000E+00   4.17576475802191E-12   2.47996422781233E-22
      1.79303755421380E-08   1.79345513068963E-08  -7.55198227478584E-19  -2.66331026644737E-01  -2.66331026642824E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91358036503735E-09   0.00000000000000E+00  -1.91358036503735E-09
      3.61167270880665E-18  -2.42711969429176E-01  -2.37664503984243E-01   0.00000000000000E+00   1.46431051767416E-11
     -9.60523771879605E-23  -1.60356140470356E-08  -1.60209709418590E-08  -2.85647448132807E-18
      7.31053790244618E-10
      0.00000000000000E+00  -1.72439412554504E-11   0.00000000000000E+00  -1.68844821626337E-12   2.46667852415552E-22
      1.72455900753728E-08   1.72439016271568E-08  -7.54540578893299E-19  -2.66912668800242E-01  -2.66912668799313E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29363813646500E-10   0.00000000000000E+00  -9.29363813646500E-10
      3.59308543253372E-18  -2.33920236732381E-01  -2.28780264513559E-01   0.00000000000000E+00   1.05239488253217E-11
     -9.50698526053442E-23  -1.63250617623354E-08  -1.63145378135102E-08  -2.83854485364042E-18
      7.51053790244618E-10
      0.00000000000000E+00  -1.20507642795252E-11   0.00000000000000E+00  -1.28303774136536E-11   1.81674101053813E-22
      1.20636078824963E-08   1.20507775050829E-08  -7.78477061243533E-19  -2.56276853112031E-01  -2.56276853114323E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29172832022081E-09   0.00000000000000E+00   2.29172832022081E-09
      3.63891999893814E-18  -2.34377068802238E-01  -2.29858381604798E-01   0.00000000000000E+00  -8.54555237309449E-12
     -9.61365065996862E-23  -1.43339602729305E-08  -1.43425058253037E-08  -2.86044293769461E-18
      7.71053790244618E-10
      0.00000000000000E+00  -3.62116245388116E-12   0.00000000000000E+00  -2.08967844767669E-11   7.01937905355604E-23
      3.64202366142131E-09   3.62112687694461E-09  -8.39476763876046E-19  -2.28272748815107E-01  -2.28272748822081E-01
      0.00000000000000E+00   0.00000000000000E+00   6.97467795979343E-09   0.00000000000000E+00   6.97467795979343E-09
      3.77841355813401E-18  -2.49144123789879E-01  -2.45805835876454E-01   0.00000000000000E+00  -4.81506809866282E-11
     -1.00535055898176E-22  -1.05476541557513E-08  -1.05958048367381E-08  -2.93893679425796E-18
      7.91053790244618E-10
      0.00000000000000E+00   2.88842514043951E-12   0.00000000000000E+00  -1.63183660202493E-11  -1.60130707244996E-23
     -2.87208419170343E-09  -2.88840255772370E-09  -9.36307978353858E-19  -1.82172419573923E-01  -1.82172419584377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04531304379072E-08   0.00000000000000E+00   1.04531304379072E-08
      3.98747616689215E-18  -2.69938199258427E-01  -2.67554837530425E-01   0.00000000000000E+00  -1.02990922773856E-10
     -1.07950956291589E-22  -7.46173695740957E-09  -7.56472788018353E-09  -3.05116818853829E-18
      8.11053790244618E-10
      0.00000000000000E+00   4.71833968456227E-12   0.00000000000000E+00  -4.91828317537080E-12  -4.14972826024439E-23
     -4.71339278269585E-09  -4.71831106587126E-09  -1.03921902266998E-18  -1.30436053509893E-01  -1.30436053520476E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05826608237952E-08   0.00000000000000E+00   1.05826608237952E-08
      4.19912938336806E-18  -2.88185507451899E-01  -2.86337843290178E-01   0.00000000000000E+00  -1.44344557020404E-10
     -1.16338710549213E-22  -5.72000520090339E-09  -5.86434975792391E-09  -3.15991036069807E-18
      8.31053790244618E-10
      0.00000000000000E+00   3.27793867093663E-12   0.00000000000000E+00   3.20766623853080E-12  -4.52163298824321E-23
     -3.28117749940644E-09  -3.27796983316795E-09  -1.10732220439482E-18  -9.43455997951743E-02  -9.43455998024647E-02
      0.00000000000000E+00   0.00000000000000E+00   7.29042109619058E-09   0.00000000000000E+00   7.29042109619058E-09
      4.34493780529187E-18  -3.03813473147550E-01  -3.02549271742340E-01   0.00000000000000E+00  -1.32992802219603E-10
     -1.23505114093465E-22  -3.87945846080291E-09  -4.01245126302264E-09  -3.23761560089704E-18
      8.51053790244618E-10
      0.00000000000000E+00   7.46422179285570E-13   0.00000000000000E+00   6.14542743655742E-12  -4.54849629430882E-23
     -7.52617521587886E-10  -7.46472094151374E-10  -1.12412686734872E-18  -8.51722990665649E-02  -8.51722990692572E-02
      0.00000000000000E+00   0.00000000000000E+00   2.69225875028795E-09   0.00000000000000E+00   2.69225875028795E-09
      4.39878298029762E-18  -3.18319199005521E-01  -3.17706143114279E-01   0.00000000000000E+00  -6.78486323596992E-11
     -1.26847727542418E-22  -1.87793802377679E-09  -1.94578665613661E-09  -3.27465611294891E-18
      8.71053790244618E-10
      0.00000000000000E+00  -1.87372448377075E-12   0.00000000000000E+00   6.63638821745259E-12  -4.43753622490610E-23
      1.86707962065178E-09   1.87371600886919E-09  -1.09075644490604E-18  -1.03012282862269E-01  -1.03012282860735E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53363660385200E-09   0.00000000000000E+00  -1.53363660385200E-09
      4.36811024822059E-18  -3.35007761448834E-01  -3.34900629508697E-01   0.00000000000000E+00   6.34457622660043E-12
     -1.26707739639070E-22  -3.46423981243581E-10  -3.40079405017108E-10  -3.27735380331454E-18
      8.91053790244618E-10
      0.00000000000000E+00  -3.99726665274598E-12   0.00000000000000E+00   5.53895339223134E-12  -3.91478686714736E-23
      3.99175464412785E-09   3.99729359752004E-09  -1.02433300690986E-18  -1.37075949287509E-01  -1.37075949283640E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.86885772519758E-09   0.00000000000000E+00  -3.86885772519758E-09
      4.29073309371663E-18  -3.58330744298774E-01  -3.58290316899154E-01   0.00000000000000E+00   3.25914140302645E-11
     -1.25208671645686E-22  -1.61027286352707E-10  -1.28435872322567E-10  -3.26640008680678E-18
      9.11053790244618E-10
      0.00000000000000E+00  -6.07718257154763E-12   0.00000000000000E+00   5.40989939897603E-12  -1.57595936597371E-23
      6.07181523320402E-09   6.07722513260298E-09  -9.46659931898994E-19  -1.74890755824355E-01  -1.74890755819580E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.77558241608953E-09   0.00000000000000E+00  -4.77558241608953E-09
      4.19522144539484E-18  -3.81496225006190E-01  -3.81086212415308E-01   0.00000000000000E+00   3.97347709290366E-11
     -1.23234271037028E-22  -1.34137748744233E-09  -1.30164271651342E-09  -3.24856151349585E-18
      9.31053790244618E-10
      0.00000000000000E+00  -1.09793954199994E-11   0.00000000000000E+00   1.23125471033493E-11   6.37650857848749E-23
      1.09670984996322E-08   1.09794110467356E-08  -8.61736016877303E-19  -2.14371999636991E-01  -2.14371999630895E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.09644849500744E-09   0.00000000000000E+00  -6.09644849500744E-09
      4.07329247549469E-18  -3.95601015328334E-01  -3.94062788608560E-01   0.00000000000000E+00   6.16949511012283E-11
     -1.19839593695784E-22  -4.94465750282908E-09  -4.88296255172797E-09  -3.21155645861739E-18
      9.51053790244618E-10
      0.00000000000000E+00  -2.21846370487920E-11   0.00000000000000E+00   2.78447574453148E-11   2.51557783476436E-22
      2.21568579502893E-08   2.21847027077349E-08  -7.75192032508993E-19  -2.53422670403996E-01  -2.53422670395705E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.29091732920257E-09   0.00000000000000E+00  -8.29091732920257E-09
      3.90747412891064E-18  -3.87069819332747E-01  -3.82692844177561E-01   0.00000000000000E+00   9.61580005389498E-11
     -1.13759493520927E-22  -1.39899433790714E-08  -1.38937853785326E-08  -3.13228209640165E-18
      9.71053790244618E-10
      0.00000000000000E+00  -3.66261198378291E-11   0.00000000000000E+00   3.58054836785665E-11   5.16651214990320E-22
      3.65902726389540E-08   3.66260781226331E-08  -7.07736960807924E-19  -2.84118618616567E-01  -2.84118618606505E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00619883488955E-08   0.00000000000000E+00  -1.00619883488955E-08
      3.70623436193273E-18  -3.43115826326318E-01  -3.34746993866620E-01   0.00000000000000E+00   1.17479646417759E-10
     -1.04309540628146E-22  -2.66815694201552E-08  -2.65640897737375E-08  -2.99849740112481E-18
      9.91053790244618E-10
      0.00000000000000E+00  -4.58156450191282E-11   0.00000000000000E+00   2.28565314215411E-11   7.06152769788112E-22
      4.57928431422685E-08   4.58156996736908E-08  -6.66508106966186E-19  -3.04315435926922E-01  -3.04315435915806E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11156836518520E-08   0.00000000000000E+00  -1.11156836518520E-08
      3.48392068889569E-18  -2.67369420755166E-01  -2.56437101230679E-01   0.00000000000000E+00   1.15029653713961E-10
     -9.49057863120481E-23  -3.48150456755526E-08  -3.47000160218388E-08  -2.81741258192951E-18
      1.01105379024462E-09
      0.00000000000000E+00  -4.75217528574952E-11   0.00000000000000E+00   4.29554946726977E-12   7.59975086447613E-22
      4.75174729298379E-08   4.75217684793060E-08  -6.43100259940463E-19  -3.17549754852325E-01  -3.17549754840679E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16460033663533E-08   0.00000000000000E+00  -1.16460033663533E-08
      3.25100062156863E-18  -1.79437856962852E-01  -1.68134872400685E-01   0.00000000000000E+00   8.84113897659909E-11
     -8.39237369093060E-23  -3.59641765027186E-08  -3.58757651129527E-08  -2.60790036162816E-18
      1.02105379024462E-09
      0.00000000000000E+00  -4.62464886813687E-11   0.00000000000000E+00  -6.24952771133999E-12   7.47106297456565E-22
      4.62527330755938E-08   4.62464835478832E-08  -6.35160145310600E-19  -3.22702058598542E-01  -3.22702058586692E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18500330320893E-08   0.00000000000000E+00  -1.18500330320893E-08
      3.13250029124774E-18  -1.35962507058885E-01  -1.25125514632472E-01   0.00000000000000E+00   6.82851004894081E-11
     -7.25623837892641E-23  -3.44647356162831E-08  -3.43964505157938E-08  -2.49734014593714E-18
      1.03455379024462E-09
      0.00000000000000E+00  -4.37607108688470E-11   0.00000000000000E+00  -7.88670325619615E-12   7.00832308754811E-22
      4.37698242007524E-08   4.37619374974969E-08  -6.24518969857336E-19  -3.29636020822012E-01  -3.29636020810180E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18312549729209E-08   0.00000000000000E+00  -1.18312549729209E-08
      2.97277834911330E-18  -8.55165999470502E-02  -7.54567884566356E-02   0.00000000000000E+00   4.82418207754496E-11
      1.70027008622067E-23  -3.19789243453514E-08  -3.19306825245759E-08  -2.34825937925596E-18
      1.05277879024462E-09
      0.00000000000000E+00  -3.86015164456886E-11   0.00000000000000E+00  -1.39737127028868E-11   6.56407756271083E-22
      3.86154531885638E-08   3.86014794758615E-08  -5.97645284315167E-19  -3.43314356227429E-01  -3.43314356216007E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14218054132669E-08   0.00000000000000E+00  -1.14218054132669E-08
      2.76461594545651E-18  -4.40435118965782E-02  -3.54801396608688E-02   0.00000000000000E+00   3.30467690537285E-11
      3.20084880673512E-22  -2.72127208316487E-08  -2.71796740625947E-08  -2.16697066114134E-18
      1.07277879024462E-09
      0.00000000000000E+00  -3.35567605650908E-11   0.00000000000000E+00  -1.24354698525767E-11   6.52295441564610E-22
      3.35692334110124E-08   3.35567979411605E-08  -5.50471478632178E-19  -3.64335038814655E-01  -3.64335038803823E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08323652671525E-08   0.00000000000000E+00  -1.08323652671525E-08
      2.54796864011346E-18  -2.58338060626994E-02  -1.86741033709027E-02   0.00000000000000E+00   2.02175795780354E-11
      6.29143266825303E-22  -2.27446502535866E-08  -2.27244326740080E-08  -1.99749716148128E-18
      1.09277879024462E-09
      0.00000000000000E+00  -3.07652316224052E-11   0.00000000000000E+00  -6.86603654104200E-12   6.20466681353805E-22
      3.07720628038680E-08   3.07651967673275E-08  -4.99052599629733E-19  -3.86791407651797E-01  -3.86791407641300E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04968849198904E-08   0.00000000000000E+00  -1.04968849198904E-08
      2.33803094171565E-18  -1.86761779400189E-02  -1.22903038853475E-02   0.00000000000000E+00   1.17020272024572E-11
      7.61170114469996E-22  -2.02800138746403E-08  -2.02683118474371E-08  -1.83897834208592E-18
      1.11277879024462E-09
      0.00000000000000E+00  -2.90812583657052E-11   0.00000000000000E+00  -4.12432672041893E-12   5.38604019025793E-22
      2.90853283733311E-08   2.90812040466112E-08  -4.49091370898759E-19  -4.08754653289042E-01  -4.08754653278726E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03158486874919E-08   0.00000000000000E+00  -1.03158486874919E-08
      2.13171396796582E-18  -1.50960752247424E-02  -9.18372550256479E-03   0.00000000000000E+00   8.11353136575559E-12
      7.35805787935512E-22  -1.87734688904859E-08  -1.87653553591194E-08  -1.68262259706706E-18
      1.13277879024462E-09
      0.00000000000000E+00  -2.79698452007570E-11   0.00000000000000E+00  -2.70991173532273E-12   4.31498699281014E-22
      2.79725286521564E-08   2.79698187404215E-08  -4.00677139362165E-19  -4.30191290387146E-01  -4.30191290376899E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02463351551768E-08   0.00000000000000E+00  -1.02463351551768E-08
      1.92678726486228E-18  -1.29417151167962E-02  -7.35761958385789E-03   0.00000000000000E+00   6.44126640819975E-12
      6.19966258640007E-22  -1.77299248516535E-08  -1.77234835852447E-08  -1.52611012550012E-18
      1.15277879024462E-09
      0.00000000000000E+00  -2.77557551183262E-11   0.00000000000000E+00  -4.95838217059995E-13   3.16919633725617E-22
      2.77562010638067E-08   2.77557052255900E-08  -3.50491708336251E-19  -4.52420634324389E-01  -4.52420634313686E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07037759321181E-08   0.00000000000000E+00  -1.07037759321181E-08
      1.71271174621992E-18  -1.15791558044495E-02  -6.20664052024130E-03   0.00000000000000E+00   5.40189907966173E-12
      4.66305846526497E-22  -1.70573311925520E-08  -1.70519292934719E-08  -1.36222003788367E-18
      1.17277879024462E-09
      0.00000000000000E+00  -2.81943137384921E-11   0.00000000000000E+00   1.11769002926662E-12   2.09553938044114E-22
      2.81931859638631E-08   2.81943036538926E-08  -2.97542063350513E-19  -4.75855561408248E-01  -4.75855561396850E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13979169932172E-08   0.00000000000000E+00  -1.13979169932172E-08
      1.48475340635558E-18  -1.07496184959799E-02  -5.45761186515523E-03   0.00000000000000E+00   4.31374552826658E-12
      3.09238424229036E-22  -1.68007004062039E-08  -1.67963866606754E-08  -1.18721134300506E-18
      1.18277879024462E-09
      0.00000000000000E+00  -2.84787568896239E-11   0.00000000000000E+00   1.44049328714363E-12   1.57501870307062E-22
      2.84773403553702E-08   2.84787808486575E-08  -2.70829970346274E-19  -4.87742619131392E-01  -4.87742619119630E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17615593552253E-08   0.00000000000000E+00  -1.17615593552253E-08
      1.36713781280332E-18  -1.04395580833797E-02  -5.17249168280066E-03   0.00000000000000E+00   3.90325180603304E-12
      2.30104693670137E-22  -1.67211247452383E-08  -1.67172214934321E-08  -1.09630784245705E-18
      1.19627879024462E-09
      0.00000000000000E+00  -2.88217051383568E-11   0.00000000000000E+00   1.29132856748795E-12   1.02385812057430E-22
      2.88203984834983E-08   2.88216898120659E-08  -2.34700303857204E-19  -5.03861958306045E-01  -5.03861958294108E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19370211036372E-08   0.00000000000000E+00  -1.19370211036372E-08
      1.20598802790422E-18  -1.01882427071031E-02  -4.86841609180465E-03   0.00000000000000E+00   2.76789953194828E-12
      1.46028822228188E-22  -1.68874366079609E-08  -1.68846687084288E-08  -9.71287724047018E-19
      1.21450379024462E-09
      0.00000000000000E+00  -2.83914125445395E-11   0.00000000000000E+00  -1.13108199524949E-12   5.36639333885733E-23
      2.83925954629652E-08   2.83914643809700E-08  -1.90779093929707E-19  -5.23616735285316E-01  -5.23616735274227E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10890054926288E-08   0.00000000000000E+00  -1.10890054926288E-08
      1.00389090280106E-18  -9.94771732671645E-03  -4.49625421470432E-03   0.00000000000000E+00   1.76702502905195E-12
      7.15881266535312E-23  -1.73042259133703E-08  -1.73024588883412E-08  -8.13111808871354E-19
      1.23450379024462E-09
      0.00000000000000E+00  -2.32007153765189E-11   0.00000000000000E+00  -1.27828116171215E-11   2.42418095677936E-23
      2.32134922335380E-08   2.32007094219209E-08  -1.67674307707482E-19  -5.33916889975669E-01  -5.33916889970038E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63077099775106E-09   0.00000000000000E+00  -5.63077099775106E-09
      8.91275482846040E-19  -9.34439288099095E-03  -3.80865229501793E-03   0.00000000000000E+00   7.11300174222985E-13
      2.79157443494136E-23  -1.75706497243441E-08  -1.75699384241699E-08  -7.23601175138558E-19
      1.25450379024462E-09
      0.00000000000000E+00  -9.64746304101582E-12   0.00000000000000E+00  -3.34122061933818E-11   8.97466686559565E-24
      9.68092115740871E-09   9.64750895121534E-09  -2.04071841577678E-19  -5.16879292800493E-01  -5.16879292808508E-01
      0.00000000000000E+00   0.00000000000000E+00   8.01549080390886E-09   0.00000000000000E+00   8.01549080390886E-09
      1.05158529892422E-18  -8.10492004734987E-03  -2.53985800190713E-03   0.00000000000000E+00  -2.21776801342291E-12
      7.49596325950751E-24  -1.76607819871107E-08  -1.76629997551241E-08  -8.47513457346537E-19
      1.27450379024462E-09
      0.00000000000000E+00   7.08527040713744E-12   0.00000000000000E+00  -4.12902438250847E-11  -3.81948839685229E-24
     -7.04394037044647E-09  -7.08523061427156E-09  -3.28164549348744E-19  -4.62853713080789E-01  -4.62853713105535E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47460129315077E-08   0.00000000000000E+00   2.47460129315077E-08
      1.54650555755437E-18  -6.57321674642928E-03  -1.00885530880165E-03   0.00000000000000E+00  -7.70514977399775E-12
     -9.81826284552935E-24  -1.76530771674622E-08  -1.76607823172362E-08  -1.21834100820563E-18
      1.29450379024462E-09
      0.00000000000000E+00   1.62924297779804E-11   0.00000000000000E+00  -2.29411971957992E-11  -2.78431006444059E-23
     -1.62694360584467E-08  -1.62923772556426E-08  -5.50298309223216E-19  -3.73423277304446E-01  -3.73423277338295E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38496397154949E-08   0.00000000000000E+00   3.38496397154949E-08
      2.22349835186427E-18  -5.49107969561244E-03   4.06555661602991E-05   0.00000000000000E+00  -1.86424109500831E-11
     -5.17519485401778E-23  -1.75386200489021E-08  -1.75572624598523E-08  -1.67320004264105E-18
      1.31450379024462E-09
      0.00000000000000E+00   1.42228004697460E-11   0.00000000000000E+00   4.59658139041724E-12  -4.13587322093111E-23
     -1.42273835949191E-08  -1.42227870135287E-08  -8.16314693576304E-19  -2.61873285522309E-01  -2.61873285553110E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08018726342999E-08   0.00000000000000E+00   3.08018726342999E-08
      2.83953580455027E-18  -1.09435263284798E-02  -5.71999430094115E-03   0.00000000000000E+00  -4.25988786496940E-11
     -7.77427994992775E-23  -1.65364867421214E-08  -1.65790856207712E-08  -2.02322111097396E-18
      1.33450379024462E-09
      0.00000000000000E+00   1.06182619132994E-11   0.00000000000000E+00   8.19974583639885E-12  -4.46224061377455E-23
     -1.06264746870850E-08  -1.06182749412486E-08  -1.02810425433338E-18  -1.58381392457003E-01  -1.58381392481148E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41445082207004E-08   0.00000000000000E+00   2.41445082207004E-08
      3.32242596896428E-18  -3.65026327377632E-02  -3.22409610306713E-02   0.00000000000000E+00  -8.45740519881771E-11
     -8.99985911742781E-23  -1.34416592274634E-08  -1.35262332794517E-08  -2.29432171463089E-18
      1.35450379024462E-09
      0.00000000000000E+00   7.23773267090194E-12   0.00000000000000E+00   7.56386895124446E-12  -4.67524482615465E-23
     -7.24527679009114E-09  -7.23771292113994E-09  -1.17157341750417E-18  -7.89846492904900E-02  -7.89846493083876E-02
      0.00000000000000E+00   0.00000000000000E+00   1.78976288362563E-08   0.00000000000000E+00   1.78976288362563E-08
      3.68037854568940E-18  -7.81552908816876E-02  -7.47966983974166E-02   0.00000000000000E+00  -1.44179432536231E-10
     -1.02813687338395E-22  -1.05157364825800E-08  -1.06599159151164E-08  -2.50880512818523E-18
      1.35575379024462E-09
      0.00000000000000E+00   6.71375844513300E-12   0.00000000000000E+00   1.93254582613464E-11  -4.68917438823460E-23
     -6.73305396186618E-09  -6.71372850360488E-09  -1.17988733289036E-18  -7.41683101314031E-02  -7.41683101482669E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68638710600813E-08   0.00000000000000E+00   1.68638710600813E-08
      3.70145838451450E-18  -8.09284152764870E-02  -7.77304072311048E-02   0.00000000000000E+00  -1.73845871406873E-10
     -1.03655339214833E-22  -9.97629668507124E-09  -1.01501425564782E-08  -2.52157105162414E-18
      1.35744129024462E-09
      0.00000000000000E+00   6.11548182696317E-12   0.00000000000000E+00   1.67171699979538E-11  -4.70488781629066E-23
     -6.13215313349759E-09  -6.11543596349969E-09  -1.19009756894163E-18  -6.81866088138584E-02  -6.81866088296577E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57993035042794E-08   0.00000000000000E+00   1.57993035042794E-08
      3.72811970917798E-18  -8.48907944877109E-02  -8.18396897755163E-02   0.00000000000000E+00  -1.83838121320333E-10
     -1.04788840688558E-22  -9.50002941945946E-09  -9.68386754077990E-09  -2.53802214023635E-18
      1.35971941524462E-09
      0.00000000000000E+00   5.38614276879820E-12   0.00000000000000E+00   1.50553966615970E-11  -4.72215221385690E-23
     -5.40120856778489E-09  -5.38615317112334E-09  -1.20221429374604E-18  -6.10108506462942E-02  -6.10108506608484E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45541872699704E-08   0.00000000000000E+00   1.45541872699704E-08
      3.76127596705237E-18  -9.05607794823703E-02  -8.76721973136320E-02   0.00000000000000E+00  -1.86420941823639E-10
     -1.06275199057120E-22  -8.98161315702311E-09  -9.16803409884686E-09  -2.55906167330634E-18
      1.36279488399462E-09
      0.00000000000000E+00   4.48982997838995E-12   0.00000000000000E+00   1.37279467134919E-11  -4.74054214842053E-23
     -4.50361704315433E-09  -4.48988909644089E-09  -1.21580885445320E-18  -5.28504043181811E-02  -5.28504043312104E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30292707795962E-08   0.00000000000000E+00   1.30292707795962E-08
      3.80134708217031E-18  -9.87187789652056E-02  -9.60282651419355E-02   0.00000000000000E+00  -1.86702662332331E-10
     -1.08200336606384E-22  -8.35267902082292E-09  -8.53938168315536E-09  -2.58553822771711E-18
      1.36694676680712E-09
      0.00000000000000E+00   3.44913726109146E-12   0.00000000000000E+00   1.18591739861014E-11  -4.75858089102464E-23
     -3.46098766468907E-09  -3.44912849070302E-09  -1.22983424864847E-18  -4.42790912954066E-02  -4.42790913066437E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12370110559373E-08   0.00000000000000E+00   1.12370110559373E-08
      3.84800183523733E-18  -1.10471762228171E-01  -1.08018024337942E-01   0.00000000000000E+00  -1.85951865871433E-10
     -1.10663609431272E-22  -7.60193069936289E-09  -7.78788256523443E-09  -2.61816758658886E-18
      1.37255180860399E-09
      0.00000000000000E+00   2.37969714104702E-12   0.00000000000000E+00   9.06377212460444E-12  -4.77424581862329E-23
     -2.38884438785825E-09  -2.37978061573369E-09  -1.24277132446928E-18  -3.61663665053065E-02  -3.61663665146502E-02
      0.00000000000000E+00   0.00000000000000E+00   9.34372998124120E-09   0.00000000000000E+00   9.34372998124120E-09
      3.90037383232090E-18  -1.27236840725604E-01  -1.25042699236251E-01   0.00000000000000E+00  -1.85349396320588E-10
     -1.13786018882597E-22  -6.77859996918704E-09  -6.96394936550774E-09  -2.65760250785162E-18
      1.38011861502977E-09
      0.00000000000000E+00   1.46519909267167E-12   0.00000000000000E+00   5.75708040056406E-12  -4.78627106662415E-23
     -1.47096398665239E-09  -1.46520690625188E-09  -1.25331855949605E-18  -2.92767148848180E-02  -2.92767148924410E-02
      0.00000000000000E+00   0.00000000000000E+00   7.62295535735020E-09   0.00000000000000E+00   7.62295535735020E-09
      3.95805525990234E-18  -1.50560793842484E-01  -1.48620661373193E-01   0.00000000000000E+00  -1.86908259524642E-10
     -1.17745184434606E-22  -5.97084019157341E-09  -6.15774845109817E-09  -2.70473670040629E-18
      1.39033380370458E-09
      0.00000000000000E+00   8.31286716465325E-13   0.00000000000000E+00   2.95504721969814E-12  -4.79471096725601E-23
     -8.34186684813080E-10  -8.31231637593429E-10  -1.26109391930663E-18  -2.38479783199596E-02  -2.38479783262025E-02
      0.00000000000000E+00   0.00000000000000E+00   6.24286956405111E-09   0.00000000000000E+00   6.24286956405111E-09
      4.02182735037132E-18  -1.81745204066278E-01  -1.80040147372120E-01   0.00000000000000E+00  -1.91705716721545E-10
     -1.22788179357203E-22  -5.21993220973589E-09  -5.41163792645756E-09  -2.76073343106469E-18
      1.40412430841556E-09
      0.00000000000000E+00   4.68132625546764E-13   0.00000000000000E+00   1.24814173207482E-12  -4.80042466145665E-23
     -4.69364454654854E-10  -4.68116312922827E-10  -1.26660937920170E-18  -1.96194839553027E-02  -1.96194839604026E-02
      0.00000000000000E+00   0.00000000000000E+00   5.09998000257751E-09   0.00000000000000E+00   5.09998000257751E-09
      4.09215864862280E-18  -2.20852169707997E-01  -2.19392794823421E-01   0.00000000000000E+00  -1.95460991762123E-10
     -1.29089307367246E-22  -4.43640269789243E-09  -4.63186368965468E-09  -2.82554926942109E-18
      1.42274148977540E-09
      0.00000000000000E+00   2.90596748524615E-13   0.00000000000000E+00   4.46729715183606E-13  -4.80449388055862E-23
     -2.91007690242310E-10  -2.90560960527174E-10  -1.27078917623757E-18  -1.61848509990906E-02  -1.61848510029951E-02
      0.00000000000000E+00   0.00000000000000E+00   3.90445074998971E-09   0.00000000000000E+00   3.90445074998971E-09
      4.16484851634589E-18  -2.64040312643257E-01  -2.62901670260792E-01   0.00000000000000E+00  -1.82411542623721E-10
     -1.36240331119991E-22  -3.43147824683861E-09  -3.61388978946246E-09  -2.89405934010832E-18
      1.44274148977540E-09
      0.00000000000000E+00   2.15375908751650E-13   0.00000000000000E+00   1.73123876572097E-13  -4.80708826828264E-23
     -2.15525016649417E-10  -2.15351892772893E-10  -1.27380726071242E-18  -1.37751836661442E-02  -1.37751836689001E-02
      0.00000000000000E+00   0.00000000000000E+00   2.75586507723108E-09   0.00000000000000E+00   2.75586507723108E-09
      4.21996581789051E-18  -2.97069354095211E-01  -2.96268902137502E-01   0.00000000000000E+00  -1.46882164104553E-10
     -1.41901254016436E-22  -2.39363102035351E-09  -2.54051318445820E-09  -2.94615855717809E-18
      1.46274148977540E-09
      0.00000000000000E+00   1.77903255970979E-13   0.00000000000000E+00   8.56619363644246E-14  -4.80867651916011E-23
     -1.77978724675908E-10  -1.77893062739592E-10  -1.27609741170728E-18  -1.21341626386009E-02  -1.21341626404392E-02
      0.00000000000000E+00   0.00000000000000E+00   1.83824418907715E-09   0.00000000000000E+00   1.83824418907715E-09
      4.25673070167205E-18  -3.18147142077535E-01  -3.17624008412520E-01   0.00000000000000E+00  -1.01333334533867E-10
     -1.45588393282541E-22  -1.55901779180352E-09  -1.66035112633753E-09  -2.98063328996477E-18
      1.48274148977540E-09
      0.00000000000000E+00   1.58248482208569E-13   0.00000000000000E+00   4.46224300516841E-14  -4.80973011546690E-23
     -1.58283602692389E-10  -1.58238980262385E-10  -1.27800773468630E-18  -1.09772055293353E-02  -1.09772055304744E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13915739116232E-09   0.00000000000000E+00   1.13915739116232E-09
      4.27951384949530E-18  -3.29523299077661E-01  -3.29214241736551E-01   0.00000000000000E+00  -5.61597570872638E-11
     -1.47575795472154E-22  -9.24758653812539E-10  -9.80918410899950E-10  -3.00150611480900E-18
      1.50274148977539E-09
      0.00000000000000E+00   1.25368066288274E-13   0.00000000000000E+00   8.22355484933973E-14  -4.80957245290865E-23
     -1.25486369336657E-10  -1.25404133788211E-10  -1.27927238231636E-18  -1.03042228231747E-02  -1.03042228239988E-02
      0.00000000000000E+00   0.00000000000000E+00   8.24120532354729E-10   0.00000000000000E+00   8.24120532354729E-10
      4.29599626014240E-18  -3.37199798328427E-01  -3.36979657801656E-01   0.00000000000000E+00  -3.67349007598013E-11
     -1.48849045330051E-22  -6.61981497806546E-10  -6.98716398566496E-10  -3.01672387782604E-18
      1.52274148977539E-09
      0.00000000000000E+00   9.83657135492612E-14   0.00000000000000E+00   7.22307258474209E-14  -4.80854104679638E-23
     -9.84701586895591E-11  -9.83979279637598E-11  -1.28000938555616E-18  -9.91464622237930E-03  -9.91464622321668E-03
      0.00000000000000E+00   0.00000000000000E+00   8.37380681168554E-10   0.00000000000000E+00   8.37380681168554E-10
      4.31274387376577E-18  -3.45925867238839E-01  -3.45693038958256E-01   0.00000000000000E+00  -4.20989095633535E-11
     -1.50266113826425E-22  -6.96883843641347E-10  -7.38982753204851E-10  -3.03273448820961E-18
      1.52774148977539E-09
      0.00000000000000E+00   8.44053134937171E-14   0.00000000000000E+00   1.45590050148441E-13  -4.80811319131679E-23
     -8.45113216681254E-11  -8.43657316180251E-11  -1.28012430918436E-18  -9.85546493469261E-03  -9.85546493554017E-03
      0.00000000000000E+00   0.00000000000000E+00   8.47562720771351E-10   0.00000000000000E+00   8.47562720771351E-10
      4.31698168736963E-18  -3.48249892614212E-01  -3.48009434376325E-01   0.00000000000000E+00  -4.50994985880313E-11
     -1.50640163933909E-22  -7.18097490565020E-10  -7.63196989153202E-10  -3.03685737818526E-18
      1.53449148977539E-09
      0.00000000000000E+00   5.03309159897247E-14   0.00000000000000E+00   2.61642144271329E-13  -4.80703898862191E-23
     -5.05707065654979E-11  -5.03090644212747E-11  -1.28005161936315E-18  -9.87334487118306E-03  -9.87334487226465E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08158865574609E-09   0.00000000000000E+00   1.08158865574609E-09
      4.32428241079591E-18  -3.52982686843571E-01  -3.52657758622012E-01   0.00000000000000E+00  -7.02813599042732E-11
     -1.51413438513371E-22  -9.60998231420522E-10  -1.03127959132495E-09  -3.04423079143276E-18
      1.53904773977540E-09
      0.00000000000000E+00   3.37070185551623E-14   0.00000000000000E+00   1.97352127206369E-13  -4.80622509769743E-23
     -3.38623189436120E-11  -3.36649668164537E-11  -1.27992782202661E-18  -9.90839707357181E-03  -9.90839707485616E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28435119242149E-09   0.00000000000000E+00   1.28435119242149E-09
      4.33013423591638E-18  -3.57003206766116E-01  -3.56609145948246E-01   0.00000000000000E+00  -9.07304586255318E-11
     -1.52081880541066E-22  -1.15995576697970E-09  -1.25068622560539E-09  -3.05020641388977E-18
      1.54519867727539E-09
      0.00000000000000E+00   3.26048817086720E-14   0.00000000000000E+00   2.64300361826726E-14  -4.80525840205499E-23
     -3.26286606606343E-11  -3.26022306244997E-11  -1.27975643341207E-18  -9.92590604201906E-03  -9.92590604354241E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52335787343069E-09   0.00000000000000E+00   1.52335787343069E-09
      4.33950431498598E-18  -3.63558016676677E-01  -3.63088313099457E-01   0.00000000000000E+00  -1.13039332619411E-10
     -1.53198678949504E-22  -1.37771631018704E-09  -1.49075564280660E-09  -3.05974788157391E-18
      1.55350244290040E-09
      0.00000000000000E+00   4.45446975456505E-14   0.00000000000000E+00  -5.65849792001846E-14  -4.80422829821562E-23
     -4.45283451318948E-11  -4.45849301111430E-11  -1.27962893113921E-18  -9.85715132596196E-03  -9.85715132766371E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70174358982514E-09   0.00000000000000E+00   1.70174358982514E-09
      4.35363519490974E-18  -3.73389593937822E-01  -3.72867458983854E-01   0.00000000000000E+00  -1.30270219245038E-10
     -1.54916369712615E-22  -1.52688844046856E-09  -1.65715865971376E-09  -3.07400626377053E-18
      1.56471252649415E-09
      0.00000000000000E+00   6.13522844546279E-14   0.00000000000000E+00  -6.31330986221563E-14  -4.80320777867483E-23
     -6.13039328206217E-11  -6.13670659192919E-11  -1.27965280095248E-18  -9.63233269821207E-03  -9.63233269998511E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77304181705024E-09   0.00000000000000E+00   1.77304181705024E-09
      4.37351114189409E-18  -3.87034758356167E-01  -3.86495445904888E-01   0.00000000000000E+00  -1.39842511900219E-10
     -1.57361204216357E-22  -1.57183223923055E-09  -1.71167475113093E-09  -3.09385834094160E-18
      1.57984613934571E-09
      0.00000000000000E+00   8.70688108727354E-14   0.00000000000000E+00  -7.81587584352076E-14  -4.80258761381077E-23
     -8.70136954781475E-11  -8.70918542366307E-11  -1.28008759395829E-18  -9.09407836285918E-03  -9.09407836462828E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76910248072544E-09   0.00000000000000E+00   1.76910248072544E-09
      4.40028405393212E-18  -4.04967055534984E-01  -4.04437089374852E-01   0.00000000000000E+00  -1.44133931992969E-10
     -1.60681081493631E-22  -1.53787669449576E-09  -1.68201062648889E-09  -3.12019645997383E-18
      1.59984613934571E-09
      0.00000000000000E+00   1.32072732104423E-13   0.00000000000000E+00  -1.13661788980763E-13  -4.80348860349413E-23
     -1.31960146034521E-10  -1.32073807823549E-10  -1.28158151580378E-18  -7.85588069391305E-03  -7.85588069566683E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75378288575934E-09   0.00000000000000E+00   1.75378288575934E-09
      4.43535971164731E-18  -4.27391313261859E-01  -4.26880346517734E-01   0.00000000000000E+00  -1.47799015398037E-10
     -1.65046273455550E-22  -1.47391006253764E-09  -1.62170907793584E-09  -3.15377819584353E-18
      1.61984613934571E-09
      0.00000000000000E+00   1.67157421717699E-13   0.00000000000000E+00  -9.60136691977368E-14  -4.80560951526289E-23
     -1.67056913202256E-10  -1.67152926871502E-10  -1.28379361762671E-18  -6.21224598196404E-03  -6.21224598369346E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72942763070607E-09   0.00000000000000E+00   1.72942763070607E-09
      4.46994826426143E-18  -4.48679206106275E-01  -4.48186964699676E-01   0.00000000000000E+00  -1.52378141157418E-10
     -1.69407838166762E-22  -1.40989656267699E-09  -1.56227470383458E-09  -3.18615464663472E-18
      1.63984613934571E-09
      0.00000000000000E+00   1.64034700652643E-13   0.00000000000000E+00  -1.76410890248828E-15  -4.80741725653556E-23
     -1.63990214495172E-10  -1.63991978604123E-10  -1.28595807673550E-18  -4.62008273479101E-03  -4.62008273645224E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66123023644156E-09   0.00000000000000E+00   1.66123023644156E-09
      4.50317286899026E-18  -4.69145210986488E-01  -4.68673460167262E-01   0.00000000000000E+00  -1.55510520472655E-10
     -1.73731643967675E-22  -1.34172773736473E-09  -1.49723825783756E-09  -3.21721479225477E-18
      1.65984613934571E-09
      0.00000000000000E+00   5.89643212872322E-14   0.00000000000000E+00   2.67161396513446E-13  -4.80493725960165E-23
     -5.92207545971253E-11  -5.89535932006599E-11  -1.28604158050372E-18  -4.30466275146744E-03  -4.30466275290591E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43847047219359E-09   0.00000000000000E+00   1.43847047219359E-09
      4.53194227843414E-18  -4.89038611176676E-01  -4.88603952097686E-01   0.00000000000000E+00  -1.50298585087831E-10
     -1.77799801320862E-22  -1.22921829390475E-09  -1.37951687899276E-09  -3.24590069793041E-18
      1.67984613934571E-09
      0.00000000000000E+00  -1.48898687960842E-12   0.00000000000000E+00   4.07356694698121E-12  -4.73929116097690E-23
      1.48495022917732E-09   1.48902379612425E-09  -1.25530459821026E-18  -2.24334289833922E-02  -2.24334289823124E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.07984546642584E-09   0.00000000000000E+00  -1.07984546642584E-09
      4.51034536910562E-18  -5.10154089522213E-01  -5.10025185452896E-01   0.00000000000000E+00  -1.85418005297459E-11
     -1.78279230597979E-22  -3.90636529168603E-10  -4.09178329698527E-10  -3.25504077089535E-18
      1.69984613934571E-09
      0.00000000000000E+00  -3.17874635475250E-12   0.00000000000000E+00   4.63350169556828E-12  -4.61630281674743E-23
      3.17413955928809E-09   3.17877306098362E-09  -1.19146512092232E-18  -5.89897554508186E-02  -5.89897554470763E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.74223748526098E-09   0.00000000000000E+00  -3.74223748526098E-09
      4.43550061940040E-18  -5.32180405574303E-01  -5.32357987590487E-01   0.00000000000000E+00   1.17773181578395E-10
     -1.75052569046185E-22   4.45691242699235E-10   5.63464424277455E-10  -3.24403549847808E-18
      1.70984613934571E-09
      0.00000000000000E+00  -4.43371284395615E-12   0.00000000000000E+00   6.71869486618209E-12  -4.53261779218541E-23
      4.42694850239750E-09   4.43366719726363E-09  -1.14757278766606E-18  -8.32118241074802E-02  -8.32118241018798E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.60042548453900E-09   0.00000000000000E+00  -5.60042548453900E-09
      4.37949636455501E-18  -5.43425830880808E-01  -5.43793516378124E-01   0.00000000000000E+00   1.97954698017105E-10
     -1.72305902483088E-22   9.68803589258261E-10   1.16675828727519E-09  -3.23192357688895E-18
      1.71659613934571E-09
      0.00000000000000E+00  -5.34747613443383E-12   0.00000000000000E+00   7.24192717010012E-12  -4.46706082396173E-23
      5.34020732478286E-09   5.34744925195291E-09  -1.11235291159687E-18  -1.02103215865004E-01  -1.02103215858140E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.86448922196320E-09   0.00000000000000E+00  -6.86448922196320E-09
      4.33316106230676E-18  -5.51102926600602E-01  -5.51580993741288E-01   0.00000000000000E+00   2.43013112214012E-10
     -1.69998312604709E-22   1.27402685779656E-09   1.51703997001040E-09  -3.22080815070988E-18
      1.72115238934571E-09
      0.00000000000000E+00  -5.94685488945015E-12   0.00000000000000E+00   7.05343087825348E-12  -4.41908686140500E-23
      5.93978491551994E-09   5.94683834639815E-09  -1.08630156770541E-18  -1.15770385259543E-01  -1.15770385251924E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.61930211764184E-09   0.00000000000000E+00  -7.61930211764184E-09
      4.29844561703325E-18  -5.56279307706060E-01  -5.56806355694147E-01   0.00000000000000E+00   2.63921252237594E-10
     -1.68287176505014E-22   1.40854251900656E-09   1.67246377124399E-09  -3.21214404932784E-18
      1.72730332684571E-09
      0.00000000000000E+00  -6.57452182352639E-12   0.00000000000000E+00   5.59043339033490E-12  -4.34734292663223E-23
      6.56893155266082E-09   6.57452198605111E-09  -1.04867612704993E-18  -1.35050761512696E-01  -1.35050761504462E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.23424081922424E-09   0.00000000000000E+00  -8.23424081922424E-09
      4.24779731639425E-18  -5.63139365278363E-01  -5.63662420252302E-01   0.00000000000000E+00   2.76192545217870E-10
     -1.65838365812854E-22   1.38352628795509E-09   1.65971883317279E-09  -3.19912118934433E-18
      1.73560709247071E-09
      0.00000000000000E+00  -7.44419964014446E-12   0.00000000000000E+00   5.66071471348427E-12  -4.20748519428073E-23
      7.43855750908201E-09   7.44421822379545E-09  -9.95728910505380E-19  -1.61335470198642E-01  -1.61335470189976E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66629623450612E-09   0.00000000000000E+00  -8.66629623450612E-09
      4.17583442362609E-18  -5.71857730603365E-01  -5.72242949465650E-01   0.00000000000000E+00   2.75156934699233E-10
     -1.62486150317606E-22   9.46921076011811E-10   1.22207801071088E-09  -3.18010551312072E-18
      1.74681717606446E-09
      0.00000000000000E+00  -9.41941255852953E-12   0.00000000000000E+00   9.09122349479625E-12  -3.71829970519182E-23
      9.41032688319140E-09   9.41941810668615E-09  -9.23548849412951E-19  -1.95733425547195E-01  -1.95733425538235E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.96032143696721E-09   0.00000000000000E+00  -8.96032143696721E-09
      4.07538847129082E-18  -5.81582491818523E-01  -5.81438172900881E-01   0.00000000000000E+00   2.65592129355400E-10
     -1.58000300405747E-22  -7.24688799074440E-10  -4.59096669719199E-10  -3.15183962187787E-18
      1.76195078891602E-09
      0.00000000000000E+00  -1.55811841330453E-11   0.00000000000000E+00   2.03639962742254E-11  -1.34305491104864E-23
      1.55608999860891E-08   1.55812639823633E-08  -8.31018542880197E-19  -2.37789338337911E-01  -2.37789338328627E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.28351152771497E-09   0.00000000000000E+00  -9.28351152771497E-09
      3.93489540192737E-18  -5.86298523805310E-01  -5.84315070075829E-01   0.00000000000000E+00   2.63843849046564E-10
     -1.51670539328791E-22  -6.56159630369477E-09  -6.29775245464836E-09  -3.10387685904717E-18
      1.78195078891602E-09
      0.00000000000000E+00  -3.18846352794906E-11   0.00000000000000E+00   4.04039630754273E-11   6.30219758550597E-23
      3.18442611346996E-08   3.18846650977751E-08  -7.31090151808650E-19  -2.81624375577490E-01  -2.81624375567617E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87342517022574E-09   0.00000000000000E+00  -9.87342517022574E-09
      3.73742689852285E-18  -5.63805349086448E-01  -5.56871909687812E-01   0.00000000000000E+00   2.89800973246433E-10
     -1.41310353834960E-22  -2.23010409007956E-08  -2.20112399275493E-08  -3.00633674671420E-18
      1.80195078891602E-09
      0.00000000000000E+00  -5.14874249206418E-11   0.00000000000000E+00   4.86427548748420E-11   1.54510709137601E-22
      5.14387417226431E-08   5.14873844775181E-08  -6.61742446761288E-19  -3.12296483848088E-01  -3.12296483837518E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05701016620622E-08   0.00000000000000E+00  -1.05701016620622E-08
      3.52602486528161E-18  -5.04171286700548E-01  -4.91281522195708E-01   0.00000000000000E+00   2.95661483548681E-10
     -1.27756824895021E-22  -4.12129442990045E-08  -4.09172828154560E-08  -2.86428241852032E-18
      1.82195078891602E-09
      0.00000000000000E+00  -6.33598267205100E-11   0.00000000000000E+00   2.95857427768054E-11   2.09490721028887E-22
      6.33302050515643E-08   6.33597907943414E-08  -6.20916569021279E-19  -3.31698381430124E-01  -3.31698381418945E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11788653360304E-08   0.00000000000000E+00  -1.11788653360304E-08
      3.30244755856100E-18  -4.09833819240016E-01  -3.93394833206375E-01   0.00000000000000E+00   2.65506553070360E-10
     -1.11873371637289E-22  -5.24464320113812E-08  -5.21809254583109E-08  -2.68153098953972E-18
      1.84195078891602E-09
      0.00000000000000E+00  -6.11129370694651E-11   0.00000000000000E+00  -5.47780279022281E-12   2.01596166781937E-22
      6.11183835395386E-08   6.11129057367486E-08  -6.04329226087990E-19  -3.41733142596854E-01  -3.41733142585138E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17163870180875E-08   0.00000000000000E+00  -1.17163870180875E-08
      3.06811981819925E-18  -2.89437858636800E-01  -2.73875461449690E-01   0.00000000000000E+00   2.15447086325949E-10
     -9.58242417638006E-23  -4.96119658049869E-08  -4.93965187186610E-08  -2.46379059211125E-18
      1.86195078891602E-09
      0.00000000000000E+00  -5.31496309746237E-11   0.00000000000000E+00  -1.97313284796783E-11   1.63755205088747E-22
      5.31693656818698E-08   5.31496343533903E-08  -5.96329598464278E-19  -3.48518345614822E-01  -3.48518345602929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18931824959617E-08   0.00000000000000E+00  -1.18931824959617E-08
      2.83025616828001E-18  -1.74742111105117E-01  -1.61743917627332E-01   0.00000000000000E+00   1.33604535267785E-10
     -8.11196438264697E-23  -4.13900563926963E-08  -4.12564518574286E-08  -2.23392656981574E-18
      1.88195078891602E-09
      0.00000000000000E+00  -4.67677994097587E-11   0.00000000000000E+00  -1.58243902869631E-11   1.29803829704669E-22
      4.67836686549872E-08   4.67678442647003E-08  -5.83826689518462E-19  -3.57014751530400E-01  -3.57014751518677E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17223549927282E-08   0.00000000000000E+00  -1.17223549927282E-08
      2.59580906842545E-18  -8.48186235727311E-02  -7.37770846806604E-02   0.00000000000000E+00   7.07788955414502E-11
     -6.22024945012170E-23  -3.51162681675134E-08  -3.50454892719720E-08  -2.01198237890699E-18
      1.89195078891602E-09
      0.00000000000000E+00  -4.17820996951853E-11   0.00000000000000E+00  -2.46384664533303E-11   1.18269686707837E-22
      4.18067180671459E-08   4.17820796006927E-08  -5.71480461181394E-19  -3.63275043426375E-01  -3.63275043414947E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14280032875945E-08   0.00000000000000E+00  -1.14280032875945E-08
      2.48152903554951E-18  -5.28750258126454E-02  -4.33115335097328E-02   0.00000000000000E+00   5.32079855958907E-11
     -1.99028142482082E-23  -3.04072842986941E-08  -3.03540763130983E-08  -1.91004857436811E-18
      1.89532578891602E-09
      0.00000000000000E+00  -3.95139020651082E-11   0.00000000000000E+00  -3.31252621859004E-11   1.15753962917953E-22
      3.95470769795005E-08   3.95139517173147E-08  -5.65711564973283E-19  -3.65894658255143E-01  -3.65894658243905E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12378111933408E-08   0.00000000000000E+00  -1.12378111933408E-08
      2.44360142277198E-18  -4.43515174529623E-02  -3.54426990702486E-02   0.00000000000000E+00   5.26124396314771E-11
      2.55959088352166E-24  -2.83287529636052E-08  -2.82761405239737E-08  -1.87788985779870E-18
      1.89988203891602E-09
      0.00000000000000E+00  -3.70979262528642E-11   0.00000000000000E+00  -2.62810577983031E-11   1.15995490604802E-22
      3.71242068335232E-08   3.70979257757250E-08  -5.55288859407508E-19  -3.70343865590947E-01  -3.70343865580001E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09467550070645E-08   0.00000000000000E+00  -1.09467550070645E-08
      2.39372527027104E-18  -3.61949508664580E-02  -2.79556231049420E-02   0.00000000000000E+00   4.04385798972319E-11
      3.29202634510377E-23  -2.61916093485576E-08  -2.61511707686604E-08  -1.83843641086353E-18
      1.90603297641602E-09
      0.00000000000000E+00  -3.48744570098072E-11   0.00000000000000E+00  -1.79015706441310E-11   1.20757333588496E-22
      3.48923449587856E-08   3.48744433881415E-08  -5.38266109287627E-19  -3.77370725024189E-01  -3.77370725013537E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06516491041951E-08   0.00000000000000E+00  -1.06516491041951E-08
      2.32820764235921E-18  -2.92010383660884E-02  -2.15692628795838E-02   0.00000000000000E+00   2.87335344036457E-11
      6.92897032044866E-23  -2.42515278183502E-08  -2.42227942839465E-08  -1.78994153307158E-18
      1.91433674204102E-09
      0.00000000000000E+00  -3.31267435054852E-11   0.00000000000000E+00  -1.03976805324171E-11   1.29913200747794E-22
      3.31371506363232E-08   3.31267529557909E-08  -5.13028522055726E-19  -3.87629566331082E-01  -3.87629566320668E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04139811948822E-08   0.00000000000000E+00  -1.04139811948822E-08
      2.24173238329375E-18  -2.37076494753593E-02  -1.65516191216416E-02   0.00000000000000E+00   1.90950947023150E-11
      1.09616592000874E-22  -2.27318668556112E-08  -2.27127717609087E-08  -1.72870386123802E-18
      1.92554682563477E-09
      0.00000000000000E+00  -3.18443154398565E-11   0.00000000000000E+00  -5.62176374179566E-12   1.39850245566505E-22
      3.18499278405835E-08   3.18443060768419E-08  -4.78390690246182E-19  -4.01661090491871E-01  -4.01661090481629E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02417118012100E-08   0.00000000000000E+00  -1.02417118012100E-08
      2.12692193785909E-18  -1.95348113618390E-02  -1.27285504573538E-02   0.00000000000000E+00   1.27461416730855E-11
      1.48724620846750E-22  -2.16153404173051E-08  -2.16025942756319E-08  -1.64853124761291E-18
      1.94068043848633E-09
      0.00000000000000E+00  -3.07436481091615E-11   0.00000000000000E+00  -3.55181673037277E-12   1.42064376200088E-22
      3.07471725356645E-08   3.07436207189342E-08  -4.33391032236900E-19  -4.20000109928058E-01  -4.20000109917961E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00968301942526E-08   0.00000000000000E+00  -1.00968301942526E-08
      1.97412041867130E-18  -1.62985444016795E-02  -9.79341659092045E-03   0.00000000000000E+00   9.29088765842407E-12
      1.74062023333898E-22  -2.06560814123403E-08  -2.06467905246817E-08  -1.54072938643440E-18
      1.96068043848633E-09
      0.00000000000000E+00  -2.94818851094045E-11   0.00000000000000E+00  -3.07657157053971E-12   1.25323722691647E-22
      2.94849351270392E-08   2.94818585554688E-08  -3.78150300120802E-19  -4.42826967387638E-01  -4.42826967377703E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93467845201711E-09   0.00000000000000E+00  -9.93467845201711E-09
      1.77542684963096E-18  -1.37003472783358E-02  -7.54166282092996E-03   0.00000000000000E+00   7.58390403154568E-12
      1.66353293499437E-22  -1.95547640074833E-08  -1.95471801034516E-08  -1.39727654951016E-18
      1.98068043848633E-09
      0.00000000000000E+00  -2.82875361467578E-11   0.00000000000000E+00  -2.91532408781526E-12   9.54148477703818E-23
      2.82904119523773E-08   2.82874966282896E-08  -3.27054708958993E-19  -4.64301703246101E-01  -4.64301703236312E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.78979197747845E-09   0.00000000000000E+00  -9.78979197747845E-09
      1.57963101008139E-18  -1.19778108842664E-02  -6.14977643122781E-03   0.00000000000000E+00   6.54861001086706E-12
      1.29665645342020E-22  -1.85042532608222E-08  -1.84977046508112E-08  -1.25257630112240E-18
      2.00068043848633E-09
      0.00000000000000E+00  -2.73240848534508E-11   0.00000000000000E+00  -2.35019187504094E-12   6.37198415340846E-23
      2.73263647968751E-08   2.73240146050001E-08  -2.79347801498468E-19  -4.84702731640731E-01  -4.84702731631069E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66165630518996E-09   0.00000000000000E+00  -9.66165630518996E-09
      1.38639788397759E-18  -1.08096713448093E-02  -5.24482315573169E-03   0.00000000000000E+00   5.40844843239206E-12
      8.49626199959834E-23  -1.76677667482427E-08  -1.76623582998102E-08  -1.10705008247913E-18
      2.02068043848633E-09
      0.00000000000000E+00  -2.65029929028155E-11   0.00000000000000E+00  -2.00124461483542E-12   3.80801017771837E-23
      2.65050014070340E-08   2.65030001624192E-08  -2.34762841667418E-19  -5.04113349533266E-01  -5.04113349523759E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50695725829721E-09   0.00000000000000E+00  -9.50695725829721E-09
      1.19625873881165E-18  -9.97222455182503E-03  -4.61730744568662E-03   0.00000000000000E+00   4.53255935776184E-12
      4.72028343798007E-23  -1.70005754634797E-08  -1.69960429041219E-08  -9.61495897144230E-19
      2.04068043848633E-09
      0.00000000000000E+00  -2.66861313088074E-11   0.00000000000000E+00   4.75624468797147E-13   2.13778866426515E-23
      2.66855965132559E-08   2.66860721377248E-08  -1.89864744676069E-19  -5.24107035337630E-01  -5.24107035327571E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00589336329891E-08   0.00000000000000E+00  -1.00589336329891E-08
      9.95080066151867E-19  -9.48988030704142E-03  -4.25119071166224E-03   0.00000000000000E+00   3.61602299096957E-12
      2.21572874118329E-23  -1.66307545277267E-08  -1.66271385047357E-08  -8.05215321475798E-19
      2.06068043848633E-09
      0.00000000000000E+00  -2.75887813860829E-11   0.00000000000000E+00   2.25306577231197E-12   1.21421110426688E-23
      2.75865426473993E-08   2.75887957131717E-08  -1.43637015976591E-19  -5.45233144829938E-01  -5.45233144818992E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09463025040147E-08   0.00000000000000E+00  -1.09463025040147E-08
      7.76154016071572E-19  -9.30116894279723E-03  -4.05763808617528E-03   0.00000000000000E+00   2.58253778590683E-12
      8.34813877518678E-24  -1.66450757469430E-08  -1.66424932091571E-08  -6.32517000094982E-19
      2.07068043848633E-09
      0.00000000000000E+00  -2.82362867833960E-11   0.00000000000000E+00   3.22138327112865E-12   9.03340671352600E-24
      2.82330250555387E-08   2.82362464388099E-08  -1.20444660667331E-19  -5.56058439487598E-01  -5.56058439476123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14757894362514E-08   0.00000000000000E+00  -1.14757894362514E-08
      6.61396121709057E-19  -9.28737684738911E-03  -4.00667793881536E-03   0.00000000000000E+00   1.94247127038991E-12
      3.71747266298599E-24  -1.67623994738287E-08  -1.67604570025583E-08  -5.40951461041727E-19
      2.07743043848633E-09
      0.00000000000000E+00  -2.88125206646360E-11   0.00000000000000E+00   4.23868704673166E-12   7.58314864447813E-24
      2.88083188489549E-08   2.88125575360016E-08  -1.04714095739847E-19  -5.63492317336544E-01  -5.63492317324738E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18058969254335E-08   0.00000000000000E+00  -1.18058969254335E-08
      5.81706317462381E-19  -9.36039632527748E-03  -4.00212506332728E-03   0.00000000000000E+00   6.87116774500379E-13
      1.55744811486535E-24  -1.70073477273425E-08  -1.70066606105680E-08  -4.76992221722535E-19
      2.08198668848633E-09
      0.00000000000000E+00  -2.92024015740820E-11   0.00000000000000E+00   4.25469164060309E-12   6.84294389191449E-24
      2.91981182992348E-08   2.92023729908755E-08  -9.41130764784878E-20  -5.68541152349369E-01  -5.68541152337390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19791997505388E-08   0.00000000000000E+00  -1.19791997505388E-08
      5.27126088598989E-19  -9.43076711001309E-03  -4.00427865797125E-03   0.00000000000000E+00   1.02899161393454E-13
      4.63201164979675E-25  -1.72232761394983E-08  -1.72231732403369E-08  -4.33013012120501E-19
      2.08813762598633E-09
      0.00000000000000E+00  -2.94855588988928E-11   0.00000000000000E+00   2.31648230379522E-12   6.13626379561823E-24
      2.94832532267761E-08   2.94855697090799E-08  -7.99828328485590E-20  -5.75307052185457E-01  -5.75307052173436E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20211693460073E-08   0.00000000000000E+00  -1.20211693460073E-08
      4.53184627274782E-19  -9.48566512821629E-03  -3.98317287949066E-03   0.00000000000000E+00   4.49738062488833E-13
     -4.96409470994108E-25  -1.74648501011350E-08  -1.74644003630726E-08  -3.73201794426224E-19
      2.09644139161133E-09
      0.00000000000000E+00  -2.93606500562905E-11   0.00000000000000E+00  -7.02442301816119E-13   5.46355502794537E-24
      2.93613824107478E-08   2.93606799684459E-08  -6.17640040083798E-20  -5.84087262851862E-01  -5.84087262840136E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17267884223273E-08   0.00000000000000E+00  -1.17267884223273E-08
      3.55808124681812E-19  -9.45987093344817E-03  -3.90397658941417E-03   0.00000000000000E+00   1.24283644729190E-12
     -1.24084255092223E-24  -1.76351343825657E-08  -1.76338915461184E-08  -2.94044120673432E-19
      2.10765147520508E-09
      0.00000000000000E+00  -2.82009265595711E-11   0.00000000000000E+00  -5.07520139041904E-12   4.75661425281550E-24
      2.82060167413262E-08   2.82009415399358E-08  -4.02965982745668E-20  -5.94497295350086E-01  -5.94497295339583E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05029221708502E-08   0.00000000000000E+00  -1.05029221708502E-08
      2.38069489167931E-19  -9.29149843272031E-03  -3.71539833224480E-03   0.00000000000000E+00   1.65865350471403E-12
     -1.76043988927858E-24  -1.76996780225905E-08  -1.76980193690858E-08  -1.97772890893364E-19
      2.12278508805664E-09
      0.00000000000000E+00  -2.37401195181387E-11   0.00000000000000E+00  -1.45241437308384E-11   3.72388667188555E-24
      2.37546130020557E-08   2.37400888583249E-08  -2.41536537336820E-20  -6.02208236335143E-01  -6.02208236329097E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04544351908807E-09   0.00000000000000E+00  -6.04544351908807E-09
      1.46580087434064E-19  -8.82688409829847E-03  -3.25184557125857E-03   0.00000000000000E+00   1.09726306742759E-12
     -2.13719319488960E-24  -1.76957426023042E-08  -1.76946453392368E-08  -1.22426433700383E-19
      2.14278508805664E-09
      0.00000000000000E+00  -1.01054009007325E-11   0.00000000000000E+00  -3.36139047139240E-11   1.52502171455572E-24
      1.01390412063003E-08   1.01054273015863E-08  -5.22838118674052E-20  -5.87616140241090E-01  -5.87616140248673E-01
      0.00000000000000E+00   0.00000000000000E+00   7.58286837068981E-09   0.00000000000000E+00   7.58286837068981E-09
      2.98237454847860E-19  -7.65441507444725E-03  -2.08137555297834E-03   0.00000000000000E+00  -1.31603698875581E-12
     -2.71230355473961E-24  -1.76869796352872E-08  -1.76882956722760E-08  -2.45953642980454E-19
      2.16278508805664E-09
      0.00000000000000E+00   8.86770122212391E-12   0.00000000000000E+00  -4.67764329610311E-11  -2.43763052274023E-24
     -8.82097438040692E-09  -8.86775081336796E-09  -1.57571278187519E-19  -5.36852370016049E-01  -5.36852370042596E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65464346299763E-08   0.00000000000000E+00   2.65464346299763E-08
      8.29166147447388E-19  -5.99464120261828E-03  -4.24630139974090E-04   0.00000000000000E+00  -5.38520011895812E-12
     -5.07406029840058E-24  -1.76732986164896E-08  -1.76786838166085E-08  -6.71594869259869E-19
      2.18278508805664E-09
      0.00000000000000E+00   2.27043864166494E-11   0.00000000000000E+00  -3.42997785670799E-11  -1.32087750107748E-23
     -2.26700963702340E-08  -2.27043961488011E-08  -3.55813345341642E-19  -4.50702618450551E-01  -4.50702618490880E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03284230475081E-08   0.00000000000000E+00   4.03284230475081E-08
      1.63573460839755E-18  -4.30436706764377E-03   1.24841829041756E-03   0.00000000000000E+00  -1.20266245790694E-11
     -2.06191571620103E-23  -1.76120002741279E-08  -1.76240268987070E-08  -1.27992126305591E-18
      2.20278508805664E-09
      0.00000000000000E+00   2.28003641670313E-11   0.00000000000000E+00  -6.27743934363661E-13  -3.68536529411733E-23
     -2.27997506222723E-08  -2.28003783662067E-08  -6.46303489147713E-19  -3.34712594353537E-01  -3.34712594393997E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04601888938397E-08   0.00000000000000E+00   4.04601888938397E-08
      2.44493838627434E-18  -2.01940827885782E-03   3.54463964893624E-03   0.00000000000000E+00  -2.79047334777701E-11
     -6.61055785340449E-23  -1.76319057941552E-08  -1.76598105276330E-08  -1.79863489712663E-18
      2.22278508805664E-09
      0.00000000000000E+00   1.44448810443138E-11   0.00000000000000E+00   1.99657136162188E-11  -4.31627649082580E-23
     -1.44648115782579E-08  -1.44448458646417E-08  -9.22295386473668E-19  -2.12321477029362E-01  -2.12321477059819E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04570066402925E-08   0.00000000000000E+00   3.04570066402925E-08
      3.05407851908019E-18  -1.10285581975732E-02  -5.98364837828847E-03   0.00000000000000E+00  -5.90762251541896E-11
     -8.22075375343135E-23  -1.59530845504965E-08  -1.60121607756508E-08  -2.13178313260653E-18
      2.24278508805664E-09
      0.00000000000000E+00   9.70027376491015E-12   0.00000000000000E+00   1.09034872772460E-11  -4.60063113971536E-23
     -9.71117236863340E-09  -9.70026888135620E-09  -1.11496753240343E-18  -1.11875551042883E-01  -1.11875551065265E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23826290162658E-08   0.00000000000000E+00   2.23826290162658E-08
      3.50173109940551E-18  -4.17396291515005E-02  -3.77438348249031E-02   0.00000000000000E+00  -1.10083057984953E-10
     -9.53154155539466E-23  -1.25722770769245E-08  -1.26823601349095E-08  -2.38676356700208E-18
      2.25278508805664E-09
      0.00000000000000E+00   7.10474149142544E-12   0.00000000000000E+00   1.19146619399786E-11  -4.70462241939508E-23
     -7.11663991538409E-09  -7.10472525344416E-09  -1.18534792250504E-18  -7.16118196943904E-02  -7.16118197121203E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77298747808020E-08   0.00000000000000E+00   1.77298747808020E-08
      3.67902984721353E-18  -6.32467509390660E-02  -5.98990949079293E-02   0.00000000000000E+00  -1.58143839052233E-10
     -1.01948628911206E-22  -1.04670056883056E-08  -1.06251495273580E-08  -2.49368192470849E-18
      2.25953508805664E-09
      0.00000000000000E+00   5.08140193074362E-12   0.00000000000000E+00   1.40324358748306E-11  -4.75088768877858E-23
     -5.09542324709899E-09  -5.08139081122420E-09  -1.21916689847061E-18  -5.14427257399147E-02  -5.14427257541404E-02
      0.00000000000000E+00   0.00000000000000E+00   1.42256983914049E-08   0.00000000000000E+00   1.42256983914049E-08
      3.77505331135551E-18  -8.05643144998341E-02  -7.76832161206486E-02   0.00000000000000E+00  -1.74306078715417E-10
     -1.06204861086830E-22  -8.97000150146499E-09  -9.14430758018051E-09  -2.55588641288490E-18
      2.26409133805664E-09
      0.00000000000000E+00   3.69151552258212E-12   0.00000000000000E+00   1.44672116458086E-11  -4.77107598463055E-23
     -3.70599642935136E-09  -3.69152921770560E-09  -1.23565585011432E-18  -4.13585462432606E-02  -4.13585462550863E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18256749264990E-08   0.00000000000000E+00   1.18256749264990E-08
      3.82893404273937E-18  -9.34508431226445E-02  -9.08880107984370E-02   0.00000000000000E+00  -1.78503106965943E-10
     -1.08925108161039E-22  -7.95564260182721E-09  -8.13414570879326E-09  -2.59327819262505E-18
      2.27024227555664E-09
      0.00000000000000E+00   2.35370508041729E-12   0.00000000000000E+00   1.03865409030169E-11  -4.78704616401391E-23
     -2.36404846871828E-09  -2.35366192781531E-09  -1.24968368852216E-18  -3.25098258076676E-02  -3.25098258171434E-02
      0.00000000000000E+00   0.00000000000000E+00   9.47573449664242E-09   0.00000000000000E+00   9.47573449664242E-09
      3.88721869339482E-18  -1.12218224580836E-01  -1.09974265295376E-01   0.00000000000000E+00  -1.77835902673152E-10
     -1.12328153440381E-22  -6.94423666615363E-09  -7.12207256882690E-09  -2.63753500487265E-18
      2.27854604118164E-09
      0.00000000000000E+00   1.32072732104423E-12   0.00000000000000E+00   5.95612509631533E-12  -4.79792149930132E-23
     -1.32672333476505E-09  -1.32076720966879E-09  -1.26004869740861E-18  -2.56227808181078E-02  -2.56227808256475E-02
      0.00000000000000E+00   0.00000000000000E+00   7.53971612463924E-09   0.00000000000000E+00   7.53971612463924E-09
      3.94982672897285E-18  -1.38547371453005E-01  -1.36587958309667E-01   0.00000000000000E+00  -1.80330060563001E-10
     -1.16622634804559E-22  -6.03861885440736E-09  -6.21894891497048E-09  -2.68977803156424E-18
      2.28975612477539E-09
      0.00000000000000E+00   6.85620963254187E-13   0.00000000000000E+00   2.71313025532856E-12  -4.80459321913454E-23
     -6.88371103157207E-10  -6.85657972901926E-10  -1.26693893443784E-18  -2.06040699504335E-02  -2.06040699565748E-02
      0.00000000000000E+00   0.00000000000000E+00   6.14123313478170E-09   0.00000000000000E+00   6.14123313478170E-09
      4.01867046578246E-18  -1.73835438741983E-01  -1.72116540202026E-01   0.00000000000000E+00  -1.87978925947667E-10
     -1.22130620682833E-22  -5.26759623593214E-09  -5.45557516187993E-09  -2.75173153134462E-18
      2.30488973762696E-09
      0.00000000000000E+00   3.58470009320977E-13   0.00000000000000E+00   1.03444141256177E-12  -4.80830109305570E-23
     -3.59458537280512E-10  -3.58424095867999E-10  -1.27132278808257E-18  -1.69185094153183E-02  -1.69185094203738E-02
      0.00000000000000E+00   0.00000000000000E+00   5.05543776298472E-09   0.00000000000000E+00   5.05543776298472E-09
      4.09517750368264E-18  -2.18319114468756E-01  -2.16839213719860E-01   0.00000000000000E+00  -1.96777446172378E-10
     -1.29121822798738E-22  -4.50023622094415E-09  -4.69701366711666E-09  -2.82385471560007E-18
      2.32488973762696E-09
      0.00000000000000E+00   2.14732995591198E-13   0.00000000000000E+00   3.43845951733926E-13  -4.81022529903703E-23
     -2.15040867057243E-10  -2.14697021105557E-10  -1.27429083065638E-18  -1.40889268408009E-02  -1.40889268447139E-02
      0.00000000000000E+00   0.00000000000000E+00   3.91297752562261E-09   0.00000000000000E+00   3.91297752562261E-09
      4.17343705419510E-18  -2.66895776589420E-01  -2.65730545049013E-01   0.00000000000000E+00  -1.89355790168644E-10
     -1.37039065434879E-22  -3.50892471434831E-09  -3.69828050451709E-09  -2.89914622353872E-18
      2.34488973762696E-09
      0.00000000000000E+00   1.64126545389850E-13   0.00000000000000E+00   1.21443769200209E-13  -4.81111879039194E-23
     -1.64227639652024E-10  -1.64106195882872E-10  -1.27628200784430E-18  -1.22403436107104E-02  -1.22403436135225E-02
      0.00000000000000E+00   0.00000000000000E+00   2.81217630910674E-09   0.00000000000000E+00   2.81217630910674E-09
      4.22968058037723E-18  -3.02223530337732E-01  -3.01389188888318E-01   0.00000000000000E+00  -1.57596110372785E-10
     -1.43028420772817E-22  -2.49047400285094E-09  -2.64807011322387E-09  -2.95339857253293E-18
      2.36488973762696E-09
      0.00000000000000E+00   1.40246913715893E-13   0.00000000000000E+00   5.87702307751066E-14  -4.81143374002296E-23
     -1.40302996188658E-10  -1.40244225957931E-10  -1.27781994478132E-18  -1.09926124417538E-02  -1.09926124436771E-02
      0.00000000000000E+00   0.00000000000000E+00   1.92332786019211E-09   0.00000000000000E+00   1.92332786019211E-09
      4.26814713758107E-18  -3.25666020635801E-01  -3.25104215759223E-01   0.00000000000000E+00  -1.13595304443957E-10
     -1.47087980144311E-22  -1.66948832979005E-09  -1.78308363423416E-09  -2.99032719279975E-18
      2.38488973762696E-09
      0.00000000000000E+00   1.31154284732348E-13   0.00000000000000E+00   2.32672280332682E-14  -4.81158505880164E-23
     -1.31201575825945E-10  -1.31178308597960E-10  -1.27919207646447E-18  -1.01078047083374E-02  -1.01078047095584E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22097124516123E-09   0.00000000000000E+00   1.22097124516123E-09
      4.29256656248430E-18  -3.39042555689201E-01  -3.38699193645951E-01   0.00000000000000E+00  -6.68366441631135E-11
     -1.49398037340591E-22  -1.02295629240006E-09  -1.08979293656332E-09  -3.01337448601983E-18
      2.40488973762696E-09
      0.00000000000000E+00   1.18571555734917E-13   0.00000000000000E+00   3.37231314111746E-14  -4.81131297151136E-23
     -1.18560485534064E-10  -1.18526762402701E-10  -1.28032162976283E-18  -9.53702847024663E-03  -9.53702847100072E-03
      0.00000000000000E+00   0.00000000000000E+00   7.54098293803386E-10   0.00000000000000E+00   7.54098293803386E-10
      4.30764852836036E-18  -3.45802935328192E-01  -3.45602691165497E-01   0.00000000000000E+00  -3.22493308545225E-11
     -1.50498634260097E-22  -6.03322200546003E-10  -6.35571531400676E-10  -3.02732689859753E-18
      2.42488973762696E-09
      0.00000000000000E+00   8.78035687703956E-14   0.00000000000000E+00   8.31577439233149E-14  -4.80988424950275E-23
     -8.78588444284070E-11  -8.77756866845318E-11  -1.28084762662347E-18  -9.31803744461685E-03  -9.31803744532606E-03
      0.00000000000000E+00   0.00000000000000E+00   7.09209484009496E-10   0.00000000000000E+00   7.09209484009496E-10
      4.32183271804055E-18  -3.52861658414262E-01  -3.52665868331485E-01   0.00000000000000E+00  -3.31010951869549E-11
     -1.51596785597159E-22  -5.88332702137888E-10  -6.21433797324994E-10  -3.04098509141708E-18
      2.44488973762696E-09
      0.00000000000000E+00   6.15359739290429E-14   0.00000000000000E+00   7.63210422504114E-14  -4.80761669497495E-23
     -6.15683711775505E-11  -6.14920501353482E-11  -1.28086381377470E-18  -9.27184578385079E-03  -9.27184578482241E-03
      0.00000000000000E+00   0.00000000000000E+00   9.71612755594930E-10   0.00000000000000E+00   9.71612755594930E-10
      4.34126497315245E-18  -3.64762399963741E-01  -3.64475648179057E-01   0.00000000000000E+00  -6.04060447483755E-11
     -1.53544440388151E-22  -8.49714660711011E-10  -9.10120705459540E-10  -3.06040115937775E-18
      2.44738973762696E-09
      0.00000000000000E+00   4.11464422689720E-14   0.00000000000000E+00   4.09886092846602E-13  -4.80712916088706E-23
     -4.15366899191272E-11  -4.11268038263286E-11  -1.28081520158426E-18  -9.29289671282527E-03  -9.29289671385324E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02796918251424E-09   0.00000000000000E+00   1.02796918251424E-09
      4.34383489610874E-18  -3.66445498726678E-01  -3.66134571881741E-01   0.00000000000000E+00  -6.94320994904549E-11
     -1.53819724331558E-22  -9.17410279197401E-10  -9.86842378688010E-10  -3.06301969452448E-18
      2.45076473762696E-09
      0.00000000000000E+00   1.13887474137333E-14   0.00000000000000E+00   4.54235589854781E-13  -4.80629118761012E-23
     -1.18137954636748E-11  -1.13595598738681E-11  -1.28064972678341E-18  -9.36536117219935E-03  -9.36536117341536E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21600123654779E-09   0.00000000000000E+00   1.21600123654779E-09
      4.34793890028209E-18  -3.69381887364130E-01  -3.69002333752327E-01   0.00000000000000E+00  -9.14584704048409E-11
     -1.54305107615590E-22  -1.11318320626922E-09  -1.20464167667422E-09  -3.06728917349868E-18
      2.45532098762696E-09
      0.00000000000000E+00   9.09262898354515E-15   0.00000000000000E+00   4.88718082779783E-14  -4.80539138482560E-23
     -9.18672470853467E-12  -9.13785290030475E-12  -1.28041748350732E-18  -9.44317420923989E-03  -9.44317421069699E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45710073874259E-09   0.00000000000000E+00   1.45710073874259E-09
      4.35457781552298E-18  -3.74194211619933E-01  -3.73737990403486E-01   0.00000000000000E+00  -1.14457237516905E-10
     -1.55123688506749E-22  -1.33350564832539E-09  -1.44796288584245E-09  -3.07416033201566E-18
      2.46147192512696E-09
      0.00000000000000E+00   2.30530290390892E-14   0.00000000000000E+00  -9.23531504723861E-14  -4.80443189162080E-23
     -2.29185026203458E-11  -2.30108557708662E-11  -1.28019174304000E-18  -9.47061397047792E-03  -9.47061397213710E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65918133407237E-09   0.00000000000000E+00   1.65918133407237E-09
      4.36478333621003E-18  -3.81505335473906E-01  -3.80989812448656E-01   0.00000000000000E+00  -1.33228096065845E-10
     -1.56402376255971E-22  -1.50294238223503E-09  -1.63617047830103E-09  -3.08459159317002E-18
      2.46977569075196E-09
      0.00000000000000E+00   4.03198396341042E-14   0.00000000000000E+00  -8.87819985175620E-14  -4.80340119917205E-23
     -4.02723175843362E-11  -4.03610995829018E-11  -1.28003557494175E-18  -9.40197237669050E-03  -9.40197237846075E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77024851211820E-09   0.00000000000000E+00   1.77024851211820E-09
      4.37948306495266E-18  -3.91878445588851E-01  -3.91333393440833E-01   0.00000000000000E+00  -1.45200470128903E-10
     -1.58261215257937E-22  -1.58468694240645E-09  -1.72988741253551E-09  -3.09944749001091E-18
      2.48098577434571E-09
      0.00000000000000E+00   5.87806318128171E-14   0.00000000000000E+00  -7.03403862557449E-14  -4.80237797725054E-23
     -5.86693522857161E-11  -5.87396926720199E-11  -1.28003868757159E-18  -9.17821879591261E-03  -9.17821879770763E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79501834184784E-09   0.00000000000000E+00   1.79501834184784E-09
      4.39960537061709E-18  -4.05847321297654E-01  -4.05300255008128E-01   0.00000000000000E+00  -1.51220071960910E-10
     -1.60828435962294E-22  -1.58505857721484E-09  -1.73627864917591E-09  -3.11956668304549E-18
      2.49611938719727E-09
      0.00000000000000E+00   8.88138608796784E-14   0.00000000000000E+00  -9.31978037355980E-14  -4.80188220290290E-23
     -8.87482396196049E-11  -8.88414374233885E-11  -1.28051151663919E-18  -8.60794835321478E-03  -8.60794835499373E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77895311771549E-09   0.00000000000000E+00   1.77895311771549E-09
      4.42652735838168E-18  -4.23994765251108E-01  -4.23462244996175E-01   0.00000000000000E+00  -1.54368652036487E-10
     -1.64284869240240E-22  -1.53574302825545E-09  -1.69011168029210E-09  -3.14601584174249E-18
      2.51611938719727E-09
      0.00000000000000E+00   1.37767105811290E-13   0.00000000000000E+00  -1.24966309642692E-13  -4.80307026566233E-23
     -1.37690553241320E-10  -1.37815519551011E-10  -1.28213488080352E-18  -7.28413401956873E-03  -7.28413402133114E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76240572945168E-09   0.00000000000000E+00   1.76240572945168E-09
      4.46177547297071E-18  -4.46570346736937E-01  -4.46058470551005E-01   0.00000000000000E+00  -1.57765150147250E-10
     -1.68821096743568E-22  -1.46682505975314E-09  -1.62459020990056E-09  -3.17964059216720E-18
      2.53611938719727E-09
      0.00000000000000E+00   1.70831211206000E-13   0.00000000000000E+00  -9.19021728380327E-14  -4.80536016498546E-23
     -1.70698192532087E-10  -1.70790094704973E-10  -1.28443363123122E-18  -5.58596273666949E-03  -5.58596273839435E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72486185334010E-09   0.00000000000000E+00   1.72486185334010E-09
      4.49627271003751E-18  -4.67843241916370E-01  -4.67353583451053E-01   0.00000000000000E+00  -1.61233215868666E-10
     -1.73319362935378E-22  -1.39283854276619E-09  -1.55407175863503E-09  -3.21183907880630E-18
      2.55611938719727E-09
      0.00000000000000E+00   1.73494708585018E-13   0.00000000000000E+00  -1.82418589913336E-14  -4.80759030879952E-23
     -1.73489720459634E-10  -1.73507962318673E-10  -1.28680124007372E-18  -3.87433537912965E-03  -3.87433538078341E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65376286066785E-09   0.00000000000000E+00   1.65376286066785E-09
      4.52934796725087E-18  -4.88073109589344E-01  -4.87606708275112E-01   0.00000000000000E+00  -1.63224745331820E-10
     -1.77746328479290E-22  -1.31703015301731E-09  -1.48025489834931E-09  -3.24254672717715E-18
      2.57611938719727E-09
      0.00000000000000E+00   2.18039406130669E-13   0.00000000000000E+00  -1.29034671713627E-13  -4.81168725367967E-23
     -2.17906005822043E-10  -2.18035040493805E-10  -1.29007060549597E-18  -1.63948508308123E-03  -1.63948508474029E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65906476924919E-09   0.00000000000000E+00   1.65906476924919E-09
      4.56252926263586E-18  -5.07335177300287E-01  -5.06881133352343E-01   0.00000000000000E+00  -1.69200096366151E-10
     -1.82212655667934E-22  -1.27182963238902E-09  -1.44102972875535E-09  -3.27245865713989E-18
      2.59611938719727E-09
      0.00000000000000E+00  -1.15540679407069E-12   0.00000000000000E+00   3.59192552738540E-12  -4.75871246258077E-23
      1.15183417041798E-09   1.15542609594532E-09  -1.26597220450625E-18  -1.58850693452845E-02  -1.58850693446950E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.89446266565255E-10   0.00000000000000E+00  -5.89446266565255E-10
      4.55074033730455E-18  -5.27439473686867E-01  -5.27261161227770E-01   0.00000000000000E+00  -4.35910778008698E-11
     -1.83340719270409E-22  -5.22388751579025E-10  -5.65979829380078E-10  -3.28476813279830E-18
      2.61611938719727E-09
      0.00000000000000E+00  -2.97751453553081E-12   0.00000000000000E+00   4.94622972683990E-12  -4.64116927825599E-23
      2.97253593811816E-09   2.97748216784495E-09  -1.20597009411495E-18  -5.05497105380608E-02  -5.05497105345781E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.48274675337272E-09   0.00000000000000E+00  -3.48274675337272E-09
      4.48108540223710E-18  -5.48597153654828E-01  -5.48756400108164E-01   0.00000000000000E+00   1.17945934097667E-10
     -1.80219306811811E-22   3.87318651430312E-10   5.05264585527799E-10  -3.27511530812215E-18
      2.62611938719727E-09
      0.00000000000000E+00  -4.25158473007362E-12   0.00000000000000E+00   6.81920769196205E-12  -4.55965068472947E-23
      4.24477469041780E-09   4.25159389810971E-09  -1.16367597659718E-18  -7.41446200651766E-02  -7.41446200597790E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.39766804072440E-09   0.00000000000000E+00  -5.39766804072440E-09
      4.42710872182985E-18  -5.59445833239847E-01  -5.59807005445222E-01   0.00000000000000E+00   2.09023658347396E-10
     -1.77408746536228E-22   9.37050484267458E-10   1.14607414261468E-09  -3.26343274523267E-18
      2.62949438719727E-09
      0.00000000000000E+00  -4.83636017187394E-12   0.00000000000000E+00   9.07524358225874E-12  -4.52813745557354E-23
      4.82732760765862E-09   4.83640285124083E-09  -1.14751984448923E-18  -8.29805725608574E-02  -8.29805725546185E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.23894503101232E-09   0.00000000000000E+00  -6.23894503101232E-09
      4.40605228235019E-18  -5.63148625172638E-01  -5.63590612268838E-01   0.00000000000000E+00   2.41841432084790E-10
     -1.76299912053293E-22   1.16070074768668E-09   1.40254217977129E-09  -3.25853243786096E-18
      2.63405063719727E-09
      0.00000000000000E+00  -5.43996378480181E-12   0.00000000000000E+00   7.14114544136876E-12  -4.48296531359784E-23
      5.43285497488387E-09   5.43999612032519E-09  -1.12321217429379E-18  -9.60649334364092E-02  -9.60649334293269E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.08228566222700E-09   0.00000000000000E+00  -7.08228566222700E-09
      4.37378361830166E-18  -5.68194883540178E-01  -5.68712420121844E-01   0.00000000000000E+00   2.74147336430290E-10
     -1.74586070971793E-22   1.36814220547171E-09   1.64228954190183E-09  -3.25057144400788E-18
      2.64020157469727E-09
      0.00000000000000E+00  -6.08250956630567E-12   0.00000000000000E+00   5.74770422131020E-12  -4.41762886371953E-23
      6.07674193956855E-09   6.08248964378981E-09  -1.08724357578625E-18  -1.14992690238100E-01  -1.14992690230236E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.86360272176464E-09   0.00000000000000E+00  -7.86360272176464E-09
      4.32541508943526E-18  -5.74973487458864E-01  -5.75534780512244E-01   0.00000000000000E+00   2.96953491273836E-10
     -1.72044505072691E-22   1.48415958670138E-09   1.78111307797504E-09  -3.23817151364901E-18
      2.64850534032227E-09
      0.00000000000000E+00  -6.82709485084709E-12   0.00000000000000E+00   4.97166472718551E-12  -4.31421202841911E-23
      6.82215596185322E-09   6.82712762658036E-09  -1.03546070253220E-18  -1.41387373712182E-01  -1.41387373703725E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.45733964439721E-09   0.00000000000000E+00  -8.45733964439721E-09
      4.25518732321716E-18  -5.83812208501792E-01  -5.84325991317786E-01   0.00000000000000E+00   3.02944539633984E-10
     -1.68477277932115E-22   1.32726747818297E-09   1.63021201781678E-09  -3.21972662068496E-18
      2.65971542391602E-09
      0.00000000000000E+00  -8.19714279577176E-12   0.00000000000000E+00   6.48655690405589E-12  -4.03750228721995E-23
      8.19068014315901E-09   8.19716670006303E-09  -9.63376487286836E-19  -1.76607605744148E-01  -1.76607605735311E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.83752725426039E-09   0.00000000000000E+00  -8.83752725426039E-09
      4.15611790393486E-18  -5.94429398671076E-01  -5.94631410170491E-01   0.00000000000000E+00   2.93163197414817E-10
     -1.63698620460024E-22   3.47197356782851E-10   6.40360554197504E-10  -3.19274141664802E-18
      2.67484903676758E-09
      0.00000000000000E+00  -1.25236728314067E-11   0.00000000000000E+00   1.44337295944548E-11  -2.57944699264763E-23
      1.25091796890396E-08   1.25236134186340E-08  -8.68092970219827E-19  -2.20818624348396E-01  -2.20818624339252E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14398581965520E-09   0.00000000000000E+00  -9.14398581965520E-09
      4.01773636262002E-18  -6.02897143454979E-01  -6.01832926225770E-01   0.00000000000000E+00   2.82906956840286E-10
     -1.57224700503509E-22  -3.66253455581893E-09  -3.37962759897880E-09  -3.14964339240019E-18
      2.69484903676758E-09
      0.00000000000000E+00  -2.62160699437792E-11   0.00000000000000E+00   3.39829188922935E-11   3.82666319290396E-23
      2.61820711067386E-08   2.62160540256310E-08  -7.59636719944104E-19  -2.68807479254800E-01  -2.68807479245135E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66479364623115E-09   0.00000000000000E+00  -9.66479364623115E-09
      3.82444048969540E-18  -5.90378552097696E-01  -5.85165227199649E-01   0.00000000000000E+00   3.01525941259262E-10
     -1.47307049197398E-22  -1.68527863206589E-08  -1.65512603793998E-08  -3.06480376975129E-18
      2.71484903676758E-09
      0.00000000000000E+00  -4.63246485527323E-11   0.00000000000000E+00   4.98579571858415E-11   1.34063609110909E-22
      4.62747482050625E-08   4.63246061622484E-08  -6.80396051289907E-19  -3.03539613348648E-01  -3.03539613338287E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03614768218409E-08   0.00000000000000E+00  -1.03614768218409E-08
      3.61721095325858E-18  -5.42042625468933E-01  -5.30713879582614E-01   0.00000000000000E+00   3.16946189316543E-10
     -1.34634860523840E-22  -3.62800755297240E-08  -3.59631293404076E-08  -2.93681490196867E-18
      2.73484903676758E-09
      0.00000000000000E+00  -6.22477706424013E-11   0.00000000000000E+00   3.96172787105750E-11   2.08772971965140E-22
      6.22081524673544E-08   6.22477697460652E-08  -6.30462157665687E-19  -3.26490411294284E-01  -3.26490411283297E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09868275828642E-08   0.00000000000000E+00  -1.09868275828642E-08
      3.39747440160130E-18  -4.58066412050557E-01  -4.41917613771183E-01   0.00000000000000E+00   2.93672918875455E-10
     -1.18860574262813E-22  -5.15546150820765E-08  -5.12609421632012E-08  -2.76701224393561E-18
      2.75484903676758E-09
      0.00000000000000E+00  -6.51289400486014E-11   0.00000000000000E+00   7.27287716743617E-12   2.22854837740461E-22
      6.51216347578793E-08   6.51289076350469E-08  -6.06276779213327E-19  -3.39445390461856E-01  -3.39445390450312E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15442311710388E-08   0.00000000000000E+00  -1.15442311710388E-08
      3.16658977818052E-18  -3.43721230678275E-01  -3.26839592066530E-01   0.00000000000000E+00   2.45898135506822E-10
     -1.02543625625695E-22  -5.38305745995147E-08  -5.35846764640080E-08  -2.56031299896720E-18
      2.77484903676758E-09
      0.00000000000000E+00  -5.68815581815771E-11   0.00000000000000E+00  -2.04175259464390E-11   1.85641579431629E-22
      5.69019519118971E-08   5.68815343859508E-08  -5.98558565779065E-19  -3.46090629150139E-01  -3.46090629138227E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19126249235637E-08   0.00000000000000E+00  -1.19126249235637E-08
      2.92833727970925E-18  -2.20366977467775E-01  -2.06199270557925E-01   0.00000000000000E+00   1.73366157951051E-10
     -8.59707316950303E-23  -4.51422756203381E-08  -4.49689094623872E-08  -2.32977871393018E-18
      2.79484903676758E-09
      0.00000000000000E+00  -4.95422452313236E-11   0.00000000000000E+00  -1.82095588803262E-11   1.45573937168714E-22
      4.95604291206522E-08   4.95422195617720E-08  -5.89745463230954E-19  -3.53228117600956E-01  -3.53228117589114E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18421698631012E-08   0.00000000000000E+00  -1.18421698631012E-08
      2.69149388244722E-18  -1.18049058488634E-01  -1.06171224220605E-01   0.00000000000000E+00   9.29217974242125E-11
     -7.41049364485603E-23  -3.77929714960950E-08  -3.77000496986708E-08  -2.10174841921627E-18
      2.79984903676758E-09
      0.00000000000000E+00  -4.68879323260261E-11   0.00000000000000E+00  -2.62387475883845E-11   1.34218033790257E-22
      4.69141266356479E-08   4.68878878880597E-08  -5.87885755835801E-19  -3.54862390139987E-01  -3.54862390128123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18637231766655E-08   0.00000000000000E+00  -1.18637231766655E-08
      2.63217526656390E-18  -9.47234033940783E-02  -8.36885963289569E-02   0.00000000000000E+00   7.57061780360248E-11
     -6.78334306126600E-23  -3.50998708894302E-08  -3.50241647113943E-08  -2.04428951072809E-18
      2.80659903676758E-09
      0.00000000000000E+00  -4.38946204956956E-11   0.00000000000000E+00  -2.19943547267395E-11   1.22961303054889E-22
      4.39166152604948E-08   4.38946209057682E-08  -5.82336799309246E-19  -3.58166438166160E-01  -3.58166438154507E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16537286431638E-08   0.00000000000000E+00  -1.16537286431638E-08
      2.55351259822254E-18  -6.89917458240056E-02  -5.88338066785346E-02   0.00000000000000E+00   5.74475035116951E-11
     -4.87063493754426E-23  -3.22983397661159E-08  -3.22408922626043E-08  -1.97117579891329E-18
      2.81571153676758E-09
      0.00000000000000E+00  -3.97650974213708E-11   0.00000000000000E+00  -2.24068484549075E-11   1.17594860042853E-22
      3.97874820101120E-08   3.97650751616572E-08  -5.67030846094560E-19  -3.65275381176890E-01  -3.65275381165662E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12281088299166E-08   0.00000000000000E+00  -1.12281088299166E-08
      2.45119645650993E-18  -4.54769378938986E-02  -3.64859428728032E-02   0.00000000000000E+00   4.45140503638779E-11
      5.26455330917634E-25  -2.85814803821044E-08  -2.85369663317406E-08  -1.88416561041537E-18
      2.81878700551758E-09
      0.00000000000000E+00  -3.79370197719922E-11   0.00000000000000E+00  -2.92773560386738E-11   1.17114216361002E-22
      3.79662749404058E-08   3.79369975843672E-08  -5.60590760039167E-19  -3.68071741140074E-01  -3.68071741129025E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10493568747856E-08   0.00000000000000E+00  -1.10493568747856E-08
      2.41721450473392E-18  -3.92110719038321E-02  -3.07397130871297E-02   0.00000000000000E+00   4.52734512416828E-11
      2.18115670504875E-23  -2.69329141608234E-08  -2.68876407095817E-08  -1.85662374469476E-18
      2.82293888833008E-09
      0.00000000000000E+00  -3.60324354565197E-11   0.00000000000000E+00  -2.27329651652797E-11   1.19068564371830E-22
      3.60551354319799E-08   3.60324024668148E-08  -5.50057142516389E-19  -3.72484419314542E-01  -3.72484419303732E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08104063378279E-08   0.00000000000000E+00  -1.08104063378279E-08
      2.37233096446376E-18  -3.31314875037591E-02  -2.51849051032381E-02   0.00000000000000E+00   3.50992058314428E-11
      4.88094197798436E-23  -2.52570953348186E-08  -2.52219961289871E-08  -1.82227382194737E-18
      2.82854393012695E-09
      0.00000000000000E+00  -3.43022642970043E-11   0.00000000000000E+00  -1.52817297467574E-11   1.24466817132271E-22
      3.43175869124460E-08   3.43023051826994E-08  -5.33895104768383E-19  -3.79114344790771E-01  -3.79114344780194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05775079079700E-08   0.00000000000000E+00  -1.05775079079700E-08
      2.31304359053281E-18  -2.77210847411689E-02  -2.02462079314413E-02   0.00000000000000E+00   2.53544985720392E-11
      8.07556719570015E-23  -2.37501517733013E-08  -2.37247972747292E-08  -1.77914848576443E-18
      2.83611073655274E-09
      0.00000000000000E+00  -3.29083367204057E-11   0.00000000000000E+00  -9.09391045997533E-12   1.33021867004244E-22
      3.29174168458064E-08   3.29083229353466E-08  -5.10655892678401E-19  -3.88549649421667E-01  -3.88549649411280E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03876373105935E-08   0.00000000000000E+00  -1.03876373105935E-08
      2.23444234978232E-18  -2.32107548267367E-02  -1.61152429654774E-02   0.00000000000000E+00   1.75362247231985E-11
      1.16166469915483E-22  -2.25382218494763E-08  -2.25206856247530E-08  -1.72378645710392E-18
      2.84632592522754E-09
      0.00000000000000E+00  -3.18216297897662E-11   0.00000000000000E+00  -5.22245245928205E-12   1.42121595194418E-22
      3.18268682736699E-08   3.18216458212107E-08  -4.79048272631234E-19  -4.01356337028177E-01  -4.01356337017935E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02418871064882E-08   0.00000000000000E+00  -1.02418871064882E-08
      2.12981954060350E-18  -1.95490057701284E-02  -1.27499394621595E-02   0.00000000000000E+00   1.23052015073252E-11
      1.51634760773710E-22  -2.15920639162301E-08  -2.15797587147226E-08  -1.65077126797226E-18
      2.86011642993853E-09
      0.00000000000000E+00  -3.08388911016457E-11   0.00000000000000E+00  -3.47832934737469E-12   1.46091934513776E-22
      3.08423512147112E-08   3.08388728853640E-08  -4.37890100235175E-19  -4.18125530353772E-01  -4.18125530343660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01119369088811E-08   0.00000000000000E+00  -1.01119369088811E-08
      1.99037082702438E-18  -1.65505790844204E-02  -1.00202007069585E-02   0.00000000000000E+00   9.28584025166882E-12
      1.77917286350461E-22  -2.07362218167347E-08  -2.07269359764829E-08  -1.55248072678920E-18
      2.87873361129836E-09
      0.00000000000000E+00  -2.96737487654310E-11   0.00000000000000E+00  -3.05076504811991E-12   1.32053410527281E-22
      2.96767990381603E-08   2.96737482731123E-08  -3.86004346491151E-19  -4.39536096097853E-01  -4.39536096087893E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96001040319394E-09   0.00000000000000E+00  -9.96001040319394E-09
      1.80494350700231E-18  -1.40166750599837E-02  -7.80551459889121E-03   0.00000000000000E+00   7.67453444953900E-12
      1.74300351499062E-22  -1.97214124043682E-08  -1.97137378699184E-08  -1.41893916051115E-18
      2.89873361129836E-09
      0.00000000000000E+00  -2.84678273658962E-11   0.00000000000000E+00  -2.94313842116644E-12   1.01683526862171E-22
      2.84707238328710E-08   2.84677806944500E-08  -3.34394630029268E-19  -4.61182148168546E-01  -4.61182148158735E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81074375224029E-09   0.00000000000000E+00  -9.81074375224029E-09
      1.60872863195750E-18  -1.22009155835557E-02  -6.32268139250087E-03   0.00000000000000E+00   6.67041892492628E-12
      1.38258829855330E-22  -1.86637073611348E-08  -1.86570369422097E-08  -1.27433400192823E-18
      2.91873361129836E-09
      0.00000000000000E+00  -2.74716793461433E-11   0.00000000000000E+00  -2.43002723038985E-12   6.89350483624174E-23
      2.74741399427995E-08   2.74717099155691E-08  -2.86245260133521E-19  -4.81725479282060E-01  -4.81725479272379E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68112879938342E-09   0.00000000000000E+00  -9.68112879938342E-09
      1.41510605596983E-18  -1.09670568626549E-02  -5.36181037026062E-03   0.00000000000000E+00   5.56055046203435E-12
      9.25853804968324E-23  -1.77961416666478E-08  -1.77905811161857E-08  -1.12886079583631E-18
      2.93873361129836E-09
      0.00000000000000E+00  -2.66290038822643E-11   0.00000000000000E+00  -2.05435276205196E-12   4.17308381130773E-23
      2.66310933998303E-08   2.66290390470682E-08  -2.41247342741796E-19  -5.01265198881376E-01  -5.01265198871849E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52642857396556E-09   0.00000000000000E+00  -9.52642857396556E-09
      1.22457748449052E-18  -1.00895759926724E-02  -4.70108332363242E-03   0.00000000000000E+00   4.64450690884919E-12
      5.26481383920831E-23  -1.71072549800116E-08  -1.71026104731027E-08  -9.83330141748726E-19
      2.95873361129836E-09
      0.00000000000000E+00  -2.64813175448346E-11   0.00000000000000E+00  -3.42244994631578E-13   2.34715596550476E-23
      2.64816855483050E-08   2.64813433033104E-08  -1.97052337444379E-19  -5.20866363288534E-01  -5.20866363278703E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.83078872334417E-09   0.00000000000000E+00  -9.83078872334417E-09
      1.02796171002364E-18  -9.52772459182875E-03  -4.28165716082135E-03   0.00000000000000E+00   3.81027529053334E-12
      2.53485783215507E-23  -1.66543648552567E-08  -1.66505545799662E-08  -8.30909372579259E-19
      2.96873361129836E-09
      0.00000000000000E+00  -2.70551634629072E-11   0.00000000000000E+00   2.84687010358677E-12   1.66545188402746E-23
      2.70523126033131E-08   2.70551594734167E-08  -1.74286200041001E-19  -5.31174115486385E-01  -5.31174115475854E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05310021250515E-08   0.00000000000000E+00  -1.05310021250515E-08
      9.22651688773122E-19  -9.38404977527519E-03  -4.17780458052419E-03   0.00000000000000E+00   3.26539081554042E-12
      1.49612745377548E-23  -1.65274227391806E-08  -1.65241573483651E-08  -7.48365488732119E-19
      2.97548361129836E-09
      0.00000000000000E+00  -2.74770063409014E-11   0.00000000000000E+00   3.11355046848426E-12   1.31424467852281E-23
      2.74738957034578E-08   2.74770092539263E-08  -1.58709658319444E-19  -5.38301335412322E-01  -5.38301335401393E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09295590737417E-08   0.00000000000000E+00  -1.09295590737417E-08
      8.48877165025365E-19  -9.34036674571298E-03  -4.12678160770566E-03   0.00000000000000E+00   2.44445278385923E-12
      9.65273655886512E-24  -1.65498946329686E-08  -1.65474501801847E-08  -6.90167506705921E-19
      2.98003986129836E-09
      0.00000000000000E+00  -2.77543774472681E-11   0.00000000000000E+00   3.03656467616284E-12   1.12262463693255E-23
      2.77513725717715E-08   2.77544091364477E-08  -1.48141564519613E-19  -5.43171868798180E-01  -5.43171868787012E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11686009832900E-08   0.00000000000000E+00  -1.11686009832900E-08
      7.97990226795249E-19  -9.32176450816930E-03  -4.09609339318672E-03   0.00000000000000E+00   2.16966096978656E-12
      6.78595595100854E-24  -1.65879778141274E-08  -1.65858081531576E-08  -6.49848662275637E-19
      2.98619079879836E-09
      0.00000000000000E+00  -2.81000810381172E-11   0.00000000000000E+00   2.80569568204504E-12   9.34373213272952E-24
      2.80972438288031E-08   2.81000495244851E-08  -1.33790649649968E-19  -5.49830479484492E-01  -5.49830479473081E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14110184238852E-08   0.00000000000000E+00  -1.14110184238852E-08
      7.27801765658583E-19  -9.31679311979286E-03  -4.05859887012350E-03   0.00000000000000E+00   1.73656396221227E-12
      4.02664794740059E-24  -1.66907676645622E-08  -1.66890311005999E-08  -5.94011116008615E-19
      2.99449456442336E-09
      0.00000000000000E+00  -2.86111970006771E-11   0.00000000000000E+00   3.06715430339980E-12   7.68655934376220E-24
      2.86081164241631E-08   2.86111835784665E-08  -1.14334389627068E-19  -5.58949322326389E-01  -5.58949322314686E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17032042439466E-08   0.00000000000000E+00  -1.17032042439466E-08
      6.30621100555345E-19  -9.35056863965822E-03  -4.02338946667200E-03   0.00000000000000E+00   1.22604356309678E-12
      1.64317095201422E-24  -1.69092053780829E-08  -1.69079793345198E-08  -5.16286710928277E-19
      3.00009960622023E-09
      0.00000000000000E+00  -2.90443367813478E-11   0.00000000000000E+00   3.83879997899573E-12   6.86258000402142E-24
      2.90404689047374E-08   2.90443077047164E-08  -1.01219271394324E-19  -5.65160841589078E-01  -5.65160841577155E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19228205197105E-08   0.00000000000000E+00  -1.19228205197105E-08
      5.63793193205729E-19  -9.41040577068349E-03  -4.01595600112921E-03   0.00000000000000E+00   6.03090857496802E-13
      4.48575804444590E-25  -1.71220902758635E-08  -1.71214871850060E-08  -4.62573921811406E-19
      3.00388300943312E-09
      0.00000000000000E+00  -2.93274941061586E-11   0.00000000000000E+00   3.72701435497664E-12   6.41320516253287E-24
      2.93237606928466E-08   2.93274877072015E-08  -9.24011148220074E-20  -5.69364195494247E-01  -5.69364195482207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20395167458430E-08   0.00000000000000E+00  -1.20395167458430E-08
      5.18242846867856E-19  -9.45982097184835E-03  -4.01291674183565E-03   0.00000000000000E+00   2.74554012500285E-13
     -1.94991543737412E-25  -1.72882455153716E-08  -1.72879709613591E-08  -4.25841732045850E-19
      3.00899060377053E-09
      0.00000000000000E+00  -2.95486562333543E-11   0.00000000000000E+00   2.18018018654140E-12   5.94670668776971E-24
      2.95464387717302E-08   2.95486189519167E-08  -8.06262719938850E-20  -5.75002760967896E-01  -5.75002760955825E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20707633256100E-08   0.00000000000000E+00  -1.20707633256100E-08
      4.56590284457847E-19  -9.49979461923717E-03  -3.99306310862410E-03   0.00000000000000E+00   5.58395483366962E-13
     -8.03427468954346E-25  -1.74784140217899E-08  -1.74778556263065E-08  -3.75964012463962E-19
      3.01588585612602E-09
      0.00000000000000E+00  -2.95088874621435E-11   0.00000000000000E+00  -2.43887498507081E-13   5.46113478024784E-24
      2.95091356818985E-08   2.95088917944000E-08  -6.52536562524782E-20  -5.82405553272716E-01  -5.82405553260833E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18827761403223E-08   0.00000000000000E+00  -1.18827761403223E-08
      3.74655544286492E-19  -9.48555368313727E-03  -3.93210946652130E-03   0.00000000000000E+00   1.22868520688958E-12
     -1.32278960435566E-24  -1.76273443392844E-08  -1.76261156540775E-08  -3.09401888034013E-19
      3.02519444680594E-09
      0.00000000000000E+00  -2.88362166068356E-11   0.00000000000000E+00  -3.53383122757531E-12   4.92265697151232E-24
      2.88397542852118E-08   2.88362204539842E-08  -4.62249175317370E-20  -5.91627397703382E-01  -5.91627397692243E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11392500273661E-08   0.00000000000000E+00  -1.11392500273661E-08
      2.70964825300499E-19  -9.37240595684634E-03  -3.79663671359624E-03   0.00000000000000E+00   1.70091790330389E-12
     -1.72748316097088E-24  -1.76986713445215E-08  -1.76969704266182E-08  -2.24739907768762E-19
      3.03776104422382E-09
      0.00000000000000E+00  -2.63452954890302E-11   0.00000000000000E+00  -9.75708436360945E-12   4.18898584458406E-24
      2.63550273349618E-08   2.63452702505982E-08  -2.68177013547285E-20  -6.01036317592112E-01  -6.01036317583469E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.64318984493368E-09   0.00000000000000E+00  -8.64318984493368E-09
      1.62349338112855E-19  -9.07489573420439E-03  -3.49751526985509E-03   0.00000000000000E+00   1.53722072595042E-12
     -2.03649882411639E-24  -1.77036176263906E-08  -1.77020804056646E-08  -1.35531636758126E-19
      3.05472595073797E-09
      0.00000000000000E+00  -1.80158044269424E-11   0.00000000000000E+00  -2.42064803815957E-11   2.75343459187926E-24
      1.80400557596883E-08   1.80158492793067E-08  -2.62812032973839E-20  -6.00831720438096E-01  -6.00831720437769E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.26196992803853E-10   0.00000000000000E+00  -3.26196992803853E-10
      1.56815436624742E-19  -8.31272758753974E-03  -2.73926122919494E-03   0.00000000000000E+00   1.13621194588980E-13
     -2.37102977084359E-24  -1.76897659076975E-08  -1.76896522865029E-08  -1.30534233327358E-19
      3.07472595073797E-09
      0.00000000000000E+00  -5.58599691696178E-13   0.00000000000000E+00  -4.30272436800762E-11  -1.45598022648198E-25
      6.01587771218655E-10   5.58560527538578E-10  -9.06475357855086E-20  -5.68596898947775E-01  -5.68596898964906E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71302437223718E-08   0.00000000000000E+00   1.71302437223718E-08
      4.99420311072179E-19  -6.83514788584109E-03  -1.26194776071941E-03   0.00000000000000E+00  -3.15445547292348E-12
     -3.36177122075932E-24  -1.76856497944375E-08  -1.76888042499104E-08  -4.08772775286670E-19
      3.09472595073797E-09
      0.00000000000000E+00   1.72253886185344E-11   0.00000000000000E+00  -4.39225075418003E-11  -6.04383892894958E-24
     -1.71814636038758E-08  -1.72253861114176E-08  -2.40540023877391E-19  -4.99457288245043E-01  -4.99457288279922E-01
      0.00000000000000E+00   0.00000000000000E+00   3.48795199702597E-08   0.00000000000000E+00   3.48795199702597E-08
      1.19701071047737E-18  -5.12609234240543E-03   4.36182212147068E-04   0.00000000000000E+00  -8.12404779543737E-12
     -9.18357020473519E-24  -1.76460098110466E-08  -1.76541338588421E-08  -9.56470686599981E-19
      3.11472595073797E-09
      0.00000000000000E+00   2.49767170599009E-11   0.00000000000000E+00  -1.93958558967033E-11  -2.51474816945049E-23
     -2.49573181705518E-08  -2.49767140264485E-08  -4.88762606292769E-19  -3.97404119422685E-01  -3.97404119465278E-01
      0.00000000000000E+00   0.00000000000000E+00   4.25936391902626E-08   0.00000000000000E+00   4.25936391902626E-08
      2.04888349428262E-18  -3.30723287570263E-03   2.24331043937068E-03   0.00000000000000E+00  -1.79496472681581E-11
     -4.25323079609606E-23  -1.75989755165459E-08  -1.76169251638141E-08  -1.56012088798985E-18
      3.13472595073797E-09
      0.00000000000000E+00   1.84483012944527E-11   0.00000000000000E+00   1.55810358249258E-11  -4.11821504285501E-23
     -1.84638224450852E-08  -1.84482414092603E-08  -7.92159776621705E-19  -2.72905824306861E-01  -2.72905824342719E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58586098297892E-08   0.00000000000000E+00   3.58586098297892E-08
      2.76605569087841E-18  -2.63208420303666E-03   2.85336306096914E-03   0.00000000000000E+00  -4.14794650971844E-11
     -7.59478324174354E-23  -1.73688889554315E-08  -1.74103684205287E-08  -1.97389591425670E-18
      3.15472595073797E-09
      0.00000000000000E+00   1.18369497313060E-11   0.00000000000000E+00   1.55827201369621E-11  -4.46767092473778E-23
     -1.18525585673346E-08  -1.18369758471977E-08  -1.02629631651168E-18  -1.59834329057220E-01  -1.59834329083381E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61610157994057E-08   0.00000000000000E+00   2.61610157994057E-08
      3.28927600686652E-18  -2.31104350342965E-02  -1.85974005603213E-02   0.00000000000000E+00  -8.01854942856526E-11
     -8.84965953744790E-23  -1.42438544579223E-08  -1.43240399522081E-08  -2.26297969035484E-18
      3.17472595073797E-09
      0.00000000000000E+00   7.76299272299178E-12   0.00000000000000E+00   9.22083323284484E-12  -4.69957981463894E-23
     -7.77221093382552E-09  -7.76299010059272E-09  -1.18016467585736E-18  -7.45851745946543E-02  -7.45851746135749E-02
      0.00000000000000E+00   0.00000000000000E+00   1.89206055511963E-08   0.00000000000000E+00   1.89206055511963E-08
      3.66768811789045E-18  -6.26491945423827E-02  -5.91337945059753E-02   0.00000000000000E+00  -1.39709116491106E-10
     -1.01555530309420E-22  -1.10179063341123E-08  -1.11576154506035E-08  -2.48752344203309E-18
      3.17722595073797E-09
      0.00000000000000E+00   6.64726285539475E-12   0.00000000000000E+00   2.08618451829613E-11  -4.72087209102788E-23
     -6.66813295310501E-09  -6.64727110792209E-09  -1.19661289109105E-18  -6.49579944096559E-02  -6.49579944265393E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68834833152428E-08   0.00000000000000E+00   1.68834833152428E-08
      3.70989682617855E-18  -6.82822557965829E-02  -6.50571301135101E-02   0.00000000000000E+00  -1.72740411234344E-10
     -1.03245148791256E-22  -1.00634717960867E-08  -1.02362122073211E-08  -2.51328393508750E-18
      3.18060095073797E-09
      0.00000000000000E+00   5.39486801883291E-12   0.00000000000000E+00   1.75572462778867E-11  -4.74475347100211E-23
     -5.41241752736404E-09  -5.39486028108620E-09  -1.21458239727605E-18  -5.42472654443858E-02  -5.42472654591280E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47422231473418E-08   0.00000000000000E+00   1.47422231473418E-08
      3.75965182930083E-18  -7.67572169401235E-02  -7.38121371431448E-02   0.00000000000000E+00  -1.78752813548826E-10
     -1.05433363238033E-22  -9.16861005270703E-09  -9.34736286625597E-09  -2.54506943202478E-18
      3.18515720073797E-09
      0.00000000000000E+00   3.97357071054644E-12   0.00000000000000E+00   1.48033511638404E-11  -4.76716790793424E-23
     -3.98837835849014E-09  -3.97357500732635E-09  -1.23235734764609E-18  -4.34285979806958E-02  -4.34285979930172E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23214074850066E-08   0.00000000000000E+00   1.23214074850066E-08
      3.81579124215439E-18  -8.94271261280305E-02  -8.67969677410199E-02   0.00000000000000E+00  -1.78263999513483E-10
     -1.08191359717897E-22  -8.16956847816639E-09  -8.34783247767998E-09  -2.58343389450830E-18
      3.18823266948797E-09
      0.00000000000000E+00   3.08102355436369E-12   0.00000000000000E+00   1.38395191686939E-11  -4.77778802273358E-23
     -3.09487537025905E-09  -3.08103585109041E-09  -1.24160873341775E-18  -3.76971657734663E-02  -3.76971657842385E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07722512709733E-08   0.00000000000000E+00   1.07722512709733E-08
      3.84892096430542E-18  -9.84725879272904E-02  -9.60493068657388E-02   0.00000000000000E+00  -1.79266085696286E-10
     -1.09975209201716E-22  -7.51194933418634E-09  -7.69121541988273E-09  -2.60731223088767E-18
      3.19238455230047E-09
      0.00000000000000E+00   2.19242572188087E-12   0.00000000000000E+00   1.02486879263171E-11  -4.78745146454311E-23
     -2.20264620782465E-09  -2.19239751989838E-09  -1.25040765701709E-18  -3.21123380587605E-02  -3.21123380679651E-02
      0.00000000000000E+00   0.00000000000000E+00   9.20460877546955E-09   0.00000000000000E+00   9.20460877546955E-09
      3.88713742127608E-18  -1.11284252941390E-01  -1.09074905237626E-01   0.00000000000000E+00  -1.78362168284370E-10
     -1.12256289623399E-22  -6.83384908728691E-09  -7.01221125557139E-09  -2.63672976425898E-18
      3.19798959409734E-09
      0.00000000000000E+00   1.43066547148164E-12   0.00000000000000E+00   6.51178790513548E-12  -4.79545096060236E-23
     -1.43714643640866E-09  -1.43063464850357E-09  -1.25801800458178E-18  -2.70925308458431E-02  -2.70925308536345E-02
      0.00000000000000E+00   0.00000000000000E+00   7.79143633963882E-09   0.00000000000000E+00   7.79143633963882E-09
      3.93080874761745E-18  -1.29109840938208E-01  -1.27105732299731E-01   0.00000000000000E+00  -1.79464500575410E-10
     -1.15183451624346E-22  -6.18133719055961E-09  -6.36080169113514E-09  -2.67279074303566E-18
      3.20555640052312E-09
      0.00000000000000E+00   8.71973935048259E-13   0.00000000000000E+00   3.53303879515553E-12  -4.80157114575992E-23
     -8.75481592639838E-10  -8.71948553844731E-10  -1.26407116519244E-18  -2.28429734068678E-02  -2.28429734135072E-02
      0.00000000000000E+00   0.00000000000000E+00   6.63937636565925E-09   0.00000000000000E+00   6.63937636565925E-09
      3.98104762336429E-18  -1.53312267664898E-01  -1.51495112477557E-01   0.00000000000000E+00  -1.84047650872078E-10
     -1.18976510777053E-22  -5.58338016094220E-09  -5.76742781181440E-09  -2.71697645817185E-18
      3.21577158919793E-09
      0.00000000000000E+00   5.14330528362150E-13   0.00000000000000E+00   1.67082159091574E-12  -4.80590204515701E-23
     -5.15980653609839E-10  -5.14309832018971E-10  -1.26860520399096E-18  -1.93345876041409E-02  -1.93345876098550E-02
      0.00000000000000E+00   0.00000000000000E+00   5.71412018310670E-09   0.00000000000000E+00   5.71412018310670E-09
      4.03941843914524E-18  -1.85165574113978E-01  -1.83527256854044E-01   0.00000000000000E+00  -1.91948917020708E-10
     -1.23913727481223E-22  -5.00786143406681E-09  -5.19981035108764E-09  -2.77081323515428E-18
      3.22956209390892E-09
      0.00000000000000E+00   3.07771714382422E-13   0.00000000000000E+00   7.13664407749519E-13  -4.80865789634335E-23
     -3.08500543409926E-10  -3.07786879002225E-10  -1.27190629913697E-18  -1.64217979209626E-02  -1.64217979258141E-02
      0.00000000000000E+00   0.00000000000000E+00   4.85157099971988E-09   0.00000000000000E+00   4.85157099971988E-09
      4.10632405187256E-18  -2.24974717683058E-01  -2.23543092908948E-01   0.00000000000000E+00  -1.98589573834499E-10
     -1.30193208300837E-22  -4.34519454688309E-09  -4.54378412071772E-09  -2.83441775273559E-18
      3.24817927526875E-09
      0.00000000000000E+00   2.03711627126294E-13   0.00000000000000E+00   2.66689008394074E-13  -4.81030711841385E-23
     -2.03936833180327E-10  -2.03670144171981E-10  -1.27446604178553E-18  -1.39366561722929E-02  -1.39366561761112E-02
      0.00000000000000E+00   0.00000000000000E+00   3.81822751308804E-09   0.00000000000000E+00   3.81822751308804E-09
      4.17740868595682E-18  -2.69367388269343E-01  -2.68228534340956E-01   0.00000000000000E+00  -1.88611982817850E-10
     -1.37453789529388E-22  -3.42594538609805E-09  -3.61455736891604E-09  -2.90294264417129E-18
      3.26817927526875E-09
      0.00000000000000E+00   1.60820134850379E-13   0.00000000000000E+00   1.02782152286563E-13  -4.81115406979139E-23
     -1.60913198172835E-10  -1.60810416020597E-10  -1.27639294105907E-18  -1.21484780207161E-02  -1.21484780234655E-02
      0.00000000000000E+00   0.00000000000000E+00   2.74939591618585E-09   0.00000000000000E+00   2.74939591618585E-09
      4.23239660428054E-18  -3.03920519765321E-01  -3.03104920332667E-01   0.00000000000000E+00  -1.55084553390899E-10
     -1.43320881425504E-22  -2.43350094677422E-09  -2.58858550016526E-09  -2.95600366322146E-18
      3.28817927526875E-09
      0.00000000000000E+00   1.39052932132195E-13   0.00000000000000E+00   5.38179902047182E-14  -4.81144802472960E-23
     -1.39067299517746E-10  -1.39013481527589E-10  -1.27790736401102E-18  -1.09313410142845E-02  -1.09313410161622E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87765371344031E-09   0.00000000000000E+00   1.87765371344031E-09
      4.26994967854934E-18  -3.26736745625377E-01  -3.26188943932864E-01   0.00000000000000E+00  -1.10918006676308E-10
     -1.47274427032779E-22  -1.62772222523631E-09  -1.73864023191276E-09  -2.99204231453832E-18
      3.30817927526875E-09
      0.00000000000000E+00   1.30786905783518E-13   0.00000000000000E+00   2.11317083883602E-14  -4.81159681831722E-23
     -1.30840871423958E-10  -1.30819739715618E-10  -1.27927300034946E-18  -1.00635259855042E-02  -1.00635259866895E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18528417616902E-09   0.00000000000000E+00   1.18528417616902E-09
      4.29365536207272E-18  -3.39591110116498E-01  -3.39258879494560E-01   0.00000000000000E+00  -6.42207843197798E-11
     -1.49491736460914E-22  -9.90243652133427E-10  -1.05446443645336E-09  -3.01438236172326E-18
      3.32817927526875E-09
      0.00000000000000E+00   1.17010195202389E-13   0.00000000000000E+00   3.68010584883163E-14  -4.81126636229628E-23
     -1.17042257427230E-10  -1.17005456368789E-10  -1.28037270283481E-18  -9.51486473467903E-03  -9.51486473541837E-03
      0.00000000000000E+00   0.00000000000000E+00   7.39339320350628E-10   0.00000000000000E+00   7.39339320350628E-10
      4.30844214847973E-18  -3.46175634132525E-01  -3.45979560945208E-01   0.00000000000000E+00  -3.12591139293272E-11
     -1.50557741563183E-22  -5.91074750052456E-10  -6.22333863981934E-10  -3.02806944564493E-18
      3.34817927526875E-09
      0.00000000000000E+00   8.66095871866977E-14   0.00000000000000E+00   8.24088944139903E-14  -4.80980273849401E-23
     -8.67105837138763E-11  -8.66281748195104E-11  -1.28087639988929E-18  -9.30699720749112E-03  -9.30699720820199E-03
      0.00000000000000E+00   0.00000000000000E+00   7.10870754242426E-10   0.00000000000000E+00   7.10870754242426E-10
      4.32265956356458E-18  -3.53296030986417E-01  -3.53099355877064E-01   0.00000000000000E+00  -3.34315233042798E-11
     -1.51665352814687E-22  -5.90811056118371E-10  -6.24242579422803E-10  -3.04178316367530E-18
      3.35317927526875E-09
      0.00000000000000E+00   8.47726924425472E-14   0.00000000000000E+00   2.68334331484376E-14  -4.80945976758521E-23
     -8.47852762570087E-11  -8.47584428239084E-11  -1.28099367314345E-18  -9.26271847543840E-03  -9.26271847611058E-03
      0.00000000000000E+00   0.00000000000000E+00   6.72184945153665E-10   0.00000000000000E+00   6.72184945153665E-10
      4.32602048829035E-18  -3.54930493875634E-01  -3.54745418999532E-01   0.00000000000000E+00  -3.03777455817155E-11
     -1.51915439309246E-22  -5.57048756747755E-10  -5.87426502329622E-10  -3.04502681514690E-18
      3.35655427526875E-09
      0.00000000000000E+00   6.67711239498719E-14   0.00000000000000E+00   2.70705777339157E-13  -4.80901056075796E-23
     -6.69956028945458E-11  -6.67248971172547E-11  -1.28101233229920E-18  -9.26475823411755E-03  -9.26475823483762E-03
      0.00000000000000E+00   0.00000000000000E+00   7.20073478155039E-10   0.00000000000000E+00   7.20073478155039E-10
      4.32845073627912E-18  -3.56270674503021E-01  -3.56064827849347E-01   0.00000000000000E+00  -3.76147574657315E-11
     -1.52120707522847E-22  -6.15733823571841E-10  -6.53348581037725E-10  -3.04743840397992E-18
      3.36111052526875E-09
      0.00000000000000E+00   4.72081949246687E-14   0.00000000000000E+00   2.26126807181451E-13  -4.80828831718248E-23
     -4.74124371012450E-11  -4.71863102941116E-11  -1.28094930525832E-18  -9.30341861055592E-03  -9.30341861142421E-03
      0.00000000000000E+00   0.00000000000000E+00   8.68293650501418E-10   0.00000000000000E+00   8.68293650501418E-10
      4.33240689922422E-18  -3.58743722376746E-01  -3.58485016650926E-01   0.00000000000000E+00  -5.34659387783181E-11
     -1.52511681611002E-22  -7.67641401428475E-10  -8.21107340206946E-10  -3.05145759396590E-18
      3.36726146276875E-09
      0.00000000000000E+00   3.04006080156914E-14   0.00000000000000E+00   1.52218414530309E-13  -4.80719581370677E-23
     -3.05434285652939E-11  -3.03912101508117E-11  -1.28076275145951E-18  -9.37979774997365E-03  -9.37979775109966E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12601124008276E-09   0.00000000000000E+00   1.12601124008276E-09
      4.33933292398627E-18  -3.63456889451769E-01  -3.63111687983580E-01   0.00000000000000E+00  -7.88519544520771E-11
     -1.53286225778022E-22  -1.01676807547993E-09  -1.09562002993216E-09  -3.05857017252676E-18
      3.37141334558125E-09
      0.00000000000000E+00   1.99303079740333E-14   0.00000000000000E+00   1.43512325607520E-13  -4.80638786073693E-23
     -2.00314810892002E-11  -1.98879687636407E-11  -1.28059417871389E-18  -9.43906203967885E-03  -9.43906204099566E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31680342776695E-09   0.00000000000000E+00   1.31680342776695E-09
      4.34480013750545E-18  -3.67316687857329E-01  -3.66908060297240E-01   0.00000000000000E+00  -9.82425695086835E-11
     -1.53933406824929E-22  -1.19867288949418E-09  -1.29691545900302E-09  -3.06420595879157E-18
      3.37701838737812E-09
      0.00000000000000E+00   2.02058421856559E-14   0.00000000000000E+00   1.69649642605189E-14  -4.80540110313453E-23
     -2.01981347715398E-11  -2.01811698073273E-11  -1.28037019353346E-18  -9.49020132677191E-03  -9.49020132830849E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53658262531526E-09   0.00000000000000E+00   1.53658262531526E-09
      4.35341274734470E-18  -3.73466750817117E-01  -3.72988965871392E-01   0.00000000000000E+00  -1.19461103953068E-10
     -1.54989471823517E-22  -1.39694035155443E-09  -1.51640145550766E-09  -3.07304255381124E-18
      3.38458519380390E-09
      0.00000000000000E+00   3.11353659133516E-14   0.00000000000000E+00  -5.47259907276904E-14  -4.80429635267619E-23
     -3.10778221867278E-11  -3.11325481775035E-11  -1.28015441085575E-18  -9.48094763829235E-03  -9.48094764000063E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70828793976295E-09   0.00000000000000E+00   1.70828793976295E-09
      4.36633903150438E-18  -3.82642259874404E-01  -3.82113823337404E-01   0.00000000000000E+00  -1.36657105771574E-10
     -1.56603882009576E-22  -1.54049828581378E-09  -1.67715539158551E-09  -3.08618462064863E-18
      3.39480038247871E-09
      0.00000000000000E+00   4.61060580781784E-14   0.00000000000000E+00  -5.90747314405279E-14  -4.80310374582289E-23
     -4.60298869735036E-11  -4.60889617049922E-11  -1.28002266575767E-18  -9.35777976740050E-03  -9.35777976918762E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78712589134412E-09   0.00000000000000E+00   1.78712589134412E-09
      4.38459485967009E-18  -3.95452055890500E-01  -3.94903490854291E-01   0.00000000000000E+00  -1.47133243004517E-10
     -1.58913160608266E-22  -1.59390368663456E-09  -1.74103692963923E-09  -3.10457219391242E-18
      3.40859088718969E-09
      0.00000000000000E+00   6.70466581614945E-14   0.00000000000000E+00  -6.58998318483304E-14  -4.80205410635223E-23
     -6.69552717055143E-11  -6.70211715374107E-11  -1.28014513516191E-18  -9.01449084249903E-03  -9.01449084428760E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78856964924596E-09   0.00000000000000E+00   1.78856964924596E-09
      4.40926013784394E-18  -4.12435457738475E-01  -4.11893032772228E-01   0.00000000000000E+00  -1.52149915169563E-10
     -1.62067154601370E-22  -1.56939856253886E-09  -1.72154847770858E-09  -3.12911500268204E-18
      3.42720806854953E-09
      0.00000000000000E+00   1.08101255693259E-13   0.00000000000000E+00  -1.07679580830867E-13  -4.80213194978016E-23
     -1.08049298767803E-10  -1.08156978348682E-10  -1.28109475265028E-18  -8.10332973355102E-03  -8.10332973531937E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76835395131615E-09   0.00000000000000E+00   1.76835395131615E-09
      4.44218190406397E-18  -4.34185329184551E-01  -4.33662234528610E-01   0.00000000000000E+00  -1.55445818615523E-10
     -1.66298183606784E-22  -1.50475115435179E-09  -1.66019697296748E-09  -3.16108715141369E-18
      3.44720806854953E-09
      0.00000000000000E+00   1.57881103259738E-13   0.00000000000000E+00  -1.30512027593832E-13  -4.80405228212432E-23
     -1.57728442684404E-10  -1.57858954712045E-10  -1.28312627191144E-18  -6.54818045033666E-03  -6.54818045208846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75180125347659E-09   0.00000000000000E+00   1.75180125347659E-09
      4.47721792913350E-18  -4.56135159236127E-01  -4.55632939028420E-01   0.00000000000000E+00  -1.59495498089225E-10
     -1.70822265008534E-22  -1.43444680067510E-09  -1.59394229876449E-09  -3.19409165722206E-18
      3.46720806854953E-09
      0.00000000000000E+00   1.71933348052490E-13   0.00000000000000E+00  -4.58590214248059E-14  -4.80628066558580E-23
     -1.71903157204231E-10  -1.71949016225704E-10  -1.28545484443297E-18  -4.84502573660822E-03  -4.84502573829988E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69165553223527E-09   0.00000000000000E+00   1.69165553223527E-09
      4.51105103977821E-18  -4.76922516266197E-01  -4.76443685142445E-01   0.00000000000000E+00  -1.62032709658153E-10
     -1.75285837016011E-22  -1.35767380635131E-09  -1.51970651600964E-09  -3.22559619534523E-18
      3.48720806854953E-09
      0.00000000000000E+00   1.94251619193919E-13   0.00000000000000E+00  -7.01759114871784E-14  -4.80938305591209E-23
     -1.94214388198950E-10  -1.94284564110485E-10  -1.28824309352673E-18  -2.88898209873435E-03  -2.88898210039114E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65678295254479E-09   0.00000000000000E+00   1.65678295254479E-09
      4.54418669882910E-18  -4.96707689241930E-01  -4.96246881909529E-01   0.00000000000000E+00  -1.65879326934505E-10
     -1.79730614537185E-22  -1.29661906149950E-09  -1.46249838843419E-09  -3.25594360530237E-18
      3.50720806854953E-09
      0.00000000000000E+00  -1.09387082014164E-13   0.00000000000000E+00   7.84577137135323E-13  -4.79979304668210E-23
      1.08633418181472E-10   1.09417995318559E-10  -1.28498524961417E-18  -4.61356825416930E-03  -4.61356825527786E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10856151072694E-09   0.00000000000000E+00   1.10856151072694E-09
      4.56635792904364E-18  -5.16004170421768E-01  -5.15620409506432E-01   0.00000000000000E+00  -1.40063303602748E-10
     -1.83391936219864E-22  -1.07791620244259E-09  -1.21797950604552E-09  -3.28137267942947E-18
      3.52720806854953E-09
      0.00000000000000E+00  -2.00919547115186E-12   0.00000000000000E+00   5.01802613303381E-12  -4.71402862699274E-23
      2.00420665951574E-09   2.00922468564873E-09  -1.24394531550860E-18  -2.87830778609818E-02  -2.87830778590207E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.96118965401593E-09   0.00000000000000E+00  -1.96118965401593E-09
      4.52713413596333E-18  -5.36697982360157E-01  -5.36682878478478E-01   0.00000000000000E+00   3.50992208883404E-11
     -1.82468568821564E-22  -8.31342525209150E-11  -4.80350316327571E-11  -3.28318882045472E-18
      3.54720806854953E-09
      0.00000000000000E+00  -3.78951385718255E-12   0.00000000000000E+00   4.91168249103376E-12  -4.57099627788234E-23
      3.78460822341730E-09   3.78951990590829E-09  -1.16845824728304E-18  -7.14797436079218E-02  -7.14797436032183E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.70349128546272E-09   0.00000000000000E+00  -4.70349128546272E-09
      4.43306431025407E-18  -5.58151565844255E-01  -5.58439602107399E-01   0.00000000000000E+00   1.78077925980328E-10
     -1.77703474907417E-22   7.35893453574207E-10   9.13971379554357E-10  -3.26460606297103E-18
      3.54970806854953E-09
      0.00000000000000E+00  -4.40257747804279E-12   0.00000000000000E+00   1.24696853013073E-11  -4.54808838592511E-23
      4.39012135388451E-09   4.40259103918577E-09  -1.15753131416348E-18  -7.75002557580890E-02  -7.75002557525032E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.58585020139646E-09   0.00000000000000E+00  -5.58585020139646E-09
      4.41909968475058E-18  -5.60855385446471E-01  -5.61228274518361E-01   0.00000000000000E+00   2.12970415570693E-10
     -1.76984102246844E-22   9.70288746641247E-10   1.18325916221176E-09  -3.26156837058710E-18
      3.55308306854953E-09
      0.00000000000000E+00  -4.96273853027150E-12   0.00000000000000E+00   8.80244988244085E-12  -4.51639791639917E-23
      4.95397891389854E-09   4.96278136378094E-09  -1.14099225369613E-18  -8.65011708065953E-02  -8.65011708001875E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.40782018611554E-09   0.00000000000000E+00  -6.40782018611554E-09
      4.39747329162244E-18  -5.64563816732870E-01  -5.65019195389429E-01   0.00000000000000E+00   2.47608549227525E-10
     -1.75846118663707E-22   1.19743027310750E-09   1.44503882233485E-09  -3.25648103792631E-18
      3.55763931854953E-09
      0.00000000000000E+00  -5.56285204318548E-12   0.00000000000000E+00   7.09893952880126E-12  -4.47057730961711E-23
      5.55571874761561E-09   5.56281768714437E-09  -1.11621665559020E-18  -9.97724143598141E-02  -9.97724143525779E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.23616057631206E-09   0.00000000000000E+00  -7.23616057631206E-09
      4.36450353499662E-18  -5.69608406597519E-01  -5.70135729979007E-01   0.00000000000000E+00   2.78597851382629E-10
     -1.74099754800477E-22   1.39474503778456E-09   1.67334288916701E-09  -3.24828687940642E-18
      3.56379025604953E-09
      0.00000000000000E+00  -6.19630519570579E-12   0.00000000000000E+00   5.67052878174719E-12  -4.40423401721492E-23
      6.19064424087223E-09   6.19631476965394E-09  -1.07977333745987E-18  -1.18851012190151E-01  -1.18851012182172E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97891962172580E-09   0.00000000000000E+00  -7.97891962172580E-09
      4.31542569908585E-18  -5.76364817843393E-01  -5.76926584656317E-01   0.00000000000000E+00   2.98913274979276E-10
     -1.71534247371390E-22   1.48369157709303E-09   1.78260485207213E-09  -3.23565236162599E-18
      3.57209402167453E-09
      0.00000000000000E+00  -6.95071786712842E-12   0.00000000000000E+00   5.02020179988034E-12  -4.29569406455768E-23
      6.94570042571127E-09   6.95072062751111E-09  -1.02762931600908E-18  -1.45289624296852E-01  -1.45289624288327E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.52565026078614E-09   0.00000000000000E+00  -8.52565026078614E-09
      4.24463069751957E-18  -5.85131339249384E-01  -5.85627711268167E-01   0.00000000000000E+00   3.02471957725098E-10
     -1.67962502332807E-22   1.27245767555010E-09   1.57492963327503E-09  -3.21700138151048E-18
      3.58330410526828E-09
      0.00000000000000E+00  -8.41885599139073E-12   0.00000000000000E+00   6.90654637558529E-12  -3.98407261548215E-23
      8.41192251233708E-09   8.41882905871263E-09  -9.55420946149393E-19  -1.80390989668214E-01  -1.80390989659339E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.87465544730129E-09   0.00000000000000E+00  -8.87465544730129E-09
      4.14514506808959E-18  -5.95526596901497E-01  -5.95670484617330E-01   0.00000000000000E+00   2.91737414935069E-10
     -1.63192595542417E-22   1.64088973653770E-10   4.55826388588676E-10  -3.18972412194020E-18
      3.59843771811984E-09
      0.00000000000000E+00  -1.30946715626259E-11   0.00000000000000E+00   1.55616573254331E-11  -2.34854244063629E-23
      1.30791738781289E-08   1.30947355354543E-08  -8.60568755200296E-19  -2.24209433724847E-01  -2.24209433715671E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.17603254398582E-09   0.00000000000000E+00  -9.17603254398582E-09
      4.00627854405557E-18  -6.03234156035090E-01  -6.02000135880129E-01   0.00000000000000E+00   2.82676745637271E-10
     -1.56696423888577E-22  -4.20137973710557E-09  -3.91870299146845E-09  -3.14570978885527E-18
      3.61843771811984E-09
      0.00000000000000E+00  -2.73952645247867E-11   0.00000000000000E+00   3.54777760242868E-11   4.38995993633039E-23
      2.73597242490004E-08   2.73952020250247E-08  -7.53718441907808E-19  -2.71384919664944E-01  -2.71384919655236E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70849425883309E-09   0.00000000000000E+00  -9.70849425883309E-09
      3.81210865887891E-18  -5.88676156100387E-01  -5.83105146400540E-01   0.00000000000000E+00   3.03302344451261E-10
     -1.46640685847931E-22  -1.79900101106429E-08  -1.76867077661918E-08  -3.05839021697110E-18
      3.63843771811984E-09
      0.00000000000000E+00  -4.75815437814173E-11   0.00000000000000E+00   5.00581609325505E-11   1.40076393525469E-22
      4.75314941381015E-08   4.75815522990342E-08  -6.76419369874549E-19  -3.05308324214682E-01  -3.05308324204278E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04044081294398E-08   0.00000000000000E+00  -1.04044081294398E-08
      3.60402049629011E-18  -5.37969395367794E-01  -5.26258167501767E-01   0.00000000000000E+00   3.17101635439553E-10
     -1.33752175701192E-22  -3.74942458050338E-08  -3.71771441695943E-08  -2.92760112641557E-18
      3.65843771811984E-09
      0.00000000000000E+00  -6.29011541028956E-11   0.00000000000000E+00   3.81264812004080E-11   2.11853710702391E-22
      6.28629959096734E-08   6.29011223908740E-08  -6.28195593404909E-19  -3.27589641833616E-01  -3.27589641822593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10230201584759E-08   0.00000000000000E+00  -1.10230201584759E-08
      3.38356009312060E-18  -4.51899050371046E-01  -4.35555770689682E-01   0.00000000000000E+00   2.91294016156089E-10
     -1.17847463876227E-22  -5.21693962485540E-08  -5.18781022323980E-08  -2.75536449971569E-18
      3.67843771811984E-09
      0.00000000000000E+00  -6.48279648447723E-11   0.00000000000000E+00   4.90073280008411E-12   2.21668208942500E-22
      6.48230727360505E-08   6.48279734688508E-08  -6.05497803262876E-19  -3.39970410513394E-01  -3.39970410501816E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15776772840808E-08   0.00000000000000E+00  -1.15776772840808E-08
      3.15200654743898E-18  -3.35975145186123E-01  -3.19198813395679E-01   0.00000000000000E+00   2.42635878711427E-10
     -1.01539351190629E-22  -5.34929320634814E-08  -5.32502961847701E-08  -2.54650874417611E-18
      3.69843771811984E-09
      0.00000000000000E+00  -5.63571247321221E-11   0.00000000000000E+00  -2.09762294816073E-11   1.83088218231202E-22
      5.63781263976817E-08   5.63571501682002E-08  -5.98115283378527E-19  -3.46490853447650E-01  -3.46490853435731E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19190528157879E-08   0.00000000000000E+00  -1.19190528157879E-08
      2.91362549112322E-18  -2.13358528937534E-01  -1.99358036663617E-01   0.00000000000000E+00   1.67805579452207E-10
     -8.50679890838839E-23  -4.46059029318644E-08  -4.44380973524123E-08  -2.31551020774470E-18
      3.71843771811984E-09
      0.00000000000000E+00  -4.91552115087311E-11   0.00000000000000E+00  -1.78690274220996E-11   1.43441798001557E-22
      4.91731027728311E-08   4.91552337454091E-08  -5.88973380100134E-19  -3.53754215083273E-01  -3.53754215071443E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18300515505642E-08   0.00000000000000E+00  -1.18300515505642E-08
      2.67702446011194E-18  -1.12643289417528E-01  -1.00883551682735E-01   0.00000000000000E+00   8.92821229021861E-11
     -7.29902456087350E-23  -3.74144643177470E-08  -3.73251821948449E-08  -2.08805108001181E-18
      3.72843771811984E-09
      0.00000000000000E+00  -4.47670536544299E-11   0.00000000000000E+00  -2.17224326755785E-11   1.25655788160652E-22
      4.47887420891629E-08   4.47670196564875E-08  -5.81828346921961E-19  -3.58267817009622E-01  -3.58267816997936E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16863409537345E-08   0.00000000000000E+00  -1.16863409537345E-08
      2.56016105057459E-18  -7.21823616708160E-02  -6.17598415842871E-02   0.00000000000000E+00   6.20442278174209E-11
     -5.14843096586240E-23  -3.31427229305703E-08  -3.30806787027529E-08  -1.97833270365263E-18
      3.73518771811984E-09
      0.00000000000000E+00  -4.11818024927969E-11   0.00000000000000E+00  -2.62547219542161E-11   1.18408243023985E-22
      4.12080931845320E-08   4.11818384625779E-08  -5.72706515444878E-19  -3.62755365075367E-01  -3.62755365063970E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13972273974722E-08   0.00000000000000E+00  -1.13972273974722E-08
      2.48322976564166E-18  -5.18508007261500E-02  -4.24667251087817E-02   0.00000000000000E+00   5.17473377127622E-11
     -1.77308945488041E-23  -2.98363584028187E-08  -2.97846110651059E-08  -1.91052325019678E-18
      3.73974396811984E-09
      0.00000000000000E+00  -3.86068434404467E-11   0.00000000000000E+00  -2.79276932775870E-11   1.16686456469610E-22
      3.86347631859469E-08   3.86068354926694E-08  -5.63867366448757E-19  -3.66674920923847E-01  -3.66674920912720E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11263348859496E-08   0.00000000000000E+00  -1.11263348859496E-08
      2.43253540231755E-18  -4.16620472307450E-02  -3.30039025984229E-02   0.00000000000000E+00   4.56045610147922E-11
      1.24146074135212E-23  -2.75261051677347E-08  -2.74805006067199E-08  -1.86866803586879E-18
      3.74281943686984E-09
      0.00000000000000E+00  -3.69703539128830E-11   0.00000000000000E+00  -2.63201491614486E-11   1.17071152361999E-22
      3.69966907479949E-08   3.69703705988336E-08  -5.56707008815455E-19  -3.69720480673555E-01  -3.69720480662621E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09347036639033E-08   0.00000000000000E+00  -1.09347036639033E-08
      2.39890606290870E-18  -3.63024088198916E-02  -2.80994724311595E-02   0.00000000000000E+00   4.01782739143102E-11
      3.31492853358344E-23  -2.60758452088443E-08  -2.60356669349299E-08  -1.84219905409325E-18
      3.74697131968234E-09
      0.00000000000000E+00  -3.53176078668335E-11   0.00000000000000E+00  -1.97251228312796E-11   1.19920633588971E-22
      3.53373480822683E-08   3.53176229594372E-08  -5.45514246695434E-19  -3.74362199398193E-01  -3.74362199387476E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07172837183128E-08   0.00000000000000E+00  -1.07172837183128E-08
      2.35440915684196E-18  -3.11016961663467E-02  -2.33509726438841E-02   0.00000000000000E+00   3.10568966426036E-11
      5.89719465122024E-23  -2.46313961377669E-08  -2.46003392411242E-08  -1.80889491014652E-18
      3.75257636147921E-09
      0.00000000000000E+00  -3.38399178899016E-11   0.00000000000000E+00  -1.30436431868196E-11   1.25983291570548E-22
      3.38530069860971E-08   3.38399633429104E-08  -5.28891191762672E-19  -3.81151722784886E-01  -3.81151722774370E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05159431572652E-08   0.00000000000000E+00  -1.05159431572652E-08
      2.29546685591192E-18  -2.64191396879670E-02  -1.90705313201276E-02   0.00000000000000E+00   2.25945329454920E-11
      8.93641768515633E-23  -2.33466147185905E-08  -2.33240201856450E-08  -1.76657566414925E-18
      3.76014316790499E-09
      0.00000000000000E+00  -3.26387724167016E-11   0.00000000000000E+00  -7.82631701679261E-12   1.34742966458040E-22
      3.26465757229194E-08   3.26387494059028E-08  -5.05458926172842E-19  -3.90652601960567E-01  -3.90652601950214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03525926998057E-08   0.00000000000000E+00  -1.03525926998057E-08
      2.21713079094754E-18  -2.24201436614613E-02  -1.53985222005978E-02   0.00000000000000E+00   1.59774125024576E-11
      1.22992297491620E-22  -2.23021341185996E-08  -2.22861567060971E-08  -1.71167186477469E-18
      3.77035835657980E-09
      0.00000000000000E+00  -3.16609933443902E-11   0.00000000000000E+00  -4.69193555376006E-12   1.43238919042164E-22
      3.16656959579605E-08   3.16610040224069E-08  -4.73910514830688E-19  -4.03438226644767E-01  -4.03438226634545E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02220621894320E-08   0.00000000000000E+00  -1.02220621894320E-08
      2.11271049703690E-18  -1.90744480948631E-02  -1.23197472193444E-02   0.00000000000000E+00   1.15786764999595E-11
      1.56104589161219E-22  -2.14505205094749E-08  -2.14389418329748E-08  -1.63879998220621E-18
      3.78414886129078E-09
      0.00000000000000E+00  -3.07187581853782E-11   0.00000000000000E+00  -3.33226010302446E-12   1.44462455923043E-22
      3.07221127499315E-08   3.07187804898286E-08  -4.33003537150380E-19  -4.20123368115397E-01  -4.20123368105299E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00976324986014E-08   0.00000000000000E+00  -1.00976324986014E-08
      1.97345904849513E-18  -1.62581801539342E-02  -9.76113123395408E-03   0.00000000000000E+00   8.99687384553267E-12
      1.76537033024686E-22  -2.06301448650728E-08  -2.06211479912271E-08  -1.54045551134475E-18
      3.80276604265062E-09
      0.00000000000000E+00  -2.95611471176146E-11   0.00000000000000E+00  -3.03113116726703E-12   1.29004102806401E-22
      2.95641878517824E-08   2.95611567206152E-08  -3.81482487377173E-19  -4.41414451612187E-01  -4.41414451602240E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94675692776306E-09   0.00000000000000E+00  -9.94675692776306E-09
      1.78827847082880E-18  -1.38294314052856E-02  -7.64956855668153E-03   0.00000000000000E+00   7.55745435526316E-12
      1.71101237225038E-22  -1.96219572472076E-08  -1.96143997928522E-08  -1.40679598345163E-18
      3.82276604265062E-09
      0.00000000000000E+00  -2.83718496155143E-11   0.00000000000000E+00  -2.90255570955488E-12   9.90200410935309E-23
      2.83747135383155E-08   2.83718109826061E-08  -3.30198436224239E-19  -4.62956508873109E-01  -4.62956508863310E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79910587714900E-09   0.00000000000000E+00  -9.79910587714900E-09
      1.59229635328582E-18  -1.20759718828920E-02  -6.22430749425979E-03   0.00000000000000E+00   6.56926630497367E-12
      1.34852385260526E-22  -1.85792743717622E-08  -1.85727051054571E-08  -1.26209791706159E-18
      3.84276604265062E-09
      0.00000000000000E+00  -2.73960911274215E-11   0.00000000000000E+00  -2.38017591326012E-12   6.65203957997933E-23
      2.73984397911138E-08   2.73960596152006E-08  -2.82321114413303E-19  -4.83414635653345E-01  -4.83414635643675E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67036016190129E-09   0.00000000000000E+00  -9.67036016190129E-09
      1.39888915004780E-18  -1.08812792241207E-02  -5.29647451497507E-03   0.00000000000000E+00   5.46753899820327E-12
      8.92114129735581E-23  -1.77311669922975E-08  -1.77256994532992E-08  -1.11656803563449E-18
      3.86276604265062E-09
      0.00000000000000E+00  -2.65612224662051E-11   0.00000000000000E+00  -2.03513730060703E-12   3.99633284987686E-23
      2.65632870284961E-08   2.65612518911956E-08  -2.37589205952557E-19  -5.02869369004107E-01  -5.02869368994596E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51117231813638E-09   0.00000000000000E+00  -9.51117231813638E-09
      1.20866570368507E-18  -1.00264620908404E-02  -4.65451995478899E-03   0.00000000000000E+00   4.57859639829786E-12
      5.00326117390669E-23  -1.70546581694576E-08  -1.70500795730593E-08  -9.71076497732514E-19
      3.88276604265062E-09
      0.00000000000000E+00  -2.65479968240472E-11   0.00000000000000E+00  -9.16568005903716E-15   2.23774856781232E-23
      2.65480550552000E-08   2.65480458895199E-08  -1.93201534456380E-19  -5.22598379583232E-01  -5.22598379573318E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.91473843405963E-09   0.00000000000000E+00  -9.91473843405963E-09
      1.01037093500388E-18  -9.50066724613725E-03  -4.26003403434463E-03   0.00000000000000E+00   3.71764046278000E-12
      2.36900056115412E-23  -1.66370250959231E-08  -1.66333074554603E-08  -8.17169400547497E-19
      3.90276604265062E-09
      0.00000000000000E+00  -2.74714038119317E-11   0.00000000000000E+00   2.30262471326845E-12   1.26427401831797E-23
      2.74690846883855E-08   2.74713873130988E-08  -1.47186209697128E-19  -5.43588713250756E-01  -5.43588713239908E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08482718588547E-08   0.00000000000000E+00  -1.08482718588547E-08
      7.93405497826783E-19  -9.30167492055639E-03  -4.06424956160052E-03   0.00000000000000E+00   2.64424420065719E-12
      9.10163852678521E-24  -1.66257596984447E-08  -1.66231154542441E-08  -6.46219288129654E-19
      3.90526604265062E-09
      0.00000000000000E+00  -2.76591344547839E-11   0.00000000000000E+00   3.70984652444981E-12   1.14665632554512E-23
      2.76554294276200E-08   2.76591392741444E-08  -1.41490223355723E-19  -5.46231286518136E-01  -5.46231286507028E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11080880290904E-08   0.00000000000000E+00  -1.11080880290904E-08
      7.65635277754057E-19  -9.26058345379085E-03  -4.04586346750889E-03   0.00000000000000E+00   3.91539179693609E-12
      7.28943515498060E-24  -1.65549666368518E-08  -1.65510512450548E-08  -6.24145054398333E-19
      3.90864104265062E-09
      0.00000000000000E+00  -2.79089521399884E-11   0.00000000000000E+00   3.68567869180879E-12   1.01426648183022E-23
      2.79053188391990E-08   2.79090045178908E-08  -1.33714147545983E-19  -5.49851784658326E-01  -5.49851784647004E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13227900148448E-08   0.00000000000000E+00  -1.13227900148448E-08
      7.27420861453956E-19  -9.25683490444054E-03  -4.03103507555089E-03   0.00000000000000E+00   2.03144816491040E-12
      5.30371420447947E-24  -1.65882459512107E-08  -1.65862145030458E-08  -5.93706713907972E-19
      3.91319729265062E-09
      0.00000000000000E+00  -2.82690753545791E-11   0.00000000000000E+00   3.92927679867039E-12   8.80005818886079E-24
      2.82651167384314E-08   2.82690460152301E-08  -1.23123051500788E-19  -5.54809080881071E-01  -5.54809080869524E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15473455560383E-08   0.00000000000000E+00  -1.15473455560383E-08
      6.74808268264256E-19  -9.28935209673455E-03  -4.02086398502694E-03   0.00000000000000E+00   1.05556570077349E-12
      3.30820818100156E-24  -1.67227560248928E-08  -1.67217004591920E-08  -5.51685216763468E-19
      3.91934823015062E-09
      0.00000000000000E+00  -2.87697210170973E-11   0.00000000000000E+00   4.04880795937029E-12   7.55373816242358E-24
      2.87657023047182E-08   2.87697511126776E-08  -1.08731086909970E-19  -5.61594673461105E-01  -5.61594673449303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18023129405939E-08   0.00000000000000E+00  -1.18023129405939E-08
      6.02212979011221E-19  -9.36087368592270E-03  -4.01496034410812E-03   0.00000000000000E+00   5.28254220382431E-13
      1.47227344463166E-24  -1.69679664263041E-08  -1.69674381720837E-08  -4.93481892101252E-19
      3.92350011296312E-09
      0.00000000000000E+00  -2.91256193737765E-11   0.00000000000000E+00   4.26042709219059E-12   6.90118576414639E-24
      2.91213744699847E-08   2.91256348970769E-08  -9.90256484547615E-20  -5.66204327400015E-01  -5.66204327388047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19674266255259E-08   0.00000000000000E+00  -1.19674266255259E-08
      5.52525626094846E-19  -9.42177665083894E-03  -4.01575693938521E-03   0.00000000000000E+00   2.00110608950618E-13
      5.10317118797415E-25  -1.71584083821597E-08  -1.71582082715508E-08  -4.53499977640085E-19
      3.92630263386156E-09
      0.00000000000000E+00  -2.93477917930815E-11   0.00000000000000E+00   3.95005673529632E-12   6.53022748432736E-24
      2.93438619598530E-08   2.93478120165883E-08  -9.24932685306667E-20  -5.69320946961554E-01  -5.69320946949498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20553842384754E-08   0.00000000000000E+00  -1.20553842384754E-08
      5.18740159827824E-19  -9.46387962653992E-03  -4.01557112227838E-03   0.00000000000000E+00   7.74583026772130E-14
     -2.86983434420834E-26  -1.72925052364149E-08  -1.72924277781122E-08  -4.26246891297157E-19
      3.93008603707445E-09
      0.00000000000000E+00  -2.95471867175590E-11   0.00000000000000E+00   2.64804091254932E-12   6.12824542904503E-24
      2.95445984119503E-08   2.95472464528628E-08  -8.37328363049322E-20  -5.73514135258721E-01  -5.73514135246623E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20976897066873E-08   0.00000000000000E+00  -1.20976897066873E-08
      4.72969721722989E-19  -9.50287877451612E-03  -4.00506345131344E-03   0.00000000000000E+00   3.55331665629506E-13
     -5.74781601440709E-25  -1.74499120778408E-08  -1.74495567461752E-08  -3.89236885418056E-19
      3.93519363141185E-09
      0.00000000000000E+00  -2.96105595862322E-11   0.00000000000000E+00   6.56390259382122E-13   5.70167271866636E-24
      2.96099137590404E-08   2.96105701492997E-08  -7.21389940723688E-20  -5.79086021332814E-01  -5.79086021320794E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20206619192561E-08   0.00000000000000E+00  -1.20206619192561E-08
      4.11573056972369E-19  -9.51097625295070E-03  -3.96894014156160E-03   0.00000000000000E+00   9.82427887513766E-13
     -1.08089974549088E-24  -1.75908906579307E-08  -1.75899082300432E-08  -3.39434062900000E-19
      3.94208888376734E-09
      0.00000000000000E+00  -2.93525677194163E-11   0.00000000000000E+00  -1.80937499907309E-12   5.24420981895933E-24
      2.93543970070200E-08   2.93525876320209E-08  -5.71993255015487E-20  -5.86303471204947E-01  -5.86303471193274E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16726873963703E-08   0.00000000000000E+00  -1.16726873963703E-08
      3.31086931707610E-19  -9.45783210771393E-03  -3.88744171378490E-03   0.00000000000000E+00   1.56886861944373E-12
     -1.50889635805409E-24  -1.76814691042701E-08  -1.76799002356506E-08  -2.73887606206061E-19
      3.95139747444726E-09
      0.00000000000000E+00  -2.83300602600849E-11   0.00000000000000E+00  -5.39145548924933E-12   4.71069540487582E-24
      2.83354478179958E-08   2.83300563625065E-08  -3.92349746297612E-20  -5.95026095567562E-01  -5.95026095556942E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06199702173322E-08   0.00000000000000E+00  -1.06199702173322E-08
      2.32229975921569E-19  -9.30400476381021E-03  -3.72410281101759E-03   0.00000000000000E+00   1.79250531283087E-12
     -1.84420676253448E-24  -1.77118786504875E-08  -1.77100861451746E-08  -1.92995001291809E-19
      3.96396407186514E-09
      0.00000000000000E+00  -2.50513868312506E-11   0.00000000000000E+00  -1.28512687121752E-11   3.91961345659498E-24
      2.50642587394074E-08   2.50514074706953E-08  -2.28902350086048E-20  -6.02908591446506E-01  -6.02908591439155E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.35082040423886E-09   0.00000000000000E+00  -7.35082040423886E-09
      1.39855175210315E-19  -8.94379374140040E-03  -3.36688337145274E-03   0.00000000000000E+00   1.35157474433951E-12
     -2.11389577928586E-24  -1.77019386412007E-08  -1.77005870664564E-08  -1.16964940201710E-19
      3.98092897837929E-09
      0.00000000000000E+00  -1.51206746206868E-11   0.00000000000000E+00  -2.88606097397493E-11   2.29969479364676E-24
      1.51495314425326E-08   1.51206708327928E-08  -3.11968974322489E-20  -5.98239520336312E-01  -5.98239520338882E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57044743705636E-09   0.00000000000000E+00   2.57044743705636E-09
      1.83462575679504E-19  -8.06364597460974E-03  -2.48971742504524E-03   0.00000000000000E+00  -4.00129899708717E-13
     -2.46860985439611E-24  -1.76907181399495E-08  -1.76911182698492E-08  -1.52265678247256E-19
      4.00092897837929E-09
      0.00000000000000E+00   3.29538917100606E-12   0.00000000000000E+00  -4.53905990326769E-11  -9.30514009110001E-25
     -3.24999866188459E-09  -3.29538926091727E-09  -1.11110639178614E-19  -5.58697569198046E-01  -5.58697569219028E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09826043498132E-08   0.00000000000000E+00   2.09826043498132E-08
      6.03114662675767E-19  -6.49505806638730E-03  -9.22358657418381E-04   0.00000000000000E+00  -3.96274355275344E-12
     -3.79289314105303E-24  -1.76832523453430E-08  -1.76872150888958E-08  -4.92004023497152E-19
      4.02092897837929E-09
      0.00000000000000E+00   1.98728131685414E-11   0.00000000000000E+00  -4.09908284787125E-11  -8.14156663872102E-24
     -1.98317752803905E-08  -1.98727661088692E-08  -2.79261052274051E-19  -4.82700196828193E-01  -4.82700196865708E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75151780327076E-08   0.00000000000000E+00   3.75151780327076E-08
      1.35341822332992E-18  -4.79206474039327E-03   7.66515584197109E-04   0.00000000000000E+00  -9.41955502131968E-12
     -1.21734250617648E-23  -1.76329923688170E-08  -1.76424119238383E-08  -1.07415717105587E-18
      4.04092897837929E-09
      0.00000000000000E+00   2.47872413670417E-11   0.00000000000000E+00  -1.24367295704211E-11  -3.02317212237628E-23
     -2.47747968391184E-08  -2.47872335686888E-08  -5.45896448877382E-19  -3.74848450472242E-01  -3.74848450514660E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24183527650886E-08   0.00000000000000E+00   4.24183527650886E-08
      2.20178527863169E-18  -2.80936070512417E-03   2.74565163790783E-03   0.00000000000000E+00  -2.11501643960225E-11
     -5.24724698524156E-23  -1.76099690320038E-08  -1.76311191963999E-08  -1.65588882975431E-18
      4.06092897837929E-09
      0.00000000000000E+00   1.68024436036938E-11   0.00000000000000E+00   1.91245754363185E-11  -4.20066555114076E-23
     -1.68215383956571E-08  -1.68024138202209E-08  -8.43600400779381E-19  -2.49629515775573E-01  -2.49629515809406E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38328779132246E-08   0.00000000000000E+00   3.38328779132246E-08
      2.87844283689618E-18  -4.75746632347715E-03   6.08281426787437E-04   0.00000000000000E+00  -4.76449115350712E-11
     -7.82613486132223E-23  -1.69828191814685E-08  -1.70304640930037E-08  -2.03484243611680E-18
      4.08092897837929E-09
      0.00000000000000E+00   1.09969377648060E-11   0.00000000000000E+00   1.35667001060087E-11  -4.52036827272541E-23
     -1.10104697349039E-08  -1.09969030347980E-08  -1.06181834247528E-18  -1.41000787837106E-01  -1.41000787861804E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46987132429156E-08   0.00000000000000E+00   2.46987132429156E-08
      3.37241710175449E-18  -2.92447915970463E-02  -2.49278020251625E-02   0.00000000000000E+00  -9.04022389182958E-11
     -9.10197120662931E-23  -1.36114079691993E-08  -1.37018102081177E-08  -2.31059875927922E-18
      4.10092897837929E-09
      0.00000000000000E+00   6.94346213288902E-12   0.00000000000000E+00   9.19143190472615E-12  -4.72747350950792E-23
     -6.95269436242609E-09  -6.94350293052141E-09  -1.19926998737271E-18  -6.32686387395756E-02  -6.32686387570445E-02
      0.00000000000000E+00   0.00000000000000E+00   1.74688414893987E-08   0.00000000000000E+00   1.74688414893987E-08
      3.72179393154247E-18  -7.22592099640473E-02  -6.89430179620710E-02   0.00000000000000E+00  -1.49414614020393E-10
     -1.03896705259452E-22  -1.03759239448568E-08  -1.05253385588773E-08  -2.52252394416976E-18
      4.10342897837929E-09
      0.00000000000000E+00   5.76344094924672E-12   0.00000000000000E+00   2.21833605116626E-11  -4.74468584769677E-23
     -5.78554971326708E-09  -5.76336635275546E-09  -1.21350231052554E-18  -5.48206768599817E-02  -5.48206768753256E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53438928603871E-08   0.00000000000000E+00   1.53438928603871E-08
      3.76015366369344E-18  -7.83187479871379E-02  -7.53002073447833E-02   0.00000000000000E+00  -1.78632958709707E-10
     -1.05545647719748E-22  -9.40189354892209E-09  -9.58052650763191E-09  -2.54665135316790E-18
      4.10680397837929E-09
      0.00000000000000E+00   4.46797093093455E-12   0.00000000000000E+00   1.83006349834409E-11  -4.76292460796887E-23
     -4.48631317110126E-09  -4.46801253611787E-09  -1.22833891419277E-18  -4.58529371746500E-02  -4.58529371877853E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31352984338554E-08   0.00000000000000E+00   1.31352984338554E-08
      3.80448529590770E-18  -8.73713359218169E-02  -8.46405266003179E-02   0.00000000000000E+00  -1.81366415111332E-10
     -1.07657192762104E-22  -8.48591948262597E-09  -8.66728589773741E-09  -2.57614638171493E-18
      4.11136022837929E-09
      0.00000000000000E+00   3.13227291772549E-12   0.00000000000000E+00   1.40103852584797E-11  -4.77914768357517E-23
     -3.14626787510923E-09  -3.13225748985080E-09  -1.24227807584325E-18  -3.72337848111324E-02  -3.72337848219765E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08440731451858E-08   0.00000000000000E+00   1.08440731451858E-08
      3.85389360417545E-18  -1.00698952169908E-01  -9.82691822207706E-02   0.00000000000000E+00  -1.79353085465746E-10
     -1.10305618660733E-22  -7.53246256986902E-09  -7.71181565533487E-09  -2.61161552833220E-18
      4.11751116587929E-09
      0.00000000000000E+00   1.94949639196696E-12   0.00000000000000E+00   9.21212706824087E-12  -4.79162388873153E-23
     -1.95871265950180E-09  -1.94950053243361E-09  -1.25382015208880E-18  -2.98437205352456E-02  -2.98437205439860E-02
      0.00000000000000E+00   0.00000000000000E+00   8.74034694037007E-09   0.00000000000000E+00   8.74034694037007E-09
      3.90765493193399E-18  -1.19821026479013E-01  -1.17681425630038E-01   0.00000000000000E+00  -1.78616071896962E-10
     -1.13628564547676E-22  -6.61223033603926E-09  -6.79084640793634E-09  -2.65383477984518E-18
      4.12581493150429E-09
      0.00000000000000E+00   1.09433004382768E-12   0.00000000000000E+00   4.93826954213409E-12  -4.80019450612928E-23
     -1.09922631819410E-09  -1.09428804865202E-09  -1.26230678972199E-18  -2.40779659345760E-02  -2.40779659416637E-02
      0.00000000000000E+00   0.00000000000000E+00   7.08765556180163E-09   0.00000000000000E+00   7.08765556180163E-09
      3.96650916254991E-18  -1.46272700201430E-01  -1.44384359968746E-01   0.00000000000000E+00  -1.82045989740240E-10
     -1.17857077699506E-22  -5.81132152340919E-09  -5.99336751314955E-09  -2.70420237282793E-18
      4.13702501509804E-09
      0.00000000000000E+00   5.84591752325908E-13   0.00000000000000E+00   2.17713256596335E-12  -4.80561479697996E-23
     -5.86759199486204E-10  -5.84582066920289E-10  -1.26806807001030E-18  -1.97492780495052E-02  -1.97492780553919E-02
      0.00000000000000E+00   0.00000000000000E+00   5.88673892252664E-09   0.00000000000000E+00   5.88673892252664E-09
      4.03249999796602E-18  -1.81343918925486E-01  -1.79673356876773E-01   0.00000000000000E+00  -1.90164654923330E-10
     -1.23309383885855E-22  -5.11199220068280E-09  -5.30215685560625E-09  -2.76443192795572E-18
      4.15215862794960E-09
      0.00000000000000E+00   3.20538132854268E-13   0.00000000000000E+00   8.34035245614425E-13  -4.80872622840129E-23
     -3.21408409655373E-10  -3.20574374409806E-10  -1.27188430488612E-18  -1.64339493146597E-02  -1.64339493195452E-02
      0.00000000000000E+00   0.00000000000000E+00   4.88556118816800E-09   0.00000000000000E+00   4.88556118816800E-09
      4.10643618955037E-18  -2.25061510976594E-01  -2.23623207042389E-01   0.00000000000000E+00  -1.97687069032458E-10
     -1.30203728944721E-22  -4.36729974472562E-09  -4.56498681375821E-09  -2.83455188466425E-18
      4.17215862794960E-09
      0.00000000000000E+00   2.02701335017012E-13   0.00000000000000E+00   2.81810323895739E-13  -4.81041606426901E-23
     -2.02987296536192E-10  -2.02705486212344E-10  -1.27461758487426E-18  -1.37952343722978E-02  -1.37952343760606E-02
      0.00000000000000E+00   0.00000000000000E+00   3.76277105344580E-09   0.00000000000000E+00   3.76277105344580E-09
      4.18169161061929E-18  -2.72031005453749E-01  -2.70909320953115E-01   0.00000000000000E+00  -1.86637047717982E-10
     -1.37897847346055E-22  -3.37342851951542E-09  -3.56006556723354E-09  -2.90707402574503E-18
      4.19215862794960E-09
      0.00000000000000E+00   1.59350619055059E-13   0.00000000000000E+00   1.04065147167986E-13  -4.81120567565393E-23
     -1.59524188808609E-10  -1.59420123661490E-10  -1.27651856281924E-18  -1.20460730846283E-02  -1.20460730873151E-02
      0.00000000000000E+00   0.00000000000000E+00   2.68674244631411E-09   0.00000000000000E+00   2.68674244631411E-09
      4.23542645954557E-18  -3.05751982963438E-01  -3.04955685975721E-01   0.00000000000000E+00  -1.52385358407257E-10
     -1.43635355027099E-22  -2.37493696424528E-09  -2.52732232265268E-09  -2.95890789672633E-18
      4.21215862794960E-09
      0.00000000000000E+00   1.37950795285705E-13   0.00000000000000E+00   5.31408237384344E-14  -4.81146402300842E-23
     -1.38012174782551E-10  -1.37959033958860E-10  -1.27801317684727E-18  -1.08595559499223E-02  -1.08595559517495E-02
      0.00000000000000E+00   0.00000000000000E+00   1.82721410458209E-09   0.00000000000000E+00   1.82721410458209E-09
      4.27197074163721E-18  -3.27865475044616E-01  -3.27333233597284E-01   0.00000000000000E+00  -1.07865615641006E-10
     -1.47468680624637E-22  -1.58138945498200E-09  -1.68925507062316E-09  -2.99395756478994E-18
      4.23215862794961E-09
      0.00000000000000E+00   1.30511371571896E-13   0.00000000000000E+00   1.92290938274235E-14  -4.81160975264348E-23
     -1.30562455109803E-10  -1.30543226016024E-10  -1.27937406088970E-18  -1.00103057637049E-02  -1.00103057648484E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14349040651579E-09   0.00000000000000E+00   1.14349040651579E-09
      4.29484054976753E-18  -3.40102806531299E-01  -3.39783657311305E-01   0.00000000000000E+00  -6.10922711874796E-11
     -1.49575591246328E-22  -9.51854909312093E-10  -1.01294718049972E-09  -3.01546648887783E-18
      4.25215862794961E-09
      0.00000000000000E+00   1.14530387297786E-13   0.00000000000000E+00   4.26038725868465E-14  -4.81118014526791E-23
     -1.14573135159299E-10  -1.14530531286760E-10  -1.28042503621801E-18  -9.49321509075047E-03  -9.49321509147872E-03
      0.00000000000000E+00   0.00000000000000E+00   7.28250078503581E-10   0.00000000000000E+00   7.28250078503581E-10
      4.30940555133760E-18  -3.46596856017256E-01  -3.46403497037914E-01   0.00000000000000E+00  -3.06870791771491E-11
     -1.50620346630260E-22  -5.83032468039600E-10  -6.13719547216900E-10  -3.02898051511959E-18
      4.27215862794961E-09
      0.00000000000000E+00   8.51400713913773E-14   0.00000000000000E+00   8.00993932677113E-14  -4.80967600186539E-23
     -8.52656541605335E-11  -8.51855547673139E-11  -1.28090082334596E-18  -9.29688307586518E-03  -9.29688307658466E-03
      0.00000000000000E+00   0.00000000000000E+00   7.19476412643192E-10   0.00000000000000E+00   7.19476412643192E-10
      4.32379507959046E-18  -3.53894279793854E-01  -3.53694438584658E-01   0.00000000000000E+00  -3.44048526949529E-11
     -1.51757946198638E-22  -5.99886005180709E-10  -6.34290857875814E-10  -3.04289425624450E-18
      4.27465862794961E-09
      0.00000000000000E+00   9.79983346004310E-14   0.00000000000000E+00  -2.40507379822740E-13  -4.80965552091186E-23
     -9.77487825508735E-11  -9.79892899307443E-11  -1.28099246408759E-18  -9.25638820881208E-03  -9.25638820946021E-03
      0.00000000000000E+00   0.00000000000000E+00   6.48130424221448E-10   0.00000000000000E+00   6.48130424221448E-10
      4.32541540565102E-18  -3.54598598013940E-01  -3.54425271778048E-01   0.00000000000000E+00  -2.58639904233495E-11
     -1.51866486648224E-22  -5.24277143867359E-10  -5.50141134290860E-10  -3.04442294156343E-18
      4.27803362794961E-09
      0.00000000000000E+00   7.08122923870031E-14   0.00000000000000E+00   3.98186513282941E-13  -4.80916311345979E-23
     -7.11782516971193E-11  -7.07800651838845E-11  -1.28102469370445E-18  -9.25367005741785E-03  -9.25367005810286E-03
      0.00000000000000E+00   0.00000000000000E+00   6.85011115746862E-10   0.00000000000000E+00   6.85011115746862E-10
      4.32772731816666E-18  -3.55829565854946E-01  -3.55636044683114E-01   0.00000000000000E+00  -3.41027150510796E-11
     -1.52052601061964E-22  -5.80128335511871E-10  -6.14231050563102E-10  -3.04670262446221E-18
      4.28258987794961E-09
      0.00000000000000E+00   5.05146054641397E-14   0.00000000000000E+00   2.34879692792241E-13  -4.80846574452743E-23
     -5.07356387602182E-11  -5.05007590674741E-11  -1.28097657587897E-18  -9.28808234972504E-03  -9.28808235054920E-03
      0.00000000000000E+00   0.00000000000000E+00   8.24159472859603E-10   0.00000000000000E+00   8.24159472859603E-10
      4.33148239476488E-18  -3.58125177611672E-01  -3.57881422406556E-01   0.00000000000000E+00  -4.91242250449583E-11
     -1.52412024459150E-22  -7.24534488747373E-10  -7.73658713792484E-10  -3.05050581888592E-18
      4.28874081544961E-09
      0.00000000000000E+00   3.31559501319172E-14   0.00000000000000E+00   1.56055057729709E-13  -4.80739886131938E-23
     -3.33318276668803E-11  -3.31757726091987E-11  -1.28080681862891E-18  -9.36154715418064E-03  -9.36154715525495E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07431122592802E-09   0.00000000000000E+00   1.07431122592802E-09
      4.33809041597111E-18  -3.62567771795681E-01  -3.62239737787497E-01   0.00000000000000E+00  -7.37809759722385E-11
     -1.53137506933065E-22  -9.67354477346351E-10  -1.04113545331874E-09  -3.05728359734220E-18
      4.29289269826211E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   1.62178742621253E-13  -4.80658882276774E-23
     -2.12337457238038E-11  -2.10715669812306E-11  -1.28064290848475E-18  -9.42262947765252E-03  -9.42262947891890E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26638451330772E-09   0.00000000000000E+00   1.26638451330772E-09
      4.34334829606593E-18  -3.66259622332325E-01  -3.65867254133592E-01   0.00000000000000E+00  -9.33402412209857E-11
     -1.53753113745553E-22  -1.15197270510528E-09  -1.24531294632642E-09  -3.06270538758118E-18
      4.29849774005898E-09
      0.00000000000000E+00   1.92873948135806E-14   0.00000000000000E+00   3.53724934940248E-14  -4.80557855062174E-23
     -1.93307500876440E-11  -1.92953775941980E-11  -1.28041358809301E-18  -9.48151336752956E-03  -9.48151336902768E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49811341117064E-09   0.00000000000000E+00   1.49811341117064E-09
      4.35174528435200E-18  -3.72252155309497E-01  -3.71786212469247E-01   0.00000000000000E+00  -1.15718411215147E-10
     -1.54777550577203E-22  -1.36309962236113E-09  -1.47881803357643E-09  -3.07133169625899E-18
      4.30606454648476E-09
      0.00000000000000E+00   2.92984711692010E-14   0.00000000000000E+00  -4.81677475917827E-14  -4.80444127162011E-23
     -2.92608962006784E-11  -2.93090639483183E-11  -1.28018349037375E-18  -9.48387132557043E-03  -9.48387132725846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68803196383941E-09   0.00000000000000E+00   1.68803196383941E-09
      4.36451829546290E-18  -3.81329350291519E-01  -3.80806721655345E-01   0.00000000000000E+00  -1.34492387792238E-10
     -1.56369183945055E-22  -1.52423051209884E-09  -1.65872289989123E-09  -3.08433480508915E-18
      4.31627973515957E-09
      0.00000000000000E+00   4.42691633340279E-14   0.00000000000000E+00  -5.87540956692214E-14  -4.80321318588937E-23
     -4.42219105763900E-11  -4.42806646721073E-11  -1.28003259014213E-18  -9.37311909388481E-03  -9.37311909566645E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78163112252395E-09   0.00000000000000E+00   1.78163112252395E-09
      4.38271799352839E-18  -3.94118412571428E-01  -3.93571009174895E-01   0.00000000000000E+00  -1.46203242157930E-10
     -1.58668306760941E-22  -1.59114721569361E-09  -1.73735045785170E-09  -3.10268540338626E-18
      4.33007023987055E-09
      0.00000000000000E+00   6.48423844685139E-14   0.00000000000000E+00  -6.41737025223429E-14  -4.80210498778265E-23
     -6.47819050413658E-11  -6.48460787439362E-11  -1.28012421887051E-18  -9.04765179902490E-03  -9.04765180081415E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78924888404707E-09   0.00000000000000E+00   1.78924888404707E-09
      4.40739263869297E-18  -4.11142977072401E-01  -4.10599652835965E-01   0.00000000000000E+00  -1.51801180428224E-10
     -1.61821078150105E-22  -1.57260162487466E-09  -1.72440280530304E-09  -3.12726841982247E-18
      4.34868742123038E-09
      0.00000000000000E+00   1.05070379365411E-13   0.00000000000000E+00  -1.04720730286828E-13  -4.80207296932650E-23
     -1.04973843016359E-10  -1.05078563746694E-10  -1.28101558645961E-18  -8.16989975922146E-03  -8.16989976099047E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76900860759841E-09   0.00000000000000E+00   1.76900860759841E-09
      4.44032659276773E-18  -4.32969635852733E-01  -4.32445365050547E-01   0.00000000000000E+00  -1.55201310735721E-10
     -1.66052937586972E-22  -1.50872873311584E-09  -1.66393004385173E-09  -3.15931100630812E-18
      4.36868742123039E-09
      0.00000000000000E+00   1.55860519041173E-13   0.00000000000000E+00  -1.32865075388740E-13  -4.80392880077246E-23
     -1.55757681301621E-10  -1.55890546377058E-10  -1.28300690713467E-18  -6.63720703154280E-03  -6.63720703329637E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75357194686320E-09   0.00000000000000E+00   1.75357194686320E-09
      4.47539803170499E-18  -4.54990689206536E-01  -4.54487290949902E-01   0.00000000000000E+00  -1.59295722354966E-10
     -1.70578721732726E-22  -1.43838567813104E-09  -1.59768140048617E-09  -3.19239112457033E-18
      4.38868742123039E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -5.09045911934483E-14  -4.80617119425115E-23
     -1.71981195002682E-10  -1.72032099593923E-10  -1.28533637491933E-18  -4.93198375023383E-03  -4.93198375192973E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69590366485472E-09   0.00000000000000E+00   1.69590366485472E-09
      4.50931610500209E-18  -4.75834705141263E-01  -4.75354561747227E-01   0.00000000000000E+00  -1.61946143050243E-10
     -1.75046708435544E-22  -1.36192542221043E-09  -1.52387156526085E-09  -3.22397973008276E-18
      4.40868742123039E-09
      0.00000000000000E+00   1.90302295493995E-13   0.00000000000000E+00  -5.93896380999584E-14  -4.80910462997248E-23
     -1.90211586316245E-10  -1.90270975954393E-10  -1.28804384348114E-18  -3.02364496768692E-03  -3.02364496934086E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65394199004887E-09   0.00000000000000E+00   1.65394199004887E-09
      4.54239494480307E-18  -4.95674609816939E-01  -4.95213433124139E-01   0.00000000000000E+00  -1.65420001076720E-10
     -1.79485692604906E-22  -1.29825101301752E-09  -1.46367101409442E-09  -3.25435110132192E-18
      4.42868742123039E-09
      0.00000000000000E+00  -4.34425606991602E-14   0.00000000000000E+00   6.01051338260203E-13  -4.80227111667424E-23
      4.28649034952013E-11   4.34659548334135E-11  -1.28610093310284E-18  -3.95240065988088E-03  -3.95240066109800E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21712699962062E-09   0.00000000000000E+00   1.21712699962062E-09
      4.56673748479548E-18  -5.14934164214996E-01  -5.14536975705158E-01   0.00000000000000E+00  -1.46054225650589E-10
     -1.83307566474853E-22  -1.11453872880332E-09  -1.26059295445409E-09  -3.28063655169264E-18
      4.44868742123039E-09
      0.00000000000000E+00  -1.91817733657920E-12   0.00000000000000E+00   4.94316448758741E-12  -4.71976936966929E-23
      1.91320856277860E-09   1.91815172726614E-09  -1.24686137020762E-18  -2.70882178341736E-02  -2.70882178323580E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.81559139024366E-09   0.00000000000000E+00  -1.81559139024366E-09
      4.53042565699061E-18  -5.35576563969482E-01  -5.35544278672581E-01   0.00000000000000E+00   2.68164381139753E-11
     -1.82600875316517E-22  -1.29376775136135E-10  -1.02560337022342E-10  -3.28356428678299E-18
      4.45868742123039E-09
      0.00000000000000E+00  -3.08754453070543E-12   0.00000000000000E+00   6.22780978670338E-12  -4.65725465674828E-23
      3.08131625524269E-09   3.08754406502935E-09  -1.21569618757225E-18  -4.50631451403919E-02  -4.50631451367312E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.66074507629444E-09   0.00000000000000E+00  -3.66074507629444E-09
      4.49381820622766E-18  -5.46203952294124E-01  -5.46384605156162E-01   0.00000000000000E+00   1.27835391044164E-10
     -1.80916296719896E-22   4.45365620220903E-10   5.73201011264886E-10  -3.27812201865541E-18
      4.46206242123039E-09
      0.00000000000000E+00  -3.57937309845173E-12   0.00000000000000E+00   7.66844088280992E-12  -4.63276409729611E-23
      3.57168037403293E-09   3.57934881491569E-09  -1.20354669988439E-18  -5.19716984733642E-02  -5.19716984689505E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.41360696223305E-09   0.00000000000000E+00  -4.41360696223305E-09
      4.47892228273013E-18  -5.49828209776236E-01  -5.50091123226408E-01   0.00000000000000E+00   1.64803463885870E-10
     -1.80178629888930E-22   6.69454683432322E-10   8.34258147318012E-10  -3.27537558284573E-18
      4.46661867123039E-09
      0.00000000000000E+00  -4.10591897686248E-12   0.00000000000000E+00   6.26107329801011E-12  -4.59676703612004E-23
      4.09965540107791E-09   4.10591647437588E-09  -1.18482224128239E-18  -6.24904796638283E-02  -6.24904796586145E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.21375952330922E-09   0.00000000000000E+00  -5.21375952330922E-09
      4.45516709090205E-18  -5.54789789144563E-01  -5.55138911374488E-01   0.00000000000000E+00   2.02488118080420E-10
     -1.78944824370112E-22   9.05354930853197E-10   1.10784304893344E-09  -3.27034484961966E-18
      4.47276960873039E-09
      0.00000000000000E+00  -4.79787722698399E-12   0.00000000000000E+00   6.13478129472673E-12  -4.54169425686341E-23
      4.79177596689005E-09   4.79791074818473E-09  -1.15552749154921E-18  -7.86577773652569E-02  -7.86577773590326E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.22423543511793E-09   0.00000000000000E+00  -6.22423543511793E-09
      4.41688220775536E-18  -5.61579297629636E-01  -5.62028777826322E-01   0.00000000000000E+00   2.46045975869843E-10
     -1.76897835515701E-22   1.18027871106367E-09   1.42632468693334E-09  -3.26135471620614E-18
      4.47692149154289E-09
      0.00000000000000E+00  -5.33443418175036E-12   0.00000000000000E+00   6.95872665663244E-12  -4.50087567916947E-23
      5.32748264917916E-09   5.33444137583575E-09  -1.13370616239294E-18  -9.04825526499659E-02  -9.04825526429963E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.96955235470001E-09   0.00000000000000E+00  -6.96955235470001E-09
      4.38794544312306E-18  -5.66190808319953E-01  -5.66706080411124E-01   0.00000000000000E+00   2.72698822682703E-10
     -1.75349793282779E-22   1.36241215618225E-09   1.63511097886478E-09  -3.25423928073011E-18
      4.47972401244132E-09
      0.00000000000000E+00  -5.69400632791783E-12   0.00000000000000E+00   6.92295096749484E-12  -4.47197772073435E-23
      5.68706406889907E-09   5.69398701986652E-09  -1.11808503185769E-18  -9.88324874462297E-02  -9.88324874387827E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.44703763906909E-09   0.00000000000000E+00  -7.44703763906909E-09
      4.36707496450811E-18  -5.69308431554707E-01  -5.69860869388760E-01   0.00000000000000E+00   2.87195195857568E-10
     -1.74240305331297E-22   1.46585542334462E-09   1.75305061920201E-09  -3.24898993265042E-18
      4.48350741565421E-09
      0.00000000000000E+00  -6.08416277157540E-12   0.00000000000000E+00   5.69395670441408E-12  -4.43155241783536E-23
      6.07847636266255E-09   6.08417031936692E-09  -1.09581545355869E-18  -1.10565068949609E-01  -1.10565068941689E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.92072097471799E-09   0.00000000000000E+00  -7.92072097471799E-09
      4.33710768332395E-18  -5.73502829243028E-01  -5.74081585505365E-01   0.00000000000000E+00   3.00128190653469E-10
     -1.72660924371969E-22   1.53642246469816E-09   1.83655065535146E-09  -3.24129222976526E-18
      4.48861500999162E-09
      0.00000000000000E+00  -6.52804838649938E-12   0.00000000000000E+00   4.86403848239887E-12  -4.37311098747938E-23
      6.52319809202627E-09   6.52806213050863E-09  -1.06432170082908E-18  -1.26831110535792E-01  -1.26831110527448E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34351506866667E-09   0.00000000000000E+00  -8.34351506866667E-09
      4.29449239300520E-18  -5.79076588274730E-01  -5.79648713706430E-01   0.00000000000000E+00   3.06187667991621E-10
     -1.70459288556962E-22   1.50926527016678E-09   1.81545293815823E-09  -3.23017069217612E-18
      4.49551026234711E-09
      0.00000000000000E+00  -7.13201937837608E-12   0.00000000000000E+00   4.84468593909094E-12  -4.27455041738590E-23
      7.12719055052339E-09   7.13203523646243E-09  -1.02035153161741E-18  -1.48939490936917E-01  -1.48939490928243E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67372986142227E-09   0.00000000000000E+00  -8.67372986142227E-09
      4.23468483674732E-18  -5.86297972533492E-01  -5.86783879844738E-01   0.00000000000000E+00   3.02892182768591E-10
     -1.67472308315260E-22   1.23880244219126E-09   1.54169462495969E-09  -3.21433330512991E-18
      4.50481885302702E-09
      0.00000000000000E+00  -8.33215455946683E-12   0.00000000000000E+00   6.80401807988311E-12  -4.01450324321093E-23
      8.32538127655684E-09   8.33218529463668E-09  -9.60058620462421E-19  -1.78210765174404E-01  -1.78210765165489E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91466788619369E-09   0.00000000000000E+00  -8.91466788619369E-09
      4.15170184234735E-18  -5.95031225155746E-01  -5.95215006784787E-01   0.00000000000000E+00   2.91561284225895E-10
     -1.63508303488936E-22   2.90921307331170E-10   5.82482591556902E-10  -3.19164322188493E-18
      4.51738545044491E-09
      0.00000000000000E+00  -1.17339917808964E-11   0.00000000000000E+00   1.36908466392825E-11  -2.90124085095922E-23
      1.17203006973894E-08   1.17339915440287E-08  -8.80136292353465E-19  -2.15369998453116E-01  -2.15369998443973E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14333326115941E-09   0.00000000000000E+00  -9.14333326115941E-09
      4.03680125419679E-18  -6.02947160981827E-01  -6.02131459195499E-01   0.00000000000000E+00   2.80846557116178E-10
     -1.58184162728238E-22  -2.87150483998522E-09  -2.59065828286920E-09  -3.15666496184333E-18
      4.53435035695906E-09
      0.00000000000000E+00  -2.20689126799106E-11   0.00000000000000E+00   3.02786891284446E-11   1.83591813399995E-23
      2.20386684681864E-08   2.20689471573148E-08  -7.83376947795654E-19  -2.58417292938430E-01  -2.58417292928886E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54396095482527E-09   0.00000000000000E+00  -9.54396095482527E-09
      3.87488884882352E-18  -5.98373526384399E-01  -5.94428535476230E-01   0.00000000000000E+00   2.91846600985529E-10
     -1.50220876470025E-22  -1.28168328034751E-08  -1.25249862024897E-08  -3.09151190102786E-18
      4.55435035695906E-09
      0.00000000000000E+00  -4.15141885967509E-11   0.00000000000000E+00   4.81988145788591E-11   1.11328656323118E-22
      4.14659441404423E-08   4.15141429550213E-08  -6.96685177279035E-19  -2.96304126006186E-01  -2.96304125995988E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01975766239667E-08   0.00000000000000E+00  -1.01975766239667E-08
      3.67093731634418E-18  -5.58981256342581E-01  -5.49116428798087E-01   0.00000000000000E+00   3.18483724296947E-10
     -1.38297595912474E-22  -3.16350500553514E-08  -3.13165663310546E-08  -2.97425213906515E-18
      4.57435035695906E-09
      0.00000000000000E+00  -5.94837951208779E-11   0.00000000000000E+00   4.46640667266319E-11   1.96187033197896E-22
      5.94391004027714E-08   5.94837644694982E-08  -6.40001971888743E-19  -3.21903947796854E-01  -3.21903947786009E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08449465813847E-08   0.00000000000000E+00  -1.08449465813847E-08
      3.45403838471649E-18  -4.83122681379701E-01  -4.67800168182568E-01   0.00000000000000E+00   3.05119568669011E-10
     -1.23089655712944E-22  -4.89439374567824E-08  -4.86388178881135E-08  -2.81403641282775E-18
      4.59435035695906E-09
      0.00000000000000E+00  -6.60924831866455E-11   0.00000000000000E+00   1.65354059052662E-11   2.26949184601775E-22
      6.60759835787695E-08   6.60925189846750E-08  -6.09793304768049E-19  -3.37182380279668E-01  -3.37182380268258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14099909046097E-08   0.00000000000000E+00  -1.14099909046097E-08
      3.22583856662430E-18  -3.75388804838973E-01  -3.58161466216375E-01   0.00000000000000E+00   2.60012047162650E-10
     -1.06649709778472E-22  -5.49425401272279E-08  -5.46825280800653E-08  -2.61604526185625E-18
      4.61435035695906E-09
      0.00000000000000E+00  -5.92499584199476E-11   0.00000000000000E+00  -1.69145775378395E-11   1.96998780477098E-22
      5.92668899191609E-08   5.92499753416233E-08  -6.00035381840354E-19  -3.44593605433678E-01  -3.44593605421809E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18694605247145E-08   0.00000000000000E+00  -1.18694605247145E-08
      2.98844935613001E-18  -2.50158528706871E-01  -2.35231129274038E-01   0.00000000000000E+00   1.96168118749000E-10
     -8.99675653569483E-23  -4.75766829356576E-08  -4.73805148169087E-08  -2.38841397428965E-18
      4.63435035695906E-09
      0.00000000000000E+00  -5.12041757510938E-11   0.00000000000000E+00  -1.99580898251234E-11   1.55123274746090E-22
      5.12241525251819E-08   5.12041944353570E-08  -5.92416529305779E-19  -3.51260511294840E-01  -3.51260511282954E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18863424215033E-08   0.00000000000000E+00  -1.18863424215033E-08
      2.75072250769994E-18  -1.41420945614013E-01  -1.29033450544829E-01   0.00000000000000E+00   1.09864591668645E-10
     -7.74367291964435E-23  -3.94277166055223E-08  -3.93178520138537E-08  -2.15830597839416E-18
      4.64435035695906E-09
      0.00000000000000E+00  -4.70335980792372E-11   0.00000000000000E+00  -2.05903829421793E-11   1.33506232783555E-22
      4.70543013722589E-08   4.70337109893169E-08  -5.87818015638934E-19  -3.54890434939192E-01  -3.54890434927368E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18241586379828E-08   0.00000000000000E+00  -1.18241586379828E-08
      2.63248092132011E-18  -9.49715724601206E-02  -8.38783830503172E-02   0.00000000000000E+00   7.30105744628167E-11
     -5.07054454349370E-23  -3.52825629257968E-08  -3.52095523513340E-08  -2.04466290568118E-18
      4.65110035695906E-09
      0.00000000000000E+00  -4.39483496669620E-11   0.00000000000000E+00  -2.26248299004340E-11   1.22719580206997E-22
      4.39709629771815E-08   4.39483381472812E-08  -5.82296059634658E-19  -3.58178489786963E-01  -3.58178489775311E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16519960759493E-08   0.00000000000000E+00  -1.16519960759493E-08
      2.55382994780745E-18  -6.91500285434212E-02  -5.89746196435477E-02   0.00000000000000E+00   5.84966777333649E-11
     -4.80872918235542E-23  -3.23548387490653E-08  -3.22963420713319E-08  -1.97153388817280E-18
      4.66021285695906E-09
      0.00000000000000E+00  -3.97993555083492E-11   0.00000000000000E+00  -2.25160321807627E-11   1.17625519755655E-22
      3.98218100559838E-08   3.97992940238031E-08  -5.67051701971090E-19  -3.65265030976472E-01  -3.65265030965241E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12307800215862E-08   0.00000000000000E+00  -1.12307800215862E-08
      2.45148946486075E-18  -4.55590072492464E-02  -3.65580727839901E-02   0.00000000000000E+00   4.47023213576499E-11
      3.17287332800712E-25  -2.86132163235747E-08  -2.85685140022170E-08  -1.88443776288966E-18
      4.66328832570906E-09
      0.00000000000000E+00  -3.79651242615777E-11   0.00000000000000E+00  -2.93765681802849E-11   1.17104553648449E-22
      3.79944581716927E-08   3.79650816035125E-08  -5.60628715876002E-19  -3.68055244575648E-01  -3.68055244564596E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10520308942028E-08   0.00000000000000E+00  -1.10520308942028E-08
      2.41749928922160E-18  -3.92729427773360E-02  -3.07935782413289E-02   0.00000000000000E+00   4.54084464176934E-11
      2.15995728217964E-23  -2.69584591557268E-08  -2.69130507093091E-08  -1.85687057334560E-18
      4.66744020852156E-09
      0.00000000000000E+00  -3.60540189697635E-11   0.00000000000000E+00  -2.28110756936022E-11   1.18946621373887E-22
      3.60767820538520E-08   3.60539709781585E-08  -5.50110623526129E-19  -3.72462335694899E-01  -3.72462335684086E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08124949034683E-08   0.00000000000000E+00  -1.08124949034683E-08
      2.37260707747164E-18  -3.31745869451912E-02  -2.52218671461335E-02   0.00000000000000E+00   3.51931860860167E-11
      4.85316937821591E-23  -2.52766692607760E-08  -2.52414760746900E-08  -1.82249645394551E-18
      4.67304525031843E-09
      0.00000000000000E+00  -3.43178779023296E-11   0.00000000000000E+00  -1.53348573972746E-11   1.24319960883638E-22
      3.43332261608093E-08   3.43178913034122E-08  -5.33959875181403E-19  -3.79088165678901E-01  -3.79088165668323E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05788692926495E-08   0.00000000000000E+00  -1.05788692926495E-08
      2.31331207292266E-18  -2.77492855842655E-02  -2.02699270854642E-02   0.00000000000000E+00   2.54140198991525E-11
      8.04216699913507E-23  -2.37644360306618E-08  -2.37390220107626E-08  -1.77935219774126E-18
      4.68061205674421E-09
      0.00000000000000E+00  -3.29197254678194E-11   0.00000000000000E+00  -9.12176165203758E-12   1.33010149114891E-22
      3.29288013596530E-08   3.29196795980011E-08  -5.10726549940876E-19  -3.88521299271505E-01  -3.88521299261116E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03884342213845E-08   0.00000000000000E+00  -1.03884342213845E-08
      2.23470480210248E-18  -2.32289822092243E-02  -1.61301433504955E-02   0.00000000000000E+00   1.75668750083371E-11
      1.16166058579207E-22  -2.25488122516251E-08  -2.25312453766167E-08  -1.72397825216161E-18
      4.69082724541902E-09
      0.00000000000000E+00  -3.18310897976986E-11   0.00000000000000E+00  -5.23187777056434E-12   1.42142340812417E-22
      3.18363098704390E-08   3.18310779926686E-08  -4.79119780552071E-19  -4.01327616919731E-01  -4.01327616909489E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02424063924169E-08   0.00000000000000E+00  -1.02424063924169E-08
      2.13007668831992E-18  -1.95615120116287E-02  -1.27596375603399E-02   0.00000000000000E+00   1.23165826686095E-11
      1.51552975657567E-22  -2.16009881829204E-08  -2.15886716002517E-08  -1.65095690776785E-18
      4.70461775013001E-09
      0.00000000000000E+00  -3.08487184885269E-11   0.00000000000000E+00  -3.47693425512954E-12   1.44834554840992E-22
      3.08521805471614E-08   3.08487036129065E-08  -4.37958168222653E-19  -4.18097999136939E-01  -4.18097999126827E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01124368475507E-08   0.00000000000000E+00  -1.01124368475507E-08
      1.99062108033422E-18  -1.65604039408226E-02  -1.00270857456466E-02   0.00000000000000E+00   9.28629195051844E-12
      1.76188211209259E-22  -2.07455530573065E-08  -2.07362667653558E-08  -1.55266291211157E-18
      4.72323493148984E-09
      0.00000000000000E+00  -2.96849538233703E-11   0.00000000000000E+00  -3.04698514515292E-12   1.30740913550798E-22
      2.96880489507616E-08   2.96850019656165E-08  -3.86066268767628E-19  -4.39510747955496E-01  -4.39510747945535E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96054660537059E-09   0.00000000000000E+00  -9.96054660537059E-09
      1.80518377773898E-18  -1.40252721391143E-02  -7.81073494887052E-03   0.00000000000000E+00   7.67215935991818E-12
      1.72533968284868E-22  -1.97321275196059E-08  -1.97244553602458E-08  -1.41911750897135E-18
      4.74323493148984E-09
      0.00000000000000E+00  -2.84779302869890E-11   0.00000000000000E+00  -2.94579703374504E-12   1.01469718120877E-22
      2.84808976625701E-08   2.84779518655365E-08  -3.34452221353114E-19  -4.61158168008542E-01  -4.61158167998731E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81105983314685E-09   0.00000000000000E+00  -9.81105983314685E-09
      1.60896258107604E-18  -1.22077436202217E-02  -6.32640441113434E-03   0.00000000000000E+00   6.67345820910873E-12
      1.37984032513841E-22  -1.86735654905989E-08  -1.86668920323897E-08  -1.27451035972293E-18
      4.76323493148984E-09
      0.00000000000000E+00  -2.74796698382804E-11   0.00000000000000E+00  -2.43544687861102E-12   6.89381208681558E-23
      2.74821206047766E-08   2.74796851578981E-08  -2.86299908023710E-19  -4.81702276129527E-01  -4.81702276119846E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68127274049106E-09   0.00000000000000E+00  -9.68127274049106E-09
      1.41533712626622E-18  -1.09720689069299E-02  -5.36435502581641E-03   0.00000000000000E+00   5.56620855893347E-12
      9.25918268979462E-23  -1.78039786259661E-08  -1.77984124174071E-08  -1.12903721824251E-18
      4.78323493148984E-09
      0.00000000000000E+00  -2.66362596165037E-11   0.00000000000000E+00  -2.05629519478647E-12   4.17555345759986E-23
      2.66382868493607E-08   2.66362305541659E-08  -2.41296412455931E-19  -5.01243987797691E-01  -5.01243987788164E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52711012001157E-09   0.00000000000000E+00  -9.52711012001157E-09
      1.22479492386599E-18  -1.00935404563327E-02  -4.70299670825363E-03   0.00000000000000E+00   4.64844405299738E-12
      5.26817882848461E-23  -1.71137688782074E-08  -1.71091204341543E-08  -9.83498511410063E-19
      4.80323493148984E-09
      0.00000000000000E+00  -2.64708472447929E-11   0.00000000000000E+00  -3.85887712145701E-13   2.34852299700527E-23
      2.64712299980252E-08   2.64708441103131E-08  -1.97156615301091E-19  -5.20819109163346E-01  -5.20819109153528E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81814811214363E-09   0.00000000000000E+00  -9.81814811214363E-09
      1.02843196162312E-18  -9.52817329565885E-03  -4.28143117776855E-03   0.00000000000000E+00   3.81821087504742E-12
      2.53708853346006E-23  -1.66565142090445E-08  -1.66526959981694E-08  -8.31275346322028E-19
      4.82323493148984E-09
      0.00000000000000E+00  -2.73884680142333E-11   0.00000000000000E+00   2.28766256442974E-12   1.32313196409487E-23
      2.73861906180161E-08   2.73884782805805E-08  -1.51223604823319E-19  -5.41725103958234E-01  -5.41725103947460E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07739596362003E-08   0.00000000000000E+00  -1.07739596362003E-08
      8.12952768899115E-19  -9.31305638642323E-03  -4.07833982973038E-03   0.00000000000000E+00   2.72160852687178E-12
      9.97187082583464E-24  -1.66172402529072E-08  -1.66145186443803E-08  -6.61729164075795E-19
      4.84323493148984E-09
      0.00000000000000E+00  -2.83628488312680E-11   0.00000000000000E+00   2.43342785488717E-12   8.15573836395465E-24
      2.83604320616685E-08   2.83628654895234E-08  -1.05060136664962E-19  -5.63301901467324E-01  -5.63301901455844E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14799589887183E-08   0.00000000000000E+00  -1.14799589887183E-08
      5.83353589124749E-19  -9.27059006401202E-03  -3.95131032685474E-03   0.00000000000000E+00   1.84079633706808E-12
      2.57762357039309E-24  -1.68847472971423E-08  -1.68829065008052E-08  -4.78293452459788E-19
      4.84573493148984E-09
      0.00000000000000E+00  -2.86428834350137E-11   0.00000000000000E+00   5.50027776468499E-12   7.57233883352841E-24
      2.86373543982720E-08   2.86428546760366E-08  -9.93563718917714E-20  -5.66018272186671E-01  -5.66018272174969E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17021670742789E-08   0.00000000000000E+00  -1.17021670742789E-08
      5.54098171439052E-19  -9.29244578616001E-03  -3.95496048100740E-03   0.00000000000000E+00   1.27353938054305E-12
      1.66631874830984E-24  -1.69419611411381E-08  -1.69406876017576E-08  -4.54741799547280E-19
      4.84910993148984E-09
      0.00000000000000E+00  -2.90250493865342E-11   0.00000000000000E+00   5.62099619499575E-12   6.94736016906162E-24
      2.90194035057221E-08   2.90250245019171E-08  -9.15911758266424E-20  -5.69731064800571E-01  -5.69731064788675E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18962050948294E-08   0.00000000000000E+00  -1.18962050948294E-08
      5.13948479244002E-19  -9.36528454654275E-03  -3.96852377715267E-03   0.00000000000000E+00  -3.26426983949650E-13
      7.09398854530634E-25  -1.71284929801033E-08  -1.71288194070872E-08  -4.22357303417359E-19
      4.85366618148984E-09
      0.00000000000000E+00  -2.93676302563183E-11   0.00000000000000E+00   3.76210912157646E-12   6.32629889669914E-24
      2.93638476562337E-08   2.93676097653553E-08  -8.11435363796013E-20  -5.74743414270150E-01  -5.74743414258151E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19993486202705E-08   0.00000000000000E+00  -1.19993486202705E-08
      4.59276447092895E-19  -9.44254472025160E-03  -3.97034278009172E-03   0.00000000000000E+00  -2.17340867635186E-13
     -1.89806555272287E-25  -1.73680438042173E-08  -1.73682611450850E-08  -3.78132910713294E-19
      4.85981711898984E-09
      0.00000000000000E+00  -2.94716903435744E-11   0.00000000000000E+00   8.83731620206575E-13   5.72384747116359E-24
      2.94708379609433E-08   2.94717216925635E-08  -6.73766132345418E-20  -5.81376135355856E-01  -5.81376135343952E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19038883318946E-08   0.00000000000000E+00  -1.19038883318946E-08
      3.86056373956432E-19  -9.46869129927983E-03  -3.93360994405754E-03   0.00000000000000E+00   6.94326995315295E-13
     -9.48829375102126E-25  -1.75685276876643E-08  -1.75678333606690E-08  -3.18679760721891E-19
      4.86812088461484E-09
      0.00000000000000E+00  -2.90400200786991E-11   0.00000000000000E+00  -2.52809965765770E-12   5.12536192689152E-24
      2.90425438159146E-08   2.90400157162569E-08  -4.99926826867173E-20  -5.89796935394310E-01  -5.89796935382948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13626997092494E-08   0.00000000000000E+00  -1.13626997092494E-08
      2.91703178703570E-19  -9.39858404511834E-03  -3.82900743590601E-03   0.00000000000000E+00   1.47689198866994E-12
     -1.52150772173083E-24  -1.76787928989961E-08  -1.76773160070074E-08  -2.41710496016851E-19
      4.87933096820859E-09
      0.00000000000000E+00  -2.72714578190309E-11   0.00000000000000E+00  -7.75773785799040E-12   4.43385196754295E-24
      2.72792103108002E-08   2.72714525729422E-08  -3.07086202567839E-20  -5.99165477992230E-01  -5.99165477982661E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56841804170277E-09   0.00000000000000E+00  -9.56841804170277E-09
      1.84440412596136E-19  -9.17318493195520E-03  -3.59550417275480E-03   0.00000000000000E+00   1.62057958718463E-12
     -1.92073116208395E-24  -1.77046551108267E-08  -1.77030345312395E-08  -1.53731792339351E-19
      4.89446458106015E-09
      0.00000000000000E+00  -2.13413186717525E-11   0.00000000000000E+00  -1.93145734846758E-11   3.28575733488135E-24
      2.13606989007628E-08   2.13413843272781E-08  -2.12030407386682E-20  -6.03535962105876E-01  -6.03535962102227E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64894720433990E-09   0.00000000000000E+00  -3.64894720433990E-09
      1.29218658289865E-19  -8.59997674897265E-03  -3.02563337604850E-03   0.00000000000000E+00   6.90952795651762E-13
     -2.24300382538694E-24  -1.76931280757339E-08  -1.76924371229383E-08  -1.08015617551197E-19
      4.91446458106015E-09
      0.00000000000000E+00  -5.68032146207391E-12   0.00000000000000E+00  -3.86086784502670E-11   7.87132989059938E-25
      5.71893710541608E-09   5.68032842696581E-09  -6.57076638271475E-20  -5.80851449810713E-01  -5.80851449822721E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20088778424848E-08   0.00000000000000E+00   1.20088778424848E-08
      3.69396215139561E-19  -7.27237432345985E-03  -1.69904670234708E-03   0.00000000000000E+00  -2.13134640778028E-12
     -2.93865478027776E-24  -1.76870749230428E-08  -1.76892062694506E-08  -3.03688551312414E-19
      4.93446458106015E-09
      0.00000000000000E+00   1.31131323548046E-11   0.00000000000000E+00  -4.60137855384310E-11  -3.86226921676543E-24
     -1.30667502059163E-08  -1.31127639914547E-08  -1.91526895049326E-19  -5.21271425060497E-01  -5.21271425091278E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07815222939383E-08   0.00000000000000E+00   3.07815222939383E-08
      9.85026661018328E-19  -5.57344361363121E-03  -6.67001791079336E-06   0.00000000000000E+00  -6.92022562235063E-12
     -6.44659279588679E-24  -1.76618380768612E-08  -1.76687583024836E-08  -7.93499765969001E-19
      4.95446458106015E-09
      0.00000000000000E+00   2.43655821785220E-11   0.00000000000000E+00  -2.79540666133901E-11  -1.81095495231593E-23
     -2.43376412467411E-08  -2.43655953133545E-08  -4.13109165831038E-19  -4.27466172198070E-01  -4.27466172240050E-01
      0.00000000000000E+00   0.00000000000000E+00   4.19802588346338E-08   0.00000000000000E+00   4.19802588346338E-08
      1.82463183771100E-18  -3.86040298044782E-03   1.68942345685142E-03   0.00000000000000E+00  -1.44196887204118E-11
     -2.92567312553403E-23  -1.76002438325590E-08  -1.76146635212794E-08  -1.41152267187997E-18
      4.97446458106015E-09
      0.00000000000000E+00   2.10043403309381E-11   0.00000000000000E+00   7.84115342602397E-12  -3.94749258756860E-23
     -2.10121429166038E-08  -2.10043017631778E-08  -7.14718714510376E-19  -3.06404192773479E-01  -3.06404192812125E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86463266792890E-08   0.00000000000000E+00   3.86463266792890E-08
      2.59755837129678E-18  -1.62665893171629E-03   3.93178137862214E-03   0.00000000000000E+00  -3.36953316075269E-11
     -7.17945673157105E-23  -1.76083295845037E-08  -1.76420249161113E-08  -1.88283965678641E-18
      4.99446458106015E-09
      0.00000000000000E+00   1.31754030866313E-11   0.00000000000000E+00   1.86269487499636E-11  -4.39124074425246E-23
     -1.31939873925907E-08  -1.31753604438408E-08  -9.72213914653272E-19  -1.87602560634988E-01  -1.87602560663400E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84124981357703E-08   0.00000000000000E+00   2.84124981357703E-08
      3.16580833401219E-18  -1.59706906992383E-02  -1.11699673813627E-02   0.00000000000000E+00  -6.80088715418194E-11
     -8.50616767564357E-23  -1.51691288203876E-08  -1.52371376919295E-08  -2.19359441935892E-18
      5.01446458106015E-09
      0.00000000000000E+00   8.83674954568498E-12   0.00000000000000E+00   9.87771771785764E-12  -4.65048100665707E-23
     -8.84663889330885E-09  -8.83676117559103E-09  -1.14760312246352E-18  -9.34470530821948E-02  -9.34470531030295E-02
      0.00000000000000E+00   0.00000000000000E+00   2.08347325948177E-08   0.00000000000000E+00   2.08347325948177E-08
      3.58250298590854E-18  -5.07159438693116E-02  -4.69357770805853E-02   0.00000000000000E+00  -1.24124359296382E-10
     -9.82116457842052E-23  -1.18738470599302E-08  -1.19979714192266E-08  -2.43489986344503E-18
      5.02446458106015E-09
      0.00000000000000E+00   6.05321109513647E-12   0.00000000000000E+00   1.28994703593912E-11  -4.73631077422224E-23
     -6.06613708135071E-09  -6.05323761099137E-09  -1.20743509566516E-18  -5.84811012071334E-02  -5.84811012230310E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58975736471247E-08   0.00000000000000E+00   1.58975736471247E-08
      3.74147872237979E-18  -7.43563587393053E-02  -7.12547103378843E-02   0.00000000000000E+00  -1.66884048756712E-10
     -1.04676247920818E-22  -9.67745198737637E-09  -9.84433603613319E-09  -2.53404362671463E-18
      5.02783958106015E-09
      0.00000000000000E+00   4.79126440590505E-12   0.00000000000000E+00   1.76504810481657E-11  -4.75629812919988E-23
     -4.80890576636324E-09  -4.79125528531512E-09  -1.22336414557039E-18  -4.89035623854725E-02  -4.89035623991782E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37056181811478E-08   0.00000000000000E+00   1.37056181811478E-08
      3.78773518374117E-18  -8.32071355967978E-02  -8.03984808676200E-02   0.00000000000000E+00  -1.79330914309932E-10
     -1.06807159995026E-22  -8.73503198152299E-09  -8.91436289583303E-09  -2.56437103817078E-18
      5.03239583106015E-09
      0.00000000000000E+00   3.43030908996392E-12   0.00000000000000E+00   1.42319960695537E-11  -4.77470792745447E-23
     -3.44450663437883E-09  -3.43027463830932E-09  -1.23866190684277E-18  -3.95011898481094E-02  -3.95011898594811E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13716779088943E-08   0.00000000000000E+00   1.13716779088943E-08
      3.83954739121356E-18  -9.63083426680651E-02  -9.38062370862325E-02   0.00000000000000E+00  -1.78793959005997E-10
     -1.09494119692549E-22  -7.76260931157844E-09  -7.94140327058454E-09  -2.60088548437079E-18
      5.03854676856015E-09
      0.00000000000000E+00   2.16726026388601E-12   0.00000000000000E+00   9.81823740140907E-12  -4.78909037867610E-23
     -2.17706427803999E-09  -2.16724604063863E-09  -1.25154306682072E-18  -3.13234801203643E-02  -3.13234801295057E-02
      0.00000000000000E+00   0.00000000000000E+00   9.14143195967937E-09   0.00000000000000E+00   9.14143195967937E-09
      3.89577576785805E-18  -1.15249955086325E-01  -1.13052590024028E-01   0.00000000000000E+00  -1.77974047879568E-10
     -1.12859447877841E-22  -6.79621187116112E-09  -6.97418591904080E-09  -2.64423270103734E-18
      5.04685053418515E-09
      0.00000000000000E+00   1.21740199168577E-12   0.00000000000000E+00   5.47968634207081E-12  -4.79892391344638E-23
     -1.22289520770463E-09  -1.21741552136260E-09  -1.26105070313378E-18  -2.49469226803425E-02  -2.49469226876805E-02
      0.00000000000000E+00   0.00000000000000E+00   7.33793458981986E-09   0.00000000000000E+00   7.33793458981986E-09
      3.95670825686350E-18  -1.41649985625915E-01  -1.39721584350253E-01   0.00000000000000E+00  -1.80913254929581E-10
     -1.17123455641371E-22  -5.93960581352756E-09  -6.12051906845725E-09  -2.69565755372972E-18
      5.05806061777890E-09
      0.00000000000000E+00   6.40249663073669E-13   0.00000000000000E+00   2.46538790010518E-12  -4.80504057045560E-23
     -6.42675316053124E-10  -6.40209928153067E-10  -1.26743308805064E-18  -2.02374382534731E-02  -2.02374382595042E-02
      0.00000000000000E+00   0.00000000000000E+00   6.03110423792364E-09   0.00000000000000E+00   6.03110423792364E-09
      4.02431743953324E-18  -1.76863342953803E-01  -1.75164822994741E-01   0.00000000000000E+00  -1.88824546682842E-10
     -1.22607264763311E-22  -5.20206976308754E-09  -5.39089430977050E-09  -2.75688435148261E-18
      5.07319423063047E-09
      0.00000000000000E+00   3.41662422412000E-13   0.00000000000000E+00   9.43434244575990E-13  -4.80848816059789E-23
     -3.42604661872544E-10  -3.41661227628016E-10  -1.27156533801931E-18  -1.67145140529502E-02  -1.67145140579351E-02
      0.00000000000000E+00   0.00000000000000E+00   4.98487197297683E-09   0.00000000000000E+00   4.98487197297683E-09
      4.09975656208688E-18  -2.21048363523670E-01  -2.19585414096877E-01   0.00000000000000E+00  -1.97169703491028E-10
     -1.29559700529815E-22  -4.44604104185770E-09  -4.64321074534886E-09  -2.82819122406757E-18
      5.09319423063047E-09
      0.00000000000000E+00   2.09406000833161E-13   0.00000000000000E+00   3.16243339326333E-13  -4.81031013572489E-23
     -2.09750084604948E-10  -2.09433841265670E-10  -1.27443015393433E-18  -1.39669269797007E-02  -1.39669269835525E-02
      0.00000000000000E+00   0.00000000000000E+00   3.85179442252185E-09   0.00000000000000E+00   3.85179442252185E-09
      4.17679245053732E-18  -2.68982247479288E-01  -2.67834634479505E-01   0.00000000000000E+00  -1.88303410590469E-10
     -1.37387778762442E-22  -3.45405717066559E-09  -3.64236058125620E-09  -2.90236229660299E-18
      5.11319423063047E-09
      0.00000000000000E+00   1.62105961171285E-13   0.00000000000000E+00   1.13717885728258E-13  -4.81115926171436E-23
     -1.62200886649594E-10  -1.62087168763914E-10  -1.27638236072520E-18  -1.21600689009450E-02  -1.21600689037060E-02
      0.00000000000000E+00   0.00000000000000E+00   2.76107506120102E-09   0.00000000000000E+00   2.76107506120102E-09
      4.23201395176134E-18  -3.03659559497326E-01  -3.02840682558175E-01   0.00000000000000E+00  -1.55510531545926E-10
     -1.43275410308122E-22  -2.44347736089102E-09  -2.59898789243709E-09  -2.95563159103614E-18
      5.13319423063047E-09
      0.00000000000000E+00   1.39236621606611E-13   0.00000000000000E+00   5.63719173937938E-14  -4.81144910548433E-23
     -1.39305902342022E-10  -1.39249530424676E-10  -1.27790135329779E-18  -1.09379081012039E-02  -1.09379081030883E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88435313224887E-09   0.00000000000000E+00   1.88435313224887E-09
      4.26970101440631E-18  -3.26565743456019E-01  -3.26015905290689E-01   0.00000000000000E+00  -1.11299083579797E-10
     -1.47243816566578E-22  -1.63380451824419E-09  -1.74510360182413E-09  -2.99179966110852E-18
      5.15319423063047E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   2.15509822460965E-14  -4.81159705121672E-23
     -1.30908212744393E-10  -1.30886661762195E-10  -1.27926822816072E-18  -1.00678381574487E-02  -1.00678381586384E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18965776960066E-09   0.00000000000000E+00   1.18965776960066E-09
      4.29349416979833E-18  -3.39483159270753E-01  -3.39149571687480E-01   0.00000000000000E+00  -6.45298786821332E-11
     -1.49472068355860E-22  -9.94241229156269E-10  -1.05877110783855E-09  -3.01422594163761E-18
      5.17319423063047E-09
      0.00000000000000E+00   1.17010195202389E-13   0.00000000000000E+00   3.69976968301141E-14  -4.81126495698940E-23
     -1.17033622936194E-10  -1.16996625239412E-10  -1.28036769433462E-18  -9.51818600782824E-03  -9.51818600857085E-03
      0.00000000000000E+00   0.00000000000000E+00   7.42603532354370E-10   0.00000000000000E+00   7.42603532354370E-10
      4.30834624044541E-18  -3.46117316969046E-01  -3.45920212490788E-01   0.00000000000000E+00  -3.15220727705863E-11
     -1.50546918794303E-22  -5.94084834344239E-10  -6.25606907114976E-10  -3.02797854611080E-18
      5.18319423063047E-09
      0.00000000000000E+00   9.69880424911483E-14   0.00000000000000E+00   1.04394982944004E-13  -4.81066935804359E-23
     -9.70935722603144E-11  -9.69891772774185E-11  -1.28071985061333E-18  -9.37837017194680E-03  -9.37837017256824E-03
      0.00000000000000E+00   0.00000000000000E+00   6.21431696330322E-10   0.00000000000000E+00   6.21431696330322E-10
      4.31456055740872E-18  -3.48822629552409E-01  -3.48657400229141E-01   0.00000000000000E+00  -2.41262696630079E-11
     -1.50952795493272E-22  -5.00316249389764E-10  -5.24442519052923E-10  -3.03384070679539E-18
      5.18994423063047E-09
      0.00000000000000E+00   8.22928845379440E-14   0.00000000000000E+00   1.15840992703692E-13  -4.81008933467088E-23
     -8.24001468308554E-11  -8.22843058381998E-11  -1.28085955527469E-18  -9.33537344143856E-03  -9.33537344208409E-03
      0.00000000000000E+00   0.00000000000000E+00   6.45528472606894E-10   0.00000000000000E+00   6.45528472606894E-10
      4.31891787459882E-18  -3.50942503354523E-01  -3.50765047770914E-01   0.00000000000000E+00  -2.84974183777560E-11
     -1.51270633248125E-22  -5.34746748390843E-10  -5.63244166768750E-10  -3.03805831932413E-18
      5.19450048063047E-09
      0.00000000000000E+00   7.62311318822472E-14   0.00000000000000E+00   7.56736343347686E-14  -4.80967638966036E-23
     -7.62832873353685E-11  -7.62076137010818E-11  -1.28092678125951E-18  -9.31734214963746E-03  -9.31734215032206E-03
      0.00000000000000E+00   0.00000000000000E+00   6.84594290452940E-10   0.00000000000000E+00   6.84594290452940E-10
      4.32203705733469E-18  -3.52553253420223E-01  -3.52361573883135E-01   0.00000000000000E+00  -3.28058209375810E-11
     -1.51515903256684E-22  -5.75580855814111E-10  -6.08386676751843E-10  -3.04111027607518E-18
      5.20065141813047E-09
      0.00000000000000E+00   6.57608318405892E-14   0.00000000000000E+00   9.44022067277514E-14  -4.80899596053097E-23
     -6.58938256512230E-11  -6.57994234445434E-11  -1.28095480167369E-18  -9.31452038162961E-03  -9.31452038242095E-03
      0.00000000000000E+00   0.00000000000000E+00   7.91334467763953E-10   0.00000000000000E+00   7.91334467763953E-10
      4.32690450618750E-18  -3.55335586312660E-01  -3.55106994626547E-01   0.00000000000000E+00  -4.36907155747369E-11
     -1.51952974025198E-22  -6.81844328744260E-10  -7.25535044319149E-10  -3.04594970451381E-18
      5.20895518375547E-09
      0.00000000000000E+00   4.81266422967440E-14   0.00000000000000E+00   1.18861188420279E-13  -4.80780680279489E-23
     -4.82273736966944E-11  -4.81085125083222E-11  -1.28084869224006E-18  -9.35281863615550E-03  -9.35281863717446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01896030357077E-09   0.00000000000000E+00   1.01896030357077E-09
      4.33536571372953E-18  -3.60770479468058E-01  -3.60464591375250E-01   0.00000000000000E+00  -6.63669388805181E-11
     -1.52840092786226E-22  -9.04484852181905E-10  -9.70851791062576E-10  -3.05451702148948E-18
      5.21456022555234E-09
      0.00000000000000E+00   2.88392474831634E-14   0.00000000000000E+00   1.85881002580037E-13  -4.80677239414046E-23
     -2.90432037259406E-11  -2.88573227234086E-11  -1.28067079993632E-18  -9.41412824947502E-03  -9.41412825071161E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23659493710111E-09   0.00000000000000E+00   1.23659493710111E-09
      4.34229688003779E-18  -3.65552183714894E-01  -3.65171655330153E-01   0.00000000000000E+00  -8.92571467335712E-11
     -1.53637028796795E-22  -1.11848046764395E-09  -1.20773761437768E-09  -3.06162608010147E-18
      5.21834362876523E-09
      0.00000000000000E+00   1.91955500763731E-14   0.00000000000000E+00   1.45538952043313E-13  -4.80603412154638E-23
     -1.93108161600910E-11  -1.91652772080958E-11  -1.28051488760587E-18  -9.46261081445487E-03  -9.46261081585748E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40260583999169E-09   0.00000000000000E+00   1.40260583999169E-09
      4.34760350347923E-18  -3.69323322261391E-01  -3.68887431586460E-01   0.00000000000000E+00  -1.06623795924859E-10
     -1.54275245958775E-22  -1.27681676685844E-09  -1.38344056278345E-09  -3.06708861587336E-18
      5.22345122310264E-09
      0.00000000000000E+00   2.14916685065613E-14   0.00000000000000E+00  -3.20639059235436E-15  -4.80516343911691E-23
     -2.15208816781739E-11  -2.15240880688143E-11  -1.28031810197914E-18  -9.49933062954058E-03  -9.49933063112839E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58780835787548E-09   0.00000000000000E+00   1.58780835787548E-09
      4.35571338445680E-18  -3.75118684849611E-01  -3.74625182317829E-01   0.00000000000000E+00  -1.24597569867602E-10
     -1.55276389801917E-22  -1.44168669993908E-09  -1.56628426980684E-09  -3.07539528247766E-18
      5.23034647545813E-09
      0.00000000000000E+00   3.29722606575021E-14   0.00000000000000E+00  -6.54851493244102E-14  -4.80418950530164E-23
     -3.28891930796517E-11  -3.29546782290242E-11  -1.28013437046884E-18  -9.48036251341796E-03  -9.48036251514675E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72879730079630E-09   0.00000000000000E+00   1.72879730079630E-09
      4.36763387811729E-18  -3.83571439297502E-01  -3.83037114497152E-01   0.00000000000000E+00  -1.38879698923097E-10
     -1.56768707921739E-22  -1.55696292364393E-09  -1.69584262256718E-09  -3.08749950764844E-18
      5.23965506613804E-09
      0.00000000000000E+00   4.71163501874612E-14   0.00000000000000E+00  -6.19933514495151E-14  -4.80312214023032E-23
     -4.70311984385515E-11  -4.70931917900491E-11  -1.28002357253144E-18  -9.36170726528769E-03  -9.36170726708052E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79283189096753E-09   0.00000000000000E+00   1.79283189096753E-09
      4.38432261634820E-18  -3.95272597765404E-01  -3.94722551112010E-01   0.00000000000000E+00  -1.47735253533575E-10
     -1.58880576084404E-22  -1.59800344564387E-09  -1.74573869917760E-09  -3.10429904381676E-18
      5.25222166355593E-09
      0.00000000000000E+00   6.61282107894193E-14   0.00000000000000E+00  -6.55177799785876E-14  -4.80214202764792E-23
     -6.60518515051042E-11  -6.61173692851308E-11  -1.28012279352959E-18  -9.05525803901465E-03  -9.05525804080729E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79263264240907E-09   0.00000000000000E+00   1.79263264240907E-09
      4.40684990908352E-18  -4.10798855283659E-01  -4.10254865233820E-01   0.00000000000000E+00  -1.52202706840926E-10
     -1.61759520367784E-22  -1.57431256628280E-09  -1.72651527312389E-09  -3.12672711555393E-18
      5.26918657007008E-09
      0.00000000000000E+00   1.03049795146845E-13   0.00000000000000E+00  -1.05119185393635E-13  -4.80204927571808E-23
     -1.02950666167234E-10  -1.03055785352675E-10  -1.28089903559397E-18  -8.27507519489746E-03  -8.27507519667035E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77288419610737E-09   0.00000000000000E+00   1.77288419610737E-09
      4.43692672373089E-18  -4.30777539511955E-01  -4.30251410076255E-01   0.00000000000000E+00  -1.55194160838190E-10
     -1.65622633184106E-22  -1.51463424991638E-09  -1.66982841075474E-09  -3.15602768813692E-18
      5.28918657007008E-09
      0.00000000000000E+00   1.52462263764494E-13   0.00000000000000E+00  -1.28700536034035E-13  -4.80376945485995E-23
     -1.52305627709902E-10  -1.52434328245985E-10  -1.28281954358721E-18  -6.78195377730858E-03  -6.78195377906540E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75681409115547E-09   0.00000000000000E+00   1.75681409115547E-09
      4.47206300555400E-18  -4.52925707739013E-01  -4.52420199081827E-01   0.00000000000000E+00  -1.58951114138042E-10
     -1.70151813794063E-22  -1.44542864877136E-09  -1.60437976290957E-09  -3.18924346196679E-18
      5.30918657007008E-09
      0.00000000000000E+00   1.72208882264113E-13   0.00000000000000E+00  -5.97081853249919E-14  -4.80603526141339E-23
     -1.72103840442147E-10  -1.72163548627520E-10  -1.28515006766984E-18  -5.07328591296601E-03  -5.07328591466936E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70334401548648E-09   0.00000000000000E+00   1.70334401548648E-09
      4.50612988586372E-18  -4.73868764430867E-01  -4.73386318247545E-01   0.00000000000000E+00  -1.61779536729848E-10
     -1.74627420636097E-22  -1.36940093012900E-09  -1.53118046685902E-09  -3.22097981819389E-18
      5.32918657007008E-09
      0.00000000000000E+00   1.84424232312714E-13   0.00000000000000E+00  -4.36591906828686E-14  -4.80872150503043E-23
     -1.84382776096348E-10  -1.84426435287079E-10  -1.28773946976030E-18  -3.23416822763734E-03  -3.23416822928827E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65093348059862E-09   0.00000000000000E+00   1.65093348059862E-09
      4.53914855547570E-18  -4.93803761111161E-01  -4.93341691022016E-01   0.00000000000000E+00  -1.64718641434836E-10
     -1.79059154943366E-22  -1.30178840387650E-09  -1.46650704531152E-09  -3.25140908571540E-18
      5.34918657007008E-09
      0.00000000000000E+00   6.33728686731935E-14   0.00000000000000E+00   3.05265412670459E-13  -4.80634913486124E-23
     -6.36847390707777E-11  -6.33794736581553E-11  -1.28792667314454E-18  -2.87235629328407E-03  -2.87235629467772E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39364317374939E-09   0.00000000000000E+00   1.39364317374939E-09
      4.56702141895068E-18  -5.13010328404094E-01  -5.12591186534960E-01   0.00000000000000E+00  -1.55708895736670E-10
     -1.83141350936096E-22  -1.17455480435429E-09  -1.33026370009115E-09  -3.27909474580615E-18
      5.36918657007008E-09
      0.00000000000000E+00  -1.74183544114074E-12   0.00000000000000E+00   4.74634926034188E-12  -4.73032445039000E-23
      1.73710851975556E-09   1.74185486901585E-09  -1.25217739015818E-18  -2.39888878174720E-02  -2.39888878159387E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.53330785215259E-09   0.00000000000000E+00  -1.53330785215259E-09
      4.53635526190763E-18  -5.33542614190114E-01  -5.33476931583752E-01   0.00000000000000E+00   1.07068169753976E-11
     -1.82855379106684E-22  -2.19253833838503E-10  -2.08547016863289E-10  -3.28417787174945E-18
      5.38918657007008E-09
      0.00000000000000E+00  -3.51416333503439E-12   0.00000000000000E+00   4.87294802175314E-12  -4.59586493379297E-23
      3.50929899730992E-09   3.51417194533163E-09  -1.18187248473591E-18  -6.40630877926016E-02  -6.40630877883041E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.29754463912925E-09   0.00000000000000E+00  -4.29754463912925E-09
      4.45040436912505E-18  -5.54910142448285E-01  -5.55157024641980E-01   0.00000000000000E+00   1.58895952089952E-10
     -1.78621019503810E-22   6.24476741707842E-10   7.83372693797615E-10  -3.26853188438914E-18
      5.39168657007008E-09
      0.00000000000000E+00  -4.10830694002988E-12   0.00000000000000E+00   1.20921472900154E-11  -4.57416011901362E-23
      4.09623146933608E-09   4.10832361662605E-09  -1.17163033364036E-18  -6.97628984636975E-02  -6.97628984585311E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.16639566258255E-09   0.00000000000000E+00  -5.16639566258255E-09
      4.43748837996859E-18  -5.57602516968321E-01  -5.57935957607273E-01   0.00000000000000E+00   1.96105487444809E-10
     -1.77962708691762E-22   8.61966558511872E-10   1.05807204595650E-09  -3.26585804632824E-18
      5.39506157007008E-09
      0.00000000000000E+00  -4.65009904481708E-12   0.00000000000000E+00   8.52460776848494E-12  -4.54403261116947E-23
      4.64157631236988E-09   4.65010092013832E-09  -1.15605207205138E-18  -7.83312563607895E-02  -7.83312563548138E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.97566257173720E-09   0.00000000000000E+00  -5.97566257173720E-09
      4.41732051878898E-18  -5.61298165198763E-01  -5.61715894034917E-01   0.00000000000000E+00   2.31669490399669E-10
     -1.76904617033012E-22   1.09389216119941E-09   1.32556165159890E-09  -3.26126844673759E-18
      5.39961782007008E-09
      0.00000000000000E+00  -5.25884596302857E-12   0.00000000000000E+00   7.18918870848002E-12  -4.49990672510679E-23
      5.25162715846585E-09   5.25881634717428E-09  -1.13246222266524E-18  -9.11133638086799E-02  -9.11133638018361E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.84379248919514E-09   0.00000000000000E+00  -6.84379248919514E-09
      4.38613848926008E-18  -5.66343349719498E-01  -5.66842824721418E-01   0.00000000000000E+00   2.66475803099068E-10
     -1.75245494183757E-22   1.31850033892233E-09   1.58497614202123E-09  -3.25367626659485E-18
      5.40269328882008E-09
      0.00000000000000E+00  -5.67361679625776E-12   0.00000000000000E+00   7.24042942254498E-12  -4.46827628517356E-23
      5.66641784949394E-09   5.67365827891644E-09  -1.11540617639749E-18  -1.00220313343353E-01  -1.00220313335953E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.40001540623477E-09   0.00000000000000E+00  -7.40001540623477E-09
      4.36337997312869E-18  -5.69757048654350E-01  -5.70301076289425E-01   0.00000000000000E+00   2.84237656526309E-10
     -1.74040384922364E-22   1.44211947079147E-09   1.72635712731760E-09  -3.24797379673120E-18
      5.40684517163258E-09
      0.00000000000000E+00  -6.11520629275155E-12   0.00000000000000E+00   5.84769530702742E-12  -4.42377588735518E-23
      6.10934923649743E-09   6.11519693180441E-09  -1.09092386980200E-18  -1.13086983353844E-01  -1.13086983345910E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.93428346632325E-09   0.00000000000000E+00  -7.93428346632325E-09
      4.33043775797536E-18  -5.74347217398376E-01  -5.74920472990439E-01   0.00000000000000E+00   2.99124467790951E-10
     -1.72311459811216E-22   1.51996206672849E-09   1.81908653451926E-09  -3.23951388817336E-18
      5.41245021342945E-09
      0.00000000000000E+00  -6.61263738946751E-12   0.00000000000000E+00   4.94658403973103E-12  -4.35830863925616E-23
      6.60769281914300E-09   6.61263940318268E-09  -1.05619827965295E-18  -1.30943662428614E-01  -1.30943662420226E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38780716184844E-09   0.00000000000000E+00  -8.38780716184844E-09
      4.28342374824907E-18  -5.80426104790122E-01  -5.80985542519409E-01   0.00000000000000E+00   3.05233809883093E-10
     -1.69898118819729E-22   1.46993394878288E-09   1.77516775866581E-09  -3.22722546859612E-18
      5.42001701985523E-09
      0.00000000000000E+00  -7.32085215807475E-12   0.00000000000000E+00   5.12595875143576E-12  -4.23897892031707E-23
      7.31576153041413E-09   7.32088748916553E-09  -1.00775047781310E-18  -1.55136475399270E-01  -1.55136475390547E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72270043835386E-09   0.00000000000000E+00  -8.72270043835386E-09
      4.21742076252197E-18  -5.88220095513448E-01  -5.88661944464598E-01   0.00000000000000E+00   3.00598882977351E-10
     -1.66633633854438E-22   1.10121406621114E-09   1.40181294918832E-09  -3.20967028470887E-18
      5.43023220853004E-09
      0.00000000000000E+00  -8.86843598002158E-12   0.00000000000000E+00   7.89397857825999E-12  -3.87169022509138E-23
      8.86058000193109E-09   8.86847398050931E-09  -9.41642224264905E-19  -1.86919515954759E-01  -1.86919515945796E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.96293168349103E-09   0.00000000000000E+00  -8.96293168349103E-09
      4.12586272429573E-18  -5.97295592998799E-01  -5.97325657498611E-01   0.00000000000000E+00   2.88340482023955E-10
     -1.62305675140284E-22  -1.93882779041978E-10   9.44577029818141E-11  -3.18422050003082E-18
      5.44402271324103E-09
      0.00000000000000E+00  -1.35316688222593E-11   0.00000000000000E+00   1.69869343329213E-11  -2.17560484357760E-23
      1.35147498551241E-08   1.35317367894570E-08  -8.55378034524418E-19  -2.26548464083842E-01  -2.26548464074621E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.22109480156220E-09   0.00000000000000E+00  -9.22109480156220E-09
      3.99869917299433E-18  -6.03792131657525E-01  -6.02434654382175E-01   0.00000000000000E+00   2.80831277618450E-10
     -1.56392081267611E-22  -4.59147326551312E-09  -4.31064198789483E-09  -3.14332113846991E-18
      5.46263989460086E-09
      0.00000000000000E+00  -2.70716955156045E-11   0.00000000000000E+00   3.60866753040258E-11   4.23071478510536E-23
      2.70356101810440E-08   2.70716968563480E-08  -7.55524666073078E-19  -2.70582332528496E-01  -2.70582332518784E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71208401418719E-09   0.00000000000000E+00  -9.71208401418719E-09
      3.81788754352029E-18  -5.90745399365373E-01  -5.85277438852850E-01   0.00000000000000E+00   3.01223581359448E-10
     -1.47096980082179E-22  -1.76608364235202E-08  -1.73596128421609E-08  -3.06236287744721E-18
      5.48263989460086E-09
      0.00000000000000E+00  -4.72748742038814E-11   0.00000000000000E+00   5.00672644779985E-11   1.38679155630029E-22
      4.72247314273563E-08   4.72747986918344E-08  -6.77619086606780E-19  -3.04753908989207E-01  -3.04753908978815E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03923761131253E-08   0.00000000000000E+00  -1.03923761131253E-08
      3.61004002125778E-18  -5.40697525217392E-01  -5.29079155681503E-01   0.00000000000000E+00   3.19151916165132E-10
     -1.34252667281577E-22  -3.72015744948741E-08  -3.68824225787091E-08  -2.93242093465100E-18
      5.50263989460086E-09
      0.00000000000000E+00  -6.28338319105225E-11   0.00000000000000E+00   3.87192541913752E-11   2.11590160712984E-22
      6.27951341743522E-08   6.28338534285438E-08  -6.28826160560003E-19  -3.27254719394345E-01  -3.27254719383334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10110019665244E-08   0.00000000000000E+00  -1.10110019665244E-08
      3.38981998192729E-18  -4.55243558111581E-01  -4.38917711592369E-01   0.00000000000000E+00   2.93739836591443E-10
     -1.18353571249279E-22  -5.21165912986106E-08  -5.18228514620193E-08  -2.76099382136729E-18
      5.52263989460086E-09
      0.00000000000000E+00  -6.51174594564504E-11   0.00000000000000E+00   5.78781858601352E-12   2.22910089953642E-22
      6.51116955294592E-08   6.51174833480454E-08  -6.05597429833247E-19  -3.39837711336262E-01  -3.39837711324696E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15654141744824E-08   0.00000000000000E+00  -1.15654141744824E-08
      3.15851169843764E-18  -3.39781209190006E-01  -3.22909822677210E-01   0.00000000000000E+00   2.44878271691588E-10
     -1.02006993220537E-22  -5.37969474452546E-08  -5.35520691735631E-08  -2.55291426860440E-18
      5.54263989460086E-09
      0.00000000000000E+00  -5.66532321648792E-11   0.00000000000000E+00  -2.09588797369379E-11   1.84503009706327E-22
      5.66741536549807E-08   5.66531947752439E-08  -5.98196271092603E-19  -3.46361468162904E-01  -3.46361468150985E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19190706750393E-08   0.00000000000000E+00  -1.19190706750393E-08
      2.92013028493686E-18  -2.16607047876556E-01  -2.02513300064997E-01   0.00000000000000E+00   1.70770876115431E-10
     -8.53732866594476E-23  -4.49048949763200E-08  -4.47341241002047E-08  -2.32193401384425E-18
      5.56263989460086E-09
      0.00000000000000E+00  -4.93501060410855E-11   0.00000000000000E+00  -1.81205373272221E-11   1.44457782083445E-22
      4.93681898693997E-08   4.93500693320726E-08  -5.89271087194163E-19  -3.53541260743920E-01  -3.53541260732083E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18371013635177E-08   0.00000000000000E+00  -1.18371013635177E-08
      2.68338825766650E-18  -1.15072664174032E-01  -1.03253766718023E-01   0.00000000000000E+00   9.10441796202606E-11
     -7.35041213633836E-23  -3.76040121481750E-08  -3.75129679685549E-08  -2.09411717047234E-18
      5.57263989460086E-09
      0.00000000000000E+00  -4.49912466579535E-11   0.00000000000000E+00  -2.15800782624056E-11   1.26285857437893E-22
      4.50128318748432E-08   4.49912517965810E-08  -5.82440547660454E-19  -3.57946853340641E-01  -3.57946853328939E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17024073818051E-08   0.00000000000000E+00  -1.17024073818051E-08
      2.56636418384845E-18  -7.39981472766306E-02  -6.35100443622568E-02   0.00000000000000E+00   6.29236819151090E-11
     -5.33032900934463E-23  -3.33517680966910E-08  -3.32888444147759E-08  -1.98392363618800E-18
      5.57938989460086E-09
      0.00000000000000E+00  -4.14386922227663E-11   0.00000000000000E+00  -2.60180973771211E-11   1.18615445896463E-22
      4.14647126988673E-08   4.14386946014903E-08  -5.73685721187021E-19  -3.62312070366107E-01  -3.62312070354684E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14232629917732E-08   0.00000000000000E+00  -1.14232629917732E-08
      2.48925715865398E-18  -5.31538105120604E-02  -4.36970132632191E-02   0.00000000000000E+00   5.23444324450601E-11
     -2.08848300962416E-23  -3.00677760421619E-08  -3.00154316097168E-08  -1.91557143746696E-18
      5.58394614460086E-09
      0.00000000000000E+00  -3.88526199572140E-11   0.00000000000000E+00  -2.80467907632266E-11   1.16572508913769E-22
      3.88805976273415E-08   3.88525508365784E-08  -5.65104363218035E-19  -3.66145392764582E-01  -3.66145392753427E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11550162203353E-08   0.00000000000000E+00  -1.11550162203353E-08
      2.43843211600008E-18  -4.26316790021003E-02  -3.39051560424651E-02   0.00000000000000E+00   4.63300483322968E-11
      8.88510375789042E-24  -2.77438646645752E-08  -2.76975346162429E-08  -1.87332775278204E-18
      5.58702161335086E-09
      0.00000000000000E+00  -3.71899546795461E-11   0.00000000000000E+00  -2.67383200312223E-11   1.16785071636624E-22
      3.72166687114600E-08   3.71899303914289E-08  -5.58095624379416E-19  -3.69139809642172E-01  -3.69139809631210E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09619194358662E-08   0.00000000000000E+00  -1.09619194358662E-08
      2.40471907533506E-18  -3.70733145592381E-02  -2.88097784432286E-02   0.00000000000000E+00   4.10264984359613E-11
      2.98599942281095E-23  -2.62690374539989E-08  -2.62280109555630E-08  -1.84662345095564E-18
      5.59117349616336E-09
      0.00000000000000E+00  -3.54927557806883E-11   0.00000000000000E+00  -2.02538813697685E-11   1.19433082369301E-22
      3.55130746553080E-08   3.54928207739384E-08  -5.47048944213653E-19  -3.73732081287863E-01  -3.73732081277123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07396537181159E-08   0.00000000000000E+00  -1.07396537181159E-08
      2.36012929165061E-18  -3.16651174418586E-02  -2.38662441234537E-02   0.00000000000000E+00   3.18614260723534E-11
      5.59178535169319E-23  -2.47850284818945E-08  -2.47531670558221E-08  -1.81308034743696E-18
      5.59677853796023E-09
      0.00000000000000E+00  -3.39627143035481E-11   0.00000000000000E+00  -1.35076095125232E-11   1.25364208640338E-22
      3.39762392352747E-08   3.39627316257623E-08  -5.30531120018436E-19  -3.80486154187437E-01  -3.80486154176905E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05315983724569E-08   0.00000000000000E+00  -1.05315983724569E-08
      2.30109924258509E-18  -2.67983428638546E-02  -1.94159875842845E-02   0.00000000000000E+00   2.32207103715126E-11
      8.66127428476491E-23  -2.34543539636774E-08  -2.34311332533058E-08  -1.77056812256665E-18
      5.60434534438601E-09
      0.00000000000000E+00  -3.27170241328024E-11   0.00000000000000E+00  -8.11878213916043E-12   1.34144781367850E-22
      3.27251488784869E-08   3.27170300963479E-08  -5.07139050658112E-19  -3.89973956321343E-01  -3.89973956310981E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03622096609411E-08   0.00000000000000E+00  -1.03622096609411E-08
      2.22269040793739E-18  -2.26607882678546E-02  -1.56175335984701E-02   0.00000000000000E+00   1.63673283573909E-11
      1.21045401017993E-22  -2.23711877637644E-08  -2.23548204354069E-08  -1.71555135727927E-18
      5.61456053306082E-09
      0.00000000000000E+00  -3.17123345524892E-11   0.00000000000000E+00  -4.82323806796220E-12   1.42784227497002E-22
      3.17171134193297E-08   3.17122901812619E-08  -4.75562783522389E-19  -4.02769409641370E-01  -4.02769409631142E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02280032566174E-08   0.00000000000000E+00  -1.02280032566174E-08
      2.11820942490452E-18  -1.92238826767887E-02  -1.24548954625071E-02   0.00000000000000E+00   1.17754331252393E-11
      1.54948748810043E-22  -2.14960623577698E-08  -2.14842869246444E-08  -1.64264664138213E-18
      5.62835103777181E-09
      0.00000000000000E+00  -3.07601801618588E-11   0.00000000000000E+00  -3.36788336086828E-12   1.44558024682296E-22
      3.07635310602279E-08   3.07601631768671E-08  -4.34571737236511E-19  -4.19482568750607E-01  -4.19482568740505E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01022457566942E-08   0.00000000000000E+00  -1.01022457566942E-08
      1.97889435720529E-18  -1.63526755868048E-02  -9.84404209655764E-03   0.00000000000000E+00   9.07912019690042E-12
      1.77399735699965E-22  -2.06669965403699E-08  -2.06579174201729E-08  -1.54432261996878E-18
      5.64696821913164E-09
      0.00000000000000E+00  -2.96011914230370E-11   0.00000000000000E+00  -3.03455600910181E-12   1.29448775972410E-22
      2.96042422281837E-08   2.96012076721748E-08  -3.82932286862914E-19  -4.40812339938925E-01  -4.40812339928974E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95113021839829E-09   0.00000000000000E+00  -9.95113021839829E-09
      1.79363236119407E-18  -1.38912993735638E-02  -7.70019583785688E-03   0.00000000000000E+00   7.59217180451657E-12
      1.71583524875430E-22  -1.96576696255812E-08  -1.96500774537765E-08  -1.41070007433116E-18
      5.66696821913164E-09
      0.00000000000000E+00  -2.84060158577555E-11   0.00000000000000E+00  -2.91681994139648E-12   9.97379444923955E-23
      2.84089397853408E-08   2.84060229653995E-08  -3.31543853533415E-19  -4.62387595899228E-01  -4.62387595889425E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80286996124145E-09   0.00000000000000E+00  -9.80286996124145E-09
      1.59757496196924E-18  -1.21177190678498E-02  -6.25646166722464E-03   0.00000000000000E+00   6.60264008681752E-12
      1.35829420925894E-22  -1.86097556442451E-08  -1.86031530041581E-08  -1.26603110843583E-18
      5.68696821913164E-09
      0.00000000000000E+00  -2.74230934801605E-11   0.00000000000000E+00  -2.39789048690842E-12   6.73454558520489E-23
      2.74254545023153E-08   2.74230566118285E-08  -2.83579436912965E-19  -4.82872895955289E-01  -4.82872895945616E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67382940914672E-09   0.00000000000000E+00  -9.67382940914672E-09
      1.40409837378631E-18  -1.09101162670828E-02  -5.31789882890420E-03   0.00000000000000E+00   5.49901183419192E-12
      9.03905316155457E-23  -1.77547262145159E-08  -1.77492272026816E-08  -1.12051893687334E-18
      5.70696821913164E-09
      0.00000000000000E+00  -2.65851939426163E-11   0.00000000000000E+00  -2.04252146684433E-12   4.05690519472151E-23
      2.65872763629908E-08   2.65852338415240E-08  -2.38762284250760E-19  -5.02354796437415E-01  -5.02354796427899E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51607934454569E-09   0.00000000000000E+00  -9.51607934454569E-09
      1.21377678689539E-18  -1.00477769170909E-02  -4.66982496837196E-03   0.00000000000000E+00   4.60092323432031E-12
      5.09492031159311E-23  -1.70737554202128E-08  -1.70691544969785E-08  -9.75014502644631E-19
      5.72696821913164E-09
      0.00000000000000E+00  -2.65214536949943E-11   0.00000000000000E+00  -1.35411142050214E-13   2.27269766412005E-23
      2.65215778415387E-08   2.65214424303967E-08  -1.94460823129109E-19  -5.22031369887676E-01  -5.22031369877794E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.88233368918433E-09   0.00000000000000E+00  -9.88233368918433E-09
      1.01613011311171E-18  -9.50899989491340E-03  -4.26653850657587E-03   0.00000000000000E+00   3.75180667600986E-12
      2.42224540969610E-23  -1.66428605478883E-08  -1.66391087412123E-08  -8.21669289982595E-19
      5.74696821913164E-09
      0.00000000000000E+00  -2.74440340802439E-11   0.00000000000000E+00   2.30055769200747E-12   1.28255571958798E-23
      2.74417672027753E-08   2.74440677604674E-08  -1.48473725024842E-19  -5.42993897451028E-01  -5.42993897440204E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08240276922086E-08   0.00000000000000E+00  -1.08240276922086E-08
      7.99649559267532E-19  -9.30504346296990E-03  -4.06858713077872E-03   0.00000000000000E+00   2.66865467232991E-12
      9.37169042734531E-24  -1.66227087229311E-08  -1.66200400682588E-08  -6.51175834242690E-19
      5.76696821913164E-09
      0.00000000000000E+00  -2.84343040368154E-11   0.00000000000000E+00   2.47244023111960E-12   7.96882831021185E-24
      2.84318521173675E-08   2.84343245575986E-08  -1.02316556035708E-19  -5.64603612391824E-01  -5.64603612380306E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15179204497234E-08   0.00000000000000E+00  -1.15179204497234E-08
      5.69291150273065E-19  -9.27730061255542E-03  -3.94746661593040E-03   0.00000000000000E+00   1.76408655387297E-12
      2.30944839946004E-24  -1.69181681944292E-08  -1.69164041078753E-08  -4.66974594237357E-19
      5.78696821913164E-09
      0.00000000000000E+00  -2.89038143334203E-11   0.00000000000000E+00   1.18678322802610E-12   5.74151283225133E-24
      2.89026518021700E-08   2.89038385853980E-08  -5.89142891063887E-20  -5.85443903378577E-01  -5.85443903367125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14523884704430E-08   0.00000000000000E+00  -1.14523884704430E-08
      3.40243380864205E-19  -9.33548826683935E-03  -3.83707532697373E-03   0.00000000000000E+00   9.27088479370746E-13
     -6.52106538579517E-25  -1.74523772034343E-08  -1.74514501149550E-08  -2.81329091757816E-19
      5.80696821913164E-09
      0.00000000000000E+00  -2.59103188136154E-11   0.00000000000000E+00  -7.36133764614552E-12   4.29596410391980E-24
      2.59176665545480E-08   2.59103052169018E-08  -2.90945879429046E-20  -5.99885584362610E-01  -5.99885584354347E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.26274119374342E-09   0.00000000000000E+00  -8.26274119374342E-09
      1.74988556989336E-19  -9.02222957869067E-03  -3.46202541784736E-03   0.00000000000000E+00   1.02457026762305E-12
     -1.80673361031642E-24  -1.76485885934261E-08  -1.76475640231585E-08  -1.45893969046432E-19
      5.82696821913164E-09
      0.00000000000000E+00  -1.51766080656461E-11   0.00000000000000E+00  -2.64580445543663E-11   2.36983472693227E-24
      1.52031042526605E-08   1.51766462081062E-08  -3.86615937153487E-20  -5.94567162060453E-01  -5.94567162062953E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49984878759425E-09   0.00000000000000E+00   2.49984878759425E-09
      2.24985532741221E-19  -8.08265261354986E-03  -2.51333157125221E-03   0.00000000000000E+00  -4.94752628965190E-13
     -2.44432540302669E-24  -1.76760002430714E-08  -1.76764949957004E-08  -1.86323939025872E-19
      5.84696821913164E-09
      0.00000000000000E+00   3.11730222556067E-12   0.00000000000000E+00  -4.50851860703047E-11  -9.46995544291919E-25
     -3.07224276229988E-09  -3.11732794837019E-09  -1.18618012625907E-19  -5.55184934373211E-01  -5.55184934394013E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08010758581921E-08   0.00000000000000E+00   2.08010758581921E-08
      6.41007049905063E-19  -6.52323912972668E-03  -9.51632429814870E-04   0.00000000000000E+00  -4.01800303879939E-12
     -3.91719975016906E-24  -1.76797299067832E-08  -1.76837479098220E-08  -5.22389037279156E-19
      5.86696821913164E-09
      0.00000000000000E+00   1.95857065200307E-11   0.00000000000000E+00  -4.07213055966686E-11  -8.45343645153742E-24
     -1.95449747382619E-08  -1.95856960438586E-08  -2.87417734186589E-19  -4.79262261546341E-01  -4.79262261583567E-01
      0.00000000000000E+00   0.00000000000000E+00   3.72258506748372E-08   0.00000000000000E+00   3.72258506748372E-08
      1.38552406340181E-18  -4.82343372864171E-03   7.34434687000036E-04   0.00000000000000E+00  -9.55031433468289E-12
     -1.28600633262186E-23  -1.76306043166438E-08  -1.76401546309785E-08  -1.09810632921522E-18
      5.88696821913164E-09
      0.00000000000000E+00   2.43317833152296E-11   0.00000000000000E+00  -1.20277428546002E-11  -3.08798380570461E-23
     -2.43197740035186E-08  -2.43318017463732E-08  -5.54715250515158E-19  -3.71376359348212E-01  -3.71376359390172E-01
      0.00000000000000E+00   0.00000000000000E+00   4.19599814791496E-08   0.00000000000000E+00   4.19599814791496E-08
      2.22472369298480E-18  -2.84658970487130E-03   2.70749674173693E-03   0.00000000000000E+00  -2.15658878037701E-11
     -5.39165150261110E-23  -1.76066138449725E-08  -1.76281797327763E-08  -1.67000844246964E-18
      5.90696821913164E-09
      0.00000000000000E+00   1.64853037261162E-11   0.00000000000000E+00   1.87761467105598E-11  -4.20841943260919E-23
     -1.65041020632737E-08  -1.64853259165631E-08  -8.49906806791092E-19  -2.46708067119322E-01  -2.46708067152744E-01
      0.00000000000000E+00   0.00000000000000E+00   3.34216514079172E-08   0.00000000000000E+00   3.34216514079172E-08
      2.89315672114314E-18  -5.43762300914878E-03  -1.01535218063427E-04   0.00000000000000E+00  -4.84094209776165E-11
     -7.85684793009250E-23  -1.68879160703763E-08  -1.69363254913540E-08  -2.04324991435205E-18
      5.92696821913164E-09
      0.00000000000000E+00   1.08725799906270E-11   0.00000000000000E+00   1.30885325290924E-11  -4.52598499079588E-23
     -1.08856237166742E-08  -1.08725351841452E-08  -1.06573473510461E-18  -1.38876788090475E-01  -1.38876788114953E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44787829833759E-08   0.00000000000000E+00   2.44787829833759E-08
      3.38273238081066E-18  -3.05012137747722E-02  -2.62143328148176E-02   0.00000000000000E+00  -9.18619336278556E-11
     -9.13651636522640E-23  -1.35143858656029E-08  -1.36062477992308E-08  -2.31699764570604E-18
      5.94696821913164E-09
      0.00000000000000E+00   6.84169816406308E-12   0.00000000000000E+00   9.13981933362167E-12  -4.73006790507813E-23
     -6.85084202036943E-09  -6.84170220103586E-09  -1.20114900824400E-18  -6.21266853987268E-02  -6.21266854160091E-02
      0.00000000000000E+00   0.00000000000000E+00   1.72823655971369E-08   0.00000000000000E+00   1.72823655971369E-08
      3.72837969275340E-18  -7.39264756848112E-02  -7.06369617710266E-02   0.00000000000000E+00  -1.50721251459535E-10
     -1.04216689318024E-22  -1.02899421446414E-08  -1.04406633961010E-08  -2.52723068450939E-18
      5.96696821913164E-09
      0.00000000000000E+00   2.69545934756650E-12   0.00000000000000E+00   9.81328609893526E-12  -4.79504732874210E-23
     -2.70529083989055E-09  -2.69547755379166E-09  -1.25360759974184E-18  -2.96093417853956E-02  -2.96093417953481E-02
      0.00000000000000E+00   0.00000000000000E+00   9.95249778745381E-09   0.00000000000000E+00   9.95249778745381E-09
      3.92742964850248E-18  -1.32361088107098E-01  -1.30074627340804E-01   0.00000000000000E+00  -1.74616494044807E-10
     -1.15291522906714E-22  -7.08240373961725E-09  -7.25702023366217E-09  -2.67382204876064E-18
      5.96946821913164E-09
      0.00000000000000E+00   1.94022007350900E-12   0.00000000000000E+00   1.44902484587448E-11  -4.79836431257775E-23
     -1.95464354359799E-09  -1.94015329513929E-09  -1.25827702704362E-18  -2.66337071603678E-02  -2.66337071688741E-02
      0.00000000000000E+00   0.00000000000000E+00   8.50624739262592E-09   0.00000000000000E+00   8.50624739262592E-09
      3.94869526698404E-18  -1.39930610167436E-01  -1.37861818511911E-01   0.00000000000000E+00  -1.91507198350190E-10
     -1.16670777049382E-22  -6.37458689913624E-09  -6.56609409748655E-09  -2.69041823994042E-18
      5.97284321913164E-09
      0.00000000000000E+00   1.27618262349858E-12   0.00000000000000E+00   9.57118720188269E-12  -4.80122780316324E-23
     -1.28578132236784E-09  -1.27621013516601E-09  -1.26234106266166E-18  -2.39419774660323E-02  -2.39419774733286E-02
      0.00000000000000E+00   0.00000000000000E+00   7.29631856386283E-09   0.00000000000000E+00   7.29631856386283E-09
      3.97332034213708E-18  -1.50468479717518E-01  -1.48571709261376E-01   0.00000000000000E+00  -1.91503121345546E-10
     -1.18443074750185E-22  -5.82860530735113E-09  -6.02010842869679E-09  -2.71097927947542E-18
      5.97739946913164E-09
      0.00000000000000E+00   8.11264563754084E-13   0.00000000000000E+00   4.95698476381644E-12  -4.80374991998932E-23
     -8.16262208073083E-10  -8.11305223309314E-10  -1.26571203895695E-18  -2.15665490895020E-02  -2.15665490958863E-02
      0.00000000000000E+00   0.00000000000000E+00   6.38434377478167E-09   0.00000000000000E+00   6.38434377478167E-09
      4.00240900846093E-18  -1.64828827259139E-01  -1.63072912223907E-01   0.00000000000000E+00  -1.92251926347650E-10
     -1.20734569623548E-22  -5.38078662512482E-09  -5.57303855147259E-09  -2.73669696950398E-18
      5.98355040663164E-09
      0.00000000000000E+00   5.21861796813167E-13   0.00000000000000E+00   2.26945219722545E-12  -4.80593096852206E-23
     -5.24166958832335E-10  -5.21897506635157E-10  -1.26848845524417E-18  -1.94333627684484E-02  -1.94333627741485E-02
      0.00000000000000E+00   0.00000000000000E+00   5.70011478969928E-09   0.00000000000000E+00   5.70011478969928E-09
      4.03747005827519E-18  -1.83972962657444E-01  -1.82341443147080E-01   0.00000000000000E+00  -1.95647435468333E-10
     -1.23727191397576E-22  -4.98256984759567E-09  -5.17821728306413E-09  -2.76898160303102E-18
      5.99185417225664E-09
      0.00000000000000E+00   3.50203982972300E-13   0.00000000000000E+00   9.91730304516561E-13  -4.80780190297161E-23
     -3.51176601739434E-10  -3.50184871434966E-10  -1.27082135451913E-18  -1.74436671717385E-02  -1.74436671768504E-02
      0.00000000000000E+00   0.00000000000000E+00   5.11191446557851E-09   0.00000000000000E+00   5.11191446557851E-09
      4.07991819789240E-18  -2.08807268689491E-01  -2.07306972879103E-01   0.00000000000000E+00  -2.00165698331604E-10
     -1.27623573778174E-22  -4.56156389581188E-09  -4.76172959414361E-09  -2.80909684337327E-18
      6.00306425585039E-09
      0.00000000000000E+00   2.48072635197530E-13   0.00000000000000E+00   4.33913148637044E-13  -4.80927418269021E-23
     -2.48520722776843E-10  -2.48086809628254E-10  -1.27284385577304E-18  -1.55337247252696E-02  -1.55337247297384E-02
      0.00000000000000E+00   0.00000000000000E+00   4.46877595513248E-09   0.00000000000000E+00   4.46877595513248E-09
      4.13001354991118E-18  -2.39537779980254E-01  -2.38207949080007E-01   0.00000000000000E+00  -2.00800801402031E-10
     -1.32541685194295E-22  -4.01988834410207E-09  -4.22068914550423E-09  -2.85716969413813E-18
      6.01819786870196E-09
      0.00000000000000E+00   1.89659382333543E-13   0.00000000000000E+00   1.83453228548701E-13  -4.81040385470659E-23
     -1.89815786969714E-10  -1.89632333741213E-10  -1.27471578432949E-18  -1.36863114487987E-02  -1.36863114524332E-02
      0.00000000000000E+00   0.00000000000000E+00   3.63452224821369E-09   0.00000000000000E+00   3.63452224821369E-09
      4.18501700251604E-18  -2.74174692677088E-01  -2.73089293685034E-01   0.00000000000000E+00  -1.86886161527988E-10
     -1.38257086883535E-22  -3.25800375294440E-09  -3.44488991447252E-09  -2.91030121818654E-18
      6.03819786870196E-09
      0.00000000000000E+00   1.56136053252795E-13   0.00000000000000E+00   8.01988318572649E-14  -4.81116133195464E-23
     -1.56261685408604E-10  -1.56181486576795E-10  -1.27655339694224E-18  -1.19955462470013E-02  -1.19955462496302E-02
      0.00000000000000E+00   0.00000000000000E+00   2.62892816814214E-09   0.00000000000000E+00   2.62892816814214E-09
      4.23759556587888E-18  -3.07192584209988E-01  -3.06413482557586E-01   0.00000000000000E+00  -1.49995274607235E-10
     -1.43881338872908E-22  -2.32275140695797E-09  -2.47274668156534E-09  -2.96104216893663E-18
      6.05819786870196E-09
      0.00000000000000E+00   1.37491571599668E-13   0.00000000000000E+00   4.62963926898309E-14  -4.81143194016460E-23
     -1.37549013314289E-10  -1.37502716921648E-10  -1.27803983095087E-18  -1.08279856087786E-02  -1.08279856105685E-02
      0.00000000000000E+00   0.00000000000000E+00   1.78995273462796E-09   0.00000000000000E+00   1.78995273462796E-09
      4.27339462057144E-18  -3.28780725976568E-01  -3.28260081048535E-01   0.00000000000000E+00  -1.05606908354521E-10
     -1.47626786854972E-22  -1.54684310935164E-09  -1.65245001770631E-09  -2.99535478962057E-18
      6.07819786870196E-09
      0.00000000000000E+00   1.30603216309103E-13   0.00000000000000E+00   1.79212334929772E-14  -4.81158816029409E-23
     -1.30616319622563E-10  -1.30598398389118E-10  -1.27940243073870E-18  -9.98797051046301E-03  -9.98797051157976E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11675513313357E-09   0.00000000000000E+00   1.11675513313357E-09
      4.29572972323411E-18  -3.40618970890342E-01  -3.40308262903402E-01   0.00000000000000E+00  -5.91061768262062E-11
     -1.49663675352067E-22  -9.27050557918039E-10  -9.86156734744395E-10  -3.01632729249541E-18
      6.09819786870196E-09
      0.00000000000000E+00   1.14163008348956E-13   0.00000000000000E+00   4.37404350242052E-14  -4.81114491882563E-23
     -1.14185355428445E-10  -1.14141614993469E-10  -1.28044608167273E-18  -9.48056687629977E-03  -9.48056687701325E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13476937790791E-10   0.00000000000000E+00   7.13476937790791E-10
      4.30999926198992E-18  -3.46903229367915E-01  -3.46714402646578E-01   0.00000000000000E+00  -2.95578261068407E-11
     -1.50669939365425E-22  -5.69777496690363E-10  -5.99335322797354E-10  -3.02955318031720E-18
      6.11819786870196E-09
      0.00000000000000E+00   8.45890029681321E-14   0.00000000000000E+00   8.06242628574236E-14  -4.80962187667881E-23
     -8.46974387616706E-11  -8.46168144988613E-11  -1.28091093104061E-18  -9.29157315303485E-03  -9.29157315375053E-03
      0.00000000000000E+00   0.00000000000000E+00   7.15675793859226E-10   0.00000000000000E+00   7.15675793859226E-10
      4.32431277786711E-18  -3.54161831830144E-01  -3.53963008931278E-01   0.00000000000000E+00  -3.41899571605540E-11
     -1.51799717818455E-22  -5.96869022199694E-10  -6.31058979360400E-10  -3.04340184682650E-18
      6.12319786870196E-09
      0.00000000000000E+00   8.10989029542461E-14   0.00000000000000E+00   4.32231342272605E-14  -4.80923786225733E-23
     -8.11681373405937E-11  -8.11249142064146E-11  -1.28101040766424E-18  -9.25528103679196E-03  -9.25528103748344E-03
      0.00000000000000E+00   0.00000000000000E+00   6.91481153216948E-10   0.00000000000000E+00   6.91481153216948E-10
      4.32777018363319E-18  -3.55900221176373E-01  -3.55707921362273E-01   0.00000000000000E+00  -3.26349651934932E-11
     -1.52067221580518E-22  -5.77721273816678E-10  -6.10356239010323E-10  -3.04675977596895E-18
      6.12994786870196E-09
      0.00000000000000E+00   5.18004317850451E-14   0.00000000000000E+00   2.26507916894597E-13  -4.80821534412933E-23
     -5.19851026289041E-11  -5.17585947120576E-11  -1.28094822283370E-18  -9.29395570534680E-03  -9.29395570621930E-03
      0.00000000000000E+00   0.00000000000000E+00   8.72492195919803E-10   0.00000000000000E+00   8.72492195919803E-10
      4.33365950595565E-18  -3.59531474284512E-01  -3.59272886492919E-01   0.00000000000000E+00  -5.31803194674891E-11
     -1.52644113477541E-22  -7.67553281740095E-10  -8.20733601207737E-10  -3.05271128312195E-18
      6.13906036870196E-09
      0.00000000000000E+00   2.92984711692010E-14   0.00000000000000E+00   1.39013609780388E-13  -4.80660234685818E-23
     -2.94415630086166E-11  -2.93025493988843E-11  -1.28066393352754E-18  -9.39147980393359E-03  -9.39147980516207E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22847506734620E-09   0.00000000000000E+00   1.22847506734620E-09
      4.34485398500684E-18  -3.67239876591309E-01  -3.66862047183698E-01   0.00000000000000E+00  -8.85260473113924E-11
     -1.53928681043113E-22  -1.11064647063571E-09  -1.19917251794726E-09  -3.06419005147930E-18
      6.14213583745196E-09
      0.00000000000000E+00   1.81852579670903E-14   0.00000000000000E+00   1.96736415226284E-13  -4.80597419365240E-23
     -1.83446068529873E-11  -1.81478704378091E-11  -1.28053422276157E-18  -9.43497430952180E-03  -9.43497431088798E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36617177717316E-09   0.00000000000000E+00   1.36617177717316E-09
      4.34905560361467E-18  -3.70226908424828E-01  -3.69802176988477E-01   0.00000000000000E+00  -1.03929235424270E-10
     -1.54433072808160E-22  -1.24409467131100E-09  -1.34802390673542E-09  -3.06852138085310E-18
      6.14628772026446E-09
      0.00000000000000E+00   1.66238974345623E-14   0.00000000000000E+00   3.89887053968886E-14  -4.80520912700854E-23
     -1.66620360190072E-11  -1.66230473136583E-11  -1.28035386144567E-18  -9.48054462618358E-03  -9.48054462772598E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54240357770862E-09   0.00000000000000E+00   1.54240357770862E-09
      4.35545948251890E-18  -3.74830316540498E-01  -3.74349576009466E-01   0.00000000000000E+00  -1.21347391318201E-10
     -1.55224553702254E-22  -1.40443313907667E-09  -1.52578053039503E-09  -3.07510562107323E-18
      6.15189276206133E-09
      0.00000000000000E+00   2.74615764250505E-14   0.00000000000000E+00  -7.75628072343031E-14  -4.80437086865598E-23
     -2.73966844012580E-11  -2.74742472085404E-11  -1.28017324611298E-18  -9.48714062433485E-03  -9.48714062602886E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69401770514278E-09   0.00000000000000E+00   1.69401770514278E-09
      4.36495452256087E-18  -3.81600834043707E-01  -3.81075740858532E-01   0.00000000000000E+00  -1.35942259023134E-10
     -1.56413593995541E-22  -1.53060119891091E-09  -1.66654345793420E-09  -3.08478127644789E-18
      6.15945956848711E-09
      0.00000000000000E+00   4.16975106922171E-14   0.00000000000000E+00  -7.87284150469735E-14  -4.80344095404096E-23
     -4.16283568027728E-11  -4.17070852178678E-11  -1.28004086265885E-18  -9.41740748420230E-03  -9.41740748598232E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78002366525810E-09   0.00000000000000E+00   1.78002366525810E-09
      4.37842361706919E-18  -3.91091302231086E-01  -3.90543594110480E-01   0.00000000000000E+00  -1.45742129737863E-10
     -1.58115014389429E-22  -1.59257445030237E-09  -1.73831658004039E-09  -3.09838275441033E-18
      6.16967475716192E-09
      0.00000000000000E+00   5.73111160174967E-14   0.00000000000000E+00  -6.44294366213171E-14  -4.80247293299128E-23
     -5.72260301814873E-11  -5.72904596181567E-11  -1.28002794468352E-18  -9.22186606071902E-03  -9.22186606251806E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79903575116153E-09   0.00000000000000E+00   1.79903575116153E-09
      4.39680110670002E-18  -4.03864852954947E-01  -4.03316064162951E-01   0.00000000000000E+00  -1.51055321964167E-10
     -1.60456883299566E-22  -1.59068996957911E-09  -1.74174529154344E-09  -3.11677316201650E-18
      6.18346526187290E-09
      0.00000000000000E+00   8.28439529611891E-14   0.00000000000000E+00  -8.52265286299400E-14  -4.80185632652109E-23
     -8.27193298404214E-11  -8.28045563690994E-11  -1.28037344473957E-18  -8.75057829925366E-03  -8.75057830103584E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78218001259162E-09   0.00000000000000E+00   1.78218001259162E-09
      4.42137826855949E-18  -4.20531898377332E-01  -4.19996459245463E-01   0.00000000000000E+00  -1.53945148558831E-10
     -1.63610534863689E-22  -1.54543030766342E-09  -1.69937545622242E-09  -3.14100482381992E-18
      6.20208244323274E-09
      0.00000000000000E+00   1.28582632090537E-13   0.00000000000000E+00  -1.23645944412315E-13  -4.80265097351492E-23
     -1.28423370900164E-10  -1.28547016844624E-10  -1.28170858597631E-18  -7.61798936569714E-03  -7.61798936746319E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76605587810085E-09   0.00000000000000E+00   1.76605587810085E-09
      4.45425725113370E-18  -4.41799863021054E-01  -4.41283916477950E-01   0.00000000000000E+00  -1.57036468853582E-10
     -1.67838257914590E-22  -1.48047239240250E-09  -1.63750886125625E-09  -3.17254866515739E-18
      6.22208244323274E-09
      0.00000000000000E+00   1.67708490140944E-13   0.00000000000000E+00  -1.06372231148222E-13  -4.80486278338701E-23
     -1.67551124234268E-10  -1.67657496465464E-10  -1.28394145246659E-18  -5.95254761983573E-03  -5.95254762157330E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73757081659067E-09   0.00000000000000E+00   1.73757081659067E-09
      4.48900866746551E-18  -4.63321127551450E-01  -4.62826477977290E-01   0.00000000000000E+00  -1.60631027020497E-10
     -1.72348628457435E-22  -1.40928229310450E-09  -1.56991332012517E-09  -3.20506721499892E-18
      6.24208244323274E-09
      0.00000000000000E+00   1.71565969103660E-13   0.00000000000000E+00  -2.07470384141440E-14  -4.80702468369939E-23
     -1.71520572317061E-10  -1.71541319355523E-10  -1.28626684621532E-18  -4.26062347899240E-03  -4.26062348065819E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66579388446036E-09   0.00000000000000E+00   1.66579388446036E-09
      4.52232454515471E-18  -4.83761677165167E-01  -4.83290865724183E-01   0.00000000000000E+00  -1.62607827867562E-10
     -1.76785696865791E-22  -1.33164473723713E-09  -1.49425256510487E-09  -3.23605769893939E-18
      6.26208244323274E-09
      0.00000000000000E+00   2.25938053530516E-13   0.00000000000000E+00  -1.54580037602182E-13  -4.81145393221334E-23
     -2.25754414017838E-10  -2.25908994055488E-10  -1.28969064039379E-18  -1.92711323731143E-03  -1.92711323899667E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68524423338832E-09   0.00000000000000E+00   1.68524423338832E-09
      4.55602942982248E-18  -5.03200282982907E-01  -5.02740471485515E-01   0.00000000000000E+00  -1.69390450533809E-10
     -1.81282868776380E-22  -1.28994478879885E-09  -1.45933523933284E-09  -3.26633878942869E-18
      6.28208244323274E-09
      0.00000000000000E+00  -6.85988342203017E-13   0.00000000000000E+00   2.37861229268476E-12  -4.77780023354522E-23
      6.83632779574149E-10   6.86011391866786E-10  -1.27494009224281E-18  -1.05800562786212E-02  -1.05800562787903E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69140222652891E-10   0.00000000000000E+00   1.69140222652891E-10
      4.55941223427554E-18  -5.22921114140793E-01  -5.22651681724675E-01   0.00000000000000E+00  -8.70562237932256E-11
     -1.83545503482418E-22  -7.68095390726301E-10  -8.55151614519711E-10  -3.28447214203273E-18
      6.30208244323274E-09
      0.00000000000000E+00  -2.58441906028260E-12   0.00000000000000E+00   5.08992968342543E-12  -4.67271584236529E-23
      2.57936688524728E-09   2.58445681493066E-09  -1.22258928611025E-18  -4.10953071695345E-02  -4.10953071666625E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.87202988262194E-09   0.00000000000000E+00  -2.87202988262194E-09
      4.50197163662310E-18  -5.43901699080993E-01  -5.43992348477354E-01   0.00000000000000E+00   8.56549866658983E-11
     -1.81288750568840E-22   2.01918081025617E-10   2.87573067691334E-10  -3.27938235051285E-18
      6.30458244323274E-09
      0.00000000000000E+00  -3.12272106505591E-12   0.00000000000000E+00   1.09540369818568E-11  -4.65527844310492E-23
      3.11174385525919E-09   3.12269789224100E-09  -1.21471181005530E-18  -4.56137623961321E-02  -4.56137623924357E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.69636294835415E-09   0.00000000000000E+00  -3.69636294835415E-09
      4.49273072925222E-18  -5.46543124930464E-01  -5.46723924312796E-01   0.00000000000000E+00   1.29026878964878E-10
     -1.80864458653169E-22   4.44638177148907E-10   5.73665056113603E-10  -3.27801891919691E-18
      6.30795744323274E-09
      0.00000000000000E+00  -3.56578007734502E-12   0.00000000000000E+00   7.03304265119034E-12  -4.63135950811255E-23
      3.55880198727449E-09   3.56583502992563E-09  -1.20261036563214E-18  -5.24867875090527E-02  -5.24867875046623E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.39043502289989E-09   0.00000000000000E+00  -4.39043502289989E-09
      4.47791301104993E-18  -5.50162106894418E-01  -5.50421977263151E-01   0.00000000000000E+00   1.63272265104734E-10
     -1.80133221762823E-22   6.61327727869794E-10   8.24599992974348E-10  -3.27530264541779E-18
      6.31251369323274E-09
      0.00000000000000E+00  -4.09434653997433E-12   0.00000000000000E+00   6.27163751707777E-12  -4.59544384722104E-23
      4.08804854400548E-09   4.09432018152251E-09  -1.18394296240842E-18  -6.29668203567949E-02  -6.29668203516017E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.19317816415172E-09   0.00000000000000E+00  -5.19317816415172E-09
      4.45425159303951E-18  -5.55117450911259E-01  -5.55463741999637E-01   0.00000000000000E+00   2.01233392853257E-10
     -1.78906856685222E-22   8.97624589776146E-10   1.09885798262922E-09  -3.27030863063109E-18
      6.31866463073274E-09
      0.00000000000000E+00  -4.79484635065614E-12   0.00000000000000E+00   6.20046696617501E-12  -4.54037759821899E-23
      4.78862243425210E-09   4.79482290121823E-09  -1.15467605448985E-18  -7.91096098131790E-02  -7.91096098069627E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.21628960358131E-09   0.00000000000000E+00  -6.21628960358131E-09
      4.41601558420598E-18  -5.61900301521093E-01  -5.62348251122868E-01   0.00000000000000E+00   2.45479273603173E-10
     -1.76864613668359E-22   1.17598742875996E-09   1.42146670236296E-09  -3.26133952971614E-18
      6.32281651354524E-09
      0.00000000000000E+00  -5.33590369754568E-12   0.00000000000000E+00   7.01101927892253E-12  -4.49955397490251E-23
      5.32886416127176E-09   5.33587518055063E-09  -1.13285714856702E-18  -9.09265116273373E-02  -9.09265116203694E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.96791374624184E-09   0.00000000000000E+00  -6.96791374624184E-09
      4.38708562288398E-18  -5.66507854841127E-01  -5.67022159050959E-01   0.00000000000000E+00   2.72442468889949E-10
     -1.75318084672361E-22   1.35959609680162E-09   1.63203856569139E-09  -3.25422847431695E-18
      6.32561903444368E-09
      0.00000000000000E+00  -5.69768011740613E-12   0.00000000000000E+00   6.96170840469698E-12  -4.47065098553028E-23
      5.69072592333314E-09   5.69768763173779E-09  -1.11723284686843E-18  -9.92734956332042E-02  -9.92734956257560E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.44818549310715E-09   0.00000000000000E+00  -7.44818549310715E-09
      4.36621192738410E-18  -5.69622880188748E-01  -5.70174513950653E-01   0.00000000000000E+00   2.87060198934451E-10
     -1.74209152198761E-22   1.46343766243397E-09   1.75049786136824E-09  -3.24897908051568E-18
      6.32940243765657E-09
      0.00000000000000E+00  -6.08985714528227E-12   0.00000000000000E+00   5.71904485211260E-12  -4.43020782171974E-23
      6.08415966168642E-09   6.08987870653849E-09  -1.09495533321093E-18  -1.11003688773245E-01  -1.11003688765322E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.92354787701011E-09   0.00000000000000E+00  -7.92354787701011E-09
      4.33623395088873E-18  -5.73813568870009E-01  -5.74391417601988E-01   0.00000000000000E+00   3.00055630239992E-10
     -1.72630177061972E-22   1.53361354023172E-09   1.83366917047154E-09  -3.24127861767780E-18
      6.33451003199397E-09
      0.00000000000000E+00  -6.53594703389923E-12   0.00000000000000E+00   4.88373848728336E-12  -4.37165056257063E-23
      6.53104803259106E-09   6.53593177107830E-09  -1.06345086396073E-18  -1.27266158696398E-01  -1.27266158688052E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34667445169791E-09   0.00000000000000E+00  -8.34667445169791E-09
      4.29360252372310E-18  -5.79381456565326E-01  -5.79952098478807E-01   0.00000000000000E+00   3.06118720861883E-10
     -1.70429017767480E-22   1.50462395975798E-09   1.81074268061970E-09  -3.23015165976237E-18
      6.34140528434946E-09
      0.00000000000000E+00  -7.14405103895026E-12   0.00000000000000E+00   4.87326640874008E-12  -4.27238214453414E-23
      7.13920266221438E-09   7.14407592862308E-09  -1.01947193083265E-18  -1.49366754989550E-01  -1.49366754980874E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67636604882615E-09   0.00000000000000E+00  -8.67636604882615E-09
      4.23377679028781E-18  -5.86592181122357E-01  -5.87075126346362E-01   0.00000000000000E+00   3.02805490578121E-10
     -1.67442754764007E-22   1.22948462962507E-09   1.53229012020303E-09  -3.21430485945516E-18
      6.35071387502938E-09
      0.00000000000000E+00  -8.35557496745475E-12   0.00000000000000E+00   6.86300552625714E-12  -4.00864462293488E-23
      8.34873855955600E-09   8.35560156508222E-09  -9.59181652639846E-19  -1.78621248370540E-01  -1.78621248361623E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91683860981131E-09   0.00000000000000E+00  -8.91683860981131E-09
      4.15077358951021E-18  -5.95301771755847E-01  -5.95478861633390E-01   0.00000000000000E+00   2.91496315643733E-10
     -1.63479173615481E-22   2.69740729085488E-10   5.61237044729057E-10  -3.19159193687036E-18
      6.36328047244726E-09
      0.00000000000000E+00  -1.17890067784837E-11   0.00000000000000E+00   1.38135397012112E-11  -2.87943903796298E-23
      1.17751681367268E-08   1.17889816764280E-08  -8.79299119772887E-19  -2.15744361987637E-01  -2.15744361978491E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14599647281731E-09   0.00000000000000E+00  -9.14599647281731E-09
      4.03583953385091E-18  -6.03152835991766E-01  -6.02320652190663E-01   0.00000000000000E+00   2.80917273987003E-10
     -1.58152307617965E-22  -2.92390247759741E-09  -2.64298520361057E-09  -3.15654041407802E-18
      6.38024537896141E-09
      0.00000000000000E+00  -2.21864739435362E-11   0.00000000000000E+00   3.04597642220272E-11   1.89656142704053E-23
      2.21559654321121E-08   2.21864251963341E-08  -7.82675481069976E-19  -2.58718344711553E-01  -2.58718344702005E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54823163664647E-09   0.00000000000000E+00  -9.54823163664647E-09
      3.87385467675978E-18  -5.98405180145996E-01  -5.94424528772084E-01   0.00000000000000E+00   2.92170525682788E-10
     -1.50176053747652E-22  -1.29303640853704E-08  -1.26381935596877E-08  -3.09117919568981E-18
      6.40024537896141E-09
      0.00000000000000E+00  -4.16645384315596E-11   0.00000000000000E+00   4.82807545809480E-11   1.12153909210369E-22
      4.16162340105374E-08   4.16645147651184E-08  -6.96198943642354E-19  -2.96512472469222E-01  -2.96512472459019E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02023985006271E-08   0.00000000000000E+00  -1.02023985006271E-08
      3.66980670674724E-18  -5.58745938976931E-01  -5.48835258091733E-01   0.00000000000000E+00   3.18772398110314E-10
     -1.38228518836447E-22  -3.17808886626014E-08  -3.14621162644913E-08  -2.97360776310488E-18
      6.42024537896141E-09
      0.00000000000000E+00  -5.95898757923526E-11   0.00000000000000E+00   4.45551856342910E-11   1.96849476218529E-22
      5.95452622793576E-08   5.95898174649921E-08  -6.39708670306304E-19  -3.22035987194219E-01  -3.22035987183370E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08489977299388E-08   0.00000000000000E+00  -1.08489977299388E-08
      3.45282675214846E-18  -4.82645480548201E-01  -4.67290828592383E-01   0.00000000000000E+00   3.05075925219188E-10
     -1.22998984437218E-22  -4.90458956602724E-08  -4.87408197350533E-08  -2.81311808184216E-18
      6.44024537896141E-09
      0.00000000000000E+00  -6.61039637787965E-11   0.00000000000000E+00   1.63004208344226E-11   2.27196593979147E-22
      6.60876375832377E-08   6.61039380040724E-08  -6.09664938541963E-19  -3.37250506600363E-01  -3.37250506588950E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14136124555750E-08   0.00000000000000E+00  -1.14136124555750E-08
      3.22455450303696E-18  -3.74714568825278E-01  -3.57484769438858E-01   0.00000000000000E+00   2.59797928150980E-10
     -1.06556878929197E-22  -5.49501234766483E-08  -5.46903255484974E-08  -2.61488956449500E-18
      6.46024537896141E-09
      0.00000000000000E+00  -5.92037605171322E-11   0.00000000000000E+00  -1.70582906131398E-11   1.96943922580302E-22
      5.92207504000959E-08   5.92036921094830E-08  -5.99990496661278E-19  -3.44629851881924E-01  -3.44629851870052E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18713245112899E-08   0.00000000000000E+00  -1.18713245112899E-08
      2.98712801281116E-18  -2.49468903480009E-01  -2.34556670616445E-01   0.00000000000000E+00   1.95719071329085E-10
     -8.98655076530190E-23  -4.75280866695220E-08  -4.73323675981930E-08  -2.38713751614989E-18
      6.48024537896141E-09
      0.00000000000000E+00  -5.11677133904224E-11   0.00000000000000E+00  -1.99339989699683E-11   1.55009729220884E-22
      5.11876545418369E-08   5.11677205428671E-08  -5.92359269413261E-19  -3.51301962040166E-01  -3.51301962028280E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18857487486107E-08   0.00000000000000E+00  -1.18857487486107E-08
      2.74941303783895E-18  -1.40862673872289E-01  -1.28486482073593E-01   0.00000000000000E+00   1.09456217575598E-10
     -7.72608379923616E-23  -3.93914280118319E-08  -3.92819717942564E-08  -2.15705376842569E-18
      6.50024537896141E-09
      0.00000000000000E+00  -4.44024300477160E-11   0.00000000000000E+00  -1.67622450303755E-11   1.25154059231935E-22
      4.44191676737504E-08   4.44024054287201E-08  -5.74840802599268E-19  -3.61526633861987E-01  -3.61526633850411E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15761415295420E-08   0.00000000000000E+00  -1.15761415295420E-08
      2.51789020724811E-18  -6.31894458382025E-02  -5.28470701231344E-02   0.00000000000000E+00   5.82026639344899E-11
     -3.74111815292880E-23  -3.28844665631126E-08  -3.28262638991782E-08  -1.94304940464884E-18
      6.50274537896141E-09
      0.00000000000000E+00  -4.23123193630843E-11   0.00000000000000E+00  -4.09239201924072E-11   1.21123233747484E-22
      4.23532582840115E-08   4.23123343638192E-08  -5.72187141224915E-19  -3.62896822222411E-01  -3.62896822210884E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15273176650431E-08   0.00000000000000E+00  -1.15273176650431E-08
      2.48907191308550E-18  -5.47505816334604E-02  -4.50513212995364E-02   0.00000000000000E+00   6.85442130051253E-11
     -2.33178094232640E-23  -3.08535609117813E-08  -3.07850166987762E-08  -1.91688477186059E-18
      6.50612037896141E-09
      0.00000000000000E+00  -3.99671558432273E-11   0.00000000000000E+00  -3.44811916612002E-11   1.17735178562677E-22
      4.00016628090077E-08   3.99671816173466E-08  -5.66787332530618E-19  -3.65388519863487E-01  -3.65388519852185E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13014767792458E-08   0.00000000000000E+00  -1.13014767792458E-08
      2.45092942895555E-18  -4.57958750565078E-02  -3.67643205290783E-02   0.00000000000000E+00   5.41666641713805E-11
     -6.54521420421071E-25  -2.87198715022717E-08  -2.86657048381003E-08  -1.88414209642493E-18
      6.51067662896141E-09
      0.00000000000000E+00  -3.74548349016527E-11   0.00000000000000E+00  -2.73341353599977E-11   1.17259118248835E-22
      3.74822054427759E-08   3.74548713074160E-08  -5.56728982322420E-19  -3.69712678762035E-01  -3.69712678751042E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09930019374217E-08   0.00000000000000E+00  -1.09930019374217E-08
      2.40084256387817E-18  -3.71923989494047E-02  -2.88551822982371E-02   0.00000000000000E+00   4.18730215230233E-11
      3.00940109254319E-23  -2.65037423915172E-08  -2.64618693699942E-08  -1.84411358155575E-18
      6.51682756646141E-09
      0.00000000000000E+00  -3.51170189607723E-11   0.00000000000000E+00  -1.88246119581367E-11   1.21504524661985E-22
      3.51358463053941E-08   3.51170216934360E-08  -5.39989782195388E-19  -3.76642500461029E-01  -3.76642500450346E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06822809147810E-08   0.00000000000000E+00  -1.06822809147810E-08
      2.33513652161391E-18  -2.98173198690619E-02  -2.21187683738198E-02   0.00000000000000E+00   2.98736756026132E-11
      6.71130809298855E-23  -2.44646144542578E-08  -2.44347407786551E-08  -1.79514673941852E-18
      6.52513133208641E-09
      0.00000000000000E+00  -3.32740624639660E-11   0.00000000000000E+00  -1.09682523418394E-11   1.30460429734297E-22
      3.32849789010349E-08   3.32740106486932E-08  -5.14898218212900E-19  -3.86852715192650E-01  -3.86852715182219E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04314195131205E-08   0.00000000000000E+00  -1.04314195131205E-08
      2.24851645884091E-18  -2.40627795668643E-02  -1.68658482304013E-02   0.00000000000000E+00   1.97683122513192E-11
      1.08253674340725E-22  -2.28623594478240E-08  -2.28425911355726E-08  -1.73361824062801E-18
      6.53634141568016E-09
      0.00000000000000E+00  -3.19384562954942E-11   0.00000000000000E+00  -5.85766820230449E-12   1.40549121597319E-22
      3.19442789080187E-08   3.19384212398165E-08  -4.80275244656106E-19  -4.00881609269377E-01  -4.00881609259125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02515427183644E-08   0.00000000000000E+00  -1.02515427183644E-08
      2.13359580800314E-18  -1.97409461574950E-02  -1.29081305521465E-02   0.00000000000000E+00   1.30429817293007E-11
      1.48339940185885E-22  -2.16999215031816E-08  -2.16868785214522E-08  -1.65332056334704E-18
      6.55147502853172E-09
      0.00000000000000E+00  -3.08239204094808E-11   0.00000000000000E+00  -3.59749761390533E-12   1.43166367533018E-22
      3.08274770808567E-08   3.08238795832429E-08  -4.35196716492055E-19  -4.19250185892867E-01  -4.19250185882763E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01042130947762E-08   0.00000000000000E+00  -1.01042130947762E-08
      1.98068255885711E-18  -1.64293311791617E-02  -9.90124283496884E-03   0.00000000000000E+00   9.38186630375780E-12
      1.74813300163402E-22  -2.07290483547707E-08  -2.07196664884667E-08  -1.54548584236506E-18
      6.57147502853172E-09
      0.00000000000000E+00  -2.95650045965773E-11   0.00000000000000E+00  -3.06938162624915E-12   1.26783353224251E-22
      2.95680688522680E-08   2.95649994706419E-08  -3.79830025815004E-19  -4.42121980523702E-01  -4.42121980513761E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94151277953144E-09   0.00000000000000E+00  -9.94151277953144E-09
      1.78185230326648E-18  -1.37925493093427E-02  -7.60982331151991E-03   0.00000000000000E+00   7.60801260374998E-12
      1.68077098133539E-22  -1.96310947037144E-08  -1.96234866911104E-08  -1.40202227745148E-18
      6.59147502853173E-09
      0.00000000000000E+00  -2.83600016444145E-11   0.00000000000000E+00  -2.94137521136664E-12   9.68741198792023E-23
      2.83629520331499E-08   2.83600106579386E-08  -3.28632052473491E-19  -4.63631013732665E-01  -4.63631013722870E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79480624413830E-09   0.00000000000000E+00  -9.79480624413830E-09
      1.58595617838372E-18  -1.20443621147577E-02  -6.19506080897466E-03   0.00000000000000E+00   6.59185118097942E-12
      1.31665612490658E-22  -1.85717962649814E-08  -1.85652044138003E-08  -1.25732412591023E-18
      6.61147502853173E-09
      0.00000000000000E+00  -2.73837839326357E-11   0.00000000000000E+00  -2.38153760348243E-12   6.49077838001671E-23
      2.73861783955691E-08   2.73837968579657E-08  -2.80834828289221E-19  -4.84060997388913E-01  -4.84060997379247E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66598719866365E-09   0.00000000000000E+00  -9.66598719866365E-09
      1.39263643441044E-18  -1.08584126665337E-02  -5.27609364927802E-03   0.00000000000000E+00   5.45407697096025E-12
      8.66860634836590E-23  -1.77232637362731E-08  -1.77178096593021E-08  -1.11180160612122E-18
      6.63147502853173E-09
      0.00000000000000E+00  -2.65504766319518E-11   0.00000000000000E+00  -2.03168417325985E-12   3.88880599526952E-23
      2.65524642564687E-08   2.65504325722955E-08  -2.36180092423548E-19  -5.03490958039334E-01  -5.03490958029826E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50768242194542E-09   0.00000000000000E+00  -9.50768242194542E-09
      1.20248278597153E-18  -1.00094836658932E-02  -4.63985068976793E-03   0.00000000000000E+00   4.56567151030888E-12
      4.83957368193167E-23  -1.70473158218603E-08  -1.70427501503500E-08  -9.66302693547986E-19
      6.65147502853173E-09
      0.00000000000000E+00  -2.65699477162398E-11   0.00000000000000E+00   7.10207851808083E-14   2.18146794914158E-23
      2.65698617630634E-08   2.65699327838486E-08  -1.91760340887889E-19  -5.23248230842309E-01  -5.23248230832372E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93682181201879E-09   0.00000000000000E+00  -9.93682181201879E-09
      1.00374634973116E-18  -9.49283891685089E-03  -4.25226738508570E-03   0.00000000000000E+00   3.69674496568209E-12
      2.28391626710341E-23  -1.66368077167954E-08  -1.66331109718297E-08  -8.11986008843268E-19
      6.67147502853173E-09
      0.00000000000000E+00  -2.74883032435779E-11   0.00000000000000E+00   2.29044598727678E-12   1.23712515937169E-23
      2.74859824711444E-08   2.74882729171317E-08  -1.45769875046524E-19  -5.44243183700440E-01  -5.44243183689578E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08616936194132E-08   0.00000000000000E+00  -1.08616936194132E-08
      7.86512477342895E-19  -9.29669128239390E-03  -4.05817449994470E-03   0.00000000000000E+00   2.62932385438464E-12
      8.69985450506749E-24  -1.66292086215729E-08  -1.66265792977185E-08  -6.40742602296371E-19
      6.67397502853173E-09
      0.00000000000000E+00  -2.76757583522185E-11   0.00000000000000E+00   3.70393240286881E-12   1.12308126344939E-23
      2.76720303883591E-08   2.76757343207620E-08  -1.40077613848916E-19  -5.46886089272752E-01  -5.46886089261632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11200223542794E-08   0.00000000000000E+00  -1.11200223542794E-08
      7.58712421457196E-19  -9.25623650961497E-03  -4.04004799532331E-03   0.00000000000000E+00   3.88639498116899E-12
      6.94433326875662E-24  -1.65595983614641E-08  -1.65557119664830E-08  -6.18634807608280E-19
      6.67735002853173E-09
      0.00000000000000E+00  -2.79269537084810E-11   0.00000000000000E+00   3.70470670257736E-12   9.94873377872671E-24
      2.79232275775171E-08   2.79269322842196E-08  -1.32307110082180E-19  -5.50506962679844E-01  -5.50506962668509E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13341868889649E-08   0.00000000000000E+00  -1.13341868889649E-08
      7.20459540706939E-19  -9.25359009050707E-03  -4.02573248535892E-03   0.00000000000000E+00   1.99827715715815E-12
      5.02310518497819E-24  -1.65947436724119E-08  -1.65927453952547E-08  -5.88152430624759E-19
      6.68190627853173E-09
      0.00000000000000E+00  -2.82905670230856E-11   0.00000000000000E+00   3.96790077190264E-12   8.65113625362452E-24
      2.82865895514852E-08   2.82905574522571E-08  -1.21723668765063E-19  -5.55464899332182E-01  -5.55464899320623E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15587837431797E-08   0.00000000000000E+00  -1.15587837431797E-08
      6.67794832277077E-19  -9.28812594610881E-03  -4.01646398377406E-03   0.00000000000000E+00   1.01163769189994E-12
      3.09568601034436E-24  -1.67327853467690E-08  -1.67317737090771E-08  -5.46071163512013E-19
      6.68805721603173E-09
      0.00000000000000E+00  -2.87932332698224E-11   0.00000000000000E+00   4.06452320190065E-12   7.44861018246938E-24
      2.87891357827321E-08   2.87932003059340E-08  -1.07344880115793E-19  -5.62249956996290E-01  -5.62249956984478E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18117686718060E-08   0.00000000000000E+00  -1.18117686718060E-08
      5.95141381412340E-19  -9.36171268459199E-03  -4.01139035090871E-03   0.00000000000000E+00   4.90856264355407E-13
      1.32588244202925E-24  -1.69819224903920E-08  -1.69814316341277E-08  -4.87796501296545E-19
      6.69220909884423E-09
      0.00000000000000E+00  -2.91456415264877E-11   0.00000000000000E+00   4.22049495635107E-12   6.81886335420904E-24
      2.91414583609436E-08   2.91456788558999E-08  -9.76518481539526E-20  -5.66857311203976E-01  -5.66857311192003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19727332448376E-08   0.00000000000000E+00  -1.19727332448376E-08
      5.45431996034451E-19  -9.42280842362134E-03  -4.01214535732264E-03   0.00000000000000E+00   1.84645549803458E-13
      3.99478932812208E-25  -1.71731302566126E-08  -1.71729456110628E-08  -4.47780147880498E-19
      6.69781414064110E-09
      0.00000000000000E+00  -2.94634243172257E-11   0.00000000000000E+00   2.83976986187372E-12   6.19931295432645E-24
      2.94605819167596E-08   2.94634216866215E-08  -8.46646153611549E-20  -5.73063579095342E-01  -5.73063579083283E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20594785684446E-08   0.00000000000000E+00  -1.20594785684446E-08
      4.77838114609801E-19  -9.48159634290016E-03  -3.99815252183866E-03   0.00000000000000E+00   3.80928733219551E-13
     -4.52535355390054E-25  -1.74043240469100E-08  -1.74039431181768E-08  -3.93173499248645E-19
      6.70538094706688E-09
      0.00000000000000E+00  -2.95129286305806E-11   0.00000000000000E+00   3.63228024602237E-13   5.59624121841408E-24
      2.95125263632522E-08   2.95128895912768E-08  -6.76720656617122E-20  -5.81236153084982E-01  -5.81236153073063E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19193353155630E-08   0.00000000000000E+00  -1.19193353155630E-08
      3.87646811552957E-19  -9.48377277146512E-03  -3.94058770933013E-03   0.00000000000000E+00   1.07533589626245E-12
     -1.15152471349085E-24  -1.75946296116101E-08  -1.75935542757139E-08  -3.19974745891245E-19
      6.71559613574169E-09
      0.00000000000000E+00  -2.88580756542909E-11   0.00000000000000E+00  -3.13083246190842E-12   4.97097531155347E-24
      2.88611957748226E-08   2.88580649423607E-08  -4.66925651188144E-20  -5.91399741562517E-01  -5.91399741551347E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11700547691718E-08   0.00000000000000E+00  -1.11700547691718E-08
      2.73542594577965E-19  -9.37281027267287E-03  -3.79986413324664E-03   0.00000000000000E+00   1.63151743189966E-12
     -1.66577079267191E-24  -1.76896416906207E-08  -1.76880101731887E-08  -2.26850029459150E-19
      6.72938664045267E-09
      0.00000000000000E+00  -2.60817929379818E-11   0.00000000000000E+00  -9.91071621602555E-12   4.14758676924704E-24
      2.60916948189163E-08   2.60817841027003E-08  -2.60465268531875E-20  -6.01403034520201E-01  -6.01403034511818E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.38300930643956E-09   0.00000000000000E+00  -8.38300930643956E-09
      1.57936665245267E-19  -9.04703027446842E-03  -3.47069121336458E-03   0.00000000000000E+00   1.47164174651238E-12
     -2.03227531906622E-24  -1.77002464380072E-08  -1.76987747962607E-08  -1.31890138392079E-19
      6.74800382181251E-09
      0.00000000000000E+00  -1.62915113306083E-11   0.00000000000000E+00  -2.59281009223174E-11   2.49261144664472E-24
      1.63174632775108E-08   1.62915351765885E-08  -3.12155488055752E-20  -5.98296255742311E-01  -5.98296255743707E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39578332139717E-09   0.00000000000000E+00   1.39578332139717E-09
      1.83922216478746E-19  -8.16867491730904E-03  -2.59594400427018E-03   0.00000000000000E+00  -1.94864220303703E-13
     -2.43397056096158E-24  -1.76871236337655E-08  -1.76873184979858E-08  -1.52706667673172E-19
      6.76800382181251E-09
      0.00000000000000E+00   1.75809195962648E-12   0.00000000000000E+00  -4.44842602314283E-11  -6.21019295345542E-25
     -1.71361728104751E-09  -1.75810154127894E-09  -1.05049050123489E-19  -5.61639169452042E-01  -5.61639169471487E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94452917458869E-08   0.00000000000000E+00   1.94452917458869E-08
      5.72828051396483E-19  -6.63556178842962E-03  -1.06287030544085E-03   0.00000000000000E+00  -3.65675498747106E-12
     -3.64470905722619E-24  -1.76835334496204E-08  -1.76871902046078E-08  -4.67779001272995E-19
      6.78800382181251E-09
      0.00000000000000E+00   1.88163231564432E-11   0.00000000000000E+00  -4.21595258572040E-11  -7.34742133001332E-24
     -1.87741840995048E-08  -1.88163436253620E-08  -2.66261972111631E-19  -4.88293317410713E-01  -4.88293317447176E-01
      0.00000000000000E+00   0.00000000000000E+00   3.64628671924366E-08   0.00000000000000E+00   3.64628671924366E-08
      1.30208539524521E-18  -4.93037472239552E-03   6.29501339253026E-04   0.00000000000000E+00  -8.93384143729385E-12
     -1.10669045363105E-23  -1.76375897256372E-08  -1.76465235670745E-08  -1.03582342313358E-18
      6.80800382181251E-09
      0.00000000000000E+00   2.48013854565717E-11   0.00000000000000E+00  -1.50650849614874E-11  -2.85264009491451E-23
     -2.47863536757804E-08  -2.48014187607419E-08  -5.26191852764794E-19  -3.82636395396020E-01  -3.82636395438445E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24251895978986E-08   0.00000000000000E+00   4.24251895978986E-08
      2.15058918720319E-18  -3.02122925852910E-03   2.53146940114670E-03   0.00000000000000E+00  -1.99561900666409E-11
     -4.91532395307257E-23  -1.76038146470900E-08  -1.76237708371567E-08  -1.62439733443839E-18
      6.82800382181251E-09
      0.00000000000000E+00   1.73097020872909E-11   0.00000000000000E+00   1.79254775945499E-11  -4.17361265401897E-23
     -1.73276026430573E-08  -1.73096771654628E-08  -8.26106266535171E-19  -2.57640331622120E-01  -2.57640331656605E-01
      0.00000000000000E+00   0.00000000000000E+00   3.44853768070369E-08   0.00000000000000E+00   3.44853768070369E-08
      2.84029672334393E-18  -3.96310122562224E-03   1.44840666419699E-03   0.00000000000000E+00  -4.54271310688924E-11
     -7.74805843485077E-23  -1.71302725105052E-08  -1.71756996415741E-08  -2.01419045680876E-18
      6.84800382181251E-09
      0.00000000000000E+00   1.12731148895890E-11   0.00000000000000E+00   1.41469167212224E-11  -4.50213146826932E-23
     -1.12872354193810E-08  -1.12730885026598E-08  -1.04964158705037E-18  -1.47507128572567E-01  -1.47507128597751E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51837401985306E-08   0.00000000000000E+00   2.51837401985306E-08
      3.34397152731454E-18  -2.71172697164121E-02  -2.27344808423615E-02   0.00000000000000E+00  -8.67121603781096E-11
     -9.01428463925736E-23  -1.38239395354926E-08  -1.39106516958708E-08  -2.29432994026417E-18
      6.85800382181251E-09
      0.00000000000000E+00   8.70605448463867E-12   0.00000000000000E+00   1.17624201392726E-11  -4.63042632312155E-23
     -8.71779666044490E-09  -8.70603424030567E-09  -1.13615632316328E-18  -1.00065460194463E-01  -1.00065460215055E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05918940096592E-08   0.00000000000000E+00   2.05918940096592E-08
      3.54989046741113E-18  -4.51001478500081E-02  -4.13552862316242E-02   0.00000000000000E+00  -1.35047489753567E-10
     -9.69034102577228E-23  -1.17508122795998E-08  -1.18858597693535E-08  -2.41373414424785E-18
      6.86137882181251E-09
      0.00000000000000E+00   7.68262857793520E-12   0.00000000000000E+00   1.39726327848198E-11  -4.66802533111359E-23
     -7.69658214373656E-09  -7.68260951095179E-09  -1.16188250433464E-18  -8.53889725689116E-02  -8.53889725876580E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87464080550967E-08   0.00000000000000E+00   1.87464080550967E-08
      3.61315959459708E-18  -5.20114090328041E-02  -4.85255382706997E-02   0.00000000000000E+00  -1.58412968029217E-10
     -9.92083539583911E-23  -1.09053855761157E-08  -1.10637985441450E-08  -2.45127709026244E-18
      6.86593507181251E-09
      0.00000000000000E+00   6.44015297299178E-12   0.00000000000000E+00   1.25962460938606E-11  -4.71055821117047E-23
     -6.45275055581427E-09  -6.44015430972046E-09  -1.19092008574914E-18  -6.84402512556176E-02  -6.84402512722159E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65983281865918E-08   0.00000000000000E+00   1.65983281865918E-08
      3.68878572739724E-18  -6.25341392946685E-02  -5.93336012218398E-02   0.00000000000000E+00  -1.68353971904807E-10
     -1.02219518672326E-22  -9.98981990496662E-09  -1.01581738768715E-08  -2.49786564164810E-18
      6.87208600931251E-09
      0.00000000000000E+00   4.80430635858852E-12   0.00000000000000E+00   1.24157580561268E-11  -4.75097545219238E-23
     -4.81669221302733E-09  -4.80427645497125E-09  -1.22003234045522E-18  -5.09952545986725E-02  -5.09952546124627E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37901439817760E-08   0.00000000000000E+00   1.37901439817760E-08
      3.77360804114515E-18  -7.87067236365698E-02  -7.58755432535311E-02   0.00000000000000E+00  -1.73249746547317E-10
     -1.06040812565679E-22  -8.81261778025712E-09  -8.98586752680454E-09  -2.55357570068993E-18
      6.87623789212501E-09
      0.00000000000000E+00   3.62970401444146E-12   0.00000000000000E+00   1.33789682071897E-11  -4.76937128683387E-23
     -3.64303999825802E-09  -3.62966103005088E-09  -1.23480103105523E-18  -4.19493479930900E-02  -4.19493480048421E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17521701634529E-08   0.00000000000000E+00   1.17521701634529E-08
      3.82240167445636E-18  -9.05345316141384E-02  -8.79753651092847E-02   0.00000000000000E+00  -1.76811992288076E-10
     -1.08503736823509E-22  -7.94569714111414E-09  -8.12250913340232E-09  -2.58760064340113E-18
      6.87904041302344E-09
      0.00000000000000E+00   2.88484319568842E-12   0.00000000000000E+00   1.26618984733747E-11  -4.77844275283743E-23
     -2.89748152540901E-09  -2.88481962693568E-09  -1.24268124730930E-18  -3.70441705603470E-02  -3.70441705707936E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04466304986308E-08   0.00000000000000E+00   1.04466304986308E-08
      3.85167857474703E-18  -9.88861308694141E-02  -9.65036207675527E-02   0.00000000000000E+00  -1.78263550750204E-10
     -1.10109091124864E-22  -7.38354732094476E-09  -7.56181087169507E-09  -2.60899732743773E-18
      6.88282381623633E-09
      0.00000000000000E+00   2.12326663476360E-12   0.00000000000000E+00   9.62926173080229E-12  -4.78705874949845E-23
     -2.13283720833872E-09  -2.12320794660797E-09  -1.25043739092590E-18  -3.21067782771287E-02  -3.21067782862232E-02
      0.00000000000000E+00   0.00000000000000E+00   9.09446521194999E-09   0.00000000000000E+00   9.09446521194999E-09
      3.88608660364944E-18  -1.10620242515203E-01  -1.08423797721138E-01   0.00000000000000E+00  -1.77816370305236E-10
     -1.12177673856323E-22  -6.79344089503666E-09  -6.97125726534201E-09  -2.63564921272354E-18
      6.88793141057374E-09
      0.00000000000000E+00   1.44352373469070E-12   0.00000000000000E+00   6.36892619920219E-12  -4.79455356624299E-23
     -1.44986818423722E-09  -1.44349925803806E-09  -1.25743767664209E-18  -2.74914268161434E-02  -2.74914268239732E-02
      0.00000000000000E+00   0.00000000000000E+00   7.82985232210478E-09   0.00000000000000E+00   7.82985232210478E-09
      3.92607831303252E-18  -1.26887233926748E-01  -1.24875074459424E-01   0.00000000000000E+00  -1.78969341022691E-10
     -1.14847199277251E-22  -6.20738372304384E-09  -6.38635306406664E-09  -2.66864063639043E-18
      6.89482666292923E-09
      0.00000000000000E+00   9.17345235228777E-13   0.00000000000000E+00   3.64727554428783E-12  -4.80058466819142E-23
     -9.20994146668982E-10  -9.17346871124743E-10  -1.26326535556787E-18  -2.34284338487301E-02  -2.34284338554830E-02
      0.00000000000000E+00   0.00000000000000E+00   6.75289712037651E-09   0.00000000000000E+00   6.75289712037651E-09
      3.97264124280820E-18  -1.48995515548958E-01  -1.47156896809840E-01   0.00000000000000E+00  -1.83105982046751E-10
     -1.18317118344645E-22  -5.65244426720476E-09  -5.83555024925163E-09  -2.70937588724033E-18
      6.90413525360914E-09
      0.00000000000000E+00   5.59793673279876E-13   0.00000000000000E+00   1.83141593693187E-12  -4.80507533261263E-23
     -5.61588261877880E-10  -5.59756845940996E-10  -1.26781678588487E-18  -1.99678123155793E-02  -1.99678123214413E-02
      0.00000000000000E+00   0.00000000000000E+00   5.86197348132520E-09   0.00000000000000E+00   5.86197348132520E-09
      4.02720795452238E-18  -1.78265119184067E-01  -1.76594536738632E-01   0.00000000000000E+00  -1.90438426121728E-10
     -1.22847714623411E-22  -5.11177820926250E-09  -5.30221663538435E-09  -2.75939116863751E-18
      6.91670185102703E-09
      0.00000000000000E+00   3.40284751353887E-13   0.00000000000000E+00   8.31266075318738E-13  -4.80808906664720E-23
     -3.41113166348799E-10  -3.40281900273528E-10  -1.27122707574692E-18  -1.70396306563823E-02  -1.70396306614247E-02
      0.00000000000000E+00   0.00000000000000E+00   5.04233291920407E-09   0.00000000000000E+00   5.04233291920407E-09
      4.09057292236497E-18  -2.15419932419307E-01  -2.13938442575208E-01   0.00000000000000E+00  -1.98022441430647E-10
     -1.28673922932648E-22  -4.50402857749977E-09  -4.70205101893055E-09  -2.81934584661805E-18
      6.93366675754118E-09
      0.00000000000000E+00   2.21345816670139E-13   0.00000000000000E+00   3.34052861109138E-13  -4.80993614903847E-23
     -2.21640206993945E-10  -2.21306154132884E-10  -1.27384958680701E-18  -1.45210142204566E-02  -1.45210142245488E-02
      0.00000000000000E+00   0.00000000000000E+00   4.09218795501022E-09   0.00000000000000E+00   4.09218795501022E-09
      4.15999650846004E-18  -2.58457835347713E-01  -2.57238220931379E-01   0.00000000000000E+00  -1.93982450747013E-10
     -1.35645528423024E-22  -3.67689935013014E-09  -3.87088180087729E-09  -2.88614692165303E-18
      6.95366675754118E-09
      0.00000000000000E+00   1.68718782250227E-13   0.00000000000000E+00   1.25556827627901E-13  -4.81098394416833E-23
     -1.68881794895538E-10  -1.68756238067958E-10  -1.27592780846735E-18  -1.25474146553386E-02  -1.25474146583458E-02
      0.00000000000000E+00   0.00000000000000E+00   3.00721700847927E-09   0.00000000000000E+00   3.00721700847927E-09
      4.22014084862962E-18  -2.96332594709576E-01  -2.95438266307691E-01   0.00000000000000E+00  -1.65213167320585E-10
     -1.42021935099231E-22  -2.67324760309057E-09  -2.83846077041130E-09  -2.94421304016227E-18
      6.97366675754118E-09
      0.00000000000000E+00   1.43553324255364E-13   0.00000000000000E+00   6.17240107636745E-14  -4.81140232320679E-23
     -1.43574843924172E-10  -1.43513119913457E-10  -1.27752705614278E-18  -1.12050913727006E-02  -1.12050913747794E-02
      0.00000000000000E+00   0.00000000000000E+00   2.07880601629698E-09   0.00000000000000E+00   2.07880601629698E-09
      4.26171696895556E-18  -3.21922313456024E-01  -3.21312550728671E-01   0.00000000000000E+00  -1.22503520592937E-10
     -1.46442601152306E-22  -1.81278937579039E-09  -1.93529289638348E-09  -2.98418991281279E-18
      6.99366675754118E-09
      0.00000000000000E+00   1.31889042630008E-13   0.00000000000000E+00   2.95477012183747E-14  -4.81155592999597E-23
     -1.31920164782392E-10  -1.31890617081222E-10  -1.27891093084242E-18  -1.02647721716370E-02  -1.02647721729865E-02
      0.00000000000000E+00   0.00000000000000E+00   1.34948772973107E-09   0.00000000000000E+00   1.34948772973107E-09
      4.28870672355018E-18  -3.37192075315808E-01  -3.36808444362081E-01   0.00000000000000E+00  -7.62110533035802E-11
     -1.49088107222500E-22  -1.14138605934622E-09  -1.21759711264995E-09  -3.00979579270776E-18
      7.01366675754118E-09
      0.00000000000000E+00   1.24082239967369E-13   0.00000000000000E+00   2.09917497450851E-14  -4.81150335285902E-23
     -1.24086143596223E-10  -1.24065151846526E-10  -1.28014912065067E-18  -9.61235921603497E-03  -9.61235921684334E-03
      0.00000000000000E+00   0.00000000000000E+00   8.08376704490950E-10   0.00000000000000E+00   8.08376704490950E-10
      4.30487425764000E-18  -3.44599199742347E-01  -3.44383598398528E-01   0.00000000000000E+00  -3.58810294968170E-11
     -1.50316468736287E-22  -6.48430523147395E-10  -6.84311552644362E-10  -3.02472513698933E-18
      7.03366675754118E-09
      0.00000000000000E+00   9.25794951051870E-14   0.00000000000000E+00   8.41708092406344E-14  -4.81022990980755E-23
     -9.26742443337379E-11  -9.25900735245454E-11  -1.28076885402579E-18  -9.34867702875633E-03  -9.34867702945003E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93690880930683E-10   0.00000000000000E+00   6.93690880930683E-10
      4.31874807525861E-18  -3.51267227577194E-01  -3.51077844225367E-01   0.00000000000000E+00  -3.10165095170938E-11
     -1.51351610713062E-22  -5.70084297888958E-10  -6.01100807406203E-10  -3.03797922123282E-18
      7.04366675754118E-09
      0.00000000000000E+00   8.01804555821709E-14   0.00000000000000E+00   6.99400394849193E-14  -4.80940626290626E-23
     -8.02437889108498E-11  -8.01738488714130E-11  -1.28095751544015E-18  -9.27999274216502E-03  -9.27999274287233E-03
      0.00000000000000E+00   0.00000000000000E+00   7.07306535029746E-10   0.00000000000000E+00   7.07306535029746E-10
      4.32582114060891E-18  -3.54898828620296E-01  -3.54701242683309E-01   0.00000000000000E+00  -3.42095675329446E-11
     -1.51912845790582E-22  -5.92923118625262E-10  -6.27132686158358E-10  -3.04486362516876E-18
      7.05041675754118E-09
      0.00000000000000E+00   6.09849055057978E-14   0.00000000000000E+00   1.51367781407693E-13  -4.80855754300499E-23
     -6.11396704333180E-11  -6.09883026519584E-11  -1.28095698556649E-18  -9.28951488434320E-03  -9.28951488517086E-03
      0.00000000000000E+00   0.00000000000000E+00   8.27663847532037E-10   0.00000000000000E+00   8.27663847532037E-10
      4.33140787157975E-18  -3.58189528664201E-01  -3.57947974108245E-01   0.00000000000000E+00  -4.77350810315966E-11
     -1.52433402766903E-22  -7.18940463848371E-10  -7.66675544880120E-10  -3.05045088601327E-18
      7.05952925754118E-09
      0.00000000000000E+00   3.50846896132752E-14   0.00000000000000E+00   1.56480092882230E-13  -4.80700885573092E-23
     -3.51953414106368E-11  -3.50388613178026E-11  -1.28072384755959E-18  -9.37281891327251E-03  -9.37281891442481E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15230372476261E-09   0.00000000000000E+00   1.15230372476261E-09
      4.34190823927165E-18  -3.65281292623135E-01  -3.64929271403444E-01   0.00000000000000E+00  -8.06277633574637E-11
     -1.53606548445142E-22  -1.03663710008709E-09  -1.11726486344470E-09  -3.06118439171207E-18
      7.06260472629118E-09
      0.00000000000000E+00   2.06650658716935E-14   0.00000000000000E+00   2.47262705054442E-13  -4.80637293802867E-23
     -2.09236755513709E-11  -2.06764128463646E-11  -1.28060151051605E-18  -9.41736918657501E-03  -9.41736918786380E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28879400943424E-09   0.00000000000000E+00   1.28879400943424E-09
      4.34587188497285E-18  -3.68073231474289E-01  -3.67673677666567E-01   0.00000000000000E+00  -9.60624273523771E-11
     -1.54073949286948E-22  -1.17205516923432E-09  -1.26811759658685E-09  -3.06527037445680E-18
      7.06675660910368E-09
      0.00000000000000E+00   1.53380711136570E-14   0.00000000000000E+00   8.43948522450111E-14  -4.80557263889399E-23
     -1.54441880216512E-11  -1.53597931694542E-11  -1.28041533247534E-18  -9.47219668464839E-03  -9.47219668612720E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47880952300745E-09   0.00000000000000E+00   1.47880952300745E-09
      4.35201172881439E-18  -3.72482113308188E-01  -3.72021012541936E-01   0.00000000000000E+00  -1.14984188933039E-10
     -1.54825923848067E-22  -1.34846554090524E-09  -1.46344972983843E-09  -3.07159639633905E-18
      7.07236165090055E-09
      0.00000000000000E+00   2.43388553599946E-14   0.00000000000000E+00  -5.99944632756100E-14  -4.80468803154665E-23
     -2.42572184372394E-11  -2.43172129005630E-11  -1.28021622994486E-18  -9.49439100422303E-03  -9.49439100587794E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65490877571806E-09   0.00000000000000E+00   1.65490877571806E-09
      4.36128756167231E-18  -3.79109324522281E-01  -3.78595559445162E-01   0.00000000000000E+00  -1.31769198924754E-10
     -1.55982121273288E-22  -1.49882236389258E-09  -1.63059156281748E-09  -3.08107133172745E-18
      7.07992845732633E-09
      0.00000000000000E+00   3.83911001527462E-14   0.00000000000000E+00  -7.69538984370626E-14  -4.80370797075835E-23
     -3.83221045136476E-11  -3.83990584121327E-11  -1.28005775253449E-18  -9.44251349172566E-03  -9.44251349349053E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76487545350265E-09   0.00000000000000E+00   1.76487545350265E-09
      4.37464203259457E-18  -3.88543069182288E-01  -3.87999091903488E-01   0.00000000000000E+00  -1.43580113909596E-10
     -1.57664233518729E-22  -1.58289628118097E-09  -1.72647639509072E-09  -3.09458428006009E-18
      7.09014364600114E-09
      0.00000000000000E+00   5.38210160036107E-14   0.00000000000000E+00  -6.30791347167192E-14  -4.80267079577903E-23
     -5.37846416664766E-11  -5.38477208012413E-11  -1.28000829205137E-18  -9.26878695665783E-03  -9.26878695845598E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79815256311516E-09   0.00000000000000E+00   1.79815256311516E-09
      4.39301050029288E-18  -4.01349179172079E-01  -4.00799584070476E-01   0.00000000000000E+00  -1.50140874799827E-10
     -1.60000319211685E-22  -1.59416396751392E-09  -1.74430484231391E-09  -3.11300220824150E-18
      7.10393415071213E-09
      0.00000000000000E+00   7.77924924147752E-14   0.00000000000000E+00  -7.86390060878378E-14  -4.80191520129204E-23
     -7.77039311390518E-11  -7.77825701451876E-11  -1.28028286522345E-18  -8.83832662945145E-03  -8.83832663123576E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78430693418378E-09   0.00000000000000E+00   1.78430693418378E-09
      4.41761699347458E-18  -4.18118711654470E-01  -4.17581020174073E-01   0.00000000000000E+00  -1.53475605849439E-10
     -1.63155174424777E-22  -1.55304875818909E-09  -1.70652436403870E-09  -3.13733412825114E-18
      7.12255133207196E-09
      0.00000000000000E+00   1.22520879434841E-13   0.00000000000000E+00  -1.19935778862923E-13  -4.80250026331647E-23
     -1.22428855800455E-10  -1.22548791579365E-10  -1.28150447726151E-18  -7.77112269300405E-03  -7.77112269477089E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76683792641390E-09   0.00000000000000E+00   1.76683792641390E-09
      4.45051053558406E-18  -4.39530232818082E-01  -4.39012150083031E-01   0.00000000000000E+00  -1.56582478903336E-10
     -1.67384106026053E-22  -1.48770665593103E-09  -1.64428913483453E-09  -3.16900605832255E-18
      7.14255133207196E-09
      0.00000000000000E+00   1.65320526973548E-13   0.00000000000000E+00  -1.14978502642830E-13  -4.80464888235157E-23
     -1.65234328202461E-10  -1.65349306705152E-10  -1.28368944576975E-18  -6.13151714155694E-03  -6.13151714329958E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74264600549006E-09   0.00000000000000E+00   1.74264600549006E-09
      4.48536345569386E-18  -4.61176576585717E-01  -4.60679600776841E-01   0.00000000000000E+00  -1.60342270226459E-10
     -1.71899658788842E-22  -1.41695442855836E-09  -1.57729669878499E-09  -3.20167400992411E-18
      7.16255133207196E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.62575187195586E-14  -4.80681806399796E-23
     -1.71460677527792E-10  -1.71486935046560E-10  -1.28601214706144E-18  -4.43873005333206E-03  -4.43873005500519E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67312723243769E-09   0.00000000000000E+00   1.67312723243769E-09
      4.51882600034262E-18  -4.81719806883683E-01  -4.81246667822127E-01   0.00000000000000E+00  -1.62433755374037E-10
     -1.76344281103419E-22  -1.33920654201693E-09  -1.50164029739114E-09  -3.23281385328118E-18
      7.18255133207196E-09
      0.00000000000000E+00   2.16845424546971E-13   0.00000000000000E+00  -1.30833458894120E-13  -4.81086737510887E-23
     -2.16729324288458E-10  -2.16860157747400E-10  -1.28925391252549E-18  -2.21347292974659E-03  -2.21347293142390E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67730606334945E-09   0.00000000000000E+00   1.67730606334945E-09
      4.55237212160961E-18  -5.01260629663052E-01  -5.00800468457721E-01   0.00000000000000E+00  -1.68378384898152E-10
     -1.80826671766339E-22  -1.29206752070371E-09  -1.46044590560205E-09  -3.26311820908411E-18
      7.20255133207196E-09
      0.00000000000000E+00  -4.97798475664795E-13   0.00000000000000E+00   1.86203973651624E-12  -4.78505488312269E-23
      4.95959777557909E-10   4.97821817294378E-10  -1.27825335146852E-18  -8.61122939622364E-03  -8.61122939669845E-03
      0.00000000000000E+00   0.00000000000000E+00   4.74815834910977E-10   0.00000000000000E+00   4.74815834910977E-10
      4.56186843830782E-18  -5.20837027610015E-01  -5.20530574851550E-01   0.00000000000000E+00  -1.04450120055069E-10
     -1.83545856932658E-22  -8.68187532150074E-10  -9.72637652205327E-10  -3.28361508683931E-18
      7.22255133207196E-09
      0.00000000000000E+00  -2.41808824119976E-12   0.00000000000000E+00   5.12332032615188E-12  -4.68537180104221E-23
      2.41298138444579E-09   2.41810470477189E-09  -1.22916150176238E-18  -3.73242323421393E-02  -3.73242323395291E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.61017756366384E-09   0.00000000000000E+00  -2.61017756366384E-09
      4.50966488703455E-18  -5.41743740127919E-01  -5.41804296504960E-01   0.00000000000000E+00   7.13463746034616E-11
     -1.81668490818525E-22   1.20726484288661E-10   1.92072858891940E-10  -3.28050338527217E-18
      7.24255133207196E-09
      0.00000000000000E+00  -4.25645250114562E-12   0.00000000000000E+00   5.08155414100522E-12  -4.52813942218636E-23
      4.25136387922788E-09   4.25644543336883E-09  -1.14509514747869E-18  -8.42282667220806E-02  -8.42282667167105E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.37012705066478E-09   0.00000000000000E+00  -5.37012705066478E-09
      4.40226234602125E-18  -5.63320941344333E-01  -5.63671912086519E-01   0.00000000000000E+00   2.07710126706502E-10
     -1.76068848774231E-22   9.05971490589626E-10   1.11368161729595E-09  -3.25716719854256E-18
      7.24505133207196E-09
      0.00000000000000E+00  -4.88715031154971E-12   0.00000000000000E+00   1.28244591821603E-11  -4.50345637658319E-23
      4.87430027818609E-09   4.88712473736820E-09  -1.13307654611525E-18  -9.07357981202848E-02  -9.07357981140347E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.25007277374582E-09   0.00000000000000E+00  -6.25007277374582E-09
      4.38663716408689E-18  -5.66037339953256E-01  -5.66466853519137E-01   0.00000000000000E+00   2.37137195551373E-10
     -1.75259212698946E-22   1.12581084082509E-09   1.36294803637629E-09  -3.25356061797164E-18
      7.24842633207196E-09
      0.00000000000000E+00  -5.45190360063879E-12   0.00000000000000E+00   8.87566245262579E-12  -4.46963633026993E-23
      5.44304895453068E-09   5.45192461698326E-09  -1.11510960107938E-18  -1.00335475080234E-01  -1.00335475073188E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.04587232018244E-09   0.00000000000000E+00  -7.04587232018244E-09
      4.36285734500627E-18  -5.69750104730296E-01  -5.70252410596574E-01   0.00000000000000E+00   2.67961486144449E-10
     -1.74014193045038E-22   1.32598621705608E-09   1.59394770320036E-09  -3.24774774392689E-18
      7.25298258207196E-09
      0.00000000000000E+00  -6.01987145553013E-12   0.00000000000000E+00   6.74480630860741E-12  -4.42129311961167E-23
      6.01317153903050E-09   6.01991634533906E-09  -1.08872017588770E-18  -1.14197816775844E-01  -1.14197816768078E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.76679902245348E-09   0.00000000000000E+00  -7.76679902245348E-09
      4.32746986696022E-18  -5.74762257971748E-01  -5.75312763549887E-01   0.00000000000000E+00   2.91216014920959E-10
     -1.72167700676839E-22   1.45566666219373E-09   1.74688267711452E-09  -3.23874969107252E-18
      7.25913351957196E-09
      0.00000000000000E+00  -6.62319953424638E-12   0.00000000000000E+00   5.40057825446789E-12  -4.34872140889993E-23
      6.61778385458577E-09   6.62318443284019E-09  -1.05079503315779E-18  -1.33653458247077E-01  -1.33653458238737E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34036787560657E-09   0.00000000000000E+00  -8.34036787560657E-09
      4.27616878543036E-18  -5.81394398388940E-01  -5.81935570113316E-01   0.00000000000000E+00   3.01739587596337E-10
     -1.69547550321630E-22   1.41544385517065E-09   1.71718344276681E-09  -3.22537375227256E-18
      7.26743728519696E-09
      0.00000000000000E+00  -7.47129383762068E-12   0.00000000000000E+00   5.53574790838715E-12  -4.20604253316188E-23
      7.46574851756065E-09   7.47128426546900E-09  -9.97642550417689E-19  -1.60062961540764E-01  -1.60062961532034E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.73044606772795E-09   0.00000000000000E+00  -8.73044606772795E-09
      4.20367320748224E-18  -5.89813673205246E-01  -5.90210590231094E-01   0.00000000000000E+00   2.98043715000029E-10
     -1.65987032934061E-22   9.61118087259249E-10   1.25916180225911E-09  -3.20603065706455E-18
      7.27864736879071E-09
      0.00000000000000E+00  -9.43869995334311E-12   0.00000000000000E+00   9.05837925748266E-12  -3.70230710092430E-23
      9.42962652110831E-09   9.43868490036575E-09  -9.25344235981322E-19  -1.94541413092710E-01  -1.94541413083715E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.99477068480085E-09   0.00000000000000E+00  -8.99477068480085E-09
      4.10284107619901E-18  -5.99177764227615E-01  -5.99038252375854E-01   0.00000000000000E+00   2.85980856882952E-10
     -1.61251689297818E-22  -7.29895072447949E-10  -4.43914215565158E-10  -3.17749684021769E-18
      7.29378098164227E-09
      0.00000000000000E+00  -1.56253614516421E-11   0.00000000000000E+00   2.04460346526558E-11  -1.25251728852048E-23
      1.56049747065194E-08   1.56254207411720E-08  -8.32676760878817E-19  -2.36681338124963E-01  -2.36681338115663E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29968132373791E-09   0.00000000000000E+00  -9.29968132373791E-09
      3.96210329940265E-18  -6.03534364443023E-01  -6.01542145786904E-01   0.00000000000000E+00   2.82922682322218E-10
     -1.54631873561595E-22  -6.60866209975612E-09  -6.32573941743405E-09  -3.12942653852384E-18
      7.31378098164227E-09
      0.00000000000000E+00  -3.20940412803237E-11   0.00000000000000E+00   4.08135409229879E-11   6.62691731378727E-23
      3.20531452274722E-08   3.20939587683952E-08  -7.32359756084115E-19  -2.80687451296385E-01  -2.80687451286509E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87620209331144E-09   0.00000000000000E+00  -9.87620209331144E-09
      3.76457925753642E-18  -5.80818409780988E-01  -5.73820020490512E-01   0.00000000000000E+00   3.09956308918358E-10
     -1.44000999270554E-22  -2.25277129840020E-08  -2.22177566750838E-08  -3.03221950145231E-18
      7.33378098164227E-09
      0.00000000000000E+00  -5.21470538232663E-11   0.00000000000000E+00   4.97355885338307E-11   1.61664629763842E-22
      5.20972682967927E-08   5.21470038853267E-08  -6.62356505163420E-19  -3.11616568380501E-01  -3.11616568369938E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05624958664434E-08   0.00000000000000E+00  -1.05624958664434E-08
      3.55332934020756E-18  -5.21205581747858E-01  -5.08105750546009E-01   0.00000000000000E+00   3.15954689963411E-10
     -1.30277734641242E-22  -4.19004627088466E-08  -4.15845080188833E-08  -2.89097283504414E-18
      7.35378098164227E-09
      0.00000000000000E+00  -6.48686520633552E-11   0.00000000000000E+00   3.16992640049205E-11   2.20882722811496E-22
      6.48368997480547E-08   6.48685990120598E-08  -6.20490270000083E-19  -3.31417666352261E-01  -3.31417666341103E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11577081342753E-08   0.00000000000000E+00  -1.11577081342753E-08
      3.33017517752205E-18  -4.27371967666968E-01  -4.10451089866614E-01   0.00000000000000E+00   2.81524025013041E-10
     -1.14000537381093E-22  -5.39924149027974E-08  -5.37108908777845E-08  -2.70968490752197E-18
      7.37378098164227E-09
      0.00000000000000E+00  -6.32728497543745E-11   0.00000000000000E+00  -3.85848409307944E-12   2.14962063949418E-22
      6.32767414543818E-08   6.32728829702890E-08  -6.03114060622959E-19  -3.41747728729182E-01  -3.41747728717485E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16977744848615E-08   0.00000000000000E+00  -1.16977744848615E-08
      3.09621968782482E-18  -3.06293792872133E-01  -2.90045091451868E-01   0.00000000000000E+00   2.29191716163628E-10
     -9.76589354372724E-23  -5.18043002015912E-08  -5.15751084854277E-08  -2.49310562720187E-18
      7.39378098164227E-09
      0.00000000000000E+00  -5.44560305166635E-11   0.00000000000000E+00  -2.18498125271356E-11   1.73223163532360E-22
      5.44778818044296E-08   5.44560319919027E-08  -5.96335718756157E-19  -3.48054307867743E-01  -3.48054307855816E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19263202914210E-08   0.00000000000000E+00  -1.19263202914210E-08
      2.85769328199640E-18  -1.87508841522983E-01  -1.74109527994250E-01   0.00000000000000E+00   1.46698561571818E-10
     -8.20259511786896E-23  -4.26764102620533E-08  -4.25297117004816E-08  -2.26135756324025E-18
      7.41378098164227E-09
      0.00000000000000E+00  -4.76672349212320E-11   0.00000000000000E+00  -1.63415052722215E-11   1.35677965402635E-22
      4.76840168295796E-08   4.76676753243075E-08  -5.85523280608554E-19  -3.55937103577529E-01  -3.55937103565756E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17725995524741E-08   0.00000000000000E+00  -1.17725995524741E-08
      2.62224129094692E-18  -9.33815400910090E-02  -8.20725007113034E-02   0.00000000000000E+00   7.63444920800403E-11
     -6.64192113867485E-23  -3.59714202639134E-08  -3.58950757718335E-08  -2.03671801033837E-18
      7.42378098164227E-09
      0.00000000000000E+00  -4.28344566941091E-11   0.00000000000000E+00  -2.38970834906800E-11   1.21432465663598E-22
      4.28583111805860E-08   4.28344140970954E-08  -5.75206286709433E-19  -3.61517272283188E-01  -3.61517272271660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15281861531099E-08   0.00000000000000E+00  -1.15281861531099E-08
      2.50695942941582E-18  -5.84363714622991E-02  -4.85728975629036E-02   0.00000000000000E+00   5.60164671083674E-11
     -3.09617150961856E-23  -3.13622444110939E-08  -3.13062279439855E-08  -1.93175314270639E-18
      7.42715598164227E-09
      0.00000000000000E+00  -4.05656161508716E-11   0.00000000000000E+00  -3.31350159052833E-11   1.17861139961465E-22
      4.05987219152476E-08   4.05655868993424E-08  -5.70250292691919E-19  -3.63865923694216E-01  -3.63865923682860E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13557635714126E-08   0.00000000000000E+00  -1.13557635714126E-08
      2.46863372736231E-18  -4.88665719886359E-02  -3.96635890308352E-02   0.00000000000000E+00   5.54223413495096E-11
     -1.01054102137900E-23  -2.92652456692793E-08  -2.92098233279298E-08  -1.89838343467039E-18
      7.43171223164227E-09
      0.00000000000000E+00  -3.80316198513159E-11   0.00000000000000E+00  -2.75572498459761E-11   1.16785185427298E-22
      3.80591941985029E-08   3.80316369486571E-08  -5.60793951857355E-19  -3.67991719648889E-01  -3.67991719637828E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10612173583216E-08   0.00000000000000E+00  -1.10612173583216E-08
      2.41823605577345E-18  -3.94739173628001E-02  -3.09764776142314E-02   0.00000000000000E+00   4.36098298113395E-11
      2.06307926521758E-23  -2.70140294201468E-08  -2.69704195903354E-08  -1.85744210391610E-18
      7.43786316914227E-09
      0.00000000000000E+00  -3.55631088493892E-11   0.00000000000000E+00  -1.98726144276968E-11   1.20428340931362E-22
      3.55829710913338E-08   3.55630984769062E-08  -5.44603874329612E-19  -3.74739426416444E-01  -3.74739426405704E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07396267774570E-08   0.00000000000000E+00  -1.07396267774570E-08
      2.35217728269199E-18  -3.13058843742687E-02  -2.34848597572746E-02   0.00000000000000E+00   3.17464323521971E-11
      5.87336149585663E-23  -2.48552181318014E-08  -2.48234716994492E-08  -1.80757340836238E-18
      7.44616693476727E-09
      0.00000000000000E+00  -3.35536378440257E-11   0.00000000000000E+00  -1.19613860654980E-11   1.29248619988882E-22
      3.35655785843282E-08   3.35536171982628E-08  -5.19812796938273E-19  -3.84851463807601E-01  -3.84851463797133E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04680681425903E-08   0.00000000000000E+00  -1.04680681425903E-08
      2.26525289828939E-18  -2.49367571243372E-02  -1.76632798795765E-02   0.00000000000000E+00   2.11660971431323E-11
      1.01697665921925E-22  -2.31067151528159E-08  -2.30855490556727E-08  -1.74544010135111E-18
      7.45737701836102E-09
      0.00000000000000E+00  -3.20993682750818E-11   0.00000000000000E+00  -6.38307086691884E-12   1.39971741504833E-22
      3.21057369865965E-08   3.20993539157297E-08  -4.85189604417008E-19  -3.98883565792876E-01  -3.98883565782603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02722724916211E-08   0.00000000000000E+00  -1.02722724916211E-08
      2.15009986496054E-18  -2.02318314901802E-02  -1.33548439114487E-02   0.00000000000000E+00   1.37851303820080E-11
      1.44297675025760E-22  -2.18408665544907E-08  -2.18270814241085E-08  -1.66491026054353E-18
      7.47251063121259E-09
      0.00000000000000E+00  -3.09348688520275E-11   0.00000000000000E+00  -3.76121587150865E-12   1.43942893662641E-22
      3.09386346989441E-08   3.09348734830727E-08  -4.39876632101739E-19  -4.17331835105415E-01  -4.17331835095297E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01182604012944E-08   0.00000000000000E+00  -1.01182604012944E-08
      1.99697402931605E-18  -1.67113395886278E-02  -1.01527074021554E-02   0.00000000000000E+00   9.68373207335309E-12
      1.73981269323863E-22  -2.08262968138519E-08  -2.08166130817783E-08  -1.55709739721431E-18
      7.49251063121259E-09
      0.00000000000000E+00  -2.96652990496079E-11   0.00000000000000E+00  -3.09558997346125E-12   1.29002611662563E-22
      2.96683896584672E-08   2.96652940684938E-08  -3.84153558240098E-19  -4.40321314466689E-01  -4.40321314456735E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95417232251502E-09   0.00000000000000E+00  -9.95417232251502E-09
      1.79789058286575E-18  -1.39649961383785E-02  -7.75465974238670E-03   0.00000000000000E+00   7.72437433543721E-12
      1.70395968870819E-22  -1.97188461203144E-08  -1.97111217459788E-08  -1.41373702462566E-18
      7.51251063121259E-09
      0.00000000000000E+00  -2.84445906473827E-11   0.00000000000000E+00  -2.97967800757339E-12   9.96418893205689E-23
      2.84476093859504E-08   2.84446297079429E-08  -3.32653999012748E-19  -4.61927238879978E-01  -4.61927238870172E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80600210514649E-09   0.00000000000000E+00  -9.80600210514649E-09
      1.60177054076282E-18  -1.21587870631759E-02  -6.28635289426062E-03   0.00000000000000E+00   6.68627459694746E-12
      1.35421990442880E-22  -1.86453138773935E-08  -1.86386276027964E-08  -1.26911654175007E-18
      7.53251063121258E-09
      0.00000000000000E+00  -2.74507387460600E-11   0.00000000000000E+00  -2.42481657748271E-12   6.74131666639689E-23
      2.74531913989835E-08   2.74507665824061E-08  -2.84600705592827E-19  -4.82437892564524E-01  -4.82437892554847E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67644430320170E-09   0.00000000000000E+00  -9.67644430320170E-09
      1.40824165469879E-18  -1.09370289367722E-02  -5.33690493763181E-03   0.00000000000000E+00   5.53794112798023E-12
      9.03420531602485E-23  -1.77798602203324E-08  -1.77743222792043E-08  -1.12364094910596E-18
      7.55251063121258E-09
      0.00000000000000E+00  -2.66097164874507E-11   0.00000000000000E+00  -2.05037185062977E-12   4.07036642399855E-23
      2.66118034360078E-08   2.66097530641572E-08  -2.39698158963848E-19  -5.01946572964339E-01  -5.01946572954817E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52130209417896E-09   0.00000000000000E+00  -9.52130209417896E-09
      1.21781561281521E-18  -1.00671917923938E-02  -4.68316021246717E-03   0.00000000000000E+00   4.62553504604983E-12
      5.11026318045948E-23  -1.70930765050244E-08  -1.70884509699783E-08  -9.78117453851361E-19
      7.57251063121258E-09
      0.00000000000000E+00  -2.65095138791573E-11   0.00000000000000E+00  -2.25189933979304E-13   2.28853714767379E-23
      2.65097701987782E-08   2.65095450088443E-08  -1.95434991176112E-19  -5.21594124020538E-01  -5.21594124010676E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86230034329938E-09   0.00000000000000E+00  -9.86230034329938E-09
      1.02056960594922E-18  -9.51790370583799E-03  -4.27287901373807E-03   0.00000000000000E+00   3.78110585839111E-12
      2.44572226103699E-23  -1.66510257714033E-08  -1.66472446655449E-08  -8.25134614773110E-19
      7.59251063121258E-09
      0.00000000000000E+00  -2.74260325117512E-11   0.00000000000000E+00   2.28515689242392E-12   1.29271837323296E-23
      2.74237223264165E-08   2.74260074833090E-08  -1.49463592269392E-19  -5.42537265925671E-01  -5.42537265914864E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08064775816905E-08   0.00000000000000E+00  -1.08064775816905E-08
      8.04440054315413E-19  -9.30869360452487E-03  -4.07239806443826E-03   0.00000000000000E+00   2.69234670333267E-12
      9.51868648016296E-24  -1.66222222483218E-08  -1.66195299016184E-08  -6.54976462046020E-19
      7.59751063121258E-09
      0.00000000000000E+00  -2.77693481394329E-11   0.00000000000000E+00   3.40949713323152E-12   1.08051254244390E-23
      2.77659915674775E-08   2.77694010646108E-08  -1.37994383339644E-19  -5.47857024638267E-01  -5.47857024627079E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11885009608387E-08   0.00000000000000E+00  -1.11885009608387E-08
      7.48497549511219E-19  -9.26405825288637E-03  -4.03993335343850E-03   0.00000000000000E+00   2.90806792323287E-12
      6.29937772920546E-24  -1.65838081716953E-08  -1.65809001037721E-08  -6.10503166171576E-19
      7.60426063121258E-09
      0.00000000000000E+00  -2.82413382439424E-11   0.00000000000000E+00   3.48128857829059E-12   8.81677318905501E-24
      2.82378539572601E-08   2.82413352458383E-08  -1.22325802155807E-19  -5.55180000666798E-01  -5.55180000655289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15093497925776E-08   0.00000000000000E+00  -1.15093497925776E-08
      6.70809438411320E-19  -9.28651270675826E-03  -4.01478421188734E-03   0.00000000000000E+00   1.42189757868563E-12
      3.35613178585587E-24  -1.67334073508394E-08  -1.67319854532607E-08  -5.48483636255514E-19
      7.61337313121258E-09
      0.00000000000000E+00  -2.88980281149762E-11   0.00000000000000E+00   3.58726763001068E-12   7.18409742871350E-24
      2.88944117999705E-08   2.88979990676005E-08  -1.01064525962732E-19  -5.65224805150192E-01  -5.65224805138357E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18347082104047E-08   0.00000000000000E+00  -1.18347082104047E-08
      5.62965659844007E-19  -9.37297163167945E-03  -3.99685774728318E-03   0.00000000000000E+00   6.89453069166666E-13
      9.84699847767465E-25  -1.70639803102649E-08  -1.70632908571957E-08  -4.61901133881276E-19
      7.61644859996258E-09
      0.00000000000000E+00  -2.91675924186803E-11   0.00000000000000E+00   4.34686882433984E-12   6.72001574157586E-24
      2.91632701398153E-08   2.91676170086396E-08  -9.39315101364118E-20  -5.68626066801015E-01  -5.68626066789047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19677674199198E-08   0.00000000000000E+00  -1.19677674199198E-08
      5.26159165136776E-19  -9.41758416443565E-03  -3.99844431186069E-03   0.00000000000000E+00   2.46433570712802E-13
      2.93938817237843E-25  -1.72000960222905E-08  -1.71998495887198E-08  -4.32227655000364E-19
      7.62060048277508E-09
      0.00000000000000E+00  -2.94389936171285E-11   0.00000000000000E+00   3.26920932976757E-12   6.23322919421512E-24
      2.94357306744737E-08   2.94389998838035E-08  -8.43401578552920E-20  -5.73217250364245E-01  -5.73217250352195E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20505384721791E-08   0.00000000000000E+00  -1.20505384721791E-08
      4.76126741572765E-19  -9.47174876692022E-03  -3.99318265228908E-03   0.00000000000000E+00   1.62426783088401E-13
     -3.91771023881772E-25  -1.73886238384075E-08  -1.73884614116244E-08  -3.91786583717473E-19
      7.62620552457196E-09
      0.00000000000000E+00  -2.95516871096822E-11   0.00000000000000E+00   1.03723898280346E-12   5.73677099716942E-24
      2.95505893598406E-08   2.95516265988235E-08  -7.16470894328708E-20  -5.79319693612604E-01  -5.79319693600615E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19888684106564E-08   0.00000000000000E+00  -1.19888684106564E-08
      4.08928633033802E-19  -9.49279427798387E-03  -3.95931221298983E-03   0.00000000000000E+00   7.97720604852260E-13
     -1.00427890548406E-24  -1.75635559087720E-08  -1.75627581881672E-08  -3.37281543600931E-19
      7.63377233099774E-09
      0.00000000000000E+00  -2.92688971638202E-11   0.00000000000000E+00  -1.80637685277589E-12   5.22156747643089E-24
      2.92706719864587E-08   2.92688656096060E-08  -5.53805330038889E-20  -5.87183469852761E-01  -5.87183469841164E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15970901929207E-08   0.00000000000000E+00  -1.15970901929207E-08
      3.21175696441644E-19  -9.43944605152703E-03  -3.87161540815459E-03   0.00000000000000E+00   1.48192066986198E-12
     -1.49845937331672E-24  -1.76732573373552E-08  -1.76717754166853E-08  -2.65795163437756E-19
      7.64398751967254E-09
      0.00000000000000E+00  -2.80238499062350E-11   0.00000000000000E+00  -5.98559929629712E-12   4.62561885033058E-24
      2.80298134641118E-08   2.80238278648155E-08  -3.62875221622043E-20  -5.96458090538386E-01  -5.96458090528068E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03177823246116E-08   0.00000000000000E+00  -1.03177823246116E-08
      2.15777603290172E-19  -9.26335856255534E-03  -3.68472949763379E-03   0.00000000000000E+00   1.72273320079247E-12
     -1.86667884372181E-24  -1.77077682734047E-08  -1.77060455402040E-08  -1.79490081127968E-19
      7.65777802438353E-09
      0.00000000000000E+00  -2.38355462000973E-11   0.00000000000000E+00  -1.49645021366806E-11   3.70277470562600E-24
      2.38505244813815E-08   2.38355599792448E-08  -2.14070455628396E-20  -6.03575634429421E-01  -6.03575634423282E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.13892512023065E-09   0.00000000000000E+00  -6.13892512023065E-09
      1.31118727499239E-19  -8.82750344030579E-03  -3.25183798588182E-03   0.00000000000000E+00   1.12988439922881E-12
     -2.15905700626699E-24  -1.76977647434134E-08  -1.76966348590142E-08  -1.09711681936399E-19
      7.67639520574336E-09
      0.00000000000000E+00  -1.13790118715893E-11   0.00000000000000E+00  -3.29894303967718E-11   1.71933115770406E-24
      1.14120415873293E-08   1.13790521569326E-08  -4.31530604344358E-20  -5.92149889691808E-01  -5.92149889698119E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31113530773402E-09   0.00000000000000E+00   6.31113530773402E-09
      2.48614278109760E-19  -7.75097480881186E-03  -2.17733911618085E-03   0.00000000000000E+00  -1.07442292128740E-12
     -2.62482555028828E-24  -1.76891130417453E-08  -1.76901874646666E-08  -2.05461217675325E-19
      7.69639520574336E-09
      0.00000000000000E+00   7.59307995915786E-12   0.00000000000000E+00  -4.67693667005272E-11  -1.99382956013259E-24
     -7.54633702547978E-09  -7.59310639218031E-09  -1.41854676530188E-19  -5.44138045816506E-01  -5.44138045841781E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52748157746081E-08   0.00000000000000E+00   2.52748157746081E-08
      7.54110593601922E-19  -6.10740832870829E-03  -5.36443798711019E-04   0.00000000000000E+00  -4.98941171540388E-12
     -4.59329163127500E-24  -1.76767199707124E-08  -1.76817093824278E-08  -6.12255917071733E-19
      7.71639520574336E-09
      0.00000000000000E+00   2.22521429306396E-11   0.00000000000000E+00  -3.63107504965563E-11  -1.15251951157983E-23
     -2.22158052431538E-08  -2.22521159936503E-08  -3.32051368474261E-19  -4.60484187952920E-01  -4.60484187992800E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98806885157863E-08   0.00000000000000E+00   3.98806885157863E-08
      1.55172436391765E-18  -4.41514885077109E-03   1.13906954030058E-03   0.00000000000000E+00  -1.12293219438755E-11
     -1.76253020636968E-23  -1.76173432001921E-08  -1.76285725221360E-08  -1.21967299544339E-18
      7.73639520574336E-09
      0.00000000000000E+00   2.36292629203292E-11   0.00000000000000E+00  -3.76599473991039E-12  -3.53194234146833E-23
     -2.36254765930114E-08  -2.36292425877514E-08  -6.17371919013375E-19  -3.46401505543610E-01  -3.46401505584896E-01
      0.00000000000000E+00   0.00000000000000E+00   4.12864905486519E-08   0.00000000000000E+00   4.12864905486519E-08
      2.37745417489068E-18  -2.17482365724472E-03   3.38841851214798E-03   0.00000000000000E+00  -2.58182731180668E-11
     -6.28220181839443E-23  -1.76314296877825E-08  -1.76572479609006E-08  -1.76008225587731E-18
      7.75639520574336E-09
      0.00000000000000E+00   1.50797118678922E-11   0.00000000000000E+00   2.04621044171722E-11  -4.28539918428056E-23
     -1.51001871251766E-08  -1.50797250207595E-08  -9.00960175828292E-19  -2.22643214429833E-01  -2.22643214461253E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14200479388901E-08   0.00000000000000E+00   3.14200479388901E-08
      3.00585513366849E-18  -8.91171783706448E-03  -3.76341374932338E-03   0.00000000000000E+00  -5.56956754828542E-11
     -8.10530044908603E-23  -1.62846272426476E-08  -1.63403229181305E-08  -2.10489495784019E-18
      7.76639520574336E-09
      0.00000000000000E+00   1.14957465325801E-11   0.00000000000000E+00   1.68910139962742E-11  -4.44917313877478E-23
     -1.15126102272698E-08  -1.14957192132735E-08  -1.01567043018594E-18  -1.65478180950581E-01  -1.65478180976190E-01
      0.00000000000000E+00   0.00000000000000E+00   2.56085742879965E-08   0.00000000000000E+00   2.56085742879965E-08
      3.26194087654845E-18  -2.00761728175946E-02  -1.56296614919997E-02   0.00000000000000E+00  -8.85471718196697E-11
     -8.76093036154047E-23  -1.40243079029031E-08  -1.41128550747228E-08  -2.24627044636251E-18
      7.77314520574336E-09
      0.00000000000000E+00   9.73049068345142E-12   0.00000000000000E+00   1.20415413895756E-11  -4.54490375659136E-23
     -9.74255557335206E-09  -9.73051403196253E-09  -1.08116411005518E-18  -1.30682840976873E-01  -1.30682840999360E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24868838089332E-08   0.00000000000000E+00   2.24868838089332E-08
      3.41372734225875E-18  -3.05821613355032E-02  -2.65630267029911E-02   0.00000000000000E+00  -1.17207249283263E-10
     -9.21906907609354E-23  -1.26391625276872E-08  -1.27563697769705E-08  -2.33256323220358E-18
      7.77770145574336E-09
      0.00000000000000E+00   8.64360006333755E-12   0.00000000000000E+00   1.08507557911169E-11  -4.60367777045447E-23
     -8.65448435762196E-09  -8.64363360183089E-09  -1.12034125444308E-18  -1.09067708585546E-01  -1.09067708606074E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05274567170027E-08   0.00000000000000E+00   2.05274567170027E-08
      3.50725556692559E-18  -3.88985493146149E-02  -3.51543193856919E-02   0.00000000000000E+00  -1.37680194489269E-10
     -9.52954849109730E-23  -1.17461429206825E-08  -1.18838231151718E-08  -2.38691431248252E-18
      7.78385239324336E-09
      0.00000000000000E+00   7.33931295025346E-12   0.00000000000000E+00   9.57491151887386E-12  -4.67176329870232E-23
     -7.34884976118742E-09  -7.33927484966860E-09  -1.16510697245884E-18  -8.35621709398002E-02  -8.35621709580141E-02
      0.00000000000000E+00   0.00000000000000E+00   1.82139487394158E-08   0.00000000000000E+00   1.82139487394158E-08
      3.61928842724994E-18  -5.19179125496561E-02  -4.84916325580784E-02   0.00000000000000E+00  -1.54494504170232E-10
     -9.93964050486967E-23  -1.07201793855767E-08  -1.08746738897471E-08  -2.45418145479110E-18
      7.79215615886836E-09
      0.00000000000000E+00   5.46816011912452E-12   0.00000000000000E+00   1.03500062478729E-11  -4.73744538587211E-23
     -5.47849314580844E-09  -5.46814313956061E-09  -1.20993023135278E-18  -5.70812113974207E-02  -5.70812114123712E-02
      0.00000000000000E+00   0.00000000000000E+00   1.49504742878120E-08   0.00000000000000E+00   1.49504742878120E-08
      3.74343366171853E-18  -7.26438928259725E-02  -6.96562963856405E-02   0.00000000000000E+00  -1.67811632012902E-10
     -1.04643535481932E-22  -9.31451951623831E-09  -9.48233114825132E-09  -2.53350343036575E-18
      7.79776120066523E-09
      0.00000000000000E+00   3.93830233145875E-12   0.00000000000000E+00   1.28396810589059E-11  -4.76559174390233E-23
     -3.95117899324423E-09  -3.93833931218538E-09  -1.23159938792441E-18  -4.38963513007153E-02  -4.38963513130034E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22880644197920E-08   0.00000000000000E+00   1.22880644197920E-08
      3.81230877639415E-18  -8.82778806775167E-02  -8.56471276652537E-02   0.00000000000000E+00  -1.75264481318497E-10
     -1.08006599320540E-22  -8.17446062628785E-09  -8.34972510760645E-09  -2.58070938846974E-18
      7.80154460387812E-09
      0.00000000000000E+00   2.94591994593142E-12   0.00000000000000E+00   1.24757242127883E-11  -4.77833224928655E-23
     -2.95838320412535E-09  -2.94590747991261E-09  -1.24246889959694E-18  -3.71431291006571E-02  -3.71431291112051E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05480320220238E-08   0.00000000000000E+00   1.05480320220238E-08
      3.85221623463595E-18  -9.94986108265736E-02  -9.71034003318529E-02   0.00000000000000E+00  -1.77825689163471E-10
     -1.10178361551975E-22  -7.42429885294772E-09  -7.60212454211130E-09  -2.60974733503901E-18
      7.80665219821553E-09
      0.00000000000000E+00   1.99312264214054E-12   0.00000000000000E+00   8.91784430986974E-12  -4.78925419225975E-23
     -2.00204525317765E-09  -1.99312740886783E-09  -1.25227556637449E-18  -3.08708711347110E-02  -3.08708711435566E-02
      0.00000000000000E+00   0.00000000000000E+00   8.84560062705581E-09   0.00000000000000E+00   8.84560062705581E-09
      3.89739597430962E-18  -1.15400302628107E-01  -1.13241284162675E-01   0.00000000000000E+00  -1.77779377123722E-10
     -1.12945175485276E-22  -6.67469384106392E-09  -6.85247321818775E-09  -2.64512040793514E-18
      7.81354745057102E-09
      0.00000000000000E+00   1.22658646540652E-12   0.00000000000000E+00   5.31957886429965E-12  -4.79766502598899E-23
     -1.23190972168070E-09  -1.22659014281645E-09  -1.26023258045975E-18  -2.55337187423458E-02  -2.55337187497285E-02
      0.00000000000000E+00   0.00000000000000E+00   7.38266195907500E-09   0.00000000000000E+00   7.38266195907500E-09
      3.94830129157274E-18  -1.37406335386167E-01  -1.35466731387418E-01   0.00000000000000E+00  -1.80384884591693E-10
     -1.16492265574534E-22  -5.97568693166671E-09  -6.15607181625851E-09  -2.68806871111300E-18
      7.82285604125094E-09
      0.00000000000000E+00   7.07939234395616E-13   0.00000000000000E+00   2.66308240791608E-12  -4.80360634451916E-23
     -7.10585302970532E-10  -7.07922220562664E-10  -1.26615807802081E-18  -2.12332200076633E-02  -2.12332200138996E-02
      0.00000000000000E+00   0.00000000000000E+00   6.23634531821670E-09   0.00000000000000E+00   6.23634531821670E-09
      4.00635287747863E-18  -1.66936778418821E-01  -1.65194926558779E-01   0.00000000000000E+00  -1.87000854898945E-10
     -1.21087703611734E-22  -5.34142224275499E-09  -5.52842309765406E-09  -2.74019479945782E-18
      7.83542263866882E-09
      0.00000000000000E+00   4.02555483180590E-13   0.00000000000000E+00   1.15924003615337E-12  -4.80742389143921E-23
     -4.03720080610921E-10  -4.02560840574815E-10  -1.27034420884723E-18  -1.78052396483400E-02  -1.78052396536368E-02
      0.00000000000000E+00   0.00000000000000E+00   5.29686712837074E-09   0.00000000000000E+00   5.29686712837074E-09
      4.07291647425690E-18  -2.04925352225674E-01  -2.03383289853869E-01   0.00000000000000E+00  -1.95787448696452E-10
     -1.27014648473326E-22  -4.69851883909935E-09  -4.89430628779593E-09  -2.80257226540967E-18
      7.85238754518297E-09
      0.00000000000000E+00   2.43664087811568E-13   0.00000000000000E+00   4.47012925496789E-13  -4.80964216228489E-23
     -2.44057164161082E-10  -2.43610151235633E-10  -1.27333776546922E-18  -1.50028890909964E-02  -1.50028890953139E-02
      0.00000000000000E+00   0.00000000000000E+00   4.31745514379195E-09   0.00000000000000E+00   4.31745514379195E-09
      4.14616169715035E-18  -2.49835811198796E-01  -2.48552249939383E-01   0.00000000000000E+00  -1.96169594566006E-10
     -1.34230148317715E-22  -3.87767539799026E-09  -4.07384499255640E-09  -2.87282393168113E-18
      7.87238754518297E-09
      0.00000000000000E+00   1.76709274387281E-13   0.00000000000000E+00   1.59864953585157E-13  -4.81085056861562E-23
     -1.76865792420942E-10  -1.76705927467405E-10  -1.27556890286101E-18  -1.28647302614284E-02  -1.28647302646376E-02
      0.00000000000000E+00   0.00000000000000E+00   3.20918444222602E-09   0.00000000000000E+00   3.20918444222602E-09
      4.21034538599487E-18  -2.90225341249258E-01  -2.89269883351908E-01   0.00000000000000E+00  -1.72153092432055E-10
     -1.40983259269324E-22  -2.86032542232641E-09  -3.03247851475861E-09  -2.93477648313387E-18
      7.89238754518297E-09
      0.00000000000000E+00   1.47502647955288E-13   0.00000000000000E+00   7.10739270435004E-14  -4.81136791707208E-23
     -1.47536205024212E-10  -1.47465131097217E-10  -1.27724302234768E-18  -1.14196806951952E-02  -1.14196806974313E-02
      0.00000000000000E+00   0.00000000000000E+00   2.23610626821153E-09   0.00000000000000E+00   2.23610626821153E-09
      4.25506751135911E-18  -3.17951344841662E-01  -3.17293265548591E-01   0.00000000000000E+00  -1.30965115140495E-10
     -1.45757327413677E-22  -1.95767602197372E-09  -2.08864113711436E-09  -2.97782448901142E-18
      7.91238754518297E-09
      0.00000000000000E+00   1.33083024213706E-13   0.00000000000000E+00   3.62268400625365E-14  -4.81153649374321E-23
     -1.33134711399380E-10  -1.33098484559366E-10  -1.27864840666801E-18  -1.04195681050853E-02  -1.04195681065606E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47525452799707E-09   0.00000000000000E+00   1.47525452799707E-09
      4.28457260191905E-18  -3.35049604117058E-01  -3.34626726864512E-01   0.00000000000000E+00  -8.50300794437541E-11
     -1.48723877240050E-22  -1.25712596399384E-09  -1.34215604343774E-09  -3.00592419525103E-18
      7.93238754518297E-09
      0.00000000000000E+00   1.27388650506840E-13   0.00000000000000E+00   1.53020099250827E-14  -4.81160744858721E-23
     -1.27414366222219E-10  -1.27399064212342E-10  -1.27995134454047E-18  -9.70332650312021E-03  -9.70332650400172E-03
      0.00000000000000E+00   0.00000000000000E+00   8.81509341580711E-10   0.00000000000000E+00   8.81509341580711E-10
      4.30220278875066E-18  -3.43455451805185E-01  -3.43217857977004E-01   0.00000000000000E+00  -4.12581411422094E-11
     -1.50138558852125E-22  -7.12852136225906E-10  -7.54110277368265E-10  -3.02225144421019E-18
      7.95238754518297E-09
      0.00000000000000E+00   9.79064898632235E-14   0.00000000000000E+00   7.83590215901362E-14  -4.81052697931898E-23
     -9.80221167241314E-11  -9.79437577025893E-11  -1.28067592142107E-18  -9.38337647612317E-03  -9.38337647681410E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90935509336429E-10   0.00000000000000E+00   6.90935509336429E-10
      4.31602149893739E-18  -3.49910786991306E-01  -3.49723958781590E-01   0.00000000000000E+00  -2.99770786809907E-11
     -1.51144511102332E-22  -5.63014672952831E-10  -5.92991751633972E-10  -3.03534557751632E-18
      7.97238754518297E-09
      0.00000000000000E+00   7.47616160869268E-14   0.00000000000000E+00   6.66536096026067E-14  -4.80872107036899E-23
     -7.48138501143627E-11  -7.47471965048082E-11  -1.28094987715496E-18  -9.25940902418942E-03  -9.25940902500130E-03
      0.00000000000000E+00   0.00000000000000E+00   8.11877620874782E-10   0.00000000000000E+00   8.11877620874782E-10
      4.33225905135489E-18  -3.58949231377887E-01  -3.58716986673821E-01   0.00000000000000E+00  -4.41672158788582E-11
     -1.52584929218336E-22  -6.92963208490900E-10  -7.37130424369911E-10  -3.05130917419993E-18
      7.97488754518296E-09
      0.00000000000000E+00   7.13633608102483E-14   0.00000000000000E+00   7.65382501088416E-14  -4.80847749697251E-23
     -7.14374591139911E-11  -7.13609208639303E-11  -1.28097586490403E-18  -9.24901404046612E-03  -9.24901404126652E-03
      0.00000000000000E+00   0.00000000000000E+00   8.00401234410054E-10   0.00000000000000E+00   8.00401234410054E-10
      4.33426005444091E-18  -3.60061907022554E-01  -3.59832211265825E-01   0.00000000000000E+00  -4.36651069086816E-11
     -1.52761736462718E-22  -6.85375206637486E-10  -7.29040313546320E-10  -3.05328418953688E-18
      7.97826254518297E-09
      0.00000000000000E+00   3.59112922481430E-14   0.00000000000000E+00   5.27131909169853E-13  -4.80773526711147E-23
     -3.64425142922673E-11  -3.59153823831455E-11  -1.28089180220652E-18  -9.29560130497281E-03  -9.29560130590382E-03
      0.00000000000000E+00   0.00000000000000E+00   9.31006201991649E-10   0.00000000000000E+00   9.31006201991649E-10
      4.33740220037264E-18  -3.62124435076633E-01  -3.61842417775835E-01   0.00000000000000E+00  -6.12308644247916E-11
     -1.53090045140390E-22  -8.33859955183760E-10  -8.95090819608705E-10  -3.05651039816612E-18
      7.98281879518297E-09
      0.00000000000000E+00   1.71749658578075E-14   0.00000000000000E+00   2.25453811820561E-13  -4.80678838332325E-23
     -1.73902019842050E-11  -1.71647481724325E-11  -1.28069396272233E-18  -9.38201129299462E-03  -9.38201129416912E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17449947034314E-09   0.00000000000000E+00   1.17449947034314E-09
      4.34275351358438E-18  -3.65890402842831E-01  -3.65525755406762E-01   0.00000000000000E+00  -8.57765413523221E-11
     -1.53709411865046E-22  -1.07155818081785E-09  -1.15733472217033E-09  -3.06205955086205E-18
      7.98589426393297E-09
      0.00000000000000E+00   1.17561263625634E-14   0.00000000000000E+00   1.09089467423331E-13  -4.80616274459435E-23
     -1.18424603218246E-11  -1.17333708544493E-11  -1.28054426078029E-18  -9.43851454736979E-03  -9.43851454870988E-03
      0.00000000000000E+00   0.00000000000000E+00   1.34009148371668E-09   0.00000000000000E+00   1.34009148371668E-09
      4.34687492306470E-18  -3.68847966004810E-01  -3.68429430925523E-01   0.00000000000000E+00  -1.02101307336013E-10
     -1.54205430406552E-22  -1.22625680552578E-09  -1.32835811286195E-09  -3.06633066228441E-18
      7.99004614674547E-09
      0.00000000000000E+00   1.53380711136570E-14   0.00000000000000E+00  -2.16448354320270E-14  -4.80541532514481E-23
     -1.52958463712499E-11  -1.53174912067299E-11  -1.28035811784179E-18  -9.48881264308549E-03  -9.48881264461167E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52617628955814E-09   0.00000000000000E+00   1.52617628955814E-09
      4.35321142817016E-18  -3.73405718070875E-01  -3.72929679258057E-01   0.00000000000000E+00  -1.19514298648028E-10
     -1.54986659432317E-22  -1.39134449970326E-09  -1.51085879835144E-09  -3.07285331032837E-18
      7.99565118854234E-09
      0.00000000000000E+00   2.68186632645978E-14   0.00000000000000E+00  -8.32399062372811E-14  -4.80456924557447E-23
     -2.66996400350327E-11  -2.67828799413180E-11  -1.28017313447905E-18  -9.49946882301113E-03  -9.49946882469506E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68392046923377E-09   0.00000000000000E+00   1.68392046923377E-09
      4.36264987278282E-18  -3.80135881901687E-01  -3.79613752478160E-01   0.00000000000000E+00  -1.34495981015043E-10
     -1.56165577181615E-22  -1.52264160827756E-09  -1.65713758929276E-09  -3.08247673830377E-18
      8.00321799496812E-09
      0.00000000000000E+00   4.05953738457268E-14   0.00000000000000E+00  -7.57119282743388E-14  -4.80361826145592E-23
     -4.05109852332878E-11  -4.05866971616102E-11  -1.28003161409347E-18  -9.43607631370743E-03  -9.43607631548412E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77669303900564E-09   0.00000000000000E+00   1.77669303900564E-09
      4.37609376508702E-18  -3.89615450280638E-01  -3.89068438675096E-01   0.00000000000000E+00  -1.44900340612065E-10
     -1.57860651938306E-22  -1.59120600123182E-09  -1.73610634184405E-09  -3.09606215099355E-18
      8.01343318364293E-09
      0.00000000000000E+00   5.55660660105537E-14   0.00000000000000E+00  -6.13654318718286E-14  -4.80261235973522E-23
     -5.55505353038532E-11  -5.56119007357730E-11  -1.28000069561060E-18  -9.25130060907548E-03  -9.25130061087586E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80037888240996E-09   0.00000000000000E+00   1.80037888240996E-09
      4.39448497505697E-18  -4.02417803684594E-01  -4.01868062897375E-01   0.00000000000000E+00  -1.50684452826174E-10
     -1.60201391943795E-22  -1.59408252884795E-09  -1.74476698167428E-09  -3.11448427944637E-18
      8.02722368835391E-09
      0.00000000000000E+00   7.99967661077558E-14   0.00000000000000E+00  -8.06487911484139E-14  -4.80191522416576E-23
     -7.99198217976557E-11  -8.00004705888522E-11  -1.28030648121322E-18  -8.80309459534230E-03  -8.80309459712631E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78400672236227E-09   0.00000000000000E+00   1.78400672236227E-09
      4.41908732816613E-18  -4.19149062311911E-01  -4.18612164177965E-01   0.00000000000000E+00  -1.53746525915127E-10
     -1.63356843166176E-22  -1.55025972585832E-09  -1.70400625177361E-09  -3.13878084695291E-18
      8.04584086971374E-09
      0.00000000000000E+00   1.25184376813859E-13   0.00000000000000E+00  -1.21501960188462E-13  -4.80259015047296E-23
     -1.25058889047603E-10  -1.25180391007840E-10  -1.28157776391581E-18  -7.70762668249022E-03  -7.70762668425703E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76681058452603E-09   0.00000000000000E+00   1.76681058452603E-09
      4.45198036124673E-18  -4.40502674233784E-01  -4.39985429215791E-01   0.00000000000000E+00  -1.56822346920763E-10
     -1.67586088115534E-22  -1.48480784659721E-09  -1.64163019351814E-09  -3.17040259733091E-18
      8.06584086971374E-09
      0.00000000000000E+00   1.66514508557246E-13   0.00000000000000E+00  -1.11392549712098E-13  -4.80476771985139E-23
     -1.66329658505999E-10  -1.66441051055759E-10  -1.28378518167658E-18  -6.05618126898676E-03  -6.05618127072748E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74071840906720E-09   0.00000000000000E+00   1.74071840906720E-09
      4.48679472942807E-18  -4.62097230702460E-01  -4.61601206172566E-01   0.00000000000000E+00  -1.60503531897385E-10
     -1.72100108114168E-22  -1.41377382611394E-09  -1.57427735801149E-09  -3.20300954775149E-18
      8.08584086971374E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.36340719169635E-14  -4.80693129633850E-23
     -1.71488846151816E-10  -1.71512480223781E-10  -1.28610895607086E-18  -4.36419040592179E-03  -4.36419040759180E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67001021479844E-09   0.00000000000000E+00   1.67001021479844E-09
      4.52019493372404E-18  -4.82597392709560E-01  -4.82125243759189E-01   0.00000000000000E+00  -1.62531983957370E-10
     -1.76541818452680E-22  -1.33596575061707E-09  -1.49849773457461E-09  -3.23408597765318E-18
      8.10584086971374E-09
      0.00000000000000E+00   2.20978437721309E-13   0.00000000000000E+00  -1.41540289066010E-13  -4.81115032956819E-23
     -2.20805327084904E-10  -2.20946867374018E-10  -1.28943277428718E-18  -2.09043012091047E-03  -2.09043012259150E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68103290019832E-09   0.00000000000000E+00   1.68103290019832E-09
      4.55381559172801E-18  -5.02094497071039E-01  -5.01634449146994E-01   0.00000000000000E+00  -1.68849242684721E-10
     -1.81031248486790E-22  -1.29123679013941E-09  -1.46008603282431E-09  -3.26438281744083E-18
      8.12584086971374E-09
      0.00000000000000E+00  -5.79172912830664E-13   0.00000000000000E+00   2.08581703499277E-12  -4.78194775359844E-23
      5.77024716884188E-10   5.79110533919133E-10  -1.27681213772347E-18  -9.46351713718476E-03  -9.46351713752750E-03
      0.00000000000000E+00   0.00000000000000E+00   3.42734780664415E-10   0.00000000000000E+00   3.42734780664415E-10
      4.56067028734129E-18  -5.21733920905866E-01  -5.21443473063657E-01   0.00000000000000E+00  -9.69539964758981E-11
     -1.83553423964221E-22  -8.24891318107444E-10  -9.21845314583526E-10  -3.28385814961782E-18
      8.14584086971374E-09
      0.00000000000000E+00  -2.49092111780533E-12   0.00000000000000E+00   5.11112483960110E-12  -4.67988597902177E-23
      2.48579086786788E-09   2.49090199270743E-09  -1.22629271867298E-18  -3.89689116127051E-02  -3.89689116099801E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.72492228511417E-09   0.00000000000000E+00  -2.72492228511417E-09
      4.50617184163901E-18  -5.42674204643143E-01  -5.42747978941939E-01   0.00000000000000E+00   7.76478175966667E-11
     -1.81509311738393E-22   1.56372474810272E-10   2.34020292406757E-10  -3.27987912296603E-18
      8.16584086971374E-09
      0.00000000000000E+00  -4.34388869096718E-12   0.00000000000000E+00   5.11910786118031E-12  -4.52007189957127E-23
      4.33877417474740E-09   4.34389328260853E-09  -1.14065526198676E-18  -8.66250866046602E-02  -8.66250865991686E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.49161238087517E-09   0.00000000000000E+00  -5.49161238087517E-09
      4.39633959402151E-18  -5.64269398219379E-01  -5.64631094617519E-01   0.00000000000000E+00   2.12884754872917E-10
     -1.75762302781711E-22   9.34834343393914E-10   1.14771909826665E-09  -3.25568433203475E-18
      8.17584086971374E-09
      0.00000000000000E+00  -5.75177666762136E-12   0.00000000000000E+00   7.49679797971241E-12  -4.41776445845702E-23
      5.74430357540603E-09   5.75180037338569E-09  -1.08555327213894E-18  -1.15807669184193E-01  -1.15807669176846E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34637027962653E-09   0.00000000000000E+00  -7.34637027962653E-09
      4.32287589122524E-18  -5.75158348075357E-01  -5.75660864395406E-01   0.00000000000000E+00   2.77394259036515E-10
     -1.71918371073301E-22   1.31717564720447E-09   1.59456990624081E-09  -3.23732261908630E-18
      8.18934086971374E-09
      0.00000000000000E+00  -7.20439303129561E-12   0.00000000000000E+00   5.82316047782881E-12  -4.22221640085189E-23
      7.19853754997996E-09   7.20436071045775E-09  -1.00181257173235E-18  -1.57989778437201E-01  -1.57989778428767E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.43395962996282E-09   0.00000000000000E+00  -8.43395962996282E-09
      4.20901743622074E-18  -5.88924339886245E-01  -5.89311937789291E-01   0.00000000000000E+00   2.95803718625883E-10
     -1.66220862703390E-22   9.33795200879497E-10   1.22959891950521E-09  -3.20720486448839E-18
      8.20756586971374E-09
      0.00000000000000E+00  -1.12169059104180E-11   0.00000000000000E+00   1.12347990043038E-11  -3.06120874554212E-23
      1.12056713693813E-08   1.12169061683856E-08  -8.86913958520765E-19  -2.12251127297138E-01  -2.12251127288149E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.98929267776250E-09   0.00000000000000E+00  -8.98929267776250E-09
      4.04518757716852E-18  -6.01173256573871E-01  -6.00471909351216E-01   0.00000000000000E+00   2.86972006126039E-10
     -1.58431500885197E-22  -2.51458549674909E-09  -2.22761349062321E-09  -3.15827361864775E-18
      8.22756586971374E-09
      0.00000000000000E+00  -2.34087437062940E-11   0.00000000000000E+00   3.02942994522046E-11   2.47744877234283E-23
      2.33783917919563E-08   2.34086860914086E-08  -7.74791081853249E-19  -2.62187644941996E-01  -2.62187644932444E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.55189772345139E-09   0.00000000000000E+00  -9.55189772345139E-09
      3.85414962269949E-18  -5.93501889523908E-01  -5.89137356254280E-01   0.00000000000000E+00   2.96724898831925E-10
     -1.48843442040755E-22  -1.41535132667889E-08  -1.38567883679572E-08  -3.07935854084625E-18
      8.24756586971374E-09
      0.00000000000000E+00  -4.31217470320943E-11   0.00000000000000E+00   4.88588564773350E-11   1.18618377564439E-22
      4.30729533484392E-08   4.31218122049167E-08  -6.90730948347206E-19  -2.98960078387283E-01  -2.98960078377030E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02529060834030E-08   0.00000000000000E+00  -1.02529060834030E-08
      3.64909150103143E-18  -5.51078450950128E-01  -5.40724536641090E-01   0.00000000000000E+00   3.15295649053104E-10
     -1.36700815294290E-22  -3.31842017705667E-08  -3.28689061215137E-08  -2.95836055268423E-18
      8.26756586971374E-09
      0.00000000000000E+00  -6.03734032454700E-11   0.00000000000000E+00   4.29157637604824E-11   1.99849625942763E-22
      6.03305246584456E-08   6.03734404222063E-08  -6.36502142701207E-19  -3.23601865393185E-01  -3.23601865382289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08961880582674E-08   0.00000000000000E+00  -1.08961880582674E-08
      3.43116773986609E-18  -4.72385458613448E-01  -4.56798721760730E-01   0.00000000000000E+00   2.98662167592155E-10
     -1.21314434652106E-22  -4.97759145315310E-08  -4.94772523639390E-08  -2.79466559716488E-18
      8.28756586971374E-09
      0.00000000000000E+00  -6.55882555793762E-11   0.00000000000000E+00   1.30720790350449E-11   2.24484616022103E-22
      6.55751863258153E-08   6.55882584048505E-08  -6.08560070314875E-19  -3.38011248430527E-01  -3.38011248419066E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14605730927762E-08   0.00000000000000E+00  -1.14605730927762E-08
      3.20195627801056E-18  -3.62224806264171E-01  -3.45172194146993E-01   0.00000000000000E+00   2.53300872691796E-10
     -1.04974744805310E-22  -5.43809861847660E-08  -5.41276853120743E-08  -2.59339620769568E-18
      8.30756586971374E-09
      0.00000000000000E+00  -5.81713338261824E-11   0.00000000000000E+00  -1.83442112635528E-11   1.91777480130305E-22
      5.81896874499773E-08   5.81713432387140E-08  -5.99634317049430E-19  -3.45113561724179E-01  -3.45113561712291E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18875956420428E-08   0.00000000000000E+00  -1.18875956420428E-08
      2.96420436516970E-18  -2.37733136228512E-01  -2.23151237779133E-01   0.00000000000000E+00   1.86480518083027E-10
     -8.83248967410323E-23  -4.64702281147542E-08  -4.62837475966713E-08  -2.36457004812027E-18
      8.32756586971374E-09
      0.00000000000000E+00  -5.04860417508682E-11   0.00000000000000E+00  -1.90140405605214E-11   1.50945904729651E-22
      5.05051314975389E-08   5.04861174569785E-08  -5.91475781230194E-19  -3.51996528249461E-01  -3.51996528237593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18676042526394E-08   0.00000000000000E+00  -1.18676042526394E-08
      2.72685228011692E-18  -1.31695153730805E-01  -1.19527989511923E-01   0.00000000000000E+00   1.02360759539038E-10
     -7.62437612761551E-23  -3.87208739638780E-08  -3.86185132043390E-08  -2.13537649888672E-18
      8.34756586971374E-09
      0.00000000000000E+00  -4.36197291972335E-11   0.00000000000000E+00  -1.70054261060949E-11   1.23777575656451E-22
      4.36367440109451E-08   4.36197385848391E-08  -5.71724287958562E-19  -3.62985102012976E-01  -3.62985102001460E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15152188127896E-08   0.00000000000000E+00  -1.15152188127896E-08
      2.49654790386112E-18  -5.82204347989212E-02  -4.81054472866118E-02   0.00000000000000E+00   5.50338274420035E-11
     -2.82306949247602E-23  -3.21595535994916E-08  -3.21045197720497E-08  -1.92482361590256E-18
      8.35006586971374E-09
      0.00000000000000E+00  -4.14841553676841E-11   0.00000000000000E+00  -4.18040287987432E-11   1.20228537632239E-22
      4.15259698650700E-08   4.14841658362713E-08  -5.68625886697849E-19  -3.64502866528648E-01  -3.64502866517204E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14441401499899E-08   0.00000000000000E+00  -1.14441401499899E-08
      2.46793755348615E-18  -5.03982700538924E-02  -4.09337241252129E-02   0.00000000000000E+00   6.66119441002090E-11
     -1.25336445646036E-23  -3.01066376303816E-08  -3.00400256862814E-08  -1.89931166678830E-18
      8.35344086971374E-09
      0.00000000000000E+00  -3.91310932004272E-11   0.00000000000000E+00  -3.46008142102477E-11   1.17630712056815E-22
      3.91656444776688E-08   3.91310436634587E-08  -5.62570125310400E-19  -3.67212240699515E-01  -3.67212240688309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12055222581360E-08   0.00000000000000E+00  -1.12055222581360E-08
      2.43011891586494E-18  -4.22878102925613E-02  -3.34894567984216E-02   0.00000000000000E+00   5.20701296933209E-11
      1.12049049553113E-23  -2.79775915350161E-08  -2.79255214053228E-08  -1.86754879055454E-18
      8.35799711971374E-09
      0.00000000000000E+00  -3.67254039987505E-11   0.00000000000000E+00  -2.61821949678222E-11   1.18124726620317E-22
      3.67516029477624E-08   3.67254207527947E-08  -5.51770351228687E-19  -3.71784922268811E-01  -3.71784922257909E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09025715888950E-08   0.00000000000000E+00  -1.09025715888950E-08
      2.38044407406304E-18  -3.46606421783318E-02  -2.65247546916603E-02   0.00000000000000E+00   3.92515496236710E-11
      4.14659304499420E-23  -2.58621007135234E-08  -2.58228491638997E-08  -1.82867372283435E-18
      8.36414805721374E-09
      0.00000000000000E+00  -3.45909323060476E-11   0.00000000000000E+00  -1.71886572743622E-11   1.23133605758346E-22
      3.46081481177955E-08   3.45909594605213E-08  -5.34429315502298E-19  -3.78917338736105E-01  -3.78917338725490E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06148563516449E-08   0.00000000000000E+00  -1.06148563516449E-08
      2.31515275607259E-18  -2.81917672119762E-02  -2.06377136974927E-02   0.00000000000000E+00   2.74327999499520E-11
      7.70669228551467E-23  -2.40035359088266E-08  -2.39761031088766E-08  -1.78072344057029E-18
      8.37245182283874E-09
      0.00000000000000E+00  -3.29526977284769E-11   0.00000000000000E+00  -9.74531869039671E-12   1.32186329185066E-22
      3.29623978730471E-08   3.29526525543569E-08  -5.09052967193283E-19  -3.89222077070398E-01  -3.89222077060007E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03908040247859E-08   0.00000000000000E+00  -1.03908040247859E-08
      2.22886995479546E-18  -2.31049601778736E-02  -1.59964791943838E-02   0.00000000000000E+00   1.81361953267935E-11
      1.16063068681211E-22  -2.25799847248981E-08  -2.25618485295712E-08  -1.71981698760218E-18
      8.38366190643249E-09
      0.00000000000000E+00  -3.17467763289421E-11   0.00000000000000E+00  -5.28282732833317E-12   1.41434678069655E-22
      3.17520835475968E-08   3.17468007202687E-08  -4.74482229537639E-19  -4.03231524945449E-01  -4.03231524935221E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02285622857467E-08   0.00000000000000E+00  -1.02285622857467E-08
      2.11420691652836E-18  -1.91911692736397E-02  -1.24114850951929E-02   0.00000000000000E+00   1.22297382463099E-11
      1.53215463887999E-22  -2.15304681727684E-08  -2.15182384345220E-08  -1.63972468699073E-18
      8.39879551928405E-09
      0.00000000000000E+00  -3.06801833957511E-11   0.00000000000000E+00  -3.44026129073107E-12   1.42386515986162E-22
      3.06836393071692E-08   3.06801990458786E-08  -4.29708688810345E-19  -4.21498002615265E-01  -4.21498002605178E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00877326127525E-08   0.00000000000000E+00  -1.00877326127525E-08
      1.96154307661689E-18  -1.61024767342530E-02  -9.61446399891362E-03   0.00000000000000E+00   9.06412760801312E-12
      1.75917751460222E-22  -2.06015305607342E-08  -2.05924664331260E-08  -1.53183438780654E-18
      8.41879551928405E-09
      0.00000000000000E+00  -2.94298091434078E-11   0.00000000000000E+00  -3.04858848065557E-12   1.24286845470723E-22
      2.94329126162724E-08   2.94298640277919E-08  -3.74772290844710E-19  -4.44228617968145E-01  -4.44228617958219E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.92628015989970E-09   0.00000000000000E+00  -9.92628015989970E-09
      1.76301747341889E-18  -1.35857761780865E-02  -7.44082703202613E-03   0.00000000000000E+00   7.48194683373030E-12
      1.65502289303593E-22  -1.95110658147261E-08  -1.95035838678922E-08  -1.38824518257418E-18
      8.43879551928405E-09
      0.00000000000000E+00  -2.82467570834376E-11   0.00000000000000E+00  -2.88780026598644E-12   9.37450556078984E-23
      2.82496658249537E-08   2.82467780246878E-08  -3.23928446192977E-19  -4.65624766758008E-01  -4.65624766748226E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.78173211308220E-09   0.00000000000000E+00  -9.78173211308220E-09
      1.56738283115725E-18  -1.19052899242498E-02  -6.08754485550907E-03   0.00000000000000E+00   6.47411946689749E-12
      1.27438637494506E-22  -1.84715200310726E-08  -1.84650459116056E-08  -1.24345438496427E-18
      8.45879551928405E-09
      0.00000000000000E+00  -2.72938679349096E-11   0.00000000000000E+00  -2.32432640903445E-12   6.20918963808990E-23
      2.72961927396113E-08   2.72938684132023E-08  -2.76432623755312E-19  -4.85960262682311E-01  -4.85960262672658E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.65346514456017E-09   0.00000000000000E+00  -9.65346514456017E-09
      1.37431352826604E-18  -1.07619512800504E-02  -5.20402015442039E-03   0.00000000000000E+00   5.34880489663332E-12
      8.25930789789562E-23  -1.76457520735389E-08  -1.76404032686422E-08  -1.09788090451073E-18
      8.47879551928405E-09
      0.00000000000000E+00  -2.64747047237556E-11   0.00000000000000E+00  -1.99692297001728E-12   3.68672271584458E-23
      2.64766704238170E-08   2.64746735008471E-08  -2.32057950524866E-19  -5.05303089362188E-01  -5.05303089352695E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.49378856761495E-09   0.00000000000000E+00  -9.49378856761495E-09
      1.18443775691375E-18  -9.93875967805634E-03  -4.58861815178933E-03   0.00000000000000E+00   4.48936185377655E-12
      4.53952567427953E-23  -1.69853742950860E-08  -1.69808849332322E-08  -9.52379806388880E-19
      8.49879551928405E-09
      0.00000000000000E+00  -2.66632619692427E-11   0.00000000000000E+00   4.86682641324980E-13   2.06403967001790E-23
      2.66627166138313E-08   2.66632032964726E-08  -1.87363342858941E-19  -5.25232698156703E-01  -5.25232698146658E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00455912258207E-08   0.00000000000000E+00  -1.00455912258207E-08
      9.83525932397330E-19  -9.46626859306413E-03  -4.23057963489755E-03   0.00000000000000E+00   3.58215719381238E-12
      2.10651268440298E-23  -1.66211942278457E-08  -1.66176120706518E-08  -7.96162589538389E-19
      8.51879551928405E-09
      0.00000000000000E+00  -2.75784029307785E-11   0.00000000000000E+00   2.28374011850462E-12   1.17653704262777E-23
      2.75761437468940E-08   2.75784274870125E-08  -1.41304379572026E-19  -5.46311165786156E-01  -5.46311165775217E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09396056228512E-08   0.00000000000000E+00  -1.09396056228512E-08
      7.64733819940308E-19  -9.28556970753049E-03  -4.04319545839940E-03   0.00000000000000E+00   2.55075707494202E-12
      7.80882959949363E-24  -1.66413726212364E-08  -1.66388218641614E-08  -6.23429440368282E-19
      8.52004551928405E-09
      0.00000000000000E+00  -2.76797076759184E-11   0.00000000000000E+00   3.96293144874260E-12   1.12007032587189E-23
      2.76757250036410E-08   2.76796879350897E-08  -1.38473047329893E-19  -5.47628483017365E-01  -5.47628483006262E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11030008450952E-08   0.00000000000000E+00  -1.11030008450952E-08
      7.50855068883939E-19  -9.25598555051210E-03  -4.03318869452942E-03   0.00000000000000E+00   4.85950138276850E-12
      6.92417479921854E-24  -1.65815465913778E-08  -1.65766870899950E-08  -6.12382021554046E-19
      8.52173301928405E-09
      0.00000000000000E+00  -2.78082903080089E-11   0.00000000000000E+00   3.79852888491405E-12   1.04827891632265E-23
      2.78045330721899E-08   2.78083316010749E-08  -1.34616579391892E-19  -5.49425931261947E-01  -5.49425931250693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12531229728891E-08   0.00000000000000E+00  -1.12531229728891E-08
      7.31865423867188E-19  -9.23952990545415E-03  -4.02349950077929E-03   0.00000000000000E+00   3.17494667789930E-12
      5.83463996578230E-24  -1.65583835748636E-08  -1.65552086281857E-08  -5.97248844475297E-19
      8.52401114428405E-09
      0.00000000000000E+00  -2.79966638640216E-11   0.00000000000000E+00   4.10584701626799E-12   9.64794628843639E-24
      2.79925819184285E-08   2.79966877654448E-08  -1.29368186251681E-19  -5.51878597207541E-01  -5.51878597196142E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13984931002784E-08   0.00000000000000E+00  -1.13984931002784E-08
      7.05898231773117E-19  -9.24693810401220E-03  -4.01736332257083E-03   0.00000000000000E+00   1.60307541945015E-12
      4.58504311784317E-24  -1.65997977405859E-08  -1.65981946651664E-08  -5.76530045521435E-19
      8.52708661303405E-09
      0.00000000000000E+00  -2.82715551624837E-11   0.00000000000000E+00   4.43835187566404E-12   8.73952554597928E-24
      2.82671238338064E-08   2.82715621856821E-08  -1.22230537830093E-19  -5.55226526382104E-01  -5.55226526370539E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15640160846098E-08   0.00000000000000E+00  -1.15640160846098E-08
      6.70333461680402E-19  -9.27936966593430E-03  -4.01534100119297E-03   0.00000000000000E+00   7.58501543039060E-13
      3.22699840465231E-24  -1.67083046026151E-08  -1.67075461010721E-08  -5.48102923850309E-19
      8.53123849584655E-09
      0.00000000000000E+00  -2.86512413060996E-11   0.00000000000000E+00   4.54524782173439E-12   7.81250052091213E-24
      2.86467170744127E-08   2.86512623222344E-08  -1.12530915326654E-19  -5.59798380959940E-01  -5.59798380948180E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17597854873188E-08   0.00000000000000E+00  -1.17597854873188E-08
      6.21508210436916E-19  -9.33873185610718E-03  -4.01675167991045E-03   0.00000000000000E+00   3.12434681819262E-13
      1.84480789466879E-24  -1.68917892695979E-08  -1.68914768349161E-08  -5.08977295110263E-19
      8.53684353764342E-09
      0.00000000000000E+00  -2.91079851842326E-11   0.00000000000000E+00   4.05820661270498E-12   6.92833771627653E-24
      2.91039391382592E-08   2.91079973448719E-08  -9.94074995453594E-20  -5.66022271436393E-01  -5.66022271424437E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19567070142005E-08   0.00000000000000E+00  -1.19567070142005E-08
      5.54490367869334E-19  -9.41926000069479E-03  -4.01541993534356E-03   0.00000000000000E+00   1.86192284240461E-13
      5.52916466423892E-25  -1.71514765229555E-08  -1.71512903306713E-08  -4.55082868323975E-19
      8.54062694085631E-09
      0.00000000000000E+00  -2.93791108484692E-11   0.00000000000000E+00   3.57419549726177E-12   6.44941358768382E-24
      2.93755370862832E-08   2.93791112817805E-08  -9.05975442085773E-20  -5.70225800767925E-01  -5.70225800755868E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20571908002710E-08   0.00000000000000E+00  -1.20571908002710E-08
      5.08873153457154E-19  -9.46938626348608E-03  -4.01178547432502E-03   0.00000000000000E+00   2.09735492882967E-13
     -1.32978502490190E-25  -1.73221302170024E-08  -1.73219204815095E-08  -4.18275609248576E-19
      8.54573453519372E-09
      0.00000000000000E+00  -2.95705152808097E-11   0.00000000000000E+00   1.89352982997065E-12   5.95548626441022E-24
      2.95686115863139E-08   2.95705051161439E-08  -7.88544274749531E-20  -5.75853752457496E-01  -5.75853752445429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20672916634358E-08   0.00000000000000E+00  -1.20672916634358E-08
      4.47238322889207E-19  -9.50364275381691E-03  -3.98892170989563E-03   0.00000000000000E+00   6.30469449402576E-13
     -7.75121731873811E-25  -1.75038439221575E-08  -1.75032134527081E-08  -3.68383895414253E-19
      8.55262978754921E-09
      0.00000000000000E+00  -2.94885897752206E-11   0.00000000000000E+00  -5.46403785592285E-13   5.44831463001929E-24
      2.94891403652901E-08   2.94885939615045E-08  -6.35598187385032E-20  -5.83224337251326E-01  -5.83224337239477E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18494203566047E-08   0.00000000000000E+00  -1.18494203566047E-08
      3.65533579264099E-19  -9.48146918510047E-03  -3.92391075049290E-03   0.00000000000000E+00   1.30224206816574E-12
     -1.31686974371202E-24  -1.76404758469679E-08  -1.76391736048998E-08  -3.01973760525597E-19
      8.56193837822912E-09
      0.00000000000000E+00  -2.87517194486046E-11   0.00000000000000E+00  -3.87481990747249E-12   4.89424610974801E-24
      2.87555950842350E-08   2.87517202643276E-08  -4.47210553963222E-20  -5.92358775809760E-01  -5.92358775798709E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10509062018479E-08   0.00000000000000E+00  -1.10509062018479E-08
      2.62665216788955E-19  -9.36022187869889E-03  -3.78324154805880E-03   0.00000000000000E+00   1.72713446040796E-12
     -1.73284951776336E-24  -1.77025411969400E-08  -1.77008140624796E-08  -2.17944161392633E-19
      8.57450497564701E-09
      0.00000000000000E+00  -2.61189900565509E-11   0.00000000000000E+00  -1.03139692135903E-11   4.14262260044875E-24
      2.61293396817102E-08   2.61190257124966E-08  -2.58590498171285E-20  -6.01497969277925E-01  -6.01497969269508E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41682131728492E-09   0.00000000000000E+00  -8.41682131728492E-09
      1.56894411756352E-19  -9.05111353884002E-03  -3.47369392419442E-03   0.00000000000000E+00   1.50805811252287E-12
     -2.04590660659731E-24  -1.77037124533243E-08  -1.77022043952118E-08  -1.31035361939224E-19
      8.59146988216116E-09
      0.00000000000000E+00  -1.74843907774597E-11   0.00000000000000E+00  -2.50935861986494E-11   2.67028173068622E-24
      1.75095250714066E-08   1.74844314852079E-08  -2.69453786786083E-20  -6.00473149487078E-01  -6.00473149487283E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05638125342107E-10   0.00000000000000E+00   2.05638125342107E-10
      1.60383043328525E-19  -8.26655134051663E-03  -2.69295342910656E-03   0.00000000000000E+00   2.01078089154213E-14
     -2.38695939793028E-24  -1.76900897183590E-08  -1.76900696105501E-08  -1.33437664649918E-19
      8.61146988216116E-09
      0.00000000000000E+00   1.87179574428940E-13   0.00000000000000E+00  -4.35549949338451E-11  -2.89667292928560E-25
     -1.43575289207021E-10  -1.87130284140866E-10  -9.42586034039073E-20  -5.66837414581294E-01  -5.66837414599170E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78759197919825E-08   0.00000000000000E+00   1.78759197919825E-08
      5.17901439168175E-19  -6.76985662237130E-03  -1.19666113131890E-03   0.00000000000000E+00  -3.30590804584032E-12
     -3.43245963026510E-24  -1.76854835997958E-08  -1.76887895078417E-08  -4.23642835764269E-19
      8.63146988216116E-09
      0.00000000000000E+00   1.77698442207007E-11   0.00000000000000E+00  -4.34344042378435E-11  -6.40529578848638E-24
     -1.77263947036652E-08  -1.77698291079030E-08  -2.47624208789918E-19  -4.96360033698247E-01  -4.96360033733669E-01
      0.00000000000000E+00   0.00000000000000E+00   3.54218436035902E-08   0.00000000000000E+00   3.54218436035902E-08
      1.22633831123998E-18  -5.06134191157382E-03   5.00264720608707E-04   0.00000000000000E+00  -8.35976748277222E-12
     -9.67208906183506E-24  -1.76436547282043E-08  -1.76520144956870E-08  -9.78714102450060E-19
      8.65146988216116E-09
      0.00000000000000E+00   2.49923306652261E-11   0.00000000000000E+00  -1.80989625042800E-11  -2.61443084386011E-23
     -2.49742108260290E-08  -2.49923097885333E-08  -4.99484804911305E-19  -3.93170284388597E-01  -3.93170284431208E-01
      0.00000000000000E+00   0.00000000000000E+00   4.26110959043541E-08   0.00000000000000E+00   4.26110959043541E-08
      2.07856022932706E-18  -3.21735543130475E-03   2.33377374938226E-03   0.00000000000000E+00  -1.85161536828439E-11
     -4.44550102273513E-23  -1.76002699621379E-08  -1.76187861158208E-08  -1.57907542441575E-18
      8.67146988216115E-09
      0.00000000000000E+00   1.81192216010381E-11   0.00000000000000E+00   1.64202248159129E-11  -4.13542635131462E-23
     -1.81356736683282E-08  -1.81192534435123E-08  -8.02255551371567E-19  -2.68405227061627E-01  -2.68405227097099E-01
      0.00000000000000E+00   0.00000000000000E+00   3.54722133548076E-08   0.00000000000000E+00   3.54722133548076E-08
      2.78800449642321E-18  -2.93678368780948E-03   2.53057559337354E-03   0.00000000000000E+00  -4.26189300059375E-11
     -7.64052938644170E-23  -1.73103409812893E-08  -1.73529599112953E-08  -1.98574894505165E-18
      8.69146988216115E-09
      0.00000000000000E+00   1.16700678438000E-11   0.00000000000000E+00   1.51774360146640E-11  -4.47797282076114E-23
     -1.16852857945281E-08  -1.16701083585135E-08  -1.03328943740690E-18  -1.56165281524243E-01  -1.56165281550117E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58735703188624E-08   0.00000000000000E+00   2.58735703188624E-08
      3.30547590280046E-18  -2.42046405383831E-02  -1.97295964085955E-02   0.00000000000000E+00  -8.20318839217861E-11
     -8.89747369623257E-23  -1.41214300764269E-08  -1.42034619603488E-08  -2.27218646539356E-18
      8.71146988216115E-09
      0.00000000000000E+00   7.60979570132963E-12   0.00000000000000E+00   9.18957033866019E-12  -4.70538606454528E-23
     -7.61894878474450E-09  -7.60975921440589E-09  -1.18408741797248E-18  -7.22781058730729E-02  -7.22781058917216E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86486935076324E-08   0.00000000000000E+00   1.86486935076324E-08
      3.67844977295311E-18  -6.44050534055584E-02  -6.09270456065949E-02   0.00000000000000E+00  -1.41669697508445E-10
     -1.02005292955225E-22  -1.08972645957180E-08  -1.10389342932266E-08  -2.49436235498063E-18
      8.71396988216115E-09
      0.00000000000000E+00   6.48001358893984E-12   0.00000000000000E+00   2.11462519360119E-11  -4.72590148880487E-23
     -6.50110903117062E-09  -6.47996277923465E-09  -1.20011592218346E-18  -6.28700154719378E-02  -6.28700154885299E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65921034643973E-08   0.00000000000000E+00   1.65921034643973E-08
      3.71993003161410E-18  -7.01204896831956E-02  -6.69344548362342E-02   0.00000000000000E+00  -1.74028760443529E-10
     -1.03687940282864E-22  -9.93811192471834E-09  -1.01121406851620E-08  -2.51981410943064E-18
      8.71734488216115E-09
      0.00000000000000E+00   5.21430126548292E-12   0.00000000000000E+00   1.77710158907129E-11  -4.74866141815982E-23
     -5.23209842664909E-09  -5.21432741075842E-09  -1.21747497472197E-18  -5.24946832654531E-02  -5.24946832798833E-02
      0.00000000000000E+00   0.00000000000000E+00   1.44302631609209E-08   0.00000000000000E+00   1.44302631609209E-08
      3.76863216978221E-18  -7.87104871120269E-02  -7.58068157799537E-02   0.00000000000000E+00  -1.79362440124183E-10
     -1.05862017762764E-22  -9.03657331003843E-09  -9.21593575016271E-09  -2.55115719506024E-18
      8.72190113216115E-09
      0.00000000000000E+00   3.80301503355206E-12   0.00000000000000E+00   1.47215959894265E-11  -4.76978265171827E-23
     -3.81770144483326E-09  -3.80297984884388E-09  -1.23447198139747E-18  -4.21187673685091E-02  -4.21187673805331E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20240423138488E-08   0.00000000000000E+00   1.20240423138488E-08
      3.82341671257468E-18  -9.15181744880669E-02  -8.89279572629108E-02   0.00000000000000E+00  -1.78480913770188E-10
     -1.08598441551155E-22  -8.04258155123452E-09  -8.22106246500481E-09  -2.58894473117721E-18
      8.72497660091115E-09
      0.00000000000000E+00   2.93168401166425E-12   0.00000000000000E+00   1.35241481959847E-11  -4.77972177104746E-23
     -2.94524490214678E-09  -2.93172075395085E-09  -1.24326395052385E-18  -3.66539164185845E-02  -3.66539164290922E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05077922168379E-08   0.00000000000000E+00   1.05077922168379E-08
      3.85573309916906E-18  -1.00638943059202E-01  -9.82519401680982E-02   0.00000000000000E+00  -1.79399845165610E-10
     -1.10368270424336E-22  -7.39667161772207E-09  -7.57607146288779E-09  -2.61246914864521E-18
      8.72912848372365E-09
      0.00000000000000E+00   2.07734426615984E-12   0.00000000000000E+00   9.86055523784802E-12  -4.78874002227991E-23
     -2.08723338016639E-09  -2.07737282492859E-09  -1.25158533079533E-18  -3.13498212378901E-02  -3.13498212468844E-02
      0.00000000000000E+00   0.00000000000000E+00   8.99431613036265E-09   0.00000000000000E+00   8.99431613036265E-09
      3.89307644572091E-18  -1.13517681842335E-01  -1.11338349955267E-01   0.00000000000000E+00  -1.78610145834253E-10
     -1.12633964941355E-22  -6.73833315959965E-09  -6.91694330543402E-09  -2.64149111492558E-18
      8.73473352552053E-09
      0.00000000000000E+00   1.35544463170868E-12   0.00000000000000E+00   6.17382641769847E-12  -4.79622590649344E-23
     -1.36158140799363E-09  -1.35540758157598E-09  -1.25877437639266E-18  -2.65807493570863E-02  -2.65807493647310E-02
      0.00000000000000E+00   0.00000000000000E+00   7.64472630902021E-09   0.00000000000000E+00   7.64472630902021E-09
      3.93592545620863E-18  -1.31380694580155E-01  -1.29399107807299E-01   0.00000000000000E+00  -1.79934611928988E-10
     -1.15546967753400E-22  -6.10938411551524E-09  -6.28931872744434E-09  -2.67715107981597E-18
      8.74230033194631E-09
      0.00000000000000E+00   8.30551958567664E-13   0.00000000000000E+00   3.31913359488236E-12  -4.80199564732046E-23
     -8.33844570823714E-10  -8.30525437228879E-10  -1.26451483848333E-18  -2.25201828048186E-02  -2.25201828113654E-02
      0.00000000000000E+00   0.00000000000000E+00   6.54678487146942E-09   0.00000000000000E+00   6.54678487146942E-09
      3.98546371004228E-18  -1.55570245205413E-01  -1.53769211360211E-01   0.00000000000000E+00  -1.84710950718978E-10
     -1.19328275226281E-22  -5.53154848352125E-09  -5.71625943424034E-09  -2.72094887155895E-18
      8.75251552062111E-09
      0.00000000000000E+00   4.94675754599739E-13   0.00000000000000E+00   1.56867753205266E-12  -4.80611167969694E-23
     -4.96223461131972E-10  -4.94654783599968E-10  -1.26884921868445E-18  -1.91360592722469E-02  -1.91360592779019E-02
      0.00000000000000E+00   0.00000000000000E+00   5.65497992364290E-09   0.00000000000000E+00   5.65497992364290E-09
      4.04323039691452E-18  -1.87335588833673E-01  -1.85709711902385E-01   0.00000000000000E+00  -1.92606631140784E-10
     -1.24252706987762E-22  -4.96771850890189E-09  -5.16032514004279E-09  -2.77438117823007E-18
      8.76630602533210E-09
      0.00000000000000E+00   2.99689377508160E-13   0.00000000000000E+00   6.73634819638068E-13  -4.80875128352797E-23
     -3.00338751625290E-10  -2.99665116805700E-10  -1.27203967821497E-18  -1.62980685306632E-02  -1.62980685354690E-02
      0.00000000000000E+00   0.00000000000000E+00   4.80581865144930E-09   0.00000000000000E+00   4.80581865144930E-09
      4.10950506166748E-18  -2.26920364451252E-01  -2.25500595712782E-01   0.00000000000000E+00  -1.98786541615015E-10
     -1.30505484051093E-22  -4.30736699302848E-09  -4.50615353464362E-09  -2.83746538345251E-18
      8.78492320669193E-09
      0.00000000000000E+00   2.00956285010069E-13   0.00000000000000E+00   2.52969783432984E-13  -4.81035063229356E-23
     -2.01133940347754E-10  -2.00880970564370E-10  -1.27454887368808E-18  -1.38570955330382E-02  -1.38570955368134E-02
      0.00000000000000E+00   0.00000000000000E+00   3.77519274334772E-09   0.00000000000000E+00   3.77519274334772E-09
      4.17978850963870E-18  -2.70867468143625E-01  -2.69741294318092E-01   0.00000000000000E+00  -1.87778168607996E-10
     -1.37704629940267E-22  -3.38653360417524E-09  -3.57431177278337E-09  -2.90523963595062E-18
      8.80492320669193E-09
      0.00000000000000E+00   1.59626153266681E-13   0.00000000000000E+00   9.88596282323110E-14  -4.81117265540910E-23
     -1.59773456505556E-10  -1.59674596877372E-10  -1.27645408005923E-18  -1.20953255614132E-02  -1.20953255641262E-02
      0.00000000000000E+00   0.00000000000000E+00   2.71296393342562E-09   0.00000000000000E+00   2.71296393342562E-09
      4.23404778830722E-18  -3.04947698003328E-01  -3.04143219470412E-01   0.00000000000000E+00  -1.53547816981334E-10
     -1.43497800953146E-22  -2.39974151956680E-09  -2.55328933654827E-09  -2.95759370824798E-18
      8.82492320669193E-09
      0.00000000000000E+00   1.38501863708950E-13   0.00000000000000E+00   5.24499737667005E-14  -4.81145350983103E-23
     -1.38513113883417E-10  -1.38460663909698E-10  -1.27795813278870E-18  -1.08948213141958E-02  -1.08948213160455E-02
      0.00000000000000E+00   0.00000000000000E+00   1.84964884596861E-09   0.00000000000000E+00   1.84964884596861E-09
      4.27104076522659E-18  -3.27373534400428E-01  -3.26834382280530E-01   0.00000000000000E+00  -1.09233488848330E-10
     -1.47384980108772E-22  -1.60195469321042E-09  -1.71118818205890E-09  -2.99308263243788E-18
      8.84492320669193E-09
      0.00000000000000E+00   1.30695061046311E-13   0.00000000000000E+00   2.00430119624181E-14  -4.81160309307106E-23
     -1.30728149858344E-10  -1.30708106846430E-10  -1.27932194824398E-18  -1.00366429502227E-02  -1.00366429513853E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16262516562866E-09   0.00000000000000E+00   1.16262516562866E-09
      4.29429326853916E-18  -3.39892682809805E-01  -3.39567556494121E-01   0.00000000000000E+00  -6.25303600906313E-11
     -1.49542582387704E-22  -9.69386698691410E-10  -1.03191705878219E-09  -3.01497132029518E-18
      8.86492320669193E-09
      0.00000000000000E+00   1.15816213618691E-13   0.00000000000000E+00   3.95277341260222E-14  -4.81122700195241E-23
     -1.15898065678570E-10  -1.15858537944492E-10  -1.28039909442353E-18  -9.50342953198292E-03  -9.50342953271491E-03
      0.00000000000000E+00   0.00000000000000E+00   7.31986104338949E-10   0.00000000000000E+00   7.31986104338949E-10
      4.30893299062594E-18  -3.46401979501784E-01  -3.46207861811910E-01   0.00000000000000E+00  -3.08168057935318E-11
     -1.50592746947547E-22  -5.85310760600837E-10  -6.16127566394520E-10  -3.02853389620241E-18
      8.88492320669193E-09
      0.00000000000000E+00   8.58748292890375E-14   0.00000000000000E+00   8.15003533198472E-14  -4.80974220711663E-23
     -8.59789607474433E-11  -8.58974603941716E-11  -1.28088863281865E-18  -9.30185858913028E-03  -9.30185858984439E-03
      0.00000000000000E+00   0.00000000000000E+00   7.14106258764206E-10   0.00000000000000E+00   7.14106258764206E-10
      4.32321511580122E-18  -3.53595070671614E-01  -3.53397145848673E-01   0.00000000000000E+00  -3.38299704664370E-11
     -1.51712461652878E-22  -5.94378827903435E-10  -6.28208798370024E-10  -3.04232648298258E-18
      8.90492320669193E-09
      0.00000000000000E+00   5.78621844407419E-14   0.00000000000000E+00   8.11105371232163E-14  -4.80734318599372E-23
     -5.79741936586123E-11  -5.78930831215372E-11  -1.28083464236265E-18  -9.27698260857255E-03  -9.27698260958753E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01498209222731E-09   0.00000000000000E+00   1.01498209222731E-09
      4.34351475764577E-18  -3.66274865773691E-01  -3.65973314856835E-01   0.00000000000000E+00  -6.48786471851577E-11
     -1.53799019665853E-22  -8.92210361920323E-10  -9.57089009105635E-10  -3.06268011528311E-18
      8.92492320669193E-09
      0.00000000000000E+00   2.95740053808236E-14   0.00000000000000E+00   8.60655069970764E-14  -4.80402528369501E-23
     -2.96747749914241E-11  -2.95887094844751E-11  -1.28023882890246E-18  -9.33342630710390E-03  -9.33342630865270E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54880166450143E-09   0.00000000000000E+00   1.54880166450143E-09
      4.37449079093580E-18  -3.88127268793941E-01  -3.87648599336983E-01   0.00000000000000E+00  -1.21819347980519E-10
     -1.57600360271635E-22  -1.39739360703633E-09  -1.51921295501700E-09  -3.09425196203334E-18
      8.94492320669193E-09
      0.00000000000000E+00   5.31781028431580E-14   0.00000000000000E+00  -4.64851797222325E-14  -4.80196525046980E-23
     -5.31619277895656E-11  -5.32084129693358E-11  -1.28014024082187E-18  -9.01476405722367E-03  -9.01476405896204E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73836636650109E-09   0.00000000000000E+00   1.73836636650109E-09
      4.40925811826582E-18  -4.12367743712266E-01  -4.11836785952198E-01   0.00000000000000E+00  -1.47100018369404E-10
     -1.62042393706918E-22  -1.53805793516227E-09  -1.68515795353184E-09  -3.12911787744396E-18
      8.96492320669193E-09
      0.00000000000000E+00   1.05713292525863E-13   0.00000000000000E+00  -1.27559796498972E-13  -4.80201640546277E-23
     -1.05552417386445E-10  -1.05679977182992E-10  -1.28111239746375E-18  -8.06733206619739E-03  -8.06733206795475E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75736839604343E-09   0.00000000000000E+00   1.75736839604343E-09
      4.44440548618669E-18  -4.35642555526860E-01  -4.35122141922603E-01   0.00000000000000E+00  -1.54937335095540E-10
     -1.66567609662210E-22  -1.49675108376470E-09  -1.65168841886041E-09  -3.16329308872294E-18
      8.98492320669193E-09
      0.00000000000000E+00   1.58615861157399E-13   0.00000000000000E+00  -1.38769217659964E-13  -4.80398956053699E-23
     -1.58521553526303E-10  -1.58660322744011E-10  -1.28316136786780E-18  -6.50338393607464E-03  -6.50338393782329E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74864638262408E-09   0.00000000000000E+00   1.74864638262408E-09
      4.47937841383917E-18  -4.57534222690366E-01  -4.57033248917965E-01   0.00000000000000E+00  -1.59773908771478E-10
     -1.71090218635660E-22  -1.43021215110844E-09  -1.58998605988009E-09  -3.19621704597138E-18
      9.00492320669193E-09
      0.00000000000000E+00   1.71657813840867E-13   0.00000000000000E+00  -4.32703716992819E-14  -4.80620615593461E-23
     -1.71660056105024E-10  -1.71703326476772E-10  -1.28548639310467E-18  -4.80403312693194E-03  -4.80403312861948E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68753802700546E-09   0.00000000000000E+00   1.68753802700546E-09
      4.51312917437928E-18  -4.78273347650486E-01  -4.77795736373872E-01   0.00000000000000E+00  -1.62248108059002E-10
     -1.75551130110415E-22  -1.35358659246943E-09  -1.51583470052861E-09  -3.22764278127461E-18
      9.02492320669193E-09
      0.00000000000000E+00   1.97006961310145E-13   0.00000000000000E+00  -7.79629828190692E-14  -4.80942625448566E-23
     -1.96931651041884E-10  -1.97009614024752E-10  -1.28833030562873E-18  -2.81585412292145E-03  -2.81585412457891E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65745558902759E-09   0.00000000000000E+00   1.65745558902759E-09
      4.54627828615983E-18  -4.98005195692318E-01  -4.97545034916950E-01   0.00000000000000E+00  -1.66303071521483E-10
     -1.79999250733818E-22  -1.29414290348121E-09  -1.46044597500287E-09  -3.25794798053111E-18
      9.04492320669193E-09
      0.00000000000000E+00  -1.96823271835730E-13   0.00000000000000E+00   1.02146195162101E-12  -4.79619873339135E-23
      1.95842110898614E-10   1.96863572850188E-10  -1.28332972503594E-18  -5.59379115032027E-03  -5.59379115128556E-03
      0.00000000000000E+00   0.00000000000000E+00   9.65295583833345E-10   0.00000000000000E+00   9.65295583833345E-10
      4.56558419783650E-18  -5.17358481019405E-01  -5.16992309257036E-01   0.00000000000000E+00  -1.32085565674935E-10
     -1.83447992018815E-22  -1.03007359100841E-09  -1.16215915668353E-09  -3.28225447280056E-18
      9.06492320669193E-09
      0.00000000000000E+00  -2.10746933996391E-12   0.00000000000000E+00   5.05814342069381E-12  -4.70703956600499E-23
      2.10244239618103E-09   2.10750053960168E-09  -1.24035213029339E-18  -3.08633866972696E-02  -3.08633866951516E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.11798643127146E-09   0.00000000000000E+00  -2.11798643127146E-09
      4.52322446921107E-18  -5.38098232052085E-01  -5.38101568649155E-01   0.00000000000000E+00   4.39602014013607E-11
     -1.82292467146530E-22  -3.34743097314588E-11   1.04858916697196E-11  -3.28287233891768E-18
      9.07492320669192E-09
      0.00000000000000E+00  -3.26930526563912E-12   0.00000000000000E+00   6.20570506468825E-12  -4.64162916969680E-23
      3.26309378469940E-09   3.26929948976405E-09  -1.20742446559994E-18  -4.97544282017381E-02  -4.97544281977986E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.93943207741967E-09   0.00000000000000E+00  -3.93943207741967E-09
      4.48383014843688E-18  -5.48753769892818E-01  -5.48964966860393E-01   0.00000000000000E+00   1.41832828539803E-10
     -1.80417836869629E-22   5.28299759116044E-10   6.70132587655667E-10  -3.27640568283693E-18
      9.08842320669193E-09
      0.00000000000000E+00  -4.58112364717423E-12   0.00000000000000E+00   5.36422750703232E-12  -4.52760464585949E-23
      4.57572626510142E-09   4.58109049260841E-09  -1.14627289103293E-18  -8.36378773408899E-02  -8.36378773350175E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.87245216623112E-09   0.00000000000000E+00  -5.87245216623112E-09
      4.40455204419275E-18  -5.63479160204373E-01  -5.63886116574020E-01   0.00000000000000E+00   2.30500008974600E-10
     -1.76213573424212E-22   1.06086166464830E-09   1.29136167362273E-09  -3.25827915315983E-18
      9.10664820669192E-09
      0.00000000000000E+00  -6.33802162521701E-12   0.00000000000000E+00   5.31461384586661E-12  -4.32454278410717E-23
      6.33269433464072E-09   6.33800894848655E-09  -1.04060761991432E-18  -1.38740679791739E-01  -1.38740679783926E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.81311728781828E-09   0.00000000000000E+00  -7.81311728781828E-09
      4.26215798162226E-18  -5.82843716816404E-01  -5.83308627885331E-01   0.00000000000000E+00   2.90791436601875E-10
     -1.68797026997334E-22   1.18431690273008E-09   1.47510833933179E-09  -3.22155036170795E-18
      9.12664820669192E-09
      0.00000000000000E+00  -9.69889609385203E-12   0.00000000000000E+00   8.68518769173994E-12  -3.55407955712850E-23
      9.69016500458883E-09   9.69885019228053E-09  -9.14962290217771E-19  -1.99336771716117E-01  -1.99336771707331E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.78626344896561E-09   0.00000000000000E+00  -8.78626344896561E-09
      4.08643271264295E-18  -5.98859551191889E-01  -5.98572407712654E-01   0.00000000000000E+00   2.89487617033179E-10
     -1.60307311763469E-22  -1.20207436034790E-09  -9.12586743314878E-10  -3.17147042242518E-18
      9.14664820669192E-09
      0.00000000000000E+00  -1.97337602364092E-11   0.00000000000000E+00   2.50022775037619E-11   7.33661991925167E-24
      1.97087738345352E-08   1.97337761120389E-08  -7.98213653405555E-19  -2.51917854510594E-01  -2.51917854501199E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.39499327087250E-09   0.00000000000000E+00  -9.39499327087250E-09
      3.89853284722550E-18  -5.97522215594573E-01  -5.94265880736284E-01   0.00000000000000E+00   2.91468847072926E-10
     -1.51110771698470E-22  -1.06302516882392E-08  -1.03387828411664E-08  -3.10031919381995E-18
      9.16664820669192E-09
      0.00000000000000E+00  -3.84049687080645E-11   0.00000000000000E+00   4.62713082958853E-11   9.64823660458652E-23
      3.83587106015218E-08   3.84049819098177E-08  -7.07175314466052E-19  -2.91717206223031E-01  -2.91717206212940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00913786275759E-08   0.00000000000000E+00  -1.00913786275759E-08
      3.69670527467398E-18  -5.63629943384508E-01  -5.54711146635293E-01   0.00000000000000E+00   3.12205908733320E-10
     -1.39683130476970E-22  -2.86258091909750E-08  -2.83136032822418E-08  -2.98952996020793E-18
      9.18664820669192E-09
      0.00000000000000E+00  -5.71906157222804E-11   0.00000000000000E+00   4.66656074831318E-11   1.85471263320580E-22
      5.71439109127876E-08   5.71905765202709E-08  -6.46466685391935E-19  -3.18923614032280E-01  -3.18923614021520E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07594046459555E-08   0.00000000000000E+00  -1.07594046459555E-08
      3.48151718175487E-18  -4.92859973265865E-01  -4.78233036318667E-01   0.00000000000000E+00   3.05518880330431E-10
     -1.24959386732075E-22  -4.67366907546456E-08  -4.64311718743153E-08  -2.83505049636294E-18
      9.20664820669192E-09
      0.00000000000000E+00  -6.57202364667434E-11   0.00000000000000E+00   2.13035947845570E-11   2.26239526156387E-22
      6.56989577992021E-08   6.57202613939868E-08  -6.12811442156437E-19  -3.35544851079434E-01  -3.35544851068099E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13350120918381E-08   0.00000000000000E+00  -1.13350120918381E-08
      3.25481693991811E-18  -3.89335418589047E-01  -3.72201824512818E-01   0.00000000000000E+00   2.64126480569549E-10
     -1.08598069453950E-22  -5.46493757827182E-08  -5.43852493021487E-08  -2.64200549776167E-18
      9.22664820669192E-09
      0.00000000000000E+00  -6.02040415500594E-11   0.00000000000000E+00  -1.36123392485601E-11   2.01757024435820E-22
      6.02176424925254E-08   6.02040301532771E-08  -6.01147151096583E-19  -3.43690429292910E-01  -3.43690429281083E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18274365275454E-08   0.00000000000000E+00  -1.18274365275454E-08
      3.01826820936721E-18  -2.64827715452619E-01  -2.49586549730019E-01   0.00000000000000E+00   2.04961098591376E-10
     -9.20569927015660E-23  -4.85815547243230E-08  -4.83765936257318E-08  -2.41712105827062E-18
      9.24664820669192E-09
      0.00000000000000E+00  -5.19757633883743E-11   0.00000000000000E+00  -2.04049881153251E-11   1.59826567211997E-22
      5.19961975389486E-08   5.19757925508334E-08  -5.93744325610015E-19  -3.50268675393551E-01  -3.50268675381653E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18983042396498E-08   0.00000000000000E+00  -1.18983042396498E-08
      2.78030212457421E-18  -1.53446476101156E-01  -1.40819675564832E-01   0.00000000000000E+00   1.18605772350207E-10
     -7.85877196501470E-23  -4.01960940835338E-08  -4.00774883111836E-08  -2.18655779896419E-18
      9.26664820669192E-09
      0.00000000000000E+00  -4.53697388199857E-11   0.00000000000000E+00  -1.63745493298220E-11   1.27154398737109E-22
      4.53861159926694E-08   4.53697414433397E-08  -5.78650880881121E-19  -3.59665411256710E-01  -3.59665411245066E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16444826783716E-08   0.00000000000000E+00  -1.16444826783716E-08
      2.54741247100678E-18  -7.06484279820640E-02  -6.00228228465236E-02   0.00000000000000E+00   6.26518536293638E-11
     -4.90366912404994E-23  -3.37879106185974E-08  -3.37252587649681E-08  -1.96876159012565E-18
      9.27664820669192E-09
      0.00000000000000E+00  -3.99756974037876E-11   0.00000000000000E+00  -2.66399255199241E-11   1.19683701122119E-22
      4.00023539585048E-08   3.99757140329850E-08  -5.62532496243791E-19  -3.67174147762413E-01  -3.67174147751171E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12421298725033E-08   0.00000000000000E+00  -1.12421298725033E-08
      2.43499117228174E-18  -4.41219876593686E-02  -3.50690429570192E-02   0.00000000000000E+00   4.90694174346653E-11
      7.20797949654501E-24  -2.87826535779164E-08  -2.87335841604817E-08  -1.87245867603795E-18
      9.28002320669192E-09
      0.00000000000000E+00  -3.77733524502884E-11   0.00000000000000E+00  -3.21859570821711E-11   1.18671964366744E-22
      3.78055654960693E-08   3.77733795389873E-08  -5.55403714450154E-19  -3.70247143979817E-01  -3.70247143968786E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10313203380547E-08   0.00000000000000E+00  -1.10313203380547E-08
      2.39776046614081E-18  -3.73853657616849E-02  -2.89598725495689E-02   0.00000000000000E+00   4.71983492563499E-11
      3.06575979079736E-23  -2.67892575501894E-08  -2.67420592009330E-08  -1.84235675169065E-18
      9.28457945669192E-09
      0.00000000000000E+00  -3.56416360997017E-11   0.00000000000000E+00  -2.32035178136853E-11   1.20716942996358E-22
      3.56648404986581E-08   3.56416369808445E-08  -5.43541016687315E-19  -3.75179898286708E-01  -3.75179898275947E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07615549380334E-08   0.00000000000000E+00  -1.07615549380334E-08
      2.34872813145439E-18  -3.12056942153996E-02  -2.33668342020515E-02   0.00000000000000E+00   3.45166985392683E-11
      5.96018682035786E-23  -2.49145987413506E-08  -2.48800820428112E-08  -1.80518711476708E-18
      9.29073039419192E-09
      0.00000000000000E+00  -3.38583786820803E-11   0.00000000000000E+00  -1.43578397145751E-11   1.26777715020201E-22
      3.38727481801688E-08   3.38583903404543E-08  -5.25439922150687E-19  -3.82569717758095E-01  -3.82569717747576E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05189621170431E-08   0.00000000000000E+00  -1.05189621170431E-08
      2.28402665290759E-18  -2.59880995027835E-02  -1.86346360527464E-02   0.00000000000000E+00   2.36260932415151E-11
      9.29294540995705E-23  -2.33630543166529E-08  -2.33394282234113E-08  -1.75858673075691E-18
      9.29903415981692E-09
      0.00000000000000E+00  -3.25164352267412E-11   0.00000000000000E+00  -7.97261649496163E-12   1.35591523630790E-22
      3.25244526633446E-08   3.25164800468497E-08  -4.99783148142502E-19  -3.92967183611605E-01  -3.92967183601270E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03352741487659E-08   0.00000000000000E+00  -1.03352741487659E-08
      2.19820495870612E-18  -2.17877518482047E-02  -1.47991953932767E-02   0.00000000000000E+00   1.58262697321245E-11
      1.28302190905177E-22  -2.21970321678162E-08  -2.21812058980839E-08  -1.69842181056362E-18
      9.31024424341067E-09
      0.00000000000000E+00  -3.14803347463030E-11   0.00000000000000E+00  -4.53062254005578E-12   1.43249375367268E-22
      3.14848467353573E-08   3.14803161128174E-08  -4.65393954072320E-19  -4.06913638103729E-01  -4.06913638093533E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01963002325051E-08   0.00000000000000E+00  -1.01963002325051E-08
      2.08390358075277E-18  -1.84143726170583E-02  -1.17084820530234E-02   0.00000000000000E+00   1.11313530512454E-11
      1.60958092342205E-22  -2.12951472333637E-08  -2.12840158803123E-08  -1.61850962668045E-18
      9.32537785626223E-09
      0.00000000000000E+00  -3.04711447738667E-11   0.00000000000000E+00  -3.25192104405514E-12   1.41452555296469E-22
      3.04743917607673E-08   3.04711398397234E-08  -4.21141312737267E-19  -4.25007366641073E-01  -4.25007366631010E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00631418348261E-08   0.00000000000000E+00  -1.00631418348261E-08
      1.93161188815415E-18  -1.56289609935363E-02  -9.19906682126014E-03   0.00000000000000E+00   8.63304030249933E-12
      1.77587892400910E-22  -2.04166310452000E-08  -2.04079980048973E-08  -1.51047057541688E-18
      9.34537785626223E-09
      0.00000000000000E+00  -2.92345472321046E-11   0.00000000000000E+00  -3.01857501613227E-12   1.20616057347276E-22
      2.92374950206539E-08   2.92344764456379E-08  -3.66886644279555E-19  -4.47516282612597E-01  -4.47516282602693E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90334924916297E-09   0.00000000000000E+00  -9.90334924916297E-09
      1.73354490317089E-18  -1.32845078879387E-02  -7.19389183969400E-03   0.00000000000000E+00   7.29360543644899E-12
      1.61390345991764E-22  -1.93384208019116E-08  -1.93311271964750E-08  -1.36665825889133E-18
      9.36537785626223E-09
      0.00000000000000E+00  -2.80864880170105E-11   0.00000000000000E+00  -2.80200591758997E-12   8.91590528048328E-23
      2.80892608984872E-08   2.80864588925697E-08  -3.16596615956718E-19  -4.68737258412339E-01  -4.68737258402577E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76201229247216E-09   0.00000000000000E+00  -9.76201229247216E-09
      1.53830465732144E-18  -1.17036620950414E-02  -5.93021460309983E-03   0.00000000000000E+00   6.29075622145935E-12
      1.21188157072638E-22  -1.83307373563192E-08  -1.83244466000976E-08  -1.22170804136473E-18
      9.38537785626223E-09
      0.00000000000000E+00  -2.71645505449214E-11   0.00000000000000E+00  -2.24839001758468E-12   5.79826488974254E-23
      2.71667502233244E-08   2.71645018333069E-08  -2.69579118320105E-19  -4.88922854503098E-01  -4.88922854493465E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63312995886948E-09   0.00000000000000E+00  -9.63312995886948E-09
      1.34564205814405E-18  -1.06213628666163E-02  -5.09778345674950E-03   0.00000000000000E+00   5.19559754315482E-12
      7.66079831846048E-23  -1.75365674719806E-08  -1.75313718744374E-08  -1.07606293982395E-18
      9.40537785626223E-09
      0.00000000000000E+00  -2.63811149365412E-11   0.00000000000000E+00  -1.90908104309589E-12   3.39573685476114E-23
      2.63829542600004E-08   2.63810451789574E-08  -2.25585049298863E-19  -5.08156147721918E-01  -5.08156147712433E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48440313497334E-09   0.00000000000000E+00  -9.48440313497334E-09
      1.15595399544459E-18  -9.83798298663200E-03  -4.51438323899031E-03   0.00000000000000E+00   4.37351286980332E-12
      4.10703517375282E-23  -1.69010155568538E-08  -1.68966420439840E-08  -9.30368946145722E-19
      9.42537785626223E-09
      0.00000000000000E+00  -2.68033251934842E-11   0.00000000000000E+00   1.06312385128915E-12   1.89657639732324E-23
      2.68022769372742E-08   2.68033400611255E-08  -1.80544913469789E-19  -5.28318988571070E-01  -5.28318988560870E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02003346002464E-08   0.00000000000000E+00  -1.02003346002464E-08
      9.51947303439657E-19  -9.42945731677460E-03  -4.19836996819151E-03   0.00000000000000E+00   3.40414357037255E-12
      1.85419644817578E-23  -1.66064096044495E-08  -1.66030054608791E-08  -7.71402389969868E-19
      9.44537785626223E-09
      0.00000000000000E+00  -2.77104756628829E-11   0.00000000000000E+00   2.26584893441533E-12   1.09125535369237E-23
      2.77082624743002E-08   2.77105283232346E-08  -1.34434845354870E-19  -5.49502681639299E-01  -5.49502681628251E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10481215548619E-08   0.00000000000000E+00  -1.10481215548619E-08
      7.30984872342420E-19  -9.27044754257157E-03  -4.02064224706077E-03   0.00000000000000E+00   2.43766417759522E-12
      6.56307336037428E-24  -1.66648444325503E-08  -1.66624067683727E-08  -5.96550026987549E-19
      9.45537785626223E-09
      0.00000000000000E+00  -2.84214457736064E-11   0.00000000000000E+00   3.53328397733653E-12   8.26707003079166E-24
      2.84178879090871E-08   2.84214211930645E-08  -1.11294852938884E-19  -5.60365255085647E-01  -5.60365255074067E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15799129846373E-08   0.00000000000000E+00  -1.15799129846373E-08
      6.15185742496047E-19  -9.29075670897145E-03  -3.98452050385566E-03   0.00000000000000E+00   1.61007910457035E-12
      2.62802726645113E-24  -1.68431182875318E-08  -1.68415082084272E-08  -5.03890889557163E-19
      9.46887785626223E-09
      0.00000000000000E+00  -2.91664902818338E-11   0.00000000000000E+00   2.75590062722119E-12   6.40265137923544E-24
      2.91637253966075E-08   2.91664812972347E-08  -8.03651576507545E-20  -5.75105342333232E-01  -5.75105342321374E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18585097019667E-08   0.00000000000000E+00  -1.18585097019667E-08
      4.55095861519496E-19  -9.39694601490230E-03  -3.94373975587977E-03   0.00000000000000E+00   6.98274522249746E-13
      4.96608307583274E-27  -1.73086698697903E-08  -1.73079715952680E-08  -3.74730703868742E-19
      9.47343410626223E-09
      0.00000000000000E+00  -2.93488020851908E-11   0.00000000000000E+00   2.01043283333104E-12   5.88959816148369E-24
      2.93468163351615E-08   2.93488267679949E-08  -7.01709338763515E-20  -5.80019698578299E-01  -5.80019698566422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18773796352377E-08   0.00000000000000E+00  -1.18773796352377E-08
      4.00979550556444E-19  -9.43213486539659E-03  -3.92742191361859E-03   0.00000000000000E+00   5.33769917874304E-13
     -6.99698840366297E-25  -1.74719809026753E-08  -1.74714471327574E-08  -3.30808616680093E-19
      9.47958504376223E-09
      0.00000000000000E+00  -2.92470381163648E-11   0.00000000000000E+00  -7.73438877011479E-13   5.37091997941937E-24
      2.92477694016650E-08   2.92469959627880E-08  -5.69054762791159E-20  -5.86440036563496E-01  -5.86440036551868E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16274078431412E-08   0.00000000000000E+00  -1.16274078431412E-08
      3.29460091626273E-19  -9.42361439887997E-03  -3.87222626911758E-03   0.00000000000000E+00   1.00915193755955E-12
     -1.28906981436479E-24  -1.76205972715845E-08  -1.76195881196469E-08  -2.72554615347157E-19
      9.48788880938723E-09
      0.00000000000000E+00  -2.84512953131988E-11   0.00000000000000E+00  -4.69378708075390E-12   4.81927729418877E-24
      2.84559450632692E-08   2.84512512761884E-08  -4.06515054717195E-20  -5.94337095364061E-01  -5.94337095353301E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07599210861196E-08   0.00000000000000E+00  -1.07599210861196E-08
      2.40112228783640E-19  -9.31332039475125E-03  -3.73932785306548E-03   0.00000000000000E+00   1.55116909955622E-12
     -1.72803778250370E-24  -1.76928813591685E-08  -1.76913301900689E-08  -1.99460723311920E-19
      9.49909889298098E-09
      0.00000000000000E+00  -2.58670599423906E-11   0.00000000000000E+00  -1.13492142975865E-11   4.09715984469347E-24
      2.58784040670621E-08   2.58670548527645E-08  -2.43910648134546E-20  -6.02210715197641E-01  -6.02210715189474E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.16695284422691E-09   0.00000000000000E+00  -8.16695284422691E-09
      1.48560004693642E-19  -9.02250979841776E-03  -3.44575244745600E-03   0.00000000000000E+00   1.42243176263343E-12
     -2.04356020614031E-24  -1.77015244403002E-08  -1.77001020085375E-08  -1.24168939880186E-19
      9.51423250583254E-09
      0.00000000000000E+00  -1.81399785116470E-11   0.00000000000000E+00  -2.51710785600529E-11   2.76776092580631E-24
      1.81652021353924E-08   1.81400310568323E-08  -2.36022186999744E-20  -6.02165397028748E-01  -6.02165397028301E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.47414215679573E-10   0.00000000000000E+00  -4.47414215679573E-10
      1.41789011169261E-19  -8.31774755425231E-03  -2.74334703426726E-03   0.00000000000000E+00   1.23439725653689E-13
     -2.35164714484373E-24  -1.76927402808784E-08  -1.76926168411527E-08  -1.18186792469287E-19
      9.53423250583254E-09
      0.00000000000000E+00  -6.95999418558638E-13   0.00000000000000E+00  -4.29972967107214E-11  -1.06099819154125E-25
      7.38946730815557E-10   6.95949434104835E-10  -8.72315100755131E-20  -5.70233171308516E-01  -5.70233171325510E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69939428597970E-08   0.00000000000000E+00   1.69939428597970E-08
      4.81667868365200E-19  -6.84257580403254E-03  -1.26903276524446E-03   0.00000000000000E+00  -3.10544164117389E-12
     -3.30834256935756E-24  -1.76867868522606E-08  -1.76898922939018E-08  -3.94436358289688E-19
      9.55423250583254E-09
      0.00000000000000E+00   1.71716594472680E-11   0.00000000000000E+00  -4.41266320255512E-11  -5.88333958010266E-24
     -1.71274943845369E-08  -1.71716210165625E-08  -2.36068760289370E-19  -5.01403080002873E-01  -5.01403080037700E-01
      0.00000000000000E+00   0.00000000000000E+00   3.48267442065612E-08   0.00000000000000E+00   3.48267442065612E-08
      1.17820275249643E-18  -5.13226522475258E-03   4.30321214099315E-04   0.00000000000000E+00  -8.03085822196822E-12
     -8.90104750817987E-24  -1.76470923317768E-08  -1.76551231899988E-08  -9.42133992207055E-19
      9.57423250583254E-09
      0.00000000000000E+00   2.51109022209611E-11   0.00000000000000E+00  -1.98566220321576E-11  -2.46459456985456E-23
     -2.50910762233179E-08  -2.51109328453501E-08  -4.83053240527162E-19  -3.99652732860385E-01  -3.99652732903113E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27276192511593E-08   0.00000000000000E+00   4.27276192511593E-08
      2.03275513751961E-18  -3.31920362937093E-03   2.23126472099047E-03   0.00000000000000E+00  -1.76951904834690E-11
     -4.15069563760200E-23  -1.75989912153257E-08  -1.76166864058092E-08  -1.54970189699245E-18
      9.59423250583254E-09
      0.00000000000000E+00   1.86674428374298E-11   0.00000000000000E+00   1.53751746022998E-11  -4.10978347268896E-23
     -1.86828219122858E-08  -1.86674467376835E-08  -7.87175884602198E-19  -2.75116852364650E-01  -2.75116852400762E-01
      0.00000000000000E+00   0.00000000000000E+00   3.61115029972212E-08   0.00000000000000E+00   3.61115029972212E-08
      2.75498519746403E-18  -2.41042380335163E-03   3.08563809298416E-03   0.00000000000000E+00  -4.09533106790341E-11
     -7.57092363983400E-23  -1.74031029488585E-08  -1.74440562595376E-08  -1.96780931286183E-18
      9.61423250583254E-09
      0.00000000000000E+00   1.19295292264112E-11   0.00000000000000E+00   1.58976022690955E-11  -4.46292777120095E-23
     -1.19453799901106E-08  -1.19294823878415E-08  -1.02300906219862E-18  -1.61558046176228E-01  -1.61558046202546E-01
      0.00000000000000E+00   0.00000000000000E+00   2.63186979215060E-08   0.00000000000000E+00   2.63186979215060E-08
      3.28135915589416E-18  -2.24626390467615E-02  -1.79290698143067E-02   0.00000000000000E+00  -7.92971238104439E-11
     -8.82589206706349E-23  -1.43099184098540E-08  -1.43892155336645E-08  -2.25835009369553E-18
      9.63423250583254E-09
      0.00000000000000E+00   7.83573375486014E-12   0.00000000000000E+00   9.26870190247742E-12  -4.69688941319682E-23
     -7.84500258799212E-09  -7.83573388608969E-09  -1.17833431526832E-18  -7.56647138530332E-02  -7.56647138720848E-02
      0.00000000000000E+00   0.00000000000000E+00   1.90515995577849E-08   0.00000000000000E+00   1.90515995577849E-08
      3.66239114704985E-18  -6.16843847166356E-02  -5.81506320960589E-02   0.00000000000000E+00  -1.38689887133704E-10
     -1.01329732262166E-22  -1.10771757845615E-08  -1.12158656716953E-08  -2.48405683178154E-18
      9.64423250583254E-09
      0.00000000000000E+00   4.85812737459213E-12   0.00000000000000E+00   1.39613709549761E-11  -4.76147758527931E-23
     -4.87211546163270E-09  -4.85815409067778E-09  -1.22619637247175E-18  -4.70989788895755E-02  -4.70989789034005E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38249309147860E-08   0.00000000000000E+00   1.38249309147860E-08
      3.80064045619771E-18  -8.76175290867906E-02  -8.47923701017836E-02   0.00000000000000E+00  -1.72668947604158E-10
     -1.07542630132228E-22  -8.79410787650377E-09  -8.96677682410803E-09  -2.57444408372596E-18
      9.65098250583254E-09
      0.00000000000000E+00   2.96134986178229E-12   0.00000000000000E+00   1.33963555518191E-11  -4.78373859353925E-23
     -2.97477644837505E-09  -2.96138009282328E-09  -1.24569318330518E-18  -3.50128162097544E-02  -3.50128162202746E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05202009272095E-08   0.00000000000000E+00   1.05202009272095E-08
      3.87165181245638E-18  -1.07462302449034E-01  -1.05080739117427E-01   0.00000000000000E+00  -1.78744495623448E-10
     -1.11417728452506E-22  -7.38007633876287E-09  -7.55882083438643E-09  -2.62595862915119E-18
      9.66009500583254E-09
      0.00000000000000E+00   1.53417449031453E-12   0.00000000000000E+00   7.51527014101975E-12  -4.79749513460657E-23
     -1.54166299086212E-09  -1.53414772072114E-09  -1.25901149858970E-18  -2.63107446735738E-02  -2.63107446814970E-02
      0.00000000000000E+00   0.00000000000000E+00   7.92318695587146E-09   0.00000000000000E+00   7.92318695587146E-09
      3.94385185359176E-18  -1.36059194607795E-01  -1.34046192630537E-01   0.00000000000000E+00  -1.80115031150351E-10
     -1.16200478391182E-22  -6.20892420399989E-09  -6.38903923515036E-09  -2.68484035500206E-18
      9.67239688083254E-09
      0.00000000000000E+00   7.22818081823236E-13   0.00000000000000E+00   3.16815289083618E-12  -4.80497675846661E-23
     -7.25951285162104E-10  -7.22783132271316E-10  -1.26703005189639E-18  -2.05343728095930E-02  -2.05343728157970E-02
      0.00000000000000E+00   0.00000000000000E+00   6.20398649752310E-09   0.00000000000000E+00   6.20398649752310E-09
      4.02017251998597E-18  -1.74674083611887E-01  -1.72947111499887E-01   0.00000000000000E+00  -1.87642579241121E-10
     -1.22255827742850E-22  -5.29356078601035E-09  -5.48120336525159E-09  -2.75314246808958E-18
      9.68900441208254E-09
      0.00000000000000E+00   3.49469225074639E-13   0.00000000000000E+00   1.07883680115661E-12  -4.80870217653134E-23
     -3.50547385533851E-10  -3.49468548732742E-10  -1.27169609926934E-18  -1.65960443333191E-02  -1.65960443383019E-02
      0.00000000000000E+00   0.00000000000000E+00   4.98275525694019E-09   0.00000000000000E+00   4.98275525694019E-09
      4.10292378362671E-18  -2.22955407389456E-01  -2.21495585819661E-01   0.00000000000000E+00  -1.96435987271908E-10
     -1.29862504934618E-22  -4.43685072093549E-09  -4.63328670820753E-09  -2.83122768435737E-18
      9.70900441208254E-09
      0.00000000000000E+00   2.08303863986671E-13   0.00000000000000E+00   3.38805831401543E-13  -4.81040803707198E-23
     -2.08607071900615E-10  -2.08268266069262E-10  -1.27453908320142E-18  -1.38760605431009E-02  -1.38760605469146E-02
      0.00000000000000E+00   0.00000000000000E+00   3.81367241197536E-09   0.00000000000000E+00   3.81367241197536E-09
      4.17919723186622E-18  -2.70430591865080E-01  -2.69294622660154E-01   0.00000000000000E+00  -1.87557234932209E-10
     -1.37629975316507E-22  -3.41784691097373E-09  -3.60540414590607E-09  -2.90465814866479E-18
      9.72900441208254E-09
      0.00000000000000E+00   1.60728290113172E-13   0.00000000000000E+00   1.14504755502734E-13  -4.81119899098647E-23
     -1.60826472407446E-10  -1.60711967651991E-10  -1.27646483053295E-18  -1.20979291235612E-02  -1.20979291262868E-02
      0.00000000000000E+00   0.00000000000000E+00   2.72561719455987E-09   0.00000000000000E+00   2.72561719455987E-09
      4.23370957575741E-18  -3.04654242609941E-01  -3.03846104225912E-01   0.00000000000000E+00  -1.54029036469933E-10
     -1.43445863840725E-22  -2.41087619043784E-09  -2.56490522690792E-09  -2.95724474522447E-18
      9.74900441208254E-09
      0.00000000000000E+00   1.38410018971743E-13   0.00000000000000E+00   5.50693656590349E-14  -4.81146213718659E-23
     -1.38506713760578E-10  -1.38451644394967E-10  -1.27796858759602E-18  -1.08949376553588E-02  -1.08949376572154E-02
      0.00000000000000E+00   0.00000000000000E+00   1.85664791521344E-09   0.00000000000000E+00   1.85664791521344E-09
      4.27084253406168E-18  -3.27180508517012E-01  -3.26639148292473E-01   0.00000000000000E+00  -1.09645107742671E-10
     -1.47348950145682E-22  -1.60855116307565E-09  -1.71819627081847E-09  -2.99287394646567E-18
      9.76900441208254E-09
      0.00000000000000E+00   1.30603216309103E-13   0.00000000000000E+00   2.02985421753107E-14  -4.81160387611733E-23
     -1.30627916582377E-10  -1.30607618040250E-10  -1.27933033770695E-18  -1.00362539386146E-02  -1.00362539397816E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16702625928631E-09   0.00000000000000E+00   1.16702625928631E-09
      4.29418305924741E-18  -3.39767394563630E-01  -3.39440849871586E-01   0.00000000000000E+00  -6.28519386467663E-11
     -1.49517892743705E-22  -9.73566702599117E-10  -1.03641864124603E-09  -3.01485272154046E-18
      9.78900441208254E-09
      0.00000000000000E+00   1.15724368881484E-13   0.00000000000000E+00   3.97446285486078E-14  -4.81121996901206E-23
     -1.15723658582536E-10  -1.15683913954036E-10  -1.28040398886299E-18  -9.50363215476078E-03  -9.50363215549643E-03
      0.00000000000000E+00   0.00000000000000E+00   7.35650015777660E-10   0.00000000000000E+00   7.35650015777660E-10
      4.30889605956296E-18  -3.46336970190480E-01  -3.46141643027986E-01   0.00000000000000E+00  -3.11287201831438E-11
     -1.50578498443417E-22  -5.88837381640274E-10  -6.19966101823569E-10  -3.02849207069997E-18
      9.80900441208254E-09
      0.00000000000000E+00   8.58748292890375E-14   0.00000000000000E+00   8.10686381874790E-14  -4.80973611000807E-23
     -8.59803990472874E-11  -8.58993304091480E-11  -1.28089358648310E-18  -9.30122969880774E-03  -9.30122969952393E-03
      0.00000000000000E+00   0.00000000000000E+00   7.16189675447309E-10   0.00000000000000E+00   7.16189675447309E-10
      4.32321985307191E-18  -3.53561357044709E-01  -3.53362776352980E-01   0.00000000000000E+00  -3.39999282770082E-11
     -1.51703838981640E-22  -5.96290416761060E-10  -6.30290345038219E-10  -3.04232626658880E-18
      9.81400441208254E-09
      0.00000000000000E+00   8.35787108588493E-14   0.00000000000000E+00   3.15845047010293E-14  -4.80937999324600E-23
     -8.35925122691577E-11  -8.35609277645048E-11  -1.28100500254420E-18  -9.25924508180705E-03  -9.25924508248893E-03
      0.00000000000000E+00   0.00000000000000E+00   6.81876157404712E-10   0.00000000000000E+00   6.81876157404712E-10
      4.32662923385893E-18  -3.55242708377110E-01  -3.55054202576824E-01   0.00000000000000E+00  -3.14061083048243E-11
     -1.51961969194702E-22  -5.66909121335579E-10  -5.98315229640556E-10  -3.04562423131473E-18
      9.82075441208254E-09
      0.00000000000000E+00   5.56579107477612E-14   0.00000000000000E+00   2.14985994223292E-13  -4.80841216430513E-23
     -5.58985278605325E-11  -5.56835418663573E-11  -1.28096892275222E-18  -9.28722154689385E-03  -9.28722154773701E-03
      0.00000000000000E+00   0.00000000000000E+00   8.43150287628543E-10   0.00000000000000E+00   8.43150287628543E-10
      4.33232049830042E-18  -3.58678851757128E-01  -3.58430746004315E-01   0.00000000000000E+00  -4.99815499351681E-11
     -1.52505217975612E-22  -7.37485195826735E-10  -7.87466745762056E-10  -3.05135157554820E-18
      9.82986691208254E-09
      0.00000000000000E+00   3.23293474970494E-14   0.00000000000000E+00   1.43363395402377E-13  -4.80683944923591E-23
     -3.24619539130140E-11  -3.23185905176597E-11  -1.28071145162909E-18  -9.37802698690374E-03  -9.37802698808811E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18436883652982E-09   0.00000000000000E+00   1.18436883652982E-09
      4.34311305932330E-18  -3.66034314718384E-01  -3.65671333009439E-01   0.00000000000000E+00  -8.39608696225176E-11
     -1.53725568359393E-22  -1.06808937638956E-09  -1.15205024601223E-09  -3.06240160769421E-18
      9.83294238083254E-09
      0.00000000000000E+00   1.94710842879957E-14   0.00000000000000E+00   2.23877763623751E-13  -4.80620610385095E-23
     -1.96605699715376E-11  -1.94366922079619E-11  -1.28058546620391E-18  -9.42239228310156E-03  -9.42239228442350E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32193171580753E-09   0.00000000000000E+00   1.32193171580753E-09
      4.34717861900490E-18  -3.68910449425845E-01  -3.68500063658070E-01   0.00000000000000E+00  -9.94093693924437E-11
     -1.54208800375023E-22  -1.20308565420628E-09  -1.30249502359888E-09  -3.06659315280099E-18
      9.83709426364504E-09
      0.00000000000000E+00   1.57972947996946E-14   0.00000000000000E+00   6.42891461691814E-14  -4.80542048187130E-23
     -1.58641781920802E-11  -1.57998890459591E-11  -1.28040134975198E-18  -9.47345354317167E-03  -9.47345354467812E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50645151304764E-09   0.00000000000000E+00   1.50645151304764E-09
      4.35343322914979E-18  -3.73404400427341E-01  -3.72934728641367E-01   0.00000000000000E+00  -1.17711330601131E-10
     -1.54977852565413E-22  -1.37294029340057E-09  -1.49065162400185E-09  -3.07303187939781E-18
      9.84269930544191E-09
      0.00000000000000E+00   2.56246816809000E-14   0.00000000000000E+00  -6.80661331730498E-14  -4.80455574332180E-23
     -2.55630939323633E-11  -2.56311600655844E-11  -1.28020993760930E-18  -9.48900987296207E-03  -9.48900987463435E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67227972447507E-09   0.00000000000000E+00   1.67227972447507E-09
      4.36280642690154E-18  -3.80095717856087E-01  -3.79576893374193E-01   0.00000000000000E+00  -1.33569118025673E-10
     -1.56148425674569E-22  -1.51307944638353E-09  -1.64664856440936E-09  -3.08259648929225E-18
      9.85026611186769E-09
      0.00000000000000E+00   3.98606159480666E-14   0.00000000000000E+00  -7.81942227579333E-14  -4.80359811524610E-23
     -3.97720169702816E-11  -3.98502111930876E-11  -1.28006287853960E-18  -9.42922387015501E-03  -9.42922387192703E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77202226201113E-09   0.00000000000000E+00   1.77202226201113E-09
      4.37621497634035E-18  -3.89556892427158E-01  -3.89011120460661E-01   0.00000000000000E+00  -1.44517150968234E-10
     -1.57839187250707E-22  -1.58765489984948E-09  -1.73217205081787E-09  -3.09615209780075E-18
      9.86048130054250E-09
      0.00000000000000E+00   5.54742212733462E-14   0.00000000000000E+00  -6.41993263208423E-14  -4.80259384795383E-23
     -5.53992971376938E-11  -5.54634964640627E-11  -1.28003048836683E-18  -9.24517212201376E-03  -9.24517212381299E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79922810674393E-09   0.00000000000000E+00   1.79922810674393E-09
      4.39459443091975E-18  -4.02352201980736E-01  -4.01802777030276E-01   0.00000000000000E+00  -1.50541800064635E-10
     -1.60178197987054E-22  -1.59322281021512E-09  -1.74376461027991E-09  -3.11456394255292E-18
      9.87427180525348E-09
      0.00000000000000E+00   8.02723003193784E-14   0.00000000000000E+00  -8.22667968281447E-14  -4.80190765710091E-23
     -8.02007985609254E-11  -8.02830653578015E-11  -1.28034022253183E-18  -8.79420529911127E-03  -8.79420530089559E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78431726064271E-09   0.00000000000000E+00   1.78431726064271E-09
      4.41920106650854E-18  -4.19080790830487E-01  -4.18543883896522E-01   0.00000000000000E+00  -1.53693894190771E-10
     -1.63333259190254E-22  -1.55034030109389E-09  -1.70403419528482E-09  -3.13886084397671E-18
      9.89288898661331E-09
      0.00000000000000E+00   1.25643600499897E-13   0.00000000000000E+00  -1.22088826867986E-13  -4.80260081720635E-23
     -1.25522781622790E-10  -1.25644870449706E-10  -1.28162020074812E-18  -7.69298940961510E-03  -7.69298941138274E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76763329500430E-09   0.00000000000000E+00   1.76763329500430E-09
      4.45210941613931E-18  -4.40433642112573E-01  -4.39916284224844E-01   0.00000000000000E+00  -1.56805194780002E-10
     -1.67562882551445E-22  -1.48518322977442E-09  -1.64198842455459E-09  -3.17048921539119E-18
      9.91288898661331E-09
      0.00000000000000E+00   1.66606353294454E-13   0.00000000000000E+00  -1.10653856763540E-13  -4.80478327854696E-23
     -1.66476023470636E-10  -1.66586677327447E-10  -1.28383057488554E-18  -6.03926926977370E-03  -6.03926927151482E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74111947614707E-09   0.00000000000000E+00   1.74111947614707E-09
      4.48693180566225E-18  -4.62029501242413E-01  -4.61533396231191E-01   0.00000000000000E+00  -1.60477684481437E-10
     -1.72076975327029E-22  -1.41405511433801E-09  -1.57453279881962E-09  -3.20310123077672E-18
      9.93288898661331E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.31287679843617E-14  -4.80694510769475E-23
     -1.71428073804071E-10  -1.71451202572104E-10  -1.28615317011157E-18  -4.34752389700774E-03  -4.34752389867785E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67010922854717E-09   0.00000000000000E+00   1.67010922854717E-09
      4.52033399023319E-18  -4.82531966256894E-01  -4.82059766806049E-01   0.00000000000000E+00  -1.62497733704548E-10
     -1.76518466678571E-22  -1.33616029227039E-09  -1.49865802597511E-09  -3.23418082012162E-18
      9.95288898661331E-09
      0.00000000000000E+00   2.21713195618970E-13   0.00000000000000E+00  -1.43803026728454E-13  -4.81119914542622E-23
     -2.21599281357617E-10  -2.21743084384393E-10  -1.28949292056473E-18  -2.06366810572838E-03  -2.06366810741089E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68250971867093E-09   0.00000000000000E+00   1.68250971867093E-09
      4.55398418460662E-18  -5.02030489213747E-01  -5.01570226838552E-01   0.00000000000000E+00  -1.68893261935872E-10
     -1.81009727223861E-22  -1.29187337235041E-09  -1.46076663428647E-09  -3.26449126404189E-18
      9.97288898661331E-09
      0.00000000000000E+00  -5.95153897104773E-13   0.00000000000000E+00   2.12983980923723E-12  -4.78133145916358E-23
      5.92988518037411E-10   5.95118357846601E-10  -1.27655320892873E-18  -9.62806695835803E-03  -9.62806695867543E-03
      0.00000000000000E+00   0.00000000000000E+00   3.17400136565206E-10   0.00000000000000E+00   3.17400136565206E-10
      4.56033218733792E-18  -5.21692140721418E-01  -5.21404631815149E-01   0.00000000000000E+00  -9.54946707911626E-11
     -1.83494426153789E-22  -8.17023823620556E-10  -9.12518494411902E-10  -3.28377897840919E-18
      9.99288898661331E-09
      0.00000000000000E+00  -2.50524889680971E-12   0.00000000000000E+00   5.10926454892228E-12  -4.67880340198619E-23
      2.50014759322120E-09   2.50525685777008E-09  -1.22575232542773E-18  -3.92886520740281E-02  -3.92886520712811E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.74699968918409E-09   0.00000000000000E+00  -2.74699968918409E-09
      4.50539219355424E-18  -5.42648861859000E-01  -5.42725069702542E-01   0.00000000000000E+00   7.87299075272473E-11
     -1.81420653970680E-22   1.63012923887018E-10   2.41742831414084E-10  -3.27963986812651E-18
      9.99466673995998E-09
      0.00000000000000E+00  -2.94849159857323E-12   0.00000000000000E+00   1.25366704348252E-11  -4.66644712468286E-23
      2.93595459335554E-09   2.94849126379032E-09  -1.22045418475074E-18  -4.23413201011087E-02  -4.23413200976867E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.42206123295796E-09   0.00000000000000E+00  -3.42206123295796E-09
      4.49930861274483E-18  -5.44518348394584E-01  -5.44667611679854E-01   0.00000000000000E+00   1.15126841989282E-10
     -1.81152577183337E-22   3.58443127178126E-10   4.73569969167227E-10  -3.27885442799409E-18
      9.99706670697799E-09
      0.00000000000000E+00  -3.29750159996183E-12   0.00000000000000E+00   7.74554940644626E-12  -4.65033776540588E-23
      3.28972376539429E-09   3.29746931480069E-09  -1.21247593061518E-18  -4.69002951869803E-02  -4.69002951830040E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.97630005105963E-09   0.00000000000000E+00  -3.97630005105963E-09
      4.48976562376858E-18  -5.47074313682222E-01  -5.47288251082102E-01   0.00000000000000E+00   1.42863122616759E-10
     -1.80699654795726E-22   5.35967613643361E-10   6.78830736259939E-10  -3.27728969315340E-18
      1.00000000000000E-08
      0.00000000000000E+00  -3.65358364611541E-12   0.00000000000000E+00   6.51806510206497E-12  -4.62923103115327E-23
      3.64710969251185E-09   3.65362775761387E-09  -1.20170281814796E-18  -5.30108319606459E-02  -5.30108319561173E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.52859791607509E-09   0.00000000000000E+00  -4.52859791607509E-09
      4.47648191910187E-18  -5.50233130777799E-01  -5.50508872561192E-01   0.00000000000000E+00   1.69921156754993E-10
     -1.80037268019712E-22   7.05049001705738E-10   8.74970158460551E-10  -3.27477910095392E-18
}
